/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.behavior;

import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.view.accessibility.AccessibilityViewCommand;
import androidx.customview.widget.ViewDragHelper;

public class SwipeDismissBehavior<V extends View>
extends CoordinatorLayout.Behavior<V> {
    public static final int STATE_IDLE = 0;
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_SETTLING = 2;
    public static final int SWIPE_DIRECTION_START_TO_END = 0;
    public static final int SWIPE_DIRECTION_END_TO_START = 1;
    public static final int SWIPE_DIRECTION_ANY = 2;
    private static final float DEFAULT_DRAG_DISMISS_THRESHOLD = 0.5f;
    private static final float DEFAULT_ALPHA_START_DISTANCE = 0.0f;
    private static final float DEFAULT_ALPHA_END_DISTANCE = 0.5f;
    ViewDragHelper viewDragHelper;
    OnDismissListener listener;
    private boolean interceptingEvents;
    private boolean requestingDisallowInterceptTouchEvent;
    private float sensitivity = 0.0f;
    private boolean sensitivitySet;
    int swipeDirection = 2;
    float dragDismissThreshold = 0.5f;
    float alphaStartSwipeDistance = 0.0f;
    float alphaEndSwipeDistance = 0.5f;
    private final ViewDragHelper.Callback dragCallback = new ViewDragHelper.Callback(){
        private static final int INVALID_POINTER_ID = -1;
        private int originalCapturedViewLeft;
        private int activePointerId = -1;

        @Override
        public boolean tryCaptureView(View child, int pointerId) {
            return (this.activePointerId == -1 || this.activePointerId == pointerId) && SwipeDismissBehavior.this.canSwipeDismissView(child);
        }

        @Override
        public void onViewCaptured(@NonNull View capturedChild, int activePointerId) {
            this.activePointerId = activePointerId;
            this.originalCapturedViewLeft = capturedChild.getLeft();
            ViewParent parent = capturedChild.getParent();
            if (parent != null) {
                SwipeDismissBehavior.this.requestingDisallowInterceptTouchEvent = true;
                parent.requestDisallowInterceptTouchEvent(true);
                SwipeDismissBehavior.this.requestingDisallowInterceptTouchEvent = false;
            }
        }

        @Override
        public void onViewDragStateChanged(int state) {
            if (SwipeDismissBehavior.this.listener != null) {
                SwipeDismissBehavior.this.listener.onDragStateChanged(state);
            }
        }

        @Override
        public void onViewReleased(@NonNull View child, float xVelocity, float yVelocity) {
            int targetLeft;
            this.activePointerId = -1;
            int childWidth = child.getWidth();
            boolean dismiss = false;
            if (this.shouldDismiss(child, xVelocity)) {
                targetLeft = xVelocity < 0.0f || child.getLeft() < this.originalCapturedViewLeft ? this.originalCapturedViewLeft - childWidth : this.originalCapturedViewLeft + childWidth;
                dismiss = true;
            } else {
                targetLeft = this.originalCapturedViewLeft;
            }
            if (SwipeDismissBehavior.this.viewDragHelper.settleCapturedViewAt(targetLeft, child.getTop())) {
                ViewCompat.postOnAnimation(child, new SettleRunnable(child, dismiss));
            } else if (dismiss && SwipeDismissBehavior.this.listener != null) {
                SwipeDismissBehavior.this.listener.onDismiss(child);
            }
        }

        private boolean shouldDismiss(@NonNull View child, float xVelocity) {
            if (xVelocity != 0.0f) {
                boolean isRtl;
                boolean bl = isRtl = ViewCompat.getLayoutDirection(child) == 1;
                if (SwipeDismissBehavior.this.swipeDirection == 2) {
                    return true;
                }
                if (SwipeDismissBehavior.this.swipeDirection == 0) {
                    return isRtl ? xVelocity < 0.0f : xVelocity > 0.0f;
                }
                if (SwipeDismissBehavior.this.swipeDirection == 1) {
                    return isRtl ? xVelocity > 0.0f : xVelocity < 0.0f;
                }
            } else {
                int distance = child.getLeft() - this.originalCapturedViewLeft;
                int thresholdDistance = Math.round((float)child.getWidth() * SwipeDismissBehavior.this.dragDismissThreshold);
                return Math.abs(distance) >= thresholdDistance;
            }
            return false;
        }

        @Override
        public int getViewHorizontalDragRange(@NonNull View child) {
            return child.getWidth();
        }

        @Override
        public int clampViewPositionHorizontal(@NonNull View child, int left, int dx) {
            int max;
            int min;
            boolean isRtl;
            boolean bl = isRtl = ViewCompat.getLayoutDirection(child) == 1;
            if (SwipeDismissBehavior.this.swipeDirection == 0) {
                if (isRtl) {
                    min = this.originalCapturedViewLeft - child.getWidth();
                    max = this.originalCapturedViewLeft;
                } else {
                    min = this.originalCapturedViewLeft;
                    max = this.originalCapturedViewLeft + child.getWidth();
                }
            } else if (SwipeDismissBehavior.this.swipeDirection == 1) {
                if (isRtl) {
                    min = this.originalCapturedViewLeft;
                    max = this.originalCapturedViewLeft + child.getWidth();
                } else {
                    min = this.originalCapturedViewLeft - child.getWidth();
                    max = this.originalCapturedViewLeft;
                }
            } else {
                min = this.originalCapturedViewLeft - child.getWidth();
                max = this.originalCapturedViewLeft + child.getWidth();
            }
            return SwipeDismissBehavior.clamp(min, left, max);
        }

        @Override
        public int clampViewPositionVertical(@NonNull View child, int top, int dy) {
            return child.getTop();
        }

        @Override
        public void onViewPositionChanged(@NonNull View child, int left, int top, int dx, int dy) {
            float startAlphaDistance = (float)child.getWidth() * SwipeDismissBehavior.this.alphaStartSwipeDistance;
            float endAlphaDistance = (float)child.getWidth() * SwipeDismissBehavior.this.alphaEndSwipeDistance;
            float currentDistance = Math.abs(left - this.originalCapturedViewLeft);
            if (currentDistance <= startAlphaDistance) {
                child.setAlpha(1.0f);
            } else if (currentDistance >= endAlphaDistance) {
                child.setAlpha(0.0f);
            } else {
                float distance = SwipeDismissBehavior.fraction(startAlphaDistance, endAlphaDistance, currentDistance);
                child.setAlpha(SwipeDismissBehavior.clamp(0.0f, 1.0f - distance, 1.0f));
            }
        }
    };

    public void setListener(@Nullable OnDismissListener listener2) {
        this.listener = listener2;
    }

    @VisibleForTesting
    @Nullable
    public OnDismissListener getListener() {
        return this.listener;
    }

    public void setSwipeDirection(int direction) {
        this.swipeDirection = direction;
    }

    public void setDragDismissDistance(float distance) {
        this.dragDismissThreshold = SwipeDismissBehavior.clamp(0.0f, distance, 1.0f);
    }

    public void setStartAlphaSwipeDistance(float fraction) {
        this.alphaStartSwipeDistance = SwipeDismissBehavior.clamp(0.0f, fraction, 1.0f);
    }

    public void setEndAlphaSwipeDistance(float fraction) {
        this.alphaEndSwipeDistance = SwipeDismissBehavior.clamp(0.0f, fraction, 1.0f);
    }

    public void setSensitivity(float sensitivity) {
        this.sensitivity = sensitivity;
        this.sensitivitySet = true;
    }

    @Override
    public boolean onLayoutChild(@NonNull CoordinatorLayout parent, @NonNull V child, int layoutDirection) {
        boolean handled = super.onLayoutChild(parent, child, layoutDirection);
        if (ViewCompat.getImportantForAccessibility(child) == 0) {
            ViewCompat.setImportantForAccessibility(child, 1);
            this.updateAccessibilityActions((View)child);
        }
        return handled;
    }

    @Override
    public boolean onInterceptTouchEvent(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull MotionEvent event) {
        boolean dispatchEventToHelper = this.interceptingEvents;
        switch (event.getActionMasked()) {
            case 0: {
                dispatchEventToHelper = this.interceptingEvents = parent.isPointInChildBounds((View)child, (int)event.getX(), (int)event.getY());
                break;
            }
            case 1: 
            case 3: {
                this.interceptingEvents = false;
            }
        }
        if (dispatchEventToHelper) {
            this.ensureViewDragHelper(parent);
            return !this.requestingDisallowInterceptTouchEvent && this.viewDragHelper.shouldInterceptTouchEvent(event);
        }
        return false;
    }

    @Override
    public boolean onTouchEvent(CoordinatorLayout parent, V child, MotionEvent event) {
        if (this.viewDragHelper != null) {
            if (!this.requestingDisallowInterceptTouchEvent || event.getActionMasked() != 3) {
                this.viewDragHelper.processTouchEvent(event);
            }
            return true;
        }
        return false;
    }

    public boolean canSwipeDismissView(@NonNull View view) {
        return true;
    }

    private void ensureViewDragHelper(ViewGroup parent) {
        if (this.viewDragHelper == null) {
            this.viewDragHelper = this.sensitivitySet ? ViewDragHelper.create(parent, this.sensitivity, this.dragCallback) : ViewDragHelper.create(parent, this.dragCallback);
        }
    }

    private void updateAccessibilityActions(View child) {
        ViewCompat.removeAccessibilityAction(child, 0x100000);
        if (this.canSwipeDismissView(child)) {
            ViewCompat.replaceAccessibilityAction(child, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_DISMISS, null, new AccessibilityViewCommand(){

                @Override
                public boolean perform(@NonNull View view, @Nullable AccessibilityViewCommand.CommandArguments arguments) {
                    if (SwipeDismissBehavior.this.canSwipeDismissView(view)) {
                        boolean isRtl = ViewCompat.getLayoutDirection(view) == 1;
                        boolean dismissToLeft = SwipeDismissBehavior.this.swipeDirection == 0 && isRtl || SwipeDismissBehavior.this.swipeDirection == 1 && !isRtl;
                        int offset = dismissToLeft ? -view.getWidth() : view.getWidth();
                        ViewCompat.offsetLeftAndRight(view, offset);
                        view.setAlpha(0.0f);
                        if (SwipeDismissBehavior.this.listener != null) {
                            SwipeDismissBehavior.this.listener.onDismiss(view);
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    static float clamp(float min, float value, float max) {
        return Math.min(Math.max(min, value), max);
    }

    static int clamp(int min, int value, int max) {
        return Math.min(Math.max(min, value), max);
    }

    public int getDragState() {
        return this.viewDragHelper != null ? this.viewDragHelper.getViewDragState() : 0;
    }

    static float fraction(float startValue, float endValue, float value) {
        return (value - startValue) / (endValue - startValue);
    }

    private class SettleRunnable
    implements Runnable {
        private final View view;
        private final boolean dismiss;

        SettleRunnable(View view, boolean dismiss) {
            this.view = view;
            this.dismiss = dismiss;
        }

        @Override
        public void run() {
            if (SwipeDismissBehavior.this.viewDragHelper != null && SwipeDismissBehavior.this.viewDragHelper.continueSettling(true)) {
                ViewCompat.postOnAnimation(this.view, this);
            } else if (this.dismiss && SwipeDismissBehavior.this.listener != null) {
                SwipeDismissBehavior.this.listener.onDismiss(this.view);
            }
        }
    }

    public static interface OnDismissListener {
        public void onDismiss(View var1);

        public void onDragStateChanged(int var1);
    }
}

