/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.bottomnavigation;

import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.bottomnavigation.BottomNavigationItemView;
import com.google.android.material.navigation.NavigationBarItemView;
import com.google.android.material.navigation.NavigationBarMenuView;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class BottomNavigationMenuView
extends NavigationBarMenuView {
    private final int inactiveItemMaxWidth;
    private final int inactiveItemMinWidth;
    private final int activeItemMaxWidth;
    private final int activeItemMinWidth;
    private boolean itemHorizontalTranslationEnabled;
    private final List<Integer> tempChildWidths = new ArrayList<Integer>();

    public BottomNavigationMenuView(@NonNull Context context) {
        super(context);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        Resources res = this.getResources();
        this.inactiveItemMaxWidth = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_item_max_width);
        this.inactiveItemMinWidth = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_item_min_width);
        this.activeItemMaxWidth = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_active_item_max_width);
        this.activeItemMinWidth = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_active_item_min_width);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MenuBuilder menu2 = this.getMenu();
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int visibleCount = menu2.getVisibleItems().size();
        int totalCount = this.getChildCount();
        this.tempChildWidths.clear();
        int parentHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)parentHeight, (int)0x40000000);
        if (this.isShifting(this.getLabelVisibilityMode(), visibleCount) && this.isItemHorizontalTranslationEnabled()) {
            View activeChild = this.getChildAt(this.getSelectedItemPosition());
            int activeItemWidth = this.activeItemMinWidth;
            if (activeChild.getVisibility() != 8) {
                activeChild.measure(View.MeasureSpec.makeMeasureSpec((int)this.activeItemMaxWidth, (int)Integer.MIN_VALUE), heightSpec);
                activeItemWidth = Math.max(activeItemWidth, activeChild.getMeasuredWidth());
            }
            int inactiveCount = visibleCount - (activeChild.getVisibility() != 8 ? 1 : 0);
            int activeMaxAvailable = width - inactiveCount * this.inactiveItemMinWidth;
            int activeWidth = Math.min(activeMaxAvailable, Math.min(activeItemWidth, this.activeItemMaxWidth));
            int inactiveMaxAvailable = (width - activeWidth) / (inactiveCount == 0 ? 1 : inactiveCount);
            int inactiveWidth = Math.min(inactiveMaxAvailable, this.inactiveItemMaxWidth);
            int extra = width - activeWidth - inactiveWidth * inactiveCount;
            for (int i = 0; i < totalCount; ++i) {
                int tempChildWidth = 0;
                if (this.getChildAt(i).getVisibility() != 8) {
                    int n = tempChildWidth = i == this.getSelectedItemPosition() ? activeWidth : inactiveWidth;
                    if (extra > 0) {
                        ++tempChildWidth;
                        --extra;
                    }
                }
                this.tempChildWidths.add(tempChildWidth);
            }
        } else {
            int maxAvailable = width / (visibleCount == 0 ? 1 : visibleCount);
            int childWidth = Math.min(maxAvailable, this.activeItemMaxWidth);
            int extra = width - childWidth * visibleCount;
            for (int i = 0; i < totalCount; ++i) {
                int tempChildWidth = 0;
                if (this.getChildAt(i).getVisibility() != 8) {
                    tempChildWidth = childWidth;
                    if (extra > 0) {
                        ++tempChildWidth;
                        --extra;
                    }
                }
                this.tempChildWidths.add(tempChildWidth);
            }
        }
        int totalWidth = 0;
        for (int i = 0; i < totalCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.measure(View.MeasureSpec.makeMeasureSpec((int)this.tempChildWidths.get(i), (int)0x40000000), heightSpec);
            ViewGroup.LayoutParams params = child.getLayoutParams();
            params.width = child.getMeasuredWidth();
            totalWidth += child.getMeasuredWidth();
        }
        this.setMeasuredDimension(totalWidth, parentHeight);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count2 = this.getChildCount();
        int width = right - left;
        int height = bottom - top;
        int used = 0;
        for (int i = 0; i < count2; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            if (ViewCompat.getLayoutDirection((View)this) == 1) {
                child.layout(width - used - child.getMeasuredWidth(), 0, width - used, height);
            } else {
                child.layout(used, 0, child.getMeasuredWidth() + used, height);
            }
            used += child.getMeasuredWidth();
        }
    }

    public void setItemHorizontalTranslationEnabled(boolean itemHorizontalTranslationEnabled) {
        this.itemHorizontalTranslationEnabled = itemHorizontalTranslationEnabled;
    }

    public boolean isItemHorizontalTranslationEnabled() {
        return this.itemHorizontalTranslationEnabled;
    }

    @Override
    @NonNull
    protected NavigationBarItemView createNavigationBarItemView(@NonNull Context context) {
        return new BottomNavigationItemView(context);
    }
}

