/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.bottomsheet;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.material.R;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class BottomSheetDragHandleView
extends AppCompatImageView
implements AccessibilityManager.AccessibilityStateChangeListener {
    private static final int DEF_STYLE_RES = R.style.Widget_Material3_BottomSheet_DragHandle;
    @Nullable
    private final AccessibilityManager accessibilityManager;
    @Nullable
    private BottomSheetBehavior<?> bottomSheetBehavior;
    private boolean accessibilityServiceEnabled;
    private boolean interactable;
    private boolean clickToExpand;
    private final String clickToExpandActionLabel = this.getResources().getString(R.string.bottomsheet_action_expand);
    private final String clickToCollapseActionLabel = this.getResources().getString(R.string.bottomsheet_action_collapse);
    private final String clickFeedback = this.getResources().getString(R.string.bottomsheet_drag_handle_clicked);
    private final BottomSheetBehavior.BottomSheetCallback bottomSheetCallback = new BottomSheetBehavior.BottomSheetCallback(){

        @Override
        public void onStateChanged(@NonNull View bottomSheet, int newState) {
            BottomSheetDragHandleView.this.onBottomSheetStateChanged(newState);
        }

        @Override
        public void onSlide(@NonNull View bottomSheet, float slideOffset) {
        }
    };

    public BottomSheetDragHandleView(@NonNull Context context) {
        this(context, null);
    }

    public BottomSheetDragHandleView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.bottomSheetDragHandleStyle);
    }

    public BottomSheetDragHandleView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        this.accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        this.updateInteractableState();
        ViewCompat.setAccessibilityDelegate((View)this, new AccessibilityDelegateCompat(){

            @Override
            public void onPopulateAccessibilityEvent(View host, @NonNull AccessibilityEvent event) {
                super.onPopulateAccessibilityEvent(host, event);
                if (event.getEventType() == 1) {
                    BottomSheetDragHandleView.this.expandOrCollapseBottomSheetIfPossible();
                }
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setBottomSheetBehavior(this.findParentBottomSheetBehavior());
        if (this.accessibilityManager != null) {
            this.accessibilityManager.addAccessibilityStateChangeListener((AccessibilityManager.AccessibilityStateChangeListener)this);
            this.onAccessibilityStateChanged(this.accessibilityManager.isEnabled());
        }
    }

    protected void onDetachedFromWindow() {
        if (this.accessibilityManager != null) {
            this.accessibilityManager.removeAccessibilityStateChangeListener((AccessibilityManager.AccessibilityStateChangeListener)this);
        }
        this.setBottomSheetBehavior(null);
        super.onDetachedFromWindow();
    }

    public void onAccessibilityStateChanged(boolean enabled) {
        this.accessibilityServiceEnabled = enabled;
        this.updateInteractableState();
    }

    private void setBottomSheetBehavior(@Nullable BottomSheetBehavior<?> behavior) {
        if (this.bottomSheetBehavior != null) {
            this.bottomSheetBehavior.removeBottomSheetCallback(this.bottomSheetCallback);
            this.bottomSheetBehavior.setAccessibilityDelegateView(null);
        }
        this.bottomSheetBehavior = behavior;
        if (this.bottomSheetBehavior != null) {
            this.bottomSheetBehavior.setAccessibilityDelegateView((View)this);
            this.onBottomSheetStateChanged(this.bottomSheetBehavior.getState());
            this.bottomSheetBehavior.addBottomSheetCallback(this.bottomSheetCallback);
        }
        this.updateInteractableState();
    }

    private void onBottomSheetStateChanged(int state) {
        if (state == 4) {
            this.clickToExpand = true;
        } else if (state == 3) {
            this.clickToExpand = false;
        }
        ViewCompat.replaceAccessibilityAction((View)this, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLICK, this.clickToExpand ? this.clickToExpandActionLabel : this.clickToCollapseActionLabel, (v, args2) -> this.expandOrCollapseBottomSheetIfPossible());
    }

    private void updateInteractableState() {
        this.interactable = this.accessibilityServiceEnabled && this.bottomSheetBehavior != null;
        ViewCompat.setImportantForAccessibility((View)this, this.bottomSheetBehavior != null ? 1 : 2);
        this.setClickable(this.interactable);
    }

    private boolean expandOrCollapseBottomSheetIfPossible() {
        if (!this.interactable) {
            return false;
        }
        this.announceAccessibilityEvent(this.clickFeedback);
        boolean canHalfExpand = !this.bottomSheetBehavior.isFitToContents() && !this.bottomSheetBehavior.shouldSkipHalfExpandedStateWhenDragging();
        int currentState = this.bottomSheetBehavior.getState();
        int nextState = currentState == 4 ? (canHalfExpand ? 6 : 3) : (currentState == 3 ? (canHalfExpand ? 6 : 4) : (this.clickToExpand ? 3 : 4));
        this.bottomSheetBehavior.setState(nextState);
        return true;
    }

    private void announceAccessibilityEvent(String announcement) {
        if (this.accessibilityManager == null) {
            return;
        }
        AccessibilityEvent announce = AccessibilityEvent.obtain((int)16384);
        announce.getText().add(announcement);
        this.accessibilityManager.sendAccessibilityEvent(announce);
    }

    @Nullable
    private BottomSheetBehavior<?> findParentBottomSheetBehavior() {
        BottomSheetDragHandleView parent = this;
        while ((parent = BottomSheetDragHandleView.getParentView((View)parent)) != null) {
            CoordinatorLayout.Behavior behavior;
            ViewGroup.LayoutParams layoutParams = parent.getLayoutParams();
            if (!(layoutParams instanceof CoordinatorLayout.LayoutParams) || !((behavior = ((CoordinatorLayout.LayoutParams)layoutParams).getBehavior()) instanceof BottomSheetBehavior)) continue;
            return (BottomSheetBehavior)behavior;
        }
        return null;
    }

    @Nullable
    private static View getParentView(View view) {
        ViewParent parent = view.getParent();
        return parent instanceof View ? (View)parent : null;
    }
}

