/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.carousel;

import android.content.Context;
import android.view.View;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import com.google.android.material.carousel.Carousel;
import com.google.android.material.carousel.CarouselStrategyHelper;
import com.google.android.material.carousel.KeylineState;

public abstract class CarouselStrategy {
    private float smallSizeMin;
    private float smallSizeMax;

    void initialize(Context context) {
        this.smallSizeMin = this.smallSizeMin > 0.0f ? this.smallSizeMin : CarouselStrategyHelper.getSmallSizeMin(context);
        this.smallSizeMax = this.smallSizeMax > 0.0f ? this.smallSizeMax : CarouselStrategyHelper.getSmallSizeMax(context);
    }

    abstract KeylineState onFirstChildMeasuredWithMargins(@NonNull Carousel var1, @NonNull View var2);

    @FloatRange(from=0.0, to=1.0)
    static float getChildMaskPercentage(float maskedSize, float unmaskedSize, float childMargins) {
        return 1.0f - (maskedSize - childMargins) / (unmaskedSize - childMargins);
    }

    static int[] doubleCounts(int[] count2) {
        int[] doubledCount = new int[count2.length];
        for (int i = 0; i < doubledCount.length; ++i) {
            doubledCount[i] = count2[i] * 2;
        }
        return doubledCount;
    }

    boolean isContained() {
        return true;
    }

    boolean shouldRefreshKeylineState(Carousel carousel, int oldItemCount) {
        return false;
    }

    public void setSmallItemSizeMin(float minSmallItemSize) {
        this.smallSizeMin = minSmallItemSize;
    }

    public void setSmallItemSizeMax(float maxSmallItemSize) {
        this.smallSizeMax = maxSmallItemSize;
    }

    public float getSmallItemSizeMin() {
        return this.smallSizeMin;
    }

    public float getSmallItemSizeMax() {
        return this.smallSizeMax;
    }
}

