/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.carousel;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.core.math.MathUtils;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.carousel.Arrangement;
import com.google.android.material.carousel.Carousel;
import com.google.android.material.carousel.CarouselStrategy;
import com.google.android.material.carousel.CarouselStrategyHelper;
import com.google.android.material.carousel.KeylineState;

public class HeroCarouselStrategy
extends CarouselStrategy {
    private static final int[] SMALL_COUNTS = new int[]{1};
    private static final int[] MEDIUM_COUNTS = new int[]{0, 1};
    private int keylineCount = 0;

    @Override
    @NonNull
    KeylineState onFirstChildMeasuredWithMargins(@NonNull Carousel carousel, @NonNull View child) {
        int availableSpace = carousel.getContainerHeight();
        if (carousel.isHorizontal()) {
            availableSpace = carousel.getContainerWidth();
        }
        RecyclerView.LayoutParams childLayoutParams = (RecyclerView.LayoutParams)child.getLayoutParams();
        float childMargins = childLayoutParams.topMargin + childLayoutParams.bottomMargin;
        float measuredChildSize = child.getMeasuredWidth() * 2;
        if (carousel.isHorizontal()) {
            childMargins = childLayoutParams.leftMargin + childLayoutParams.rightMargin;
            measuredChildSize = child.getMeasuredHeight() * 2;
        }
        float smallChildSizeMin = this.getSmallItemSizeMin() + childMargins;
        float smallChildSizeMax = this.getSmallItemSizeMax() + childMargins;
        smallChildSizeMax = Math.max(smallChildSizeMax, smallChildSizeMin);
        float targetLargeChildSize = Math.min(measuredChildSize + childMargins, (float)availableSpace);
        float targetSmallChildSize = MathUtils.clamp(measuredChildSize / 3.0f + childMargins, smallChildSizeMin + childMargins, smallChildSizeMax + childMargins);
        float targetMediumChildSize = (targetLargeChildSize + targetSmallChildSize) / 2.0f;
        int[] smallCounts = SMALL_COUNTS;
        if ((float)availableSpace < smallChildSizeMin * 2.0f) {
            smallCounts = new int[]{0};
        }
        float minAvailableLargeSpace = (float)availableSpace - smallChildSizeMax * (float)CarouselStrategyHelper.maxValue(SMALL_COUNTS);
        int largeCountMin = (int)Math.max(1.0, Math.floor(minAvailableLargeSpace / targetLargeChildSize));
        int largeCountMax = (int)Math.ceil((float)availableSpace / targetLargeChildSize);
        int[] largeCounts = new int[largeCountMax - largeCountMin + 1];
        for (int i = 0; i < largeCounts.length; ++i) {
            largeCounts[i] = largeCountMin + i;
        }
        boolean isCenterAligned = carousel.getCarouselAlignment() == 1;
        Arrangement arrangement = Arrangement.findLowestCostArrangement(availableSpace, targetSmallChildSize, smallChildSizeMin, smallChildSizeMax, isCenterAligned ? HeroCarouselStrategy.doubleCounts(smallCounts) : smallCounts, targetMediumChildSize, isCenterAligned ? HeroCarouselStrategy.doubleCounts(MEDIUM_COUNTS) : MEDIUM_COUNTS, targetLargeChildSize, largeCounts);
        this.keylineCount = arrangement.getItemCount();
        if (arrangement.getItemCount() > carousel.getItemCount()) {
            isCenterAligned = false;
            arrangement = Arrangement.findLowestCostArrangement(availableSpace, targetSmallChildSize, smallChildSizeMin, smallChildSizeMax, smallCounts, targetMediumChildSize, MEDIUM_COUNTS, targetLargeChildSize, largeCounts);
        }
        return CarouselStrategyHelper.createKeylineState(child.getContext(), childMargins, availableSpace, arrangement, isCenterAligned ? 1 : 0);
    }

    @Override
    boolean shouldRefreshKeylineState(@NonNull Carousel carousel, int oldItemCount) {
        return carousel.getCarouselAlignment() == 1 && (oldItemCount < this.keylineCount && carousel.getItemCount() >= this.keylineCount || oldItemCount >= this.keylineCount && carousel.getItemCount() < this.keylineCount);
    }
}

