/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.carousel;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.math.MathUtils;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.carousel.Maskable;
import com.google.android.material.carousel.OnMaskChangedListener;
import com.google.android.material.shape.AbsoluteCornerSize;
import com.google.android.material.shape.ClampedCornerSize;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.Shapeable;
import com.google.android.material.shape.ShapeableDelegate;

public class MaskableFrameLayout
extends FrameLayout
implements Maskable,
Shapeable {
    private static final int NOT_SET = -1;
    private float maskXPercentage = -1.0f;
    private final RectF maskRect = new RectF();
    @Nullable
    private OnMaskChangedListener onMaskChangedListener;
    @NonNull
    private ShapeAppearanceModel shapeAppearanceModel;
    private final ShapeableDelegate shapeableDelegate = ShapeableDelegate.create((View)this);
    @Nullable
    private Boolean savedForceCompatClippingEnabled = null;

    public MaskableFrameLayout(@NonNull Context context) {
        this(context, null);
    }

    public MaskableFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaskableFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setShapeAppearanceModel(ShapeAppearanceModel.builder(context, attrs, defStyleAttr, 0, 0).build());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.maskXPercentage != -1.0f) {
            this.updateMaskRectForMaskXPercentage();
        }
    }

    public void getFocusedRect(Rect r) {
        r.set((int)this.maskRect.left, (int)this.maskRect.top, (int)this.maskRect.right, (int)this.maskRect.bottom);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.savedForceCompatClippingEnabled != null) {
            this.shapeableDelegate.setForceCompatClippingEnabled((View)this, this.savedForceCompatClippingEnabled);
        }
    }

    protected void onDetachedFromWindow() {
        this.savedForceCompatClippingEnabled = this.shapeableDelegate.isForceCompatClippingEnabled();
        this.shapeableDelegate.setForceCompatClippingEnabled((View)this, true);
        super.onDetachedFromWindow();
    }

    @Override
    public void setShapeAppearanceModel(@NonNull ShapeAppearanceModel shapeAppearanceModel) {
        this.shapeAppearanceModel = shapeAppearanceModel.withTransformedCornerSizes(cornerSize -> {
            if (cornerSize instanceof AbsoluteCornerSize) {
                return ClampedCornerSize.createFromCornerSize((AbsoluteCornerSize)cornerSize);
            }
            return cornerSize;
        });
        this.shapeableDelegate.onShapeAppearanceChanged((View)this, this.shapeAppearanceModel);
    }

    @Override
    @NonNull
    public ShapeAppearanceModel getShapeAppearanceModel() {
        return this.shapeAppearanceModel;
    }

    @Override
    @Deprecated
    public void setMaskXPercentage(float percentage) {
        if (this.maskXPercentage != (percentage = MathUtils.clamp(percentage, 0.0f, 1.0f))) {
            this.maskXPercentage = percentage;
            this.updateMaskRectForMaskXPercentage();
        }
    }

    private void updateMaskRectForMaskXPercentage() {
        if (this.maskXPercentage != -1.0f) {
            float maskWidth = AnimationUtils.lerp(0.0f, (float)this.getWidth() / 2.0f, 0.0f, 1.0f, this.maskXPercentage);
            this.setMaskRectF(new RectF(maskWidth, 0.0f, (float)this.getWidth() - maskWidth, (float)this.getHeight()));
        }
    }

    @Override
    public void setMaskRectF(@NonNull RectF maskRect) {
        this.maskRect.set(maskRect);
        this.onMaskChanged();
    }

    @Override
    @Deprecated
    public float getMaskXPercentage() {
        return this.maskXPercentage;
    }

    @Override
    @NonNull
    public RectF getMaskRectF() {
        return this.maskRect;
    }

    @Override
    public void setOnMaskChangedListener(@Nullable OnMaskChangedListener onMaskChangedListener) {
        this.onMaskChangedListener = onMaskChangedListener;
    }

    private void onMaskChanged() {
        this.shapeableDelegate.onMaskChanged((View)this, this.maskRect);
        if (this.onMaskChangedListener != null) {
            this.onMaskChangedListener.onMaskChanged(this.maskRect);
        }
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setForceCompatClipping(boolean forceCompatClipping) {
        this.shapeableDelegate.setForceCompatClippingEnabled((View)this, forceCompatClipping);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        float y;
        float x;
        if (!this.maskRect.isEmpty() && event.getAction() == 0 && !this.maskRect.contains(x = event.getX(), y = event.getY())) {
            return false;
        }
        return super.onTouchEvent(event);
    }

    protected void dispatchDraw(Canvas canvas) {
        this.shapeableDelegate.maybeClip(canvas, x$0 -> super.dispatchDraw(x$0));
    }
}

