/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.chip;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import androidx.annotation.AnimatorRes;
import androidx.annotation.AttrRes;
import androidx.annotation.BoolRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.annotation.XmlRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.graphics.ColorUtils;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.graphics.drawable.TintAwareDrawable;
import androidx.core.text.BidiFormatter;
import com.google.android.material.R;
import com.google.android.material.animation.MotionSpec;
import com.google.android.material.canvas.CanvasCompat;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.drawable.DrawableUtils;
import com.google.android.material.internal.TextDrawableHelper;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.resources.TextAppearance;
import com.google.android.material.ripple.RippleUtils;
import com.google.android.material.shape.MaterialShapeDrawable;
import java.lang.ref.WeakReference;
import java.util.Arrays;

public class ChipDrawable
extends MaterialShapeDrawable
implements TintAwareDrawable,
Drawable.Callback,
TextDrawableHelper.TextDrawableDelegate {
    private static final boolean DEBUG = false;
    private static final int[] DEFAULT_STATE = new int[]{16842910};
    private static final String NAMESPACE_APP = "http://schemas.android.com/apk/res-auto";
    private static final int MAX_CHIP_ICON_HEIGHT = 24;
    private static final ShapeDrawable closeIconRippleMask = new ShapeDrawable((Shape)new OvalShape());
    @Nullable
    private ColorStateList chipSurfaceColor;
    @Nullable
    private ColorStateList chipBackgroundColor;
    private float chipMinHeight;
    private float chipCornerRadius = -1.0f;
    @Nullable
    private ColorStateList chipStrokeColor;
    private float chipStrokeWidth;
    @Nullable
    private ColorStateList rippleColor;
    @Nullable
    private CharSequence text;
    private boolean chipIconVisible;
    @Nullable
    private Drawable chipIcon;
    @Nullable
    private ColorStateList chipIconTint;
    private float chipIconSize;
    private boolean hasChipIconTint;
    private boolean closeIconVisible;
    @Nullable
    private Drawable closeIcon;
    @Nullable
    private Drawable closeIconRipple;
    @Nullable
    private ColorStateList closeIconTint;
    private float closeIconSize;
    @Nullable
    private CharSequence closeIconContentDescription;
    private boolean checkable;
    private boolean checkedIconVisible;
    @Nullable
    private Drawable checkedIcon;
    @Nullable
    private ColorStateList checkedIconTint;
    @Nullable
    private MotionSpec showMotionSpec;
    @Nullable
    private MotionSpec hideMotionSpec;
    private float chipStartPadding;
    private float iconStartPadding;
    private float iconEndPadding;
    private float textStartPadding;
    private float textEndPadding;
    private float closeIconStartPadding;
    private float closeIconEndPadding;
    private float chipEndPadding;
    @NonNull
    private final Context context;
    private final Paint chipPaint = new Paint(1);
    @Nullable
    private final Paint debugPaint;
    private final Paint.FontMetrics fontMetrics = new Paint.FontMetrics();
    private final RectF rectF = new RectF();
    private final PointF pointF = new PointF();
    private final Path shapePath = new Path();
    @NonNull
    private final TextDrawableHelper textDrawableHelper;
    @ColorInt
    private int currentChipSurfaceColor;
    @ColorInt
    private int currentChipBackgroundColor;
    @ColorInt
    private int currentCompositeSurfaceBackgroundColor;
    @ColorInt
    private int currentChipStrokeColor;
    @ColorInt
    private int currentCompatRippleColor;
    @ColorInt
    private int currentTextColor;
    private boolean currentChecked;
    @ColorInt
    private int currentTint;
    private int alpha = 255;
    @Nullable
    private ColorFilter colorFilter;
    @Nullable
    private PorterDuffColorFilter tintFilter;
    @Nullable
    private ColorStateList tint;
    @Nullable
    private PorterDuff.Mode tintMode = PorterDuff.Mode.SRC_IN;
    private int[] closeIconStateSet;
    private boolean useCompatRipple;
    @Nullable
    private ColorStateList compatRippleColor;
    @NonNull
    private WeakReference<Delegate> delegate = new WeakReference<Object>(null);
    private TextUtils.TruncateAt truncateAt;
    private boolean shouldDrawText;
    private int maxWidth;
    private boolean isShapeThemingEnabled;

    @NonNull
    public static ChipDrawable createFromAttributes(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        ChipDrawable chip = new ChipDrawable(context, attrs, defStyleAttr, defStyleRes);
        chip.loadFromAttributes(attrs, defStyleAttr, defStyleRes);
        return chip;
    }

    @NonNull
    public static ChipDrawable createFromResource(@NonNull Context context, @XmlRes int id2) {
        AttributeSet attrs = DrawableUtils.parseDrawableXml(context, id2, "chip");
        int style2 = attrs.getStyleAttribute();
        if (style2 == 0) {
            style2 = R.style.Widget_MaterialComponents_Chip_Entry;
        }
        return ChipDrawable.createFromAttributes(context, attrs, R.attr.chipStandaloneStyle, style2);
    }

    private ChipDrawable(@NonNull Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initializeElevationOverlay(context);
        this.context = context;
        this.textDrawableHelper = new TextDrawableHelper(this);
        this.text = "";
        this.textDrawableHelper.getTextPaint().density = context.getResources().getDisplayMetrics().density;
        this.debugPaint = null;
        if (this.debugPaint != null) {
            this.debugPaint.setStyle(Paint.Style.STROKE);
        }
        this.setState(DEFAULT_STATE);
        this.setCloseIconState(DEFAULT_STATE);
        this.shouldDrawText = true;
        if (RippleUtils.USE_FRAMEWORK_RIPPLE) {
            closeIconRippleMask.setTint(-1);
        }
    }

    private void loadFromAttributes(@Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(this.context, attrs, R.styleable.Chip, defStyleAttr, defStyleRes, new int[0]);
        this.isShapeThemingEnabled = a.hasValue(R.styleable.Chip_shapeAppearance);
        this.setChipSurfaceColor(MaterialResources.getColorStateList(this.context, a, R.styleable.Chip_chipSurfaceColor));
        this.setChipBackgroundColor(MaterialResources.getColorStateList(this.context, a, R.styleable.Chip_chipBackgroundColor));
        this.setChipMinHeight(a.getDimension(R.styleable.Chip_chipMinHeight, 0.0f));
        if (a.hasValue(R.styleable.Chip_chipCornerRadius)) {
            this.setChipCornerRadius(a.getDimension(R.styleable.Chip_chipCornerRadius, 0.0f));
        }
        this.setChipStrokeColor(MaterialResources.getColorStateList(this.context, a, R.styleable.Chip_chipStrokeColor));
        this.setChipStrokeWidth(a.getDimension(R.styleable.Chip_chipStrokeWidth, 0.0f));
        this.setRippleColor(MaterialResources.getColorStateList(this.context, a, R.styleable.Chip_rippleColor));
        this.setText(a.getText(R.styleable.Chip_android_text));
        TextAppearance textAppearance = MaterialResources.getTextAppearance(this.context, a, R.styleable.Chip_android_textAppearance);
        float textSize = a.getDimension(R.styleable.Chip_android_textSize, textAppearance.getTextSize());
        textAppearance.setTextSize(textSize);
        if (Build.VERSION.SDK_INT < 23) {
            textAppearance.setTextColor(MaterialResources.getColorStateList(this.context, a, R.styleable.Chip_android_textColor));
        }
        this.setTextAppearance(textAppearance);
        int ellipsize = a.getInt(R.styleable.Chip_android_ellipsize, 0);
        switch (ellipsize) {
            case 1: {
                this.setEllipsize(TextUtils.TruncateAt.START);
                break;
            }
            case 2: {
                this.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                break;
            }
            case 3: {
                this.setEllipsize(TextUtils.TruncateAt.END);
                break;
            }
        }
        this.setChipIconVisible(a.getBoolean(R.styleable.Chip_chipIconVisible, false));
        if (attrs != null && attrs.getAttributeValue(NAMESPACE_APP, "chipIconEnabled") != null && attrs.getAttributeValue(NAMESPACE_APP, "chipIconVisible") == null) {
            this.setChipIconVisible(a.getBoolean(R.styleable.Chip_chipIconEnabled, false));
        }
        this.setChipIcon(MaterialResources.getDrawable(this.context, a, R.styleable.Chip_chipIcon));
        if (a.hasValue(R.styleable.Chip_chipIconTint)) {
            this.setChipIconTint(MaterialResources.getColorStateList(this.context, a, R.styleable.Chip_chipIconTint));
        }
        this.setChipIconSize(a.getDimension(R.styleable.Chip_chipIconSize, -1.0f));
        this.setCloseIconVisible(a.getBoolean(R.styleable.Chip_closeIconVisible, false));
        if (attrs != null && attrs.getAttributeValue(NAMESPACE_APP, "closeIconEnabled") != null && attrs.getAttributeValue(NAMESPACE_APP, "closeIconVisible") == null) {
            this.setCloseIconVisible(a.getBoolean(R.styleable.Chip_closeIconEnabled, false));
        }
        this.setCloseIcon(MaterialResources.getDrawable(this.context, a, R.styleable.Chip_closeIcon));
        this.setCloseIconTint(MaterialResources.getColorStateList(this.context, a, R.styleable.Chip_closeIconTint));
        this.setCloseIconSize(a.getDimension(R.styleable.Chip_closeIconSize, 0.0f));
        this.setCheckable(a.getBoolean(R.styleable.Chip_android_checkable, false));
        this.setCheckedIconVisible(a.getBoolean(R.styleable.Chip_checkedIconVisible, false));
        if (attrs != null && attrs.getAttributeValue(NAMESPACE_APP, "checkedIconEnabled") != null && attrs.getAttributeValue(NAMESPACE_APP, "checkedIconVisible") == null) {
            this.setCheckedIconVisible(a.getBoolean(R.styleable.Chip_checkedIconEnabled, false));
        }
        this.setCheckedIcon(MaterialResources.getDrawable(this.context, a, R.styleable.Chip_checkedIcon));
        if (a.hasValue(R.styleable.Chip_checkedIconTint)) {
            this.setCheckedIconTint(MaterialResources.getColorStateList(this.context, a, R.styleable.Chip_checkedIconTint));
        }
        this.setShowMotionSpec(MotionSpec.createFromAttribute(this.context, a, R.styleable.Chip_showMotionSpec));
        this.setHideMotionSpec(MotionSpec.createFromAttribute(this.context, a, R.styleable.Chip_hideMotionSpec));
        this.setChipStartPadding(a.getDimension(R.styleable.Chip_chipStartPadding, 0.0f));
        this.setIconStartPadding(a.getDimension(R.styleable.Chip_iconStartPadding, 0.0f));
        this.setIconEndPadding(a.getDimension(R.styleable.Chip_iconEndPadding, 0.0f));
        this.setTextStartPadding(a.getDimension(R.styleable.Chip_textStartPadding, 0.0f));
        this.setTextEndPadding(a.getDimension(R.styleable.Chip_textEndPadding, 0.0f));
        this.setCloseIconStartPadding(a.getDimension(R.styleable.Chip_closeIconStartPadding, 0.0f));
        this.setCloseIconEndPadding(a.getDimension(R.styleable.Chip_closeIconEndPadding, 0.0f));
        this.setChipEndPadding(a.getDimension(R.styleable.Chip_chipEndPadding, 0.0f));
        this.setMaxWidth(a.getDimensionPixelSize(R.styleable.Chip_android_maxWidth, Integer.MAX_VALUE));
        a.recycle();
    }

    public void setUseCompatRipple(boolean useCompatRipple) {
        if (this.useCompatRipple != useCompatRipple) {
            this.useCompatRipple = useCompatRipple;
            this.updateCompatRippleColor();
            this.onStateChange(this.getState());
        }
    }

    public boolean getUseCompatRipple() {
        return this.useCompatRipple;
    }

    public void setDelegate(@Nullable Delegate delegate) {
        this.delegate = new WeakReference<Delegate>(delegate);
    }

    protected void onSizeChange() {
        Delegate delegate = (Delegate)this.delegate.get();
        if (delegate != null) {
            delegate.onChipDrawableSizeChange();
        }
    }

    public void getChipTouchBounds(@NonNull RectF bounds) {
        this.calculateChipTouchBounds(this.getBounds(), bounds);
    }

    public void getCloseIconTouchBounds(@NonNull RectF bounds) {
        this.calculateCloseIconTouchBounds(this.getBounds(), bounds);
    }

    public int getIntrinsicWidth() {
        int calculatedWidth = Math.round(this.chipStartPadding + this.calculateChipIconWidth() + this.textStartPadding + this.textDrawableHelper.getTextWidth(this.getText().toString()) + this.textEndPadding + this.calculateCloseIconWidth() + this.chipEndPadding);
        return Math.min(calculatedWidth, this.maxWidth);
    }

    public int getIntrinsicHeight() {
        return (int)this.chipMinHeight;
    }

    private boolean showsChipIcon() {
        return this.chipIconVisible && this.chipIcon != null;
    }

    private boolean showsCheckedIcon() {
        return this.checkedIconVisible && this.checkedIcon != null && this.currentChecked;
    }

    private boolean showsCloseIcon() {
        return this.closeIconVisible && this.closeIcon != null;
    }

    private boolean canShowCheckedIcon() {
        return this.checkedIconVisible && this.checkedIcon != null && this.checkable;
    }

    float calculateChipIconWidth() {
        if (this.showsChipIcon() || this.showsCheckedIcon()) {
            return this.iconStartPadding + this.getCurrentChipIconWidth() + this.iconEndPadding;
        }
        return 0.0f;
    }

    private float getCurrentChipIconWidth() {
        Drawable iconDrawable;
        Drawable drawable2 = iconDrawable = this.currentChecked ? this.checkedIcon : this.chipIcon;
        if (this.chipIconSize <= 0.0f && iconDrawable != null) {
            return iconDrawable.getIntrinsicWidth();
        }
        return this.chipIconSize;
    }

    private float getCurrentChipIconHeight() {
        Drawable icon;
        Drawable drawable2 = icon = this.currentChecked ? this.checkedIcon : this.chipIcon;
        if (this.chipIconSize <= 0.0f && icon != null) {
            float maxChipIconHeight = (float)Math.ceil(ViewUtils.dpToPx(this.context, 24));
            if ((float)icon.getIntrinsicHeight() <= maxChipIconHeight) {
                return icon.getIntrinsicHeight();
            }
            return maxChipIconHeight;
        }
        return this.chipIconSize;
    }

    float calculateCloseIconWidth() {
        if (this.showsCloseIcon()) {
            return this.closeIconStartPadding + this.closeIconSize + this.closeIconEndPadding;
        }
        return 0.0f;
    }

    boolean isShapeThemingEnabled() {
        return this.isShapeThemingEnabled;
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        Rect bounds = this.getBounds();
        if (bounds.isEmpty() || this.getAlpha() == 0) {
            return;
        }
        int saveCount = 0;
        if (this.alpha < 255) {
            saveCount = CanvasCompat.saveLayerAlpha(canvas, bounds.left, bounds.top, bounds.right, bounds.bottom, this.alpha);
        }
        this.drawChipSurface(canvas, bounds);
        this.drawChipBackground(canvas, bounds);
        if (this.isShapeThemingEnabled) {
            super.draw(canvas);
        }
        this.drawChipStroke(canvas, bounds);
        this.drawCompatRipple(canvas, bounds);
        this.drawChipIcon(canvas, bounds);
        this.drawCheckedIcon(canvas, bounds);
        if (this.shouldDrawText) {
            this.drawText(canvas, bounds);
        }
        this.drawCloseIcon(canvas, bounds);
        this.drawDebug(canvas, bounds);
        if (this.alpha < 255) {
            canvas.restoreToCount(saveCount);
        }
    }

    private void drawChipSurface(@NonNull Canvas canvas, @NonNull Rect bounds) {
        if (!this.isShapeThemingEnabled) {
            this.chipPaint.setColor(this.currentChipSurfaceColor);
            this.chipPaint.setStyle(Paint.Style.FILL);
            this.rectF.set(bounds);
            canvas.drawRoundRect(this.rectF, this.getChipCornerRadius(), this.getChipCornerRadius(), this.chipPaint);
        }
    }

    private void drawChipBackground(@NonNull Canvas canvas, @NonNull Rect bounds) {
        if (!this.isShapeThemingEnabled) {
            this.chipPaint.setColor(this.currentChipBackgroundColor);
            this.chipPaint.setStyle(Paint.Style.FILL);
            this.chipPaint.setColorFilter(this.getTintColorFilter());
            this.rectF.set(bounds);
            canvas.drawRoundRect(this.rectF, this.getChipCornerRadius(), this.getChipCornerRadius(), this.chipPaint);
        }
    }

    private void drawChipStroke(@NonNull Canvas canvas, @NonNull Rect bounds) {
        if (this.chipStrokeWidth > 0.0f && !this.isShapeThemingEnabled) {
            this.chipPaint.setColor(this.currentChipStrokeColor);
            this.chipPaint.setStyle(Paint.Style.STROKE);
            if (!this.isShapeThemingEnabled) {
                this.chipPaint.setColorFilter(this.getTintColorFilter());
            }
            this.rectF.set((float)bounds.left + this.chipStrokeWidth / 2.0f, (float)bounds.top + this.chipStrokeWidth / 2.0f, (float)bounds.right - this.chipStrokeWidth / 2.0f, (float)bounds.bottom - this.chipStrokeWidth / 2.0f);
            float strokeCornerRadius = this.chipCornerRadius - this.chipStrokeWidth / 2.0f;
            canvas.drawRoundRect(this.rectF, strokeCornerRadius, strokeCornerRadius, this.chipPaint);
        }
    }

    private void drawCompatRipple(@NonNull Canvas canvas, @NonNull Rect bounds) {
        this.chipPaint.setColor(this.currentCompatRippleColor);
        this.chipPaint.setStyle(Paint.Style.FILL);
        this.rectF.set(bounds);
        if (!this.isShapeThemingEnabled) {
            canvas.drawRoundRect(this.rectF, this.getChipCornerRadius(), this.getChipCornerRadius(), this.chipPaint);
        } else {
            this.calculatePathForSize(new RectF(bounds), this.shapePath);
            super.drawShape(canvas, this.chipPaint, this.shapePath, this.getBoundsAsRectF());
        }
    }

    private void drawChipIcon(@NonNull Canvas canvas, @NonNull Rect bounds) {
        if (this.showsChipIcon()) {
            this.calculateChipIconBounds(bounds, this.rectF);
            float tx = this.rectF.left;
            float ty = this.rectF.top;
            canvas.translate(tx, ty);
            this.chipIcon.setBounds(0, 0, (int)this.rectF.width(), (int)this.rectF.height());
            this.chipIcon.draw(canvas);
            canvas.translate(-tx, -ty);
        }
    }

    private void drawCheckedIcon(@NonNull Canvas canvas, @NonNull Rect bounds) {
        if (this.showsCheckedIcon()) {
            this.calculateChipIconBounds(bounds, this.rectF);
            float tx = this.rectF.left;
            float ty = this.rectF.top;
            canvas.translate(tx, ty);
            this.checkedIcon.setBounds(0, 0, (int)this.rectF.width(), (int)this.rectF.height());
            this.checkedIcon.draw(canvas);
            canvas.translate(-tx, -ty);
        }
    }

    private void drawText(@NonNull Canvas canvas, @NonNull Rect bounds) {
        if (this.text != null) {
            Paint.Align align = this.calculateTextOriginAndAlignment(bounds, this.pointF);
            this.calculateTextBounds(bounds, this.rectF);
            if (this.textDrawableHelper.getTextAppearance() != null) {
                this.textDrawableHelper.getTextPaint().drawableState = this.getState();
                this.textDrawableHelper.updateTextPaintDrawState(this.context);
            }
            this.textDrawableHelper.getTextPaint().setTextAlign(align);
            boolean clip = Math.round(this.textDrawableHelper.getTextWidth(this.getText().toString())) > Math.round(this.rectF.width());
            int saveCount = 0;
            if (clip) {
                saveCount = canvas.save();
                canvas.clipRect(this.rectF);
            }
            CharSequence finalText = this.text;
            if (clip && this.truncateAt != null) {
                finalText = TextUtils.ellipsize((CharSequence)this.text, (TextPaint)this.textDrawableHelper.getTextPaint(), (float)this.rectF.width(), (TextUtils.TruncateAt)this.truncateAt);
            }
            canvas.drawText(finalText, 0, finalText.length(), this.pointF.x, this.pointF.y, (Paint)this.textDrawableHelper.getTextPaint());
            if (clip) {
                canvas.restoreToCount(saveCount);
            }
        }
    }

    private void drawCloseIcon(@NonNull Canvas canvas, @NonNull Rect bounds) {
        if (this.showsCloseIcon()) {
            this.calculateCloseIconBounds(bounds, this.rectF);
            float tx = this.rectF.left;
            float ty = this.rectF.top;
            canvas.translate(tx, ty);
            this.closeIcon.setBounds(0, 0, (int)this.rectF.width(), (int)this.rectF.height());
            if (RippleUtils.USE_FRAMEWORK_RIPPLE) {
                this.closeIconRipple.setBounds(this.closeIcon.getBounds());
                this.closeIconRipple.jumpToCurrentState();
                this.closeIconRipple.draw(canvas);
            } else {
                this.closeIcon.draw(canvas);
            }
            canvas.translate(-tx, -ty);
        }
    }

    private void drawDebug(@NonNull Canvas canvas, @NonNull Rect bounds) {
        if (this.debugPaint != null) {
            this.debugPaint.setColor(ColorUtils.setAlphaComponent(-16777216, 127));
            canvas.drawRect(bounds, this.debugPaint);
            if (this.showsChipIcon() || this.showsCheckedIcon()) {
                this.calculateChipIconBounds(bounds, this.rectF);
                canvas.drawRect(this.rectF, this.debugPaint);
            }
            if (this.text != null) {
                canvas.drawLine((float)bounds.left, bounds.exactCenterY(), (float)bounds.right, bounds.exactCenterY(), this.debugPaint);
            }
            if (this.showsCloseIcon()) {
                this.calculateCloseIconBounds(bounds, this.rectF);
                canvas.drawRect(this.rectF, this.debugPaint);
            }
            this.debugPaint.setColor(ColorUtils.setAlphaComponent(-65536, 127));
            this.calculateChipTouchBounds(bounds, this.rectF);
            canvas.drawRect(this.rectF, this.debugPaint);
            this.debugPaint.setColor(ColorUtils.setAlphaComponent(-16711936, 127));
            this.calculateCloseIconTouchBounds(bounds, this.rectF);
            canvas.drawRect(this.rectF, this.debugPaint);
        }
    }

    private void calculateChipIconBounds(@NonNull Rect bounds, @NonNull RectF outBounds) {
        outBounds.setEmpty();
        if (this.showsChipIcon() || this.showsCheckedIcon()) {
            float offsetFromStart = this.chipStartPadding + this.iconStartPadding;
            float chipWidth = this.getCurrentChipIconWidth();
            if (DrawableCompat.getLayoutDirection(this) == 0) {
                outBounds.left = (float)bounds.left + offsetFromStart;
                outBounds.right = outBounds.left + chipWidth;
            } else {
                outBounds.right = (float)bounds.right - offsetFromStart;
                outBounds.left = outBounds.right - chipWidth;
            }
            float chipHeight = this.getCurrentChipIconHeight();
            outBounds.top = bounds.exactCenterY() - chipHeight / 2.0f;
            outBounds.bottom = outBounds.top + chipHeight;
        }
    }

    @NonNull
    Paint.Align calculateTextOriginAndAlignment(@NonNull Rect bounds, @NonNull PointF pointF) {
        pointF.set(0.0f, 0.0f);
        Paint.Align align = Paint.Align.LEFT;
        if (this.text != null) {
            float offsetFromStart = this.chipStartPadding + this.calculateChipIconWidth() + this.textStartPadding;
            if (DrawableCompat.getLayoutDirection(this) == 0) {
                pointF.x = (float)bounds.left + offsetFromStart;
                align = Paint.Align.LEFT;
            } else {
                pointF.x = (float)bounds.right - offsetFromStart;
                align = Paint.Align.RIGHT;
            }
            pointF.y = (float)bounds.centerY() - this.calculateTextCenterFromBaseline();
        }
        return align;
    }

    private float calculateTextCenterFromBaseline() {
        this.textDrawableHelper.getTextPaint().getFontMetrics(this.fontMetrics);
        return (this.fontMetrics.descent + this.fontMetrics.ascent) / 2.0f;
    }

    private void calculateTextBounds(@NonNull Rect bounds, @NonNull RectF outBounds) {
        outBounds.setEmpty();
        if (this.text != null) {
            float offsetFromStart = this.chipStartPadding + this.calculateChipIconWidth() + this.textStartPadding;
            float offsetFromEnd = this.chipEndPadding + this.calculateCloseIconWidth() + this.textEndPadding;
            if (DrawableCompat.getLayoutDirection(this) == 0) {
                outBounds.left = (float)bounds.left + offsetFromStart;
                outBounds.right = (float)bounds.right - offsetFromEnd;
            } else {
                outBounds.left = (float)bounds.left + offsetFromEnd;
                outBounds.right = (float)bounds.right - offsetFromStart;
            }
            outBounds.top = bounds.top;
            outBounds.bottom = bounds.bottom;
        }
    }

    private void calculateCloseIconBounds(@NonNull Rect bounds, @NonNull RectF outBounds) {
        outBounds.setEmpty();
        if (this.showsCloseIcon()) {
            float offsetFromEnd = this.chipEndPadding + this.closeIconEndPadding;
            if (DrawableCompat.getLayoutDirection(this) == 0) {
                outBounds.right = (float)bounds.right - offsetFromEnd;
                outBounds.left = outBounds.right - this.closeIconSize;
            } else {
                outBounds.left = (float)bounds.left + offsetFromEnd;
                outBounds.right = outBounds.left + this.closeIconSize;
            }
            outBounds.top = bounds.exactCenterY() - this.closeIconSize / 2.0f;
            outBounds.bottom = outBounds.top + this.closeIconSize;
        }
    }

    private void calculateChipTouchBounds(@NonNull Rect bounds, @NonNull RectF outBounds) {
        outBounds.set(bounds);
        if (this.showsCloseIcon()) {
            float offsetFromEnd = this.chipEndPadding + this.closeIconEndPadding + this.closeIconSize + this.closeIconStartPadding + this.textEndPadding;
            if (DrawableCompat.getLayoutDirection(this) == 0) {
                outBounds.right = (float)bounds.right - offsetFromEnd;
            } else {
                outBounds.left = (float)bounds.left + offsetFromEnd;
            }
        }
    }

    private void calculateCloseIconTouchBounds(@NonNull Rect bounds, @NonNull RectF outBounds) {
        outBounds.setEmpty();
        if (this.showsCloseIcon()) {
            float offsetFromEnd = this.chipEndPadding + this.closeIconEndPadding + this.closeIconSize + this.closeIconStartPadding + this.textEndPadding;
            if (DrawableCompat.getLayoutDirection(this) == 0) {
                outBounds.right = bounds.right;
                outBounds.left = outBounds.right - offsetFromEnd;
            } else {
                outBounds.left = bounds.left;
                outBounds.right = (float)bounds.left + offsetFromEnd;
            }
            outBounds.top = bounds.top;
            outBounds.bottom = bounds.bottom;
        }
    }

    @Override
    public boolean isStateful() {
        return ChipDrawable.isStateful(this.chipSurfaceColor) || ChipDrawable.isStateful(this.chipBackgroundColor) || ChipDrawable.isStateful(this.chipStrokeColor) || this.useCompatRipple && ChipDrawable.isStateful(this.compatRippleColor) || ChipDrawable.isStateful(this.textDrawableHelper.getTextAppearance()) || this.canShowCheckedIcon() || ChipDrawable.isStateful(this.chipIcon) || ChipDrawable.isStateful(this.checkedIcon) || ChipDrawable.isStateful(this.tint);
    }

    public boolean isCloseIconStateful() {
        return ChipDrawable.isStateful(this.closeIcon);
    }

    public boolean setCloseIconState(@NonNull int[] stateSet) {
        if (!Arrays.equals(this.closeIconStateSet, stateSet)) {
            this.closeIconStateSet = stateSet;
            if (this.showsCloseIcon()) {
                return this.onStateChange(this.getState(), stateSet);
            }
        }
        return false;
    }

    @NonNull
    public int[] getCloseIconState() {
        return this.closeIconStateSet;
    }

    @Override
    public void onTextSizeChange() {
        this.onSizeChange();
        this.invalidateSelf();
    }

    @Override
    public boolean onStateChange(@NonNull int[] state) {
        if (this.isShapeThemingEnabled) {
            super.onStateChange(state);
        }
        return this.onStateChange(state, this.getCloseIconState());
    }

    private boolean onStateChange(@NonNull int[] chipState, @NonNull int[] closeIconState) {
        int newTint;
        boolean newChecked;
        int newTextColor;
        int newCompatRippleColor;
        int newChipStrokeColor;
        int newCompositeSurfaceBackgroundColor;
        boolean invalidate = super.onStateChange(chipState);
        boolean sizeChanged = false;
        int newChipSurfaceColor = this.chipSurfaceColor != null ? this.chipSurfaceColor.getColorForState(chipState, this.currentChipSurfaceColor) : 0;
        if (this.currentChipSurfaceColor != (newChipSurfaceColor = this.compositeElevationOverlayIfNeeded(newChipSurfaceColor))) {
            this.currentChipSurfaceColor = newChipSurfaceColor;
            invalidate = true;
        }
        int newChipBackgroundColor = this.chipBackgroundColor != null ? this.chipBackgroundColor.getColorForState(chipState, this.currentChipBackgroundColor) : 0;
        if (this.currentChipBackgroundColor != (newChipBackgroundColor = this.compositeElevationOverlayIfNeeded(newChipBackgroundColor))) {
            this.currentChipBackgroundColor = newChipBackgroundColor;
            invalidate = true;
        }
        boolean shouldUpdate = this.currentCompositeSurfaceBackgroundColor != (newCompositeSurfaceBackgroundColor = MaterialColors.layer(newChipSurfaceColor, newChipBackgroundColor));
        if (shouldUpdate |= this.getFillColor() == null) {
            this.currentCompositeSurfaceBackgroundColor = newCompositeSurfaceBackgroundColor;
            this.setFillColor(ColorStateList.valueOf((int)this.currentCompositeSurfaceBackgroundColor));
            invalidate = true;
        }
        int n = newChipStrokeColor = this.chipStrokeColor != null ? this.chipStrokeColor.getColorForState(chipState, this.currentChipStrokeColor) : 0;
        if (this.currentChipStrokeColor != newChipStrokeColor) {
            this.currentChipStrokeColor = newChipStrokeColor;
            invalidate = true;
        }
        int n2 = newCompatRippleColor = this.compatRippleColor != null && RippleUtils.shouldDrawRippleCompat(chipState) ? this.compatRippleColor.getColorForState(chipState, this.currentCompatRippleColor) : 0;
        if (this.currentCompatRippleColor != newCompatRippleColor) {
            this.currentCompatRippleColor = newCompatRippleColor;
            if (this.useCompatRipple) {
                invalidate = true;
            }
        }
        int n3 = newTextColor = this.textDrawableHelper.getTextAppearance() != null && this.textDrawableHelper.getTextAppearance().getTextColor() != null ? this.textDrawableHelper.getTextAppearance().getTextColor().getColorForState(chipState, this.currentTextColor) : 0;
        if (this.currentTextColor != newTextColor) {
            this.currentTextColor = newTextColor;
            invalidate = true;
        }
        boolean bl = newChecked = ChipDrawable.hasState(this.getState(), 0x10100A0) && this.checkable;
        if (this.currentChecked != newChecked && this.checkedIcon != null) {
            float oldChipIconWidth = this.calculateChipIconWidth();
            this.currentChecked = newChecked;
            float newChipIconWidth = this.calculateChipIconWidth();
            invalidate = true;
            if (oldChipIconWidth != newChipIconWidth) {
                sizeChanged = true;
            }
        }
        int n4 = newTint = this.tint != null ? this.tint.getColorForState(chipState, this.currentTint) : 0;
        if (this.currentTint != newTint) {
            this.currentTint = newTint;
            this.tintFilter = DrawableUtils.updateTintFilter(this, this.tint, this.tintMode);
            invalidate = true;
        }
        if (ChipDrawable.isStateful(this.chipIcon)) {
            invalidate |= this.chipIcon.setState(chipState);
        }
        if (ChipDrawable.isStateful(this.checkedIcon)) {
            invalidate |= this.checkedIcon.setState(chipState);
        }
        if (ChipDrawable.isStateful(this.closeIcon)) {
            int[] closeIconMergedState = new int[chipState.length + closeIconState.length];
            System.arraycopy(chipState, 0, closeIconMergedState, 0, chipState.length);
            System.arraycopy(closeIconState, 0, closeIconMergedState, chipState.length, closeIconState.length);
            invalidate |= this.closeIcon.setState(closeIconMergedState);
        }
        if (RippleUtils.USE_FRAMEWORK_RIPPLE && ChipDrawable.isStateful(this.closeIconRipple)) {
            invalidate |= this.closeIconRipple.setState(closeIconState);
        }
        if (invalidate) {
            this.invalidateSelf();
        }
        if (sizeChanged) {
            this.onSizeChange();
        }
        return invalidate;
    }

    private static boolean isStateful(@Nullable ColorStateList colorStateList) {
        return colorStateList != null && colorStateList.isStateful();
    }

    private static boolean isStateful(@Nullable Drawable drawable2) {
        return drawable2 != null && drawable2.isStateful();
    }

    private static boolean isStateful(@Nullable TextAppearance textAppearance) {
        return textAppearance != null && textAppearance.getTextColor() != null && textAppearance.getTextColor().isStateful();
    }

    public boolean onLayoutDirectionChanged(int layoutDirection) {
        boolean invalidate = super.onLayoutDirectionChanged(layoutDirection);
        if (this.showsChipIcon()) {
            invalidate |= DrawableCompat.setLayoutDirection(this.chipIcon, layoutDirection);
        }
        if (this.showsCheckedIcon()) {
            invalidate |= DrawableCompat.setLayoutDirection(this.checkedIcon, layoutDirection);
        }
        if (this.showsCloseIcon()) {
            invalidate |= DrawableCompat.setLayoutDirection(this.closeIcon, layoutDirection);
        }
        if (invalidate) {
            this.invalidateSelf();
        }
        return true;
    }

    protected boolean onLevelChange(int level) {
        boolean invalidate = super.onLevelChange(level);
        if (this.showsChipIcon()) {
            invalidate |= this.chipIcon.setLevel(level);
        }
        if (this.showsCheckedIcon()) {
            invalidate |= this.checkedIcon.setLevel(level);
        }
        if (this.showsCloseIcon()) {
            invalidate |= this.closeIcon.setLevel(level);
        }
        if (invalidate) {
            this.invalidateSelf();
        }
        return invalidate;
    }

    public boolean setVisible(boolean visible, boolean restart) {
        boolean invalidate = super.setVisible(visible, restart);
        if (this.showsChipIcon()) {
            invalidate |= this.chipIcon.setVisible(visible, restart);
        }
        if (this.showsCheckedIcon()) {
            invalidate |= this.checkedIcon.setVisible(visible, restart);
        }
        if (this.showsCloseIcon()) {
            invalidate |= this.closeIcon.setVisible(visible, restart);
        }
        if (invalidate) {
            this.invalidateSelf();
        }
        return invalidate;
    }

    @Override
    public void setAlpha(int alpha) {
        if (this.alpha != alpha) {
            this.alpha = alpha;
            this.invalidateSelf();
        }
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        if (this.colorFilter != colorFilter) {
            this.colorFilter = colorFilter;
            this.invalidateSelf();
        }
    }

    @Nullable
    public ColorFilter getColorFilter() {
        return this.colorFilter;
    }

    @Override
    public void setTintList(@Nullable ColorStateList tint) {
        if (this.tint != tint) {
            this.tint = tint;
            this.onStateChange(this.getState());
        }
    }

    @Override
    public void setTintMode(@NonNull PorterDuff.Mode tintMode) {
        if (this.tintMode != tintMode) {
            this.tintMode = tintMode;
            this.tintFilter = DrawableUtils.updateTintFilter(this, this.tint, tintMode);
            this.invalidateSelf();
        }
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    @Override
    @TargetApi(value=21)
    public void getOutline(@NonNull Outline outline) {
        if (this.isShapeThemingEnabled) {
            super.getOutline(outline);
            return;
        }
        Rect bounds = this.getBounds();
        if (!bounds.isEmpty()) {
            outline.setRoundRect(bounds, this.chipCornerRadius);
        } else {
            outline.setRoundRect(0, 0, this.getIntrinsicWidth(), this.getIntrinsicHeight(), this.chipCornerRadius);
        }
        outline.setAlpha((float)this.getAlpha() / 255.0f);
    }

    public void invalidateDrawable(@NonNull Drawable who) {
        Drawable.Callback callback2 = this.getCallback();
        if (callback2 != null) {
            callback2.invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
        Drawable.Callback callback2 = this.getCallback();
        if (callback2 != null) {
            callback2.scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
        Drawable.Callback callback2 = this.getCallback();
        if (callback2 != null) {
            callback2.unscheduleDrawable((Drawable)this, what);
        }
    }

    private void unapplyChildDrawable(@Nullable Drawable drawable2) {
        if (drawable2 != null) {
            drawable2.setCallback(null);
        }
    }

    private void applyChildDrawable(@Nullable Drawable drawable2) {
        if (drawable2 == null) {
            return;
        }
        drawable2.setCallback((Drawable.Callback)this);
        DrawableCompat.setLayoutDirection(drawable2, DrawableCompat.getLayoutDirection(this));
        drawable2.setLevel(this.getLevel());
        drawable2.setVisible(this.isVisible(), false);
        if (drawable2 == this.closeIcon) {
            if (drawable2.isStateful()) {
                drawable2.setState(this.getCloseIconState());
            }
            DrawableCompat.setTintList(drawable2, this.closeIconTint);
            return;
        }
        if (drawable2 == this.chipIcon && this.hasChipIconTint) {
            DrawableCompat.setTintList(this.chipIcon, this.chipIconTint);
        }
        if (drawable2.isStateful()) {
            drawable2.setState(this.getState());
        }
    }

    @Nullable
    private ColorFilter getTintColorFilter() {
        return this.colorFilter != null ? this.colorFilter : this.tintFilter;
    }

    private void updateCompatRippleColor() {
        this.compatRippleColor = this.useCompatRipple ? RippleUtils.sanitizeRippleDrawableColor(this.rippleColor) : null;
    }

    private void setChipSurfaceColor(@Nullable ColorStateList chipSurfaceColor) {
        if (this.chipSurfaceColor != chipSurfaceColor) {
            this.chipSurfaceColor = chipSurfaceColor;
            this.onStateChange(this.getState());
        }
    }

    private static boolean hasState(@Nullable int[] stateSet, @AttrRes int state) {
        if (stateSet == null) {
            return false;
        }
        for (int s : stateSet) {
            if (s != state) continue;
            return true;
        }
        return false;
    }

    public void setTextSize(@Dimension float size) {
        TextAppearance textAppearance = this.getTextAppearance();
        if (textAppearance != null) {
            textAppearance.setTextSize(size);
            this.textDrawableHelper.getTextPaint().setTextSize(size);
            this.onTextSizeChange();
        }
    }

    public void setTextColor(@ColorInt int color2) {
        this.setTextColor(ColorStateList.valueOf((int)color2));
    }

    public void setTextColor(@Nullable ColorStateList color2) {
        TextAppearance textAppearance = this.getTextAppearance();
        if (textAppearance != null) {
            textAppearance.setTextColor(color2);
            this.invalidateSelf();
        }
    }

    @Nullable
    public ColorStateList getChipBackgroundColor() {
        return this.chipBackgroundColor;
    }

    public void setChipBackgroundColorResource(@ColorRes int id2) {
        this.setChipBackgroundColor(AppCompatResources.getColorStateList(this.context, id2));
    }

    public void setChipBackgroundColor(@Nullable ColorStateList chipBackgroundColor) {
        if (this.chipBackgroundColor != chipBackgroundColor) {
            this.chipBackgroundColor = chipBackgroundColor;
            this.onStateChange(this.getState());
        }
    }

    public float getChipMinHeight() {
        return this.chipMinHeight;
    }

    public void setChipMinHeightResource(@DimenRes int id2) {
        this.setChipMinHeight(this.context.getResources().getDimension(id2));
    }

    public void setChipMinHeight(float chipMinHeight) {
        if (this.chipMinHeight != chipMinHeight) {
            this.chipMinHeight = chipMinHeight;
            this.invalidateSelf();
            this.onSizeChange();
        }
    }

    public float getChipCornerRadius() {
        return this.isShapeThemingEnabled ? this.getTopLeftCornerResolvedSize() : this.chipCornerRadius;
    }

    @Deprecated
    public void setChipCornerRadiusResource(@DimenRes int id2) {
        this.setChipCornerRadius(this.context.getResources().getDimension(id2));
    }

    @Deprecated
    public void setChipCornerRadius(float chipCornerRadius) {
        if (this.chipCornerRadius != chipCornerRadius) {
            this.chipCornerRadius = chipCornerRadius;
            this.setShapeAppearanceModel(this.getShapeAppearanceModel().withCornerSize(chipCornerRadius));
        }
    }

    @Nullable
    public ColorStateList getChipStrokeColor() {
        return this.chipStrokeColor;
    }

    public void setChipStrokeColorResource(@ColorRes int id2) {
        this.setChipStrokeColor(AppCompatResources.getColorStateList(this.context, id2));
    }

    public void setChipStrokeColor(@Nullable ColorStateList chipStrokeColor) {
        if (this.chipStrokeColor != chipStrokeColor) {
            this.chipStrokeColor = chipStrokeColor;
            if (this.isShapeThemingEnabled) {
                this.setStrokeColor(chipStrokeColor);
            }
            this.onStateChange(this.getState());
        }
    }

    public float getChipStrokeWidth() {
        return this.chipStrokeWidth;
    }

    public void setChipStrokeWidthResource(@DimenRes int id2) {
        this.setChipStrokeWidth(this.context.getResources().getDimension(id2));
    }

    public void setChipStrokeWidth(float chipStrokeWidth) {
        if (this.chipStrokeWidth != chipStrokeWidth) {
            this.chipStrokeWidth = chipStrokeWidth;
            this.chipPaint.setStrokeWidth(chipStrokeWidth);
            if (this.isShapeThemingEnabled) {
                super.setStrokeWidth(chipStrokeWidth);
            }
            this.invalidateSelf();
        }
    }

    @Nullable
    public ColorStateList getRippleColor() {
        return this.rippleColor;
    }

    public void setRippleColorResource(@ColorRes int id2) {
        this.setRippleColor(AppCompatResources.getColorStateList(this.context, id2));
    }

    public void setRippleColor(@Nullable ColorStateList rippleColor) {
        if (this.rippleColor != rippleColor) {
            this.rippleColor = rippleColor;
            this.updateCompatRippleColor();
            this.onStateChange(this.getState());
        }
    }

    @Nullable
    public CharSequence getText() {
        return this.text;
    }

    public void setTextResource(@StringRes int id2) {
        this.setText(this.context.getResources().getString(id2));
    }

    public void setText(@Nullable CharSequence text) {
        if (text == null) {
            text = "";
        }
        if (!TextUtils.equals((CharSequence)this.text, (CharSequence)text)) {
            this.text = text;
            this.textDrawableHelper.setTextWidthDirty(true);
            this.invalidateSelf();
            this.onSizeChange();
        }
    }

    @Nullable
    public TextAppearance getTextAppearance() {
        return this.textDrawableHelper.getTextAppearance();
    }

    public void setTextAppearanceResource(@StyleRes int id2) {
        this.setTextAppearance(new TextAppearance(this.context, id2));
    }

    public void setTextAppearance(@Nullable TextAppearance textAppearance) {
        this.textDrawableHelper.setTextAppearance(textAppearance, this.context);
    }

    public TextUtils.TruncateAt getEllipsize() {
        return this.truncateAt;
    }

    public void setEllipsize(@Nullable TextUtils.TruncateAt truncateAt) {
        this.truncateAt = truncateAt;
    }

    public boolean isChipIconVisible() {
        return this.chipIconVisible;
    }

    @Deprecated
    public boolean isChipIconEnabled() {
        return this.isChipIconVisible();
    }

    public void setChipIconVisible(@BoolRes int id2) {
        this.setChipIconVisible(this.context.getResources().getBoolean(id2));
    }

    public void setChipIconVisible(boolean chipIconVisible) {
        if (this.chipIconVisible != chipIconVisible) {
            boolean changed;
            boolean oldShowsChipIcon = this.showsChipIcon();
            this.chipIconVisible = chipIconVisible;
            boolean newShowsChipIcon = this.showsChipIcon();
            boolean bl = changed = oldShowsChipIcon != newShowsChipIcon;
            if (changed) {
                if (newShowsChipIcon) {
                    this.applyChildDrawable(this.chipIcon);
                } else {
                    this.unapplyChildDrawable(this.chipIcon);
                }
                this.invalidateSelf();
                this.onSizeChange();
            }
        }
    }

    @Deprecated
    public void setChipIconEnabledResource(@BoolRes int id2) {
        this.setChipIconVisible(id2);
    }

    @Deprecated
    public void setChipIconEnabled(boolean chipIconEnabled) {
        this.setChipIconVisible(chipIconEnabled);
    }

    @Nullable
    public Drawable getChipIcon() {
        return this.chipIcon != null ? (Drawable)DrawableCompat.unwrap(this.chipIcon) : null;
    }

    public void setChipIconResource(@DrawableRes int id2) {
        this.setChipIcon(AppCompatResources.getDrawable(this.context, id2));
    }

    public void setChipIcon(@Nullable Drawable chipIcon) {
        Drawable oldChipIcon = this.getChipIcon();
        if (oldChipIcon != chipIcon) {
            float oldChipIconWidth = this.calculateChipIconWidth();
            this.chipIcon = chipIcon != null ? DrawableCompat.wrap(chipIcon).mutate() : null;
            float newChipIconWidth = this.calculateChipIconWidth();
            this.unapplyChildDrawable(oldChipIcon);
            if (this.showsChipIcon()) {
                this.applyChildDrawable(this.chipIcon);
            }
            this.invalidateSelf();
            if (oldChipIconWidth != newChipIconWidth) {
                this.onSizeChange();
            }
        }
    }

    @Nullable
    public ColorStateList getChipIconTint() {
        return this.chipIconTint;
    }

    public void setChipIconTintResource(@ColorRes int id2) {
        this.setChipIconTint(AppCompatResources.getColorStateList(this.context, id2));
    }

    public void setChipIconTint(@Nullable ColorStateList chipIconTint) {
        this.hasChipIconTint = true;
        if (this.chipIconTint != chipIconTint) {
            this.chipIconTint = chipIconTint;
            if (this.showsChipIcon()) {
                DrawableCompat.setTintList(this.chipIcon, chipIconTint);
            }
            this.onStateChange(this.getState());
        }
    }

    public float getChipIconSize() {
        return this.chipIconSize;
    }

    public void setChipIconSizeResource(@DimenRes int id2) {
        this.setChipIconSize(this.context.getResources().getDimension(id2));
    }

    public void setChipIconSize(float chipIconSize) {
        if (this.chipIconSize != chipIconSize) {
            float oldChipIconWidth = this.calculateChipIconWidth();
            this.chipIconSize = chipIconSize;
            float newChipIconWidth = this.calculateChipIconWidth();
            this.invalidateSelf();
            if (oldChipIconWidth != newChipIconWidth) {
                this.onSizeChange();
            }
        }
    }

    public boolean isCloseIconVisible() {
        return this.closeIconVisible;
    }

    @Deprecated
    public boolean isCloseIconEnabled() {
        return this.isCloseIconVisible();
    }

    public void setCloseIconVisible(@BoolRes int id2) {
        this.setCloseIconVisible(this.context.getResources().getBoolean(id2));
    }

    public void setCloseIconVisible(boolean closeIconVisible) {
        if (this.closeIconVisible != closeIconVisible) {
            boolean changed;
            boolean oldShowsCloseIcon = this.showsCloseIcon();
            this.closeIconVisible = closeIconVisible;
            boolean newShowsCloseIcon = this.showsCloseIcon();
            boolean bl = changed = oldShowsCloseIcon != newShowsCloseIcon;
            if (changed) {
                if (newShowsCloseIcon) {
                    this.applyChildDrawable(this.closeIcon);
                } else {
                    this.unapplyChildDrawable(this.closeIcon);
                }
                this.invalidateSelf();
                this.onSizeChange();
            }
        }
    }

    @Deprecated
    public void setCloseIconEnabledResource(@BoolRes int id2) {
        this.setCloseIconVisible(id2);
    }

    @Deprecated
    public void setCloseIconEnabled(boolean closeIconEnabled) {
        this.setCloseIconVisible(closeIconEnabled);
    }

    @Nullable
    public Drawable getCloseIcon() {
        return this.closeIcon != null ? (Drawable)DrawableCompat.unwrap(this.closeIcon) : null;
    }

    public void setCloseIconResource(@DrawableRes int id2) {
        this.setCloseIcon(AppCompatResources.getDrawable(this.context, id2));
    }

    public void setCloseIcon(@Nullable Drawable closeIcon) {
        Drawable oldCloseIcon = this.getCloseIcon();
        if (oldCloseIcon != closeIcon) {
            float oldCloseIconWidth = this.calculateCloseIconWidth();
            Drawable drawable2 = this.closeIcon = closeIcon != null ? DrawableCompat.wrap(closeIcon).mutate() : null;
            if (RippleUtils.USE_FRAMEWORK_RIPPLE) {
                this.updateFrameworkCloseIconRipple();
            }
            float newCloseIconWidth = this.calculateCloseIconWidth();
            this.unapplyChildDrawable(oldCloseIcon);
            if (this.showsCloseIcon()) {
                this.applyChildDrawable(this.closeIcon);
            }
            this.invalidateSelf();
            if (oldCloseIconWidth != newCloseIconWidth) {
                this.onSizeChange();
            }
        }
    }

    @TargetApi(value=21)
    private void updateFrameworkCloseIconRipple() {
        this.closeIconRipple = new RippleDrawable(RippleUtils.sanitizeRippleDrawableColor(this.getRippleColor()), this.closeIcon, (Drawable)closeIconRippleMask);
    }

    @Nullable
    public ColorStateList getCloseIconTint() {
        return this.closeIconTint;
    }

    public void setCloseIconTintResource(@ColorRes int id2) {
        this.setCloseIconTint(AppCompatResources.getColorStateList(this.context, id2));
    }

    public void setCloseIconTint(@Nullable ColorStateList closeIconTint) {
        if (this.closeIconTint != closeIconTint) {
            this.closeIconTint = closeIconTint;
            if (this.showsCloseIcon()) {
                DrawableCompat.setTintList(this.closeIcon, closeIconTint);
            }
            this.onStateChange(this.getState());
        }
    }

    public float getCloseIconSize() {
        return this.closeIconSize;
    }

    public void setCloseIconSizeResource(@DimenRes int id2) {
        this.setCloseIconSize(this.context.getResources().getDimension(id2));
    }

    public void setCloseIconSize(float closeIconSize) {
        if (this.closeIconSize != closeIconSize) {
            this.closeIconSize = closeIconSize;
            this.invalidateSelf();
            if (this.showsCloseIcon()) {
                this.onSizeChange();
            }
        }
    }

    public void setCloseIconContentDescription(@Nullable CharSequence closeIconContentDescription) {
        if (this.closeIconContentDescription != closeIconContentDescription) {
            this.closeIconContentDescription = BidiFormatter.getInstance().unicodeWrap(closeIconContentDescription);
            this.invalidateSelf();
        }
    }

    @Nullable
    public CharSequence getCloseIconContentDescription() {
        return this.closeIconContentDescription;
    }

    public boolean isCheckable() {
        return this.checkable;
    }

    public void setCheckableResource(@BoolRes int id2) {
        this.setCheckable(this.context.getResources().getBoolean(id2));
    }

    public void setCheckable(boolean checkable) {
        if (this.checkable != checkable) {
            this.checkable = checkable;
            float oldChipIconWidth = this.calculateChipIconWidth();
            if (!checkable && this.currentChecked) {
                this.currentChecked = false;
            }
            float newChipIconWidth = this.calculateChipIconWidth();
            this.invalidateSelf();
            if (oldChipIconWidth != newChipIconWidth) {
                this.onSizeChange();
            }
        }
    }

    public boolean isCheckedIconVisible() {
        return this.checkedIconVisible;
    }

    @Deprecated
    public boolean isCheckedIconEnabled() {
        return this.isCheckedIconVisible();
    }

    public void setCheckedIconVisible(@BoolRes int id2) {
        this.setCheckedIconVisible(this.context.getResources().getBoolean(id2));
    }

    public void setCheckedIconVisible(boolean checkedIconVisible) {
        if (this.checkedIconVisible != checkedIconVisible) {
            boolean changed;
            boolean oldShowsCheckedIcon = this.showsCheckedIcon();
            this.checkedIconVisible = checkedIconVisible;
            boolean newShowsCheckedIcon = this.showsCheckedIcon();
            boolean bl = changed = oldShowsCheckedIcon != newShowsCheckedIcon;
            if (changed) {
                if (newShowsCheckedIcon) {
                    this.applyChildDrawable(this.checkedIcon);
                } else {
                    this.unapplyChildDrawable(this.checkedIcon);
                }
                this.invalidateSelf();
                this.onSizeChange();
            }
        }
    }

    @Deprecated
    public void setCheckedIconEnabledResource(@BoolRes int id2) {
        this.setCheckedIconVisible(this.context.getResources().getBoolean(id2));
    }

    @Deprecated
    public void setCheckedIconEnabled(boolean checkedIconEnabled) {
        this.setCheckedIconVisible(checkedIconEnabled);
    }

    @Nullable
    public Drawable getCheckedIcon() {
        return this.checkedIcon;
    }

    public void setCheckedIconResource(@DrawableRes int id2) {
        this.setCheckedIcon(AppCompatResources.getDrawable(this.context, id2));
    }

    public void setCheckedIcon(@Nullable Drawable checkedIcon) {
        Drawable oldCheckedIcon = this.checkedIcon;
        if (oldCheckedIcon != checkedIcon) {
            float oldChipIconWidth = this.calculateChipIconWidth();
            this.checkedIcon = checkedIcon;
            float newChipIconWidth = this.calculateChipIconWidth();
            this.unapplyChildDrawable(this.checkedIcon);
            this.applyChildDrawable(this.checkedIcon);
            this.invalidateSelf();
            if (oldChipIconWidth != newChipIconWidth) {
                this.onSizeChange();
            }
        }
    }

    @Nullable
    public ColorStateList getCheckedIconTint() {
        return this.checkedIconTint;
    }

    public void setCheckedIconTintResource(@ColorRes int id2) {
        this.setCheckedIconTint(AppCompatResources.getColorStateList(this.context, id2));
    }

    public void setCheckedIconTint(@Nullable ColorStateList checkedIconTint) {
        if (this.checkedIconTint != checkedIconTint) {
            this.checkedIconTint = checkedIconTint;
            if (this.canShowCheckedIcon()) {
                DrawableCompat.setTintList(this.checkedIcon, checkedIconTint);
            }
            this.onStateChange(this.getState());
        }
    }

    @Nullable
    public MotionSpec getShowMotionSpec() {
        return this.showMotionSpec;
    }

    public void setShowMotionSpecResource(@AnimatorRes int id2) {
        this.setShowMotionSpec(MotionSpec.createFromResource(this.context, id2));
    }

    public void setShowMotionSpec(@Nullable MotionSpec showMotionSpec) {
        this.showMotionSpec = showMotionSpec;
    }

    @Nullable
    public MotionSpec getHideMotionSpec() {
        return this.hideMotionSpec;
    }

    public void setHideMotionSpecResource(@AnimatorRes int id2) {
        this.setHideMotionSpec(MotionSpec.createFromResource(this.context, id2));
    }

    public void setHideMotionSpec(@Nullable MotionSpec hideMotionSpec) {
        this.hideMotionSpec = hideMotionSpec;
    }

    public float getChipStartPadding() {
        return this.chipStartPadding;
    }

    public void setChipStartPaddingResource(@DimenRes int id2) {
        this.setChipStartPadding(this.context.getResources().getDimension(id2));
    }

    public void setChipStartPadding(float chipStartPadding) {
        if (this.chipStartPadding != chipStartPadding) {
            this.chipStartPadding = chipStartPadding;
            this.invalidateSelf();
            this.onSizeChange();
        }
    }

    public float getIconStartPadding() {
        return this.iconStartPadding;
    }

    public void setIconStartPaddingResource(@DimenRes int id2) {
        this.setIconStartPadding(this.context.getResources().getDimension(id2));
    }

    public void setIconStartPadding(float iconStartPadding) {
        if (this.iconStartPadding != iconStartPadding) {
            float oldChipIconWidth = this.calculateChipIconWidth();
            this.iconStartPadding = iconStartPadding;
            float newChipIconWidth = this.calculateChipIconWidth();
            this.invalidateSelf();
            if (oldChipIconWidth != newChipIconWidth) {
                this.onSizeChange();
            }
        }
    }

    public float getIconEndPadding() {
        return this.iconEndPadding;
    }

    public void setIconEndPaddingResource(@DimenRes int id2) {
        this.setIconEndPadding(this.context.getResources().getDimension(id2));
    }

    public void setIconEndPadding(float iconEndPadding) {
        if (this.iconEndPadding != iconEndPadding) {
            float oldChipIconWidth = this.calculateChipIconWidth();
            this.iconEndPadding = iconEndPadding;
            float newChipIconWidth = this.calculateChipIconWidth();
            this.invalidateSelf();
            if (oldChipIconWidth != newChipIconWidth) {
                this.onSizeChange();
            }
        }
    }

    public float getTextStartPadding() {
        return this.textStartPadding;
    }

    public void setTextStartPaddingResource(@DimenRes int id2) {
        this.setTextStartPadding(this.context.getResources().getDimension(id2));
    }

    public void setTextStartPadding(float textStartPadding) {
        if (this.textStartPadding != textStartPadding) {
            this.textStartPadding = textStartPadding;
            this.invalidateSelf();
            this.onSizeChange();
        }
    }

    public float getTextEndPadding() {
        return this.textEndPadding;
    }

    public void setTextEndPaddingResource(@DimenRes int id2) {
        this.setTextEndPadding(this.context.getResources().getDimension(id2));
    }

    public void setTextEndPadding(float textEndPadding) {
        if (this.textEndPadding != textEndPadding) {
            this.textEndPadding = textEndPadding;
            this.invalidateSelf();
            this.onSizeChange();
        }
    }

    public float getCloseIconStartPadding() {
        return this.closeIconStartPadding;
    }

    public void setCloseIconStartPaddingResource(@DimenRes int id2) {
        this.setCloseIconStartPadding(this.context.getResources().getDimension(id2));
    }

    public void setCloseIconStartPadding(float closeIconStartPadding) {
        if (this.closeIconStartPadding != closeIconStartPadding) {
            this.closeIconStartPadding = closeIconStartPadding;
            this.invalidateSelf();
            if (this.showsCloseIcon()) {
                this.onSizeChange();
            }
        }
    }

    public float getCloseIconEndPadding() {
        return this.closeIconEndPadding;
    }

    public void setCloseIconEndPaddingResource(@DimenRes int id2) {
        this.setCloseIconEndPadding(this.context.getResources().getDimension(id2));
    }

    public void setCloseIconEndPadding(float closeIconEndPadding) {
        if (this.closeIconEndPadding != closeIconEndPadding) {
            this.closeIconEndPadding = closeIconEndPadding;
            this.invalidateSelf();
            if (this.showsCloseIcon()) {
                this.onSizeChange();
            }
        }
    }

    public float getChipEndPadding() {
        return this.chipEndPadding;
    }

    public void setChipEndPaddingResource(@DimenRes int id2) {
        this.setChipEndPadding(this.context.getResources().getDimension(id2));
    }

    public void setChipEndPadding(float chipEndPadding) {
        if (this.chipEndPadding != chipEndPadding) {
            this.chipEndPadding = chipEndPadding;
            this.invalidateSelf();
            this.onSizeChange();
        }
    }

    @Px
    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(@Px int maxWidth) {
        this.maxWidth = maxWidth;
    }

    boolean shouldDrawText() {
        return this.shouldDrawText;
    }

    void setShouldDrawText(boolean shouldDrawText) {
        this.shouldDrawText = shouldDrawText;
    }

    public static interface Delegate {
        public void onChipDrawableSizeChange();
    }
}

