/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.circularreveal;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.circularreveal.CircularRevealWidget;
import com.google.android.material.math.MathUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CircularRevealHelper {
    private static final boolean DEBUG = false;
    public static final int BITMAP_SHADER = 0;
    public static final int CLIP_PATH = 1;
    public static final int REVEAL_ANIMATOR = 2;
    public static final int STRATEGY = Build.VERSION.SDK_INT >= 21 ? 2 : (Build.VERSION.SDK_INT >= 18 ? 1 : 0);
    private final Delegate delegate;
    @NonNull
    private final View view;
    @NonNull
    private final Path revealPath;
    @NonNull
    private final Paint revealPaint;
    @NonNull
    private final Paint scrimPaint;
    @Nullable
    private CircularRevealWidget.RevealInfo revealInfo;
    @Nullable
    private Drawable overlayDrawable;
    private Paint debugPaint;
    private boolean buildingCircularRevealCache;
    private boolean hasCircularRevealCache;

    public CircularRevealHelper(Delegate delegate) {
        this.delegate = delegate;
        this.view = (View)delegate;
        this.view.setWillNotDraw(false);
        this.revealPath = new Path();
        this.revealPaint = new Paint(7);
        this.scrimPaint = new Paint(1);
        this.scrimPaint.setColor(0);
    }

    public void buildCircularRevealCache() {
        if (STRATEGY == 0) {
            this.buildingCircularRevealCache = true;
            this.hasCircularRevealCache = false;
            this.view.buildDrawingCache();
            Bitmap bitmap = this.view.getDrawingCache();
            if (bitmap == null && this.view.getWidth() != 0 && this.view.getHeight() != 0) {
                bitmap = Bitmap.createBitmap((int)this.view.getWidth(), (int)this.view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                this.view.draw(canvas);
            }
            if (bitmap != null) {
                this.revealPaint.setShader((Shader)new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
            }
            this.buildingCircularRevealCache = false;
            this.hasCircularRevealCache = true;
        }
    }

    public void destroyCircularRevealCache() {
        if (STRATEGY == 0) {
            this.hasCircularRevealCache = false;
            this.view.destroyDrawingCache();
            this.revealPaint.setShader(null);
            this.view.invalidate();
        }
    }

    public void setRevealInfo(@Nullable CircularRevealWidget.RevealInfo revealInfo) {
        if (revealInfo == null) {
            this.revealInfo = null;
        } else {
            if (this.revealInfo == null) {
                this.revealInfo = new CircularRevealWidget.RevealInfo(revealInfo);
            } else {
                this.revealInfo.set(revealInfo);
            }
            if (MathUtils.geq(revealInfo.radius, this.getDistanceToFurthestCorner(revealInfo), 1.0E-4f)) {
                this.revealInfo.radius = Float.MAX_VALUE;
            }
        }
        this.invalidateRevealInfo();
    }

    @Nullable
    public CircularRevealWidget.RevealInfo getRevealInfo() {
        if (this.revealInfo == null) {
            return null;
        }
        CircularRevealWidget.RevealInfo revealInfo = new CircularRevealWidget.RevealInfo(this.revealInfo);
        if (revealInfo.isInvalid()) {
            revealInfo.radius = this.getDistanceToFurthestCorner(revealInfo);
        }
        return revealInfo;
    }

    public void setCircularRevealScrimColor(@ColorInt int color2) {
        this.scrimPaint.setColor(color2);
        this.view.invalidate();
    }

    @ColorInt
    public int getCircularRevealScrimColor() {
        return this.scrimPaint.getColor();
    }

    @Nullable
    public Drawable getCircularRevealOverlayDrawable() {
        return this.overlayDrawable;
    }

    public void setCircularRevealOverlayDrawable(@Nullable Drawable drawable2) {
        this.overlayDrawable = drawable2;
        this.view.invalidate();
    }

    private void invalidateRevealInfo() {
        if (STRATEGY == 1) {
            this.revealPath.rewind();
            if (this.revealInfo != null) {
                this.revealPath.addCircle(this.revealInfo.centerX, this.revealInfo.centerY, this.revealInfo.radius, Path.Direction.CW);
            }
        }
        this.view.invalidate();
    }

    private float getDistanceToFurthestCorner(@NonNull CircularRevealWidget.RevealInfo revealInfo) {
        return MathUtils.distanceToFurthestCorner(revealInfo.centerX, revealInfo.centerY, 0.0f, 0.0f, this.view.getWidth(), this.view.getHeight());
    }

    public void draw(@NonNull Canvas canvas) {
        block10: {
            block9: {
                if (!this.shouldDrawCircularReveal()) break block9;
                switch (STRATEGY) {
                    case 2: {
                        this.delegate.actualDraw(canvas);
                        if (this.shouldDrawScrim()) {
                            canvas.drawRect(0.0f, 0.0f, (float)this.view.getWidth(), (float)this.view.getHeight(), this.scrimPaint);
                        }
                        break block10;
                    }
                    case 1: {
                        int count2 = canvas.save();
                        canvas.clipPath(this.revealPath);
                        this.delegate.actualDraw(canvas);
                        if (this.shouldDrawScrim()) {
                            canvas.drawRect(0.0f, 0.0f, (float)this.view.getWidth(), (float)this.view.getHeight(), this.scrimPaint);
                        }
                        canvas.restoreToCount(count2);
                        break block10;
                    }
                    case 0: {
                        canvas.drawCircle(this.revealInfo.centerX, this.revealInfo.centerY, this.revealInfo.radius, this.revealPaint);
                        if (this.shouldDrawScrim()) {
                            canvas.drawCircle(this.revealInfo.centerX, this.revealInfo.centerY, this.revealInfo.radius, this.scrimPaint);
                        }
                        break block10;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported strategy " + STRATEGY);
                    }
                }
            }
            this.delegate.actualDraw(canvas);
            if (this.shouldDrawScrim()) {
                canvas.drawRect(0.0f, 0.0f, (float)this.view.getWidth(), (float)this.view.getHeight(), this.scrimPaint);
            }
        }
        this.drawOverlayDrawable(canvas);
    }

    private void drawOverlayDrawable(@NonNull Canvas canvas) {
        if (this.shouldDrawOverlayDrawable()) {
            Rect bounds = this.overlayDrawable.getBounds();
            float translationX = this.revealInfo.centerX - (float)bounds.width() / 2.0f;
            float translationY = this.revealInfo.centerY - (float)bounds.height() / 2.0f;
            canvas.translate(translationX, translationY);
            this.overlayDrawable.draw(canvas);
            canvas.translate(-translationX, -translationY);
        }
    }

    public boolean isOpaque() {
        return this.delegate.actualIsOpaque() && !this.shouldDrawCircularReveal();
    }

    private boolean shouldDrawCircularReveal() {
        boolean invalidRevealInfo;
        boolean bl = invalidRevealInfo = this.revealInfo == null || this.revealInfo.isInvalid();
        if (STRATEGY == 0) {
            return !invalidRevealInfo && this.hasCircularRevealCache;
        }
        return !invalidRevealInfo;
    }

    private boolean shouldDrawScrim() {
        return !this.buildingCircularRevealCache && Color.alpha((int)this.scrimPaint.getColor()) != 0;
    }

    private boolean shouldDrawOverlayDrawable() {
        return !this.buildingCircularRevealCache && this.overlayDrawable != null && this.revealInfo != null;
    }

    private void drawDebugMode(@NonNull Canvas canvas) {
        this.delegate.actualDraw(canvas);
        if (this.shouldDrawScrim()) {
            canvas.drawCircle(this.revealInfo.centerX, this.revealInfo.centerY, this.revealInfo.radius, this.scrimPaint);
        }
        if (this.shouldDrawCircularReveal()) {
            this.drawDebugCircle(canvas, -16777216, 10.0f);
            this.drawDebugCircle(canvas, -65536, 5.0f);
        }
        this.drawOverlayDrawable(canvas);
    }

    private void drawDebugCircle(@NonNull Canvas canvas, int color2, float width) {
        this.debugPaint.setColor(color2);
        this.debugPaint.setStrokeWidth(width);
        canvas.drawCircle(this.revealInfo.centerX, this.revealInfo.centerY, this.revealInfo.radius - width / 2.0f, this.debugPaint);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Strategy {
    }

    public static interface Delegate {
        public void actualDraw(Canvas var1);

        public boolean actualIsOpaque();
    }
}

