/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import android.app.Activity;
import android.app.Application;
import android.app.UiModeManager;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.view.ContextThemeWrapper;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import com.google.android.material.color.ColorContrastOptions;
import com.google.android.material.color.ThemeUtils;
import java.util.LinkedHashSet;
import java.util.Set;

public class ColorContrast {
    private static final float MEDIUM_CONTRAST_THRESHOLD = 0.33333334f;
    private static final float HIGH_CONTRAST_THRESHOLD = 0.6666667f;

    private ColorContrast() {
    }

    public static void applyToActivitiesIfAvailable(@NonNull Application application, @NonNull ColorContrastOptions colorContrastOptions) {
        if (!ColorContrast.isContrastAvailable()) {
            return;
        }
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ColorContrastActivityLifecycleCallbacks(colorContrastOptions));
    }

    public static void applyToActivityIfAvailable(@NonNull Activity activity, @NonNull ColorContrastOptions colorContrastOptions) {
        if (!ColorContrast.isContrastAvailable()) {
            return;
        }
        int themeOverlayResourcesId = ColorContrast.getContrastThemeOverlayResourceId((Context)activity, colorContrastOptions);
        if (themeOverlayResourcesId != 0) {
            ThemeUtils.applyThemeOverlay((Context)activity, themeOverlayResourcesId);
        }
    }

    @NonNull
    public static Context wrapContextIfAvailable(@NonNull Context context, @NonNull ColorContrastOptions colorContrastOptions) {
        if (!ColorContrast.isContrastAvailable()) {
            return context;
        }
        int themeOverlayResourcesId = ColorContrast.getContrastThemeOverlayResourceId(context, colorContrastOptions);
        if (themeOverlayResourcesId == 0) {
            return context;
        }
        return new ContextThemeWrapper(context, themeOverlayResourcesId);
    }

    @ChecksSdkIntAtLeast(api=34)
    public static boolean isContrastAvailable() {
        return Build.VERSION.SDK_INT >= 34;
    }

    private static int getContrastThemeOverlayResourceId(Context context, ColorContrastOptions colorContrastOptions) {
        UiModeManager uiModeManager = (UiModeManager)context.getSystemService("uimode");
        if (!ColorContrast.isContrastAvailable() || uiModeManager == null) {
            return 0;
        }
        float currentContrast = uiModeManager.getContrast();
        int mediumContrastThemeOverlay = colorContrastOptions.getMediumContrastThemeOverlay();
        int highContrastThemeOverlay = colorContrastOptions.getHighContrastThemeOverlay();
        if (currentContrast >= 0.6666667f) {
            return highContrastThemeOverlay == 0 ? mediumContrastThemeOverlay : highContrastThemeOverlay;
        }
        if (currentContrast >= 0.33333334f) {
            return mediumContrastThemeOverlay == 0 ? highContrastThemeOverlay : mediumContrastThemeOverlay;
        }
        return 0;
    }

    @RequiresApi(value=34)
    private static class ColorContrastActivityLifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks {
        private final Set<Activity> activitiesInStack = new LinkedHashSet<Activity>();
        private final ColorContrastOptions colorContrastOptions;
        @Nullable
        private UiModeManager.ContrastChangeListener contrastChangeListener;

        ColorContrastActivityLifecycleCallbacks(ColorContrastOptions colorContrastOptions) {
            this.colorContrastOptions = colorContrastOptions;
        }

        public void onActivityPreCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
            UiModeManager uiModeManager = (UiModeManager)activity.getSystemService("uimode");
            if (uiModeManager != null && this.activitiesInStack.isEmpty() && this.contrastChangeListener == null) {
                this.contrastChangeListener = new UiModeManager.ContrastChangeListener(){

                    public void onContrastChanged(float contrastLevel) {
                        for (Activity activityInStack : activitiesInStack) {
                            activityInStack.recreate();
                        }
                    }
                };
                uiModeManager.addContrastChangeListener(ContextCompat.getMainExecutor(activity.getApplicationContext()), this.contrastChangeListener);
            }
            this.activitiesInStack.add(activity);
            if (uiModeManager != null) {
                ColorContrast.applyToActivityIfAvailable(activity, this.colorContrastOptions);
            }
        }

        public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        }

        public void onActivityStarted(@NonNull Activity activity) {
        }

        public void onActivityResumed(@NonNull Activity activity) {
        }

        public void onActivityPaused(@NonNull Activity activity) {
        }

        public void onActivityStopped(@NonNull Activity activity) {
        }

        public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        }

        public void onActivityDestroyed(@NonNull Activity activity) {
            this.activitiesInStack.remove(activity);
            UiModeManager uiModeManager = (UiModeManager)activity.getSystemService("uimode");
            if (uiModeManager != null && this.contrastChangeListener != null && this.activitiesInStack.isEmpty()) {
                uiModeManager.removeContrastChangeListener(this.contrastChangeListener);
                this.contrastChangeListener = null;
            }
        }
    }
}

