/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.google.android.material.R;
import com.google.android.material.color.utilities.DynamicColor;
import com.google.android.material.color.utilities.DynamicScheme;
import com.google.android.material.color.utilities.MaterialDynamicColors;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MaterialColorUtilitiesHelper {
    private static final MaterialDynamicColors dynamicColors = new MaterialDynamicColors();
    private static final Map<Integer, DynamicColor> colorResourceIdToColorValue;

    private MaterialColorUtilitiesHelper() {
    }

    @NonNull
    public static Map<Integer, Integer> createColorResourcesIdsToColorValues(@NonNull DynamicScheme colorScheme) {
        HashMap<Integer, Integer> map2 = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, DynamicColor> entry : colorResourceIdToColorValue.entrySet()) {
            map2.put(entry.getKey(), entry.getValue().getArgb(colorScheme));
        }
        return Collections.unmodifiableMap(map2);
    }

    static {
        HashMap<Integer, DynamicColor> map2 = new HashMap<Integer, DynamicColor>();
        map2.put(R.color.material_personalized_color_primary, dynamicColors.primary());
        map2.put(R.color.material_personalized_color_on_primary, dynamicColors.onPrimary());
        map2.put(R.color.material_personalized_color_primary_inverse, dynamicColors.inversePrimary());
        map2.put(R.color.material_personalized_color_primary_container, dynamicColors.primaryContainer());
        map2.put(R.color.material_personalized_color_on_primary_container, dynamicColors.onPrimaryContainer());
        map2.put(R.color.material_personalized_color_secondary, dynamicColors.secondary());
        map2.put(R.color.material_personalized_color_on_secondary, dynamicColors.onSecondary());
        map2.put(R.color.material_personalized_color_secondary_container, dynamicColors.secondaryContainer());
        map2.put(R.color.material_personalized_color_on_secondary_container, dynamicColors.onSecondaryContainer());
        map2.put(R.color.material_personalized_color_tertiary, dynamicColors.tertiary());
        map2.put(R.color.material_personalized_color_on_tertiary, dynamicColors.onTertiary());
        map2.put(R.color.material_personalized_color_tertiary_container, dynamicColors.tertiaryContainer());
        map2.put(R.color.material_personalized_color_on_tertiary_container, dynamicColors.onTertiaryContainer());
        map2.put(R.color.material_personalized_color_background, dynamicColors.background());
        map2.put(R.color.material_personalized_color_on_background, dynamicColors.onBackground());
        map2.put(R.color.material_personalized_color_surface, dynamicColors.surface());
        map2.put(R.color.material_personalized_color_on_surface, dynamicColors.onSurface());
        map2.put(R.color.material_personalized_color_surface_variant, dynamicColors.surfaceVariant());
        map2.put(R.color.material_personalized_color_on_surface_variant, dynamicColors.onSurfaceVariant());
        map2.put(R.color.material_personalized_color_surface_inverse, dynamicColors.inverseSurface());
        map2.put(R.color.material_personalized_color_on_surface_inverse, dynamicColors.inverseOnSurface());
        map2.put(R.color.material_personalized_color_surface_bright, dynamicColors.surfaceBright());
        map2.put(R.color.material_personalized_color_surface_dim, dynamicColors.surfaceDim());
        map2.put(R.color.material_personalized_color_surface_container, dynamicColors.surfaceContainer());
        map2.put(R.color.material_personalized_color_surface_container_low, dynamicColors.surfaceContainerLow());
        map2.put(R.color.material_personalized_color_surface_container_high, dynamicColors.surfaceContainerHigh());
        map2.put(R.color.material_personalized_color_surface_container_lowest, dynamicColors.surfaceContainerLowest());
        map2.put(R.color.material_personalized_color_surface_container_highest, dynamicColors.surfaceContainerHighest());
        map2.put(R.color.material_personalized_color_outline, dynamicColors.outline());
        map2.put(R.color.material_personalized_color_outline_variant, dynamicColors.outlineVariant());
        map2.put(R.color.material_personalized_color_error, dynamicColors.error());
        map2.put(R.color.material_personalized_color_on_error, dynamicColors.onError());
        map2.put(R.color.material_personalized_color_error_container, dynamicColors.errorContainer());
        map2.put(R.color.material_personalized_color_on_error_container, dynamicColors.onErrorContainer());
        map2.put(R.color.material_personalized_color_control_activated, dynamicColors.controlActivated());
        map2.put(R.color.material_personalized_color_control_normal, dynamicColors.controlNormal());
        map2.put(R.color.material_personalized_color_control_highlight, dynamicColors.controlHighlight());
        map2.put(R.color.material_personalized_color_text_primary_inverse, dynamicColors.textPrimaryInverse());
        map2.put(R.color.material_personalized_color_text_secondary_and_tertiary_inverse, dynamicColors.textSecondaryAndTertiaryInverse());
        map2.put(R.color.material_personalized_color_text_secondary_and_tertiary_inverse_disabled, dynamicColors.textSecondaryAndTertiaryInverseDisabled());
        map2.put(R.color.material_personalized_color_text_primary_inverse_disable_only, dynamicColors.textPrimaryInverseDisableOnly());
        map2.put(R.color.material_personalized_color_text_hint_foreground_inverse, dynamicColors.textHintInverse());
        colorResourceIdToColorValue = Collections.unmodifiableMap(map2);
    }
}

