/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color.utilities;

import androidx.annotation.RestrictTo;
import com.google.android.material.color.utilities.Hct;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class DislikeAnalyzer {
    private DislikeAnalyzer() {
        throw new UnsupportedOperationException();
    }

    public static boolean isDisliked(Hct hct) {
        boolean huePasses = (double)Math.round(hct.getHue()) >= 90.0 && (double)Math.round(hct.getHue()) <= 111.0;
        boolean chromaPasses = (double)Math.round(hct.getChroma()) > 16.0;
        boolean tonePasses = (double)Math.round(hct.getTone()) < 65.0;
        return huePasses && chromaPasses && tonePasses;
    }

    public static Hct fixIfDisliked(Hct hct) {
        if (DislikeAnalyzer.isDisliked(hct)) {
            return Hct.from(hct.getHue(), hct.getChroma(), 70.0);
        }
        return hct;
    }
}

