/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color.utilities;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.google.android.material.color.utilities.ContrastCurve;
import com.google.android.material.color.utilities.DislikeAnalyzer;
import com.google.android.material.color.utilities.DynamicColor;
import com.google.android.material.color.utilities.DynamicScheme;
import com.google.android.material.color.utilities.Hct;
import com.google.android.material.color.utilities.ToneDeltaPair;
import com.google.android.material.color.utilities.TonePolarity;
import com.google.android.material.color.utilities.Variant;
import com.google.android.material.color.utilities.ViewingConditions;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MaterialDynamicColors {
    @NonNull
    public DynamicColor highestSurface(@NonNull DynamicScheme s) {
        return s.isDark ? this.surfaceBright() : this.surfaceDim();
    }

    @NonNull
    public DynamicColor primaryPaletteKeyColor() {
        return DynamicColor.fromPalette("primary_palette_key_color", s -> s.primaryPalette, s -> s.primaryPalette.getKeyColor().getTone());
    }

    @NonNull
    public DynamicColor secondaryPaletteKeyColor() {
        return DynamicColor.fromPalette("secondary_palette_key_color", s -> s.secondaryPalette, s -> s.secondaryPalette.getKeyColor().getTone());
    }

    @NonNull
    public DynamicColor tertiaryPaletteKeyColor() {
        return DynamicColor.fromPalette("tertiary_palette_key_color", s -> s.tertiaryPalette, s -> s.tertiaryPalette.getKeyColor().getTone());
    }

    @NonNull
    public DynamicColor neutralPaletteKeyColor() {
        return DynamicColor.fromPalette("neutral_palette_key_color", s -> s.neutralPalette, s -> s.neutralPalette.getKeyColor().getTone());
    }

    @NonNull
    public DynamicColor neutralVariantPaletteKeyColor() {
        return DynamicColor.fromPalette("neutral_variant_palette_key_color", s -> s.neutralVariantPalette, s -> s.neutralVariantPalette.getKeyColor().getTone());
    }

    @NonNull
    public DynamicColor background() {
        return new DynamicColor("background", s -> s.neutralPalette, s -> s.isDark ? 6.0 : 98.0, true, null, null, null, null);
    }

    @NonNull
    public DynamicColor onBackground() {
        return new DynamicColor("on_background", s -> s.neutralPalette, s -> s.isDark ? 90.0 : 10.0, false, s -> this.background(), null, new ContrastCurve(3.0, 3.0, 4.5, 7.0), null);
    }

    @NonNull
    public DynamicColor surface() {
        return new DynamicColor("surface", s -> s.neutralPalette, s -> s.isDark ? 6.0 : 98.0, true, null, null, null, null);
    }

    @NonNull
    public DynamicColor surfaceDim() {
        return new DynamicColor("surface_dim", s -> s.neutralPalette, s -> s.isDark ? 6.0 : 87.0, true, null, null, null, null);
    }

    @NonNull
    public DynamicColor surfaceBright() {
        return new DynamicColor("surface_bright", s -> s.neutralPalette, s -> s.isDark ? 24.0 : 98.0, true, null, null, null, null);
    }

    @NonNull
    public DynamicColor surfaceContainerLowest() {
        return new DynamicColor("surface_container_lowest", s -> s.neutralPalette, s -> s.isDark ? 4.0 : 100.0, true, null, null, null, null);
    }

    @NonNull
    public DynamicColor surfaceContainerLow() {
        return new DynamicColor("surface_container_low", s -> s.neutralPalette, s -> s.isDark ? 10.0 : 96.0, true, null, null, null, null);
    }

    @NonNull
    public DynamicColor surfaceContainer() {
        return new DynamicColor("surface_container", s -> s.neutralPalette, s -> s.isDark ? 12.0 : 94.0, true, null, null, null, null);
    }

    @NonNull
    public DynamicColor surfaceContainerHigh() {
        return new DynamicColor("surface_container_high", s -> s.neutralPalette, s -> s.isDark ? 17.0 : 92.0, true, null, null, null, null);
    }

    @NonNull
    public DynamicColor surfaceContainerHighest() {
        return new DynamicColor("surface_container_highest", s -> s.neutralPalette, s -> s.isDark ? 22.0 : 90.0, true, null, null, null, null);
    }

    @NonNull
    public DynamicColor onSurface() {
        return new DynamicColor("on_surface", s -> s.neutralPalette, s -> s.isDark ? 90.0 : 10.0, false, this::highestSurface, null, new ContrastCurve(4.5, 7.0, 11.0, 21.0), null);
    }

    @NonNull
    public DynamicColor surfaceVariant() {
        return new DynamicColor("surface_variant", s -> s.neutralVariantPalette, s -> s.isDark ? 30.0 : 90.0, true, null, null, null, null);
    }

    @NonNull
    public DynamicColor onSurfaceVariant() {
        return new DynamicColor("on_surface_variant", s -> s.neutralVariantPalette, s -> s.isDark ? 80.0 : 30.0, false, this::highestSurface, null, new ContrastCurve(3.0, 4.5, 7.0, 11.0), null);
    }

    @NonNull
    public DynamicColor inverseSurface() {
        return new DynamicColor("inverse_surface", s -> s.neutralPalette, s -> s.isDark ? 90.0 : 20.0, false, null, null, null, null);
    }

    @NonNull
    public DynamicColor inverseOnSurface() {
        return new DynamicColor("inverse_on_surface", s -> s.neutralPalette, s -> s.isDark ? 20.0 : 95.0, false, s -> this.inverseSurface(), null, new ContrastCurve(4.5, 7.0, 11.0, 21.0), null);
    }

    @NonNull
    public DynamicColor outline() {
        return new DynamicColor("outline", s -> s.neutralVariantPalette, s -> s.isDark ? 60.0 : 50.0, false, this::highestSurface, null, new ContrastCurve(1.5, 3.0, 4.5, 7.0), null);
    }

    @NonNull
    public DynamicColor outlineVariant() {
        return new DynamicColor("outline_variant", s -> s.neutralVariantPalette, s -> s.isDark ? 30.0 : 80.0, false, this::highestSurface, null, new ContrastCurve(1.0, 1.0, 3.0, 7.0), null);
    }

    @NonNull
    public DynamicColor shadow() {
        return new DynamicColor("shadow", s -> s.neutralPalette, s -> 0.0, false, null, null, null, null);
    }

    @NonNull
    public DynamicColor scrim() {
        return new DynamicColor("scrim", s -> s.neutralPalette, s -> 0.0, false, null, null, null, null);
    }

    @NonNull
    public DynamicColor surfaceTint() {
        return new DynamicColor("surface_tint", s -> s.primaryPalette, s -> s.isDark ? 80.0 : 40.0, true, null, null, null, null);
    }

    @NonNull
    public DynamicColor primary() {
        return new DynamicColor("primary", s -> s.primaryPalette, s -> {
            if (MaterialDynamicColors.isMonochrome(s)) {
                return s.isDark ? 100.0 : 0.0;
            }
            return s.isDark ? 80.0 : 40.0;
        }, true, this::highestSurface, null, new ContrastCurve(3.0, 4.5, 7.0, 11.0), s -> new ToneDeltaPair(this.primaryContainer(), this.primary(), 15.0, TonePolarity.NEARER, false));
    }

    @NonNull
    public DynamicColor onPrimary() {
        return new DynamicColor("on_primary", s -> s.primaryPalette, s -> {
            if (MaterialDynamicColors.isMonochrome(s)) {
                return s.isDark ? 10.0 : 90.0;
            }
            return s.isDark ? 20.0 : 100.0;
        }, false, s -> this.primary(), null, new ContrastCurve(4.5, 7.0, 11.0, 21.0), null);
    }

    @NonNull
    public DynamicColor primaryContainer() {
        return new DynamicColor("primary_container", s -> s.primaryPalette, s -> {
            if (MaterialDynamicColors.isFidelity(s)) {
                return MaterialDynamicColors.performAlbers(s.sourceColorHct, s);
            }
            if (MaterialDynamicColors.isMonochrome(s)) {
                return s.isDark ? 85.0 : 25.0;
            }
            return s.isDark ? 30.0 : 90.0;
        }, true, this::highestSurface, null, new ContrastCurve(1.0, 1.0, 3.0, 7.0), s -> new ToneDeltaPair(this.primaryContainer(), this.primary(), 15.0, TonePolarity.NEARER, false));
    }

    @NonNull
    public DynamicColor onPrimaryContainer() {
        return new DynamicColor("on_primary_container", s -> s.primaryPalette, s -> {
            if (MaterialDynamicColors.isFidelity(s)) {
                return DynamicColor.foregroundTone(this.primaryContainer().tone.apply((DynamicScheme)s), 4.5);
            }
            if (MaterialDynamicColors.isMonochrome(s)) {
                return s.isDark ? 0.0 : 100.0;
            }
            return s.isDark ? 90.0 : 10.0;
        }, false, s -> this.primaryContainer(), null, new ContrastCurve(4.5, 7.0, 11.0, 21.0), null);
    }

    @NonNull
    public DynamicColor inversePrimary() {
        return new DynamicColor("inverse_primary", s -> s.primaryPalette, s -> s.isDark ? 40.0 : 80.0, false, s -> this.inverseSurface(), null, new ContrastCurve(3.0, 4.5, 7.0, 11.0), null);
    }

    @NonNull
    public DynamicColor secondary() {
        return new DynamicColor("secondary", s -> s.secondaryPalette, s -> s.isDark ? 80.0 : 40.0, true, this::highestSurface, null, new ContrastCurve(3.0, 4.5, 7.0, 11.0), s -> new ToneDeltaPair(this.secondaryContainer(), this.secondary(), 15.0, TonePolarity.NEARER, false));
    }

    @NonNull
    public DynamicColor onSecondary() {
        return new DynamicColor("on_secondary", s -> s.secondaryPalette, s -> {
            if (MaterialDynamicColors.isMonochrome(s)) {
                return s.isDark ? 10.0 : 100.0;
            }
            return s.isDark ? 20.0 : 100.0;
        }, false, s -> this.secondary(), null, new ContrastCurve(4.5, 7.0, 11.0, 21.0), null);
    }

    @NonNull
    public DynamicColor secondaryContainer() {
        return new DynamicColor("secondary_container", s -> s.secondaryPalette, s -> {
            double initialTone;
            double d = initialTone = s.isDark ? 30.0 : 90.0;
            if (MaterialDynamicColors.isMonochrome(s)) {
                return s.isDark ? 30.0 : 85.0;
            }
            if (!MaterialDynamicColors.isFidelity(s)) {
                return initialTone;
            }
            double answer = MaterialDynamicColors.findDesiredChromaByTone(s.secondaryPalette.getHue(), s.secondaryPalette.getChroma(), initialTone, !s.isDark);
            answer = MaterialDynamicColors.performAlbers(s.secondaryPalette.getHct(answer), s);
            return answer;
        }, true, this::highestSurface, null, new ContrastCurve(1.0, 1.0, 3.0, 7.0), s -> new ToneDeltaPair(this.secondaryContainer(), this.secondary(), 15.0, TonePolarity.NEARER, false));
    }

    @NonNull
    public DynamicColor onSecondaryContainer() {
        return new DynamicColor("on_secondary_container", s -> s.secondaryPalette, s -> {
            if (!MaterialDynamicColors.isFidelity(s)) {
                return s.isDark ? 90.0 : 10.0;
            }
            return DynamicColor.foregroundTone(this.secondaryContainer().tone.apply((DynamicScheme)s), 4.5);
        }, false, s -> this.secondaryContainer(), null, new ContrastCurve(4.5, 7.0, 11.0, 21.0), null);
    }

    @NonNull
    public DynamicColor tertiary() {
        return new DynamicColor("tertiary", s -> s.tertiaryPalette, s -> {
            if (MaterialDynamicColors.isMonochrome(s)) {
                return s.isDark ? 90.0 : 25.0;
            }
            return s.isDark ? 80.0 : 40.0;
        }, true, this::highestSurface, null, new ContrastCurve(3.0, 4.5, 7.0, 11.0), s -> new ToneDeltaPair(this.tertiaryContainer(), this.tertiary(), 15.0, TonePolarity.NEARER, false));
    }

    @NonNull
    public DynamicColor onTertiary() {
        return new DynamicColor("on_tertiary", s -> s.tertiaryPalette, s -> {
            if (MaterialDynamicColors.isMonochrome(s)) {
                return s.isDark ? 10.0 : 90.0;
            }
            return s.isDark ? 20.0 : 100.0;
        }, false, s -> this.tertiary(), null, new ContrastCurve(4.5, 7.0, 11.0, 21.0), null);
    }

    @NonNull
    public DynamicColor tertiaryContainer() {
        return new DynamicColor("tertiary_container", s -> s.tertiaryPalette, s -> {
            if (MaterialDynamicColors.isMonochrome(s)) {
                return s.isDark ? 60.0 : 49.0;
            }
            if (!MaterialDynamicColors.isFidelity(s)) {
                return s.isDark ? 30.0 : 90.0;
            }
            double albersTone = MaterialDynamicColors.performAlbers(s.tertiaryPalette.getHct(s.sourceColorHct.getTone()), s);
            Hct proposedHct = s.tertiaryPalette.getHct(albersTone);
            return DislikeAnalyzer.fixIfDisliked(proposedHct).getTone();
        }, true, this::highestSurface, null, new ContrastCurve(1.0, 1.0, 3.0, 7.0), s -> new ToneDeltaPair(this.tertiaryContainer(), this.tertiary(), 15.0, TonePolarity.NEARER, false));
    }

    @NonNull
    public DynamicColor onTertiaryContainer() {
        return new DynamicColor("on_tertiary_container", s -> s.tertiaryPalette, s -> {
            if (MaterialDynamicColors.isMonochrome(s)) {
                return s.isDark ? 0.0 : 100.0;
            }
            if (!MaterialDynamicColors.isFidelity(s)) {
                return s.isDark ? 90.0 : 10.0;
            }
            return DynamicColor.foregroundTone(this.tertiaryContainer().tone.apply((DynamicScheme)s), 4.5);
        }, false, s -> this.tertiaryContainer(), null, new ContrastCurve(4.5, 7.0, 11.0, 21.0), null);
    }

    @NonNull
    public DynamicColor error() {
        return new DynamicColor("error", s -> s.errorPalette, s -> s.isDark ? 80.0 : 40.0, true, this::highestSurface, null, new ContrastCurve(3.0, 4.5, 7.0, 11.0), s -> new ToneDeltaPair(this.errorContainer(), this.error(), 15.0, TonePolarity.NEARER, false));
    }

    @NonNull
    public DynamicColor onError() {
        return new DynamicColor("on_error", s -> s.errorPalette, s -> s.isDark ? 20.0 : 100.0, false, s -> this.error(), null, new ContrastCurve(4.5, 7.0, 11.0, 21.0), null);
    }

    @NonNull
    public DynamicColor errorContainer() {
        return new DynamicColor("error_container", s -> s.errorPalette, s -> s.isDark ? 30.0 : 90.0, true, this::highestSurface, null, new ContrastCurve(1.0, 1.0, 3.0, 7.0), s -> new ToneDeltaPair(this.errorContainer(), this.error(), 15.0, TonePolarity.NEARER, false));
    }

    @NonNull
    public DynamicColor onErrorContainer() {
        return new DynamicColor("on_error_container", s -> s.errorPalette, s -> s.isDark ? 90.0 : 10.0, false, s -> this.errorContainer(), null, new ContrastCurve(4.5, 7.0, 11.0, 21.0), null);
    }

    @NonNull
    public DynamicColor primaryFixed() {
        return new DynamicColor("primary_fixed", s -> s.primaryPalette, s -> MaterialDynamicColors.isMonochrome(s) ? 40.0 : 90.0, true, this::highestSurface, null, new ContrastCurve(1.0, 1.0, 3.0, 7.0), s -> new ToneDeltaPair(this.primaryFixed(), this.primaryFixedDim(), 10.0, TonePolarity.LIGHTER, true));
    }

    @NonNull
    public DynamicColor primaryFixedDim() {
        return new DynamicColor("primary_fixed_dim", s -> s.primaryPalette, s -> MaterialDynamicColors.isMonochrome(s) ? 30.0 : 80.0, true, this::highestSurface, null, new ContrastCurve(1.0, 1.0, 3.0, 7.0), s -> new ToneDeltaPair(this.primaryFixed(), this.primaryFixedDim(), 10.0, TonePolarity.LIGHTER, true));
    }

    @NonNull
    public DynamicColor onPrimaryFixed() {
        return new DynamicColor("on_primary_fixed", s -> s.primaryPalette, s -> MaterialDynamicColors.isMonochrome(s) ? 100.0 : 10.0, false, s -> this.primaryFixedDim(), s -> this.primaryFixed(), new ContrastCurve(4.5, 7.0, 11.0, 21.0), null);
    }

    @NonNull
    public DynamicColor onPrimaryFixedVariant() {
        return new DynamicColor("on_primary_fixed_variant", s -> s.primaryPalette, s -> MaterialDynamicColors.isMonochrome(s) ? 90.0 : 30.0, false, s -> this.primaryFixedDim(), s -> this.primaryFixed(), new ContrastCurve(3.0, 4.5, 7.0, 11.0), null);
    }

    @NonNull
    public DynamicColor secondaryFixed() {
        return new DynamicColor("secondary_fixed", s -> s.secondaryPalette, s -> MaterialDynamicColors.isMonochrome(s) ? 80.0 : 90.0, true, this::highestSurface, null, new ContrastCurve(1.0, 1.0, 3.0, 7.0), s -> new ToneDeltaPair(this.secondaryFixed(), this.secondaryFixedDim(), 10.0, TonePolarity.LIGHTER, true));
    }

    @NonNull
    public DynamicColor secondaryFixedDim() {
        return new DynamicColor("secondary_fixed_dim", s -> s.secondaryPalette, s -> MaterialDynamicColors.isMonochrome(s) ? 70.0 : 80.0, true, this::highestSurface, null, new ContrastCurve(1.0, 1.0, 3.0, 7.0), s -> new ToneDeltaPair(this.secondaryFixed(), this.secondaryFixedDim(), 10.0, TonePolarity.LIGHTER, true));
    }

    @NonNull
    public DynamicColor onSecondaryFixed() {
        return new DynamicColor("on_secondary_fixed", s -> s.secondaryPalette, s -> 10.0, false, s -> this.secondaryFixedDim(), s -> this.secondaryFixed(), new ContrastCurve(4.5, 7.0, 11.0, 21.0), null);
    }

    @NonNull
    public DynamicColor onSecondaryFixedVariant() {
        return new DynamicColor("on_secondary_fixed_variant", s -> s.secondaryPalette, s -> MaterialDynamicColors.isMonochrome(s) ? 25.0 : 30.0, false, s -> this.secondaryFixedDim(), s -> this.secondaryFixed(), new ContrastCurve(3.0, 4.5, 7.0, 11.0), null);
    }

    @NonNull
    public DynamicColor tertiaryFixed() {
        return new DynamicColor("tertiary_fixed", s -> s.tertiaryPalette, s -> MaterialDynamicColors.isMonochrome(s) ? 40.0 : 90.0, true, this::highestSurface, null, new ContrastCurve(1.0, 1.0, 3.0, 7.0), s -> new ToneDeltaPair(this.tertiaryFixed(), this.tertiaryFixedDim(), 10.0, TonePolarity.LIGHTER, true));
    }

    @NonNull
    public DynamicColor tertiaryFixedDim() {
        return new DynamicColor("tertiary_fixed_dim", s -> s.tertiaryPalette, s -> MaterialDynamicColors.isMonochrome(s) ? 30.0 : 80.0, true, this::highestSurface, null, new ContrastCurve(1.0, 1.0, 3.0, 7.0), s -> new ToneDeltaPair(this.tertiaryFixed(), this.tertiaryFixedDim(), 10.0, TonePolarity.LIGHTER, true));
    }

    @NonNull
    public DynamicColor onTertiaryFixed() {
        return new DynamicColor("on_tertiary_fixed", s -> s.tertiaryPalette, s -> MaterialDynamicColors.isMonochrome(s) ? 100.0 : 10.0, false, s -> this.tertiaryFixedDim(), s -> this.tertiaryFixed(), new ContrastCurve(4.5, 7.0, 11.0, 21.0), null);
    }

    @NonNull
    public DynamicColor onTertiaryFixedVariant() {
        return new DynamicColor("on_tertiary_fixed_variant", s -> s.tertiaryPalette, s -> MaterialDynamicColors.isMonochrome(s) ? 90.0 : 30.0, false, s -> this.tertiaryFixedDim(), s -> this.tertiaryFixed(), new ContrastCurve(3.0, 4.5, 7.0, 11.0), null);
    }

    @NonNull
    public DynamicColor controlActivated() {
        return DynamicColor.fromPalette("control_activated", s -> s.primaryPalette, s -> s.isDark ? 30.0 : 90.0);
    }

    @NonNull
    public DynamicColor controlNormal() {
        return DynamicColor.fromPalette("control_normal", s -> s.neutralVariantPalette, s -> s.isDark ? 80.0 : 30.0);
    }

    @NonNull
    public DynamicColor controlHighlight() {
        return new DynamicColor("control_highlight", s -> s.neutralPalette, s -> s.isDark ? 100.0 : 0.0, false, null, null, null, null, s -> s.isDark ? 0.2 : 0.12);
    }

    @NonNull
    public DynamicColor textPrimaryInverse() {
        return DynamicColor.fromPalette("text_primary_inverse", s -> s.neutralPalette, s -> s.isDark ? 10.0 : 90.0);
    }

    @NonNull
    public DynamicColor textSecondaryAndTertiaryInverse() {
        return DynamicColor.fromPalette("text_secondary_and_tertiary_inverse", s -> s.neutralVariantPalette, s -> s.isDark ? 30.0 : 80.0);
    }

    @NonNull
    public DynamicColor textPrimaryInverseDisableOnly() {
        return DynamicColor.fromPalette("text_primary_inverse_disable_only", s -> s.neutralPalette, s -> s.isDark ? 10.0 : 90.0);
    }

    @NonNull
    public DynamicColor textSecondaryAndTertiaryInverseDisabled() {
        return DynamicColor.fromPalette("text_secondary_and_tertiary_inverse_disabled", s -> s.neutralPalette, s -> s.isDark ? 10.0 : 90.0);
    }

    @NonNull
    public DynamicColor textHintInverse() {
        return DynamicColor.fromPalette("text_hint_inverse", s -> s.neutralPalette, s -> s.isDark ? 10.0 : 90.0);
    }

    private static ViewingConditions viewingConditionsForAlbers(DynamicScheme scheme) {
        return ViewingConditions.defaultWithBackgroundLstar(scheme.isDark ? 30.0 : 80.0);
    }

    private static boolean isFidelity(DynamicScheme scheme) {
        return scheme.variant == Variant.FIDELITY || scheme.variant == Variant.CONTENT;
    }

    private static boolean isMonochrome(DynamicScheme scheme) {
        return scheme.variant == Variant.MONOCHROME;
    }

    static double findDesiredChromaByTone(double hue, double chroma, double tone, boolean byDecreasingTone) {
        double answer = tone;
        Hct closestToChroma = Hct.from(hue, chroma, tone);
        if (closestToChroma.getChroma() < chroma) {
            Hct potentialSolution;
            double chromaPeak = closestToChroma.getChroma();
            while (closestToChroma.getChroma() < chroma && !(chromaPeak > (potentialSolution = Hct.from(hue, chroma, answer += byDecreasingTone ? -1.0 : 1.0)).getChroma()) && !(Math.abs(potentialSolution.getChroma() - chroma) < 0.4)) {
                double currentDelta;
                double potentialDelta = Math.abs(potentialSolution.getChroma() - chroma);
                if (potentialDelta < (currentDelta = Math.abs(closestToChroma.getChroma() - chroma))) {
                    closestToChroma = potentialSolution;
                }
                chromaPeak = Math.max(chromaPeak, potentialSolution.getChroma());
            }
        }
        return answer;
    }

    static double performAlbers(Hct prealbers, DynamicScheme scheme) {
        Hct albersd = prealbers.inViewingConditions(MaterialDynamicColors.viewingConditionsForAlbers(scheme));
        if (DynamicColor.tonePrefersLightForeground(prealbers.getTone()) && !DynamicColor.toneAllowsLightForeground(albersd.getTone())) {
            return DynamicColor.enableLightForeground(prealbers.getTone());
        }
        return DynamicColor.enableLightForeground(albersd.getTone());
    }
}

