/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color.utilities;

import androidx.annotation.RestrictTo;
import com.google.android.material.color.utilities.ColorUtils;
import com.google.android.material.color.utilities.PointProvider;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class PointProviderLab
implements PointProvider {
    @Override
    public double[] fromInt(int argb) {
        double[] lab = ColorUtils.labFromArgb(argb);
        return new double[]{lab[0], lab[1], lab[2]};
    }

    @Override
    public int toInt(double[] lab) {
        return ColorUtils.argbFromLab(lab[0], lab[1], lab[2]);
    }

    @Override
    public double distance(double[] one, double[] two) {
        double dL = one[0] - two[0];
        double dA = one[1] - two[1];
        double dB = one[2] - two[2];
        return dL * dL + dA * dA + dB * dB;
    }
}

