/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color.utilities;

import androidx.annotation.RestrictTo;
import com.google.android.material.color.utilities.Quantizer;
import com.google.android.material.color.utilities.QuantizerResult;
import java.util.LinkedHashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class QuantizerMap
implements Quantizer {
    Map<Integer, Integer> colorToCount;

    @Override
    public QuantizerResult quantize(int[] pixels, int colorCount) {
        LinkedHashMap<Integer, Integer> pixelByCount = new LinkedHashMap<Integer, Integer>();
        for (int pixel : pixels) {
            Integer currentPixelCount = (Integer)pixelByCount.get(pixel);
            int newPixelCount = currentPixelCount == null ? 1 : currentPixelCount + 1;
            pixelByCount.put(pixel, newPixelCount);
        }
        this.colorToCount = pixelByCount;
        return new QuantizerResult(pixelByCount);
    }

    public Map<Integer, Integer> getColorToCount() {
        return this.colorToCount;
    }
}

