/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color.utilities;

import androidx.annotation.RestrictTo;
import com.google.android.material.color.utilities.Hct;
import com.google.android.material.color.utilities.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Score {
    private static final double TARGET_CHROMA = 48.0;
    private static final double WEIGHT_PROPORTION = 0.7;
    private static final double WEIGHT_CHROMA_ABOVE = 0.3;
    private static final double WEIGHT_CHROMA_BELOW = 0.1;
    private static final double CUTOFF_CHROMA = 5.0;
    private static final double CUTOFF_EXCITED_PROPORTION = 0.01;
    private static final int BLUE_500 = -12417548;
    private static final int MAX_COLOR_COUNT = 4;

    private Score() {
    }

    public static List<Integer> score(Map<Integer, Integer> colorsToPopulation) {
        return Score.score(colorsToPopulation, 4, -12417548, true);
    }

    public static List<Integer> score(Map<Integer, Integer> colorsToPopulation, int maxColorCount) {
        return Score.score(colorsToPopulation, maxColorCount, -12417548, true);
    }

    public static List<Integer> score(Map<Integer, Integer> colorsToPopulation, int maxColorCount, int fallbackColorArgb) {
        return Score.score(colorsToPopulation, maxColorCount, fallbackColorArgb, true);
    }

    public static List<Integer> score(Map<Integer, Integer> colorsToPopulation, int maxColorCount, int fallbackColorArgb, boolean filter2) {
        ArrayList<Hct> colorsHct = new ArrayList<Hct>();
        int[] huePopulation = new int[360];
        double populationSum = 0.0;
        for (Map.Entry<Integer, Integer> entry : colorsToPopulation.entrySet()) {
            Hct hct = Hct.fromInt(entry.getKey());
            colorsHct.add(hct);
            int hue = (int)Math.floor(hct.getHue());
            int population = entry.getValue();
            int n = hue;
            huePopulation[n] = huePopulation[n] + population;
            populationSum += (double)population;
        }
        double[] hueExcitedProportions = new double[360];
        for (int hue = 0; hue < 360; ++hue) {
            double proportion = (double)huePopulation[hue] / populationSum;
            for (int i = hue - 14; i < hue + 16; ++i) {
                int neighborHue;
                int n = neighborHue = MathUtils.sanitizeDegreesInt(i);
                hueExcitedProportions[n] = hueExcitedProportions[n] + proportion;
            }
        }
        ArrayList<ScoredHCT> scoredHcts = new ArrayList<ScoredHCT>();
        for (Hct hct : colorsHct) {
            int hue = MathUtils.sanitizeDegreesInt((int)Math.round(hct.getHue()));
            double proportion = hueExcitedProportions[hue];
            if (filter2 && (hct.getChroma() < 5.0 || proportion <= 0.01)) continue;
            double proportionScore = proportion * 100.0 * 0.7;
            double chromaWeight = hct.getChroma() < 48.0 ? 0.1 : 0.3;
            double chromaScore = (hct.getChroma() - 48.0) * chromaWeight;
            double score = proportionScore + chromaScore;
            scoredHcts.add(new ScoredHCT(hct, score));
        }
        Collections.sort(scoredHcts, new ScoredComparator());
        ArrayList<Hct> chosenColors = new ArrayList<Hct>();
        for (int differenceDegrees = 90; differenceDegrees >= 15; --differenceDegrees) {
            chosenColors.clear();
            for (ScoredHCT entry : scoredHcts) {
                Hct hct = entry.hct;
                boolean hasDuplicateHue = false;
                for (Hct chosenHct : chosenColors) {
                    if (!(MathUtils.differenceDegrees(hct.getHue(), chosenHct.getHue()) < (double)differenceDegrees)) continue;
                    hasDuplicateHue = true;
                    break;
                }
                if (!hasDuplicateHue) {
                    chosenColors.add(hct);
                }
                if (chosenColors.size() < maxColorCount) continue;
                break;
            }
            if (chosenColors.size() >= maxColorCount) break;
        }
        ArrayList<Integer> colors = new ArrayList<Integer>();
        if (chosenColors.isEmpty()) {
            colors.add(fallbackColorArgb);
            return colors;
        }
        for (Hct chosenHct : chosenColors) {
            colors.add(chosenHct.toInt());
        }
        return colors;
    }

    private static class ScoredComparator
    implements Comparator<ScoredHCT> {
        @Override
        public int compare(ScoredHCT entry1, ScoredHCT entry2) {
            return Double.compare(entry2.score, entry1.score);
        }
    }

    private static class ScoredHCT {
        public final Hct hct;
        public final double score;

        public ScoredHCT(Hct hct, double score) {
            this.hct = hct;
            this.score = score;
        }
    }
}

