/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color.utilities;

import androidx.annotation.RestrictTo;
import com.google.android.material.color.utilities.Hct;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class TonalPalette {
    Map<Integer, Integer> cache = new HashMap<Integer, Integer>();
    Hct keyColor;
    double hue;
    double chroma;

    public static TonalPalette fromInt(int argb) {
        return TonalPalette.fromHct(Hct.fromInt(argb));
    }

    public static TonalPalette fromHct(Hct hct) {
        return new TonalPalette(hct.getHue(), hct.getChroma(), hct);
    }

    public static TonalPalette fromHueAndChroma(double hue, double chroma) {
        return new TonalPalette(hue, chroma, TonalPalette.createKeyColor(hue, chroma));
    }

    private TonalPalette(double hue, double chroma, Hct keyColor) {
        this.hue = hue;
        this.chroma = chroma;
        this.keyColor = keyColor;
    }

    private static Hct createKeyColor(double hue, double chroma) {
        double startTone = 50.0;
        Hct smallestDeltaHct = Hct.from(hue, chroma, startTone);
        double smallestDelta = Math.abs(smallestDeltaHct.getChroma() - chroma);
        for (double delta = 1.0; delta < 50.0; delta += 1.0) {
            Hct hctSubtract;
            double hctSubtractDelta;
            if (Math.round(chroma) == Math.round(smallestDeltaHct.getChroma())) {
                return smallestDeltaHct;
            }
            Hct hctAdd = Hct.from(hue, chroma, startTone + delta);
            double hctAddDelta = Math.abs(hctAdd.getChroma() - chroma);
            if (hctAddDelta < smallestDelta) {
                smallestDelta = hctAddDelta;
                smallestDeltaHct = hctAdd;
            }
            if (!((hctSubtractDelta = Math.abs((hctSubtract = Hct.from(hue, chroma, startTone - delta)).getChroma() - chroma)) < smallestDelta)) continue;
            smallestDelta = hctSubtractDelta;
            smallestDeltaHct = hctSubtract;
        }
        return smallestDeltaHct;
    }

    public int tone(int tone) {
        Integer color2 = this.cache.get(tone);
        if (color2 == null) {
            color2 = Hct.from(this.hue, this.chroma, tone).toInt();
            this.cache.put(tone, color2);
        }
        return color2;
    }

    public Hct getHct(double tone) {
        return Hct.from(this.hue, this.chroma, tone);
    }

    public double getChroma() {
        return this.chroma;
    }

    public double getHue() {
        return this.hue;
    }

    public Hct getKeyColor() {
        return this.keyColor;
    }
}

