/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.R;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.DateStrings;
import com.google.android.material.datepicker.UtcDates;
import com.google.android.material.internal.TextWatcherAdapter;
import com.google.android.material.textfield.TextInputLayout;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

abstract class DateFormatTextWatcher
extends TextWatcherAdapter {
    @NonNull
    private final TextInputLayout textInputLayout;
    private final String formatHint;
    private final DateFormat dateFormat;
    private final CalendarConstraints constraints;
    private final String outOfRange;
    private final Runnable setErrorCallback;
    private Runnable setRangeErrorCallback;
    private int lastLength = 0;

    DateFormatTextWatcher(String formatHint, DateFormat dateFormat, @NonNull TextInputLayout textInputLayout, CalendarConstraints constraints) {
        this.formatHint = formatHint;
        this.dateFormat = dateFormat;
        this.textInputLayout = textInputLayout;
        this.constraints = constraints;
        this.outOfRange = textInputLayout.getContext().getString(R.string.mtrl_picker_out_of_range);
        this.setErrorCallback = () -> {
            TextInputLayout textLayout = this.textInputLayout;
            DateFormat df = this.dateFormat;
            Context context = textLayout.getContext();
            String invalidFormat = context.getString(R.string.mtrl_picker_invalid_format);
            String useLine = String.format(context.getString(R.string.mtrl_picker_invalid_format_use), this.sanitizeDateString(formatHint));
            String exampleLine = String.format(context.getString(R.string.mtrl_picker_invalid_format_example), this.sanitizeDateString(df.format(new Date(UtcDates.getTodayCalendar().getTimeInMillis()))));
            textLayout.setError(invalidFormat + "\n" + useLine + "\n" + exampleLine);
            this.onInvalidDate();
        };
    }

    abstract void onValidDate(@Nullable Long var1);

    void onInvalidDate() {
    }

    @Override
    public void onTextChanged(@NonNull CharSequence s, int start, int before, int count2) {
        this.textInputLayout.removeCallbacks(this.setErrorCallback);
        this.textInputLayout.removeCallbacks(this.setRangeErrorCallback);
        this.textInputLayout.setError(null);
        this.onValidDate(null);
        if (TextUtils.isEmpty((CharSequence)s) || s.length() < this.formatHint.length()) {
            return;
        }
        try {
            Date date = this.dateFormat.parse(s.toString());
            this.textInputLayout.setError(null);
            long milliseconds = date.getTime();
            if (this.constraints.getDateValidator().isValid(milliseconds) && this.constraints.isWithinBounds(milliseconds)) {
                this.onValidDate(date.getTime());
                return;
            }
            this.setRangeErrorCallback = this.createRangeErrorCallback(milliseconds);
            this.runValidation((View)this.textInputLayout, this.setRangeErrorCallback);
        }
        catch (ParseException e) {
            this.runValidation((View)this.textInputLayout, this.setErrorCallback);
        }
    }

    @Override
    public void beforeTextChanged(@NonNull CharSequence s, int start, int count2, int after) {
        this.lastLength = s.length();
    }

    @Override
    public void afterTextChanged(@NonNull Editable s) {
        if (Locale.getDefault().getLanguage().equals(Locale.KOREAN.getLanguage())) {
            return;
        }
        if (s.length() == 0 || s.length() >= this.formatHint.length() || s.length() < this.lastLength) {
            return;
        }
        char nextCharHint = this.formatHint.charAt(s.length());
        if (!Character.isLetterOrDigit(nextCharHint)) {
            s.append(nextCharHint);
        }
    }

    private Runnable createRangeErrorCallback(long milliseconds) {
        return () -> {
            String dateString = DateStrings.getDateString(milliseconds);
            this.textInputLayout.setError(String.format(this.outOfRange, this.sanitizeDateString(dateString)));
            this.onInvalidDate();
        };
    }

    private String sanitizeDateString(String dateString) {
        return dateString.replace(' ', '\u00a0');
    }

    public void runValidation(View view, Runnable validation) {
        view.post(validation);
    }
}

