/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.os.Build;
import android.text.format.DateUtils;
import androidx.annotation.Nullable;
import androidx.core.util.Pair;
import com.google.android.material.R;
import com.google.android.material.datepicker.UtcDates;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

class DateStrings {
    private DateStrings() {
    }

    static String getYearMonth(long timeInMillis) {
        if (Build.VERSION.SDK_INT >= 24) {
            return UtcDates.getYearMonthFormat(Locale.getDefault()).format(new Date(timeInMillis));
        }
        int flags = 8228;
        return DateUtils.formatDateTime(null, (long)timeInMillis, (int)flags);
    }

    static String getYearMonthDay(long timeInMillis) {
        return DateStrings.getYearMonthDay(timeInMillis, Locale.getDefault());
    }

    static String getYearMonthDay(long timeInMillis, Locale locale) {
        if (Build.VERSION.SDK_INT >= 24) {
            return UtcDates.getYearAbbrMonthDayFormat(locale).format(new Date(timeInMillis));
        }
        return UtcDates.getMediumFormat(locale).format(new Date(timeInMillis));
    }

    static String getMonthDay(long timeInMillis) {
        return DateStrings.getMonthDay(timeInMillis, Locale.getDefault());
    }

    static String getMonthDay(long timeInMillis, Locale locale) {
        if (Build.VERSION.SDK_INT >= 24) {
            return UtcDates.getAbbrMonthDayFormat(locale).format(new Date(timeInMillis));
        }
        return UtcDates.getMediumNoYear(locale).format(new Date(timeInMillis));
    }

    static String getMonthDayOfWeekDay(long timeInMillis) {
        return DateStrings.getMonthDayOfWeekDay(timeInMillis, Locale.getDefault());
    }

    static String getMonthDayOfWeekDay(long timeInMillis, Locale locale) {
        if (Build.VERSION.SDK_INT >= 24) {
            return UtcDates.getMonthWeekdayDayFormat(locale).format(new Date(timeInMillis));
        }
        return UtcDates.getFullFormat(locale).format(new Date(timeInMillis));
    }

    static String getYearMonthDayOfWeekDay(long timeInMillis) {
        return DateStrings.getYearMonthDayOfWeekDay(timeInMillis, Locale.getDefault());
    }

    static String getYearMonthDayOfWeekDay(long timeInMillis, Locale locale) {
        if (Build.VERSION.SDK_INT >= 24) {
            return UtcDates.getYearMonthWeekdayDayFormat(locale).format(new Date(timeInMillis));
        }
        return UtcDates.getFullFormat(locale).format(new Date(timeInMillis));
    }

    static String getOptionalYearMonthDayOfWeekDay(long timeInMillis) {
        if (DateStrings.isDateWithinCurrentYear(timeInMillis)) {
            return DateStrings.getMonthDayOfWeekDay(timeInMillis);
        }
        return DateStrings.getYearMonthDayOfWeekDay(timeInMillis);
    }

    static String getDateString(long timeInMillis) {
        return DateStrings.getDateString(timeInMillis, null);
    }

    static String getDateString(long timeInMillis, @Nullable SimpleDateFormat userDefinedDateFormat) {
        if (userDefinedDateFormat != null) {
            Date date = new Date(timeInMillis);
            return userDefinedDateFormat.format(date);
        }
        if (DateStrings.isDateWithinCurrentYear(timeInMillis)) {
            return DateStrings.getMonthDay(timeInMillis);
        }
        return DateStrings.getYearMonthDay(timeInMillis);
    }

    private static boolean isDateWithinCurrentYear(long timeInMillis) {
        Calendar currentCalendar = UtcDates.getTodayCalendar();
        Calendar calendarDate = UtcDates.getUtcCalendar();
        calendarDate.setTimeInMillis(timeInMillis);
        return currentCalendar.get(1) == calendarDate.get(1);
    }

    static Pair<String, String> getDateRangeString(@Nullable Long start, @Nullable Long end) {
        return DateStrings.getDateRangeString(start, end, null);
    }

    static Pair<String, String> getDateRangeString(@Nullable Long start, @Nullable Long end, @Nullable SimpleDateFormat userDefinedDateFormat) {
        if (start == null && end == null) {
            return Pair.create(null, null);
        }
        if (start == null) {
            return Pair.create(null, DateStrings.getDateString(end, userDefinedDateFormat));
        }
        if (end == null) {
            return Pair.create(DateStrings.getDateString(start, userDefinedDateFormat), null);
        }
        Calendar currentCalendar = UtcDates.getTodayCalendar();
        Calendar startCalendar = UtcDates.getUtcCalendar();
        startCalendar.setTimeInMillis(start);
        Calendar endCalendar = UtcDates.getUtcCalendar();
        endCalendar.setTimeInMillis(end);
        if (userDefinedDateFormat != null) {
            Date startDate = new Date(start);
            Date endDate = new Date(end);
            return Pair.create(userDefinedDateFormat.format(startDate), userDefinedDateFormat.format(endDate));
        }
        if (startCalendar.get(1) == endCalendar.get(1)) {
            if (startCalendar.get(1) == currentCalendar.get(1)) {
                return Pair.create(DateStrings.getMonthDay(start, Locale.getDefault()), DateStrings.getMonthDay(end, Locale.getDefault()));
            }
            return Pair.create(DateStrings.getMonthDay(start, Locale.getDefault()), DateStrings.getYearMonthDay(end, Locale.getDefault()));
        }
        return Pair.create(DateStrings.getYearMonthDay(start, Locale.getDefault()), DateStrings.getYearMonthDay(end, Locale.getDefault()));
    }

    static String getDayContentDescription(Context context, long dayInMillis, boolean isToday, boolean isStartOfRange, boolean isEndOfRange) {
        String dayContentDescription = DateStrings.getOptionalYearMonthDayOfWeekDay(dayInMillis);
        if (isToday) {
            dayContentDescription = String.format(context.getString(R.string.mtrl_picker_today_description), dayContentDescription);
        }
        if (isStartOfRange) {
            return String.format(context.getString(R.string.mtrl_picker_start_date_description), dayContentDescription);
        }
        if (isEndOfRange) {
            return String.format(context.getString(R.string.mtrl_picker_end_date_description), dayContentDescription);
        }
        return dayContentDescription;
    }

    static String getYearContentDescription(Context context, int year) {
        if (UtcDates.getTodayCalendar().get(1) == year) {
            return String.format(context.getString(R.string.mtrl_picker_navigate_to_current_year_description), year);
        }
        return String.format(context.getString(R.string.mtrl_picker_navigate_to_year_description), year);
    }
}

