/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.R;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.CalendarItemStyle;
import com.google.android.material.datepicker.CalendarStyle;
import com.google.android.material.datepicker.DateStrings;
import com.google.android.material.datepicker.MaterialCalendar;
import com.google.android.material.datepicker.Month;
import com.google.android.material.datepicker.UtcDates;
import java.util.Calendar;
import java.util.Locale;

class YearGridAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final MaterialCalendar<?> materialCalendar;

    YearGridAdapter(MaterialCalendar<?> materialCalendar) {
        this.materialCalendar = materialCalendar;
    }

    @Override
    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        TextView yearTextView = (TextView)LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.mtrl_calendar_year, viewGroup, false);
        return new ViewHolder(yearTextView);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int position) {
        int year = this.getYearForPosition(position);
        viewHolder.textView.setText((CharSequence)String.format(Locale.getDefault(), "%d", year));
        viewHolder.textView.setContentDescription((CharSequence)DateStrings.getYearContentDescription(viewHolder.textView.getContext(), year));
        CalendarStyle styles = this.materialCalendar.getCalendarStyle();
        Calendar calendar = UtcDates.getTodayCalendar();
        CalendarItemStyle style2 = calendar.get(1) == year ? styles.todayYear : styles.year;
        for (Long day : this.materialCalendar.getDateSelector().getSelectedDays()) {
            calendar.setTimeInMillis(day);
            if (calendar.get(1) != year) continue;
            style2 = styles.selectedYear;
        }
        style2.styleItem(viewHolder.textView);
        viewHolder.textView.setOnClickListener(this.createYearClickListener(year));
    }

    @NonNull
    private View.OnClickListener createYearClickListener(final int year) {
        return new View.OnClickListener(){

            public void onClick(View view) {
                Month current = Month.create(year, ((YearGridAdapter)YearGridAdapter.this).materialCalendar.getCurrentMonth().month);
                CalendarConstraints calendarConstraints = YearGridAdapter.this.materialCalendar.getCalendarConstraints();
                Month moveTo = calendarConstraints.clamp(current);
                YearGridAdapter.this.materialCalendar.setCurrentMonth(moveTo);
                YearGridAdapter.this.materialCalendar.setSelector(MaterialCalendar.CalendarSelector.DAY);
            }
        };
    }

    @Override
    public int getItemCount() {
        return this.materialCalendar.getCalendarConstraints().getYearSpan();
    }

    int getPositionForYear(int year) {
        return year - this.materialCalendar.getCalendarConstraints().getStart().year;
    }

    int getYearForPosition(int position) {
        return this.materialCalendar.getCalendarConstraints().getStart().year + position;
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        final TextView textView;

        ViewHolder(TextView view) {
            super((View)view);
            this.textView = view;
        }
    }
}

