/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.divider;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class MaterialDivider
extends View {
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_MaterialDivider;
    @NonNull
    private final MaterialShapeDrawable dividerDrawable;
    private int thickness;
    @ColorInt
    private int color;
    private int insetStart;
    private int insetEnd;

    public MaterialDivider(@NonNull Context context) {
        this(context, null);
    }

    public MaterialDivider(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.materialDividerStyle);
    }

    public MaterialDivider(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        this.dividerDrawable = new MaterialShapeDrawable();
        TypedArray attributes = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.MaterialDivider, defStyleAttr, DEF_STYLE_RES, new int[0]);
        this.thickness = attributes.getDimensionPixelSize(R.styleable.MaterialDivider_dividerThickness, this.getResources().getDimensionPixelSize(R.dimen.material_divider_thickness));
        this.insetStart = attributes.getDimensionPixelOffset(R.styleable.MaterialDivider_dividerInsetStart, 0);
        this.insetEnd = attributes.getDimensionPixelOffset(R.styleable.MaterialDivider_dividerInsetEnd, 0);
        this.setDividerColor(MaterialResources.getColorStateList(context, attributes, R.styleable.MaterialDivider_dividerColor).getDefaultColor());
        attributes.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int newThickness = this.getMeasuredHeight();
        if (heightMode == Integer.MIN_VALUE || heightMode == 0) {
            if (this.thickness > 0 && newThickness != this.thickness) {
                newThickness = this.thickness;
            }
            this.setMeasuredDimension(this.getMeasuredWidth(), newThickness);
        }
    }

    protected void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        boolean isRtl = ViewCompat.getLayoutDirection(this) == 1;
        int left = isRtl ? this.insetEnd : this.insetStart;
        int right = isRtl ? this.getWidth() - this.insetStart : this.getWidth() - this.insetEnd;
        this.dividerDrawable.setBounds(left, 0, right, this.getBottom() - this.getTop());
        this.dividerDrawable.draw(canvas);
    }

    public void setDividerThickness(@Px int thickness) {
        if (this.thickness != thickness) {
            this.thickness = thickness;
            this.requestLayout();
        }
    }

    public void setDividerThicknessResource(@DimenRes int thicknessId) {
        this.setDividerThickness(this.getContext().getResources().getDimensionPixelSize(thicknessId));
    }

    public int getDividerThickness() {
        return this.thickness;
    }

    public void setDividerInsetStart(@Px int insetStart) {
        this.insetStart = insetStart;
    }

    public void setDividerInsetStartResource(@DimenRes int insetStartId) {
        this.setDividerInsetStart(this.getContext().getResources().getDimensionPixelOffset(insetStartId));
    }

    @Px
    public int getDividerInsetStart() {
        return this.insetStart;
    }

    public void setDividerInsetEnd(@Px int insetEnd) {
        this.insetEnd = insetEnd;
    }

    public void setDividerInsetEndResource(@DimenRes int insetEndId) {
        this.setDividerInsetEnd(this.getContext().getResources().getDimensionPixelOffset(insetEndId));
    }

    @Px
    public int getDividerInsetEnd() {
        return this.insetEnd;
    }

    public void setDividerColor(@ColorInt int color2) {
        if (this.color != color2) {
            this.color = color2;
            this.dividerDrawable.setFillColor(ColorStateList.valueOf((int)color2));
            this.invalidate();
        }
    }

    public void setDividerColorResource(@ColorRes int colorId) {
        this.setDividerColor(ContextCompat.getColor(this.getContext(), colorId));
    }

    public int getDividerColor() {
        return this.color;
    }
}

