/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.divider;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.R;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;

public class MaterialDividerItemDecoration
extends RecyclerView.ItemDecoration {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_MaterialDivider;
    @NonNull
    private Drawable dividerDrawable;
    private int thickness;
    @ColorInt
    private int color;
    private int orientation;
    private int insetStart;
    private int insetEnd;
    private boolean lastItemDecorated;
    private final Rect tempRect = new Rect();

    public MaterialDividerItemDecoration(@NonNull Context context, int orientation) {
        this(context, null, orientation);
    }

    public MaterialDividerItemDecoration(@NonNull Context context, @Nullable AttributeSet attrs, int orientation) {
        this(context, attrs, R.attr.materialDividerStyle, orientation);
    }

    public MaterialDividerItemDecoration(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int orientation) {
        TypedArray attributes = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.MaterialDivider, defStyleAttr, DEF_STYLE_RES, new int[0]);
        this.color = MaterialResources.getColorStateList(context, attributes, R.styleable.MaterialDivider_dividerColor).getDefaultColor();
        this.thickness = attributes.getDimensionPixelSize(R.styleable.MaterialDivider_dividerThickness, context.getResources().getDimensionPixelSize(R.dimen.material_divider_thickness));
        this.insetStart = attributes.getDimensionPixelOffset(R.styleable.MaterialDivider_dividerInsetStart, 0);
        this.insetEnd = attributes.getDimensionPixelOffset(R.styleable.MaterialDivider_dividerInsetEnd, 0);
        this.lastItemDecorated = attributes.getBoolean(R.styleable.MaterialDivider_lastItemDecorated, true);
        attributes.recycle();
        this.dividerDrawable = new ShapeDrawable();
        this.setDividerColor(this.color);
        this.setOrientation(orientation);
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("Invalid orientation: " + orientation + ". It should be either HORIZONTAL or VERTICAL");
        }
        this.orientation = orientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setDividerThickness(@Px int thickness) {
        this.thickness = thickness;
    }

    public void setDividerThicknessResource(@NonNull Context context, @DimenRes int thicknessId) {
        this.setDividerThickness(context.getResources().getDimensionPixelSize(thicknessId));
    }

    @Px
    public int getDividerThickness() {
        return this.thickness;
    }

    public void setDividerColor(@ColorInt int color2) {
        this.color = color2;
        this.dividerDrawable = DrawableCompat.wrap(this.dividerDrawable);
        DrawableCompat.setTint(this.dividerDrawable, color2);
    }

    public void setDividerColorResource(@NonNull Context context, @ColorRes int colorId) {
        this.setDividerColor(ContextCompat.getColor(context, colorId));
    }

    @ColorInt
    public int getDividerColor() {
        return this.color;
    }

    public void setDividerInsetStart(@Px int insetStart) {
        this.insetStart = insetStart;
    }

    public void setDividerInsetStartResource(@NonNull Context context, @DimenRes int insetStartId) {
        this.setDividerInsetStart(context.getResources().getDimensionPixelOffset(insetStartId));
    }

    @Px
    public int getDividerInsetStart() {
        return this.insetStart;
    }

    public void setDividerInsetEnd(@Px int insetEnd) {
        this.insetEnd = insetEnd;
    }

    public void setDividerInsetEndResource(@NonNull Context context, @DimenRes int insetEndId) {
        this.setDividerInsetEnd(context.getResources().getDimensionPixelOffset(insetEndId));
    }

    @Px
    public int getDividerInsetEnd() {
        return this.insetEnd;
    }

    public void setLastItemDecorated(boolean lastItemDecorated) {
        this.lastItemDecorated = lastItemDecorated;
    }

    public boolean isLastItemDecorated() {
        return this.lastItemDecorated;
    }

    @Override
    public void onDraw(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        if (parent.getLayoutManager() == null) {
            return;
        }
        if (this.orientation == 1) {
            this.drawForVerticalOrientation(canvas, parent);
        } else {
            this.drawForHorizontalOrientation(canvas, parent);
        }
    }

    private void drawForVerticalOrientation(@NonNull Canvas canvas, @NonNull RecyclerView parent) {
        int right;
        int left;
        canvas.save();
        if (parent.getClipToPadding()) {
            left = parent.getPaddingLeft();
            right = parent.getWidth() - parent.getPaddingRight();
            canvas.clipRect(left, parent.getPaddingTop(), right, parent.getHeight() - parent.getPaddingBottom());
        } else {
            left = 0;
            right = parent.getWidth();
        }
        boolean isRtl = ViewUtils.isLayoutRtl((View)parent);
        left += isRtl ? this.insetEnd : this.insetStart;
        right -= isRtl ? this.insetStart : this.insetEnd;
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            if (!this.shouldDrawDivider(parent, child)) continue;
            parent.getLayoutManager().getDecoratedBoundsWithMargins(child, this.tempRect);
            int bottom = this.tempRect.bottom + Math.round(child.getTranslationY());
            int top = bottom - this.thickness;
            this.dividerDrawable.setBounds(left, top, right, bottom);
            int alpha = Math.round(child.getAlpha() * 255.0f);
            this.dividerDrawable.setAlpha(alpha);
            this.dividerDrawable.draw(canvas);
        }
        canvas.restore();
    }

    private void drawForHorizontalOrientation(@NonNull Canvas canvas, @NonNull RecyclerView parent) {
        int bottom;
        int top;
        canvas.save();
        if (parent.getClipToPadding()) {
            top = parent.getPaddingTop();
            bottom = parent.getHeight() - parent.getPaddingBottom();
            canvas.clipRect(parent.getPaddingLeft(), top, parent.getWidth() - parent.getPaddingRight(), bottom);
        } else {
            top = 0;
            bottom = parent.getHeight();
        }
        top += this.insetStart;
        bottom -= this.insetEnd;
        boolean isRtl = ViewUtils.isLayoutRtl((View)parent);
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            int right;
            int left;
            View child = parent.getChildAt(i);
            if (!this.shouldDrawDivider(parent, child)) continue;
            parent.getLayoutManager().getDecoratedBoundsWithMargins(child, this.tempRect);
            int translationX = Math.round(child.getTranslationX());
            if (isRtl) {
                left = this.tempRect.left + translationX;
                right = left + this.thickness;
            } else {
                right = this.tempRect.right + translationX;
                left = right - this.thickness;
            }
            this.dividerDrawable.setBounds(left, top, right, bottom);
            int alpha = Math.round(child.getAlpha() * 255.0f);
            this.dividerDrawable.setAlpha(alpha);
            this.dividerDrawable.draw(canvas);
        }
        canvas.restore();
    }

    @Override
    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        outRect.set(0, 0, 0, 0);
        if (this.shouldDrawDivider(parent, view)) {
            if (this.orientation == 1) {
                outRect.bottom = this.thickness;
            } else if (ViewUtils.isLayoutRtl((View)parent)) {
                outRect.left = this.thickness;
            } else {
                outRect.right = this.thickness;
            }
        }
    }

    private boolean shouldDrawDivider(@NonNull RecyclerView parent, @NonNull View child) {
        int position = parent.getChildAdapterPosition(child);
        RecyclerView.Adapter adapter = parent.getAdapter();
        boolean isLastItem = adapter != null && position == adapter.getItemCount() - 1;
        return position != -1 && (!isLastItem || this.lastItemDecorated) && this.shouldDrawDivider(position, adapter);
    }

    protected boolean shouldDrawDivider(int position, @Nullable RecyclerView.Adapter<?> adapter) {
        return true;
    }
}

