/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.drawable;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.ColorStateListDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Xml;
import androidx.annotation.ColorInt;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.XmlRes;
import androidx.core.graphics.drawable.DrawableCompat;
import com.google.android.material.drawable.ScaledDrawableWrapper;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class DrawableUtils {
    public static final int INTRINSIC_SIZE = -1;
    private static final int UNSPECIFIED_WIDTH = -1;
    private static final int UNSPECIFIED_HEIGHT = -1;

    private DrawableUtils() {
    }

    public static void setTint(@NonNull Drawable drawable2, @ColorInt int color2) {
        boolean hasTint;
        boolean bl = hasTint = color2 != 0;
        if (Build.VERSION.SDK_INT == 21) {
            if (hasTint) {
                drawable2.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
            } else {
                drawable2.setColorFilter(null);
            }
        } else if (hasTint) {
            DrawableCompat.setTint(drawable2, color2);
        } else {
            DrawableCompat.setTintList(drawable2, null);
        }
    }

    @Nullable
    public static PorterDuffColorFilter updateTintFilter(@NonNull Drawable drawable2, @Nullable ColorStateList tint, @Nullable PorterDuff.Mode tintMode) {
        if (tint == null || tintMode == null) {
            return null;
        }
        int color2 = tint.getColorForState(drawable2.getState(), 0);
        return new PorterDuffColorFilter(color2, tintMode);
    }

    @NonNull
    public static AttributeSet parseDrawableXml(@NonNull Context context, @XmlRes int id2, @NonNull CharSequence startTag) {
        try {
            int type;
            XmlResourceParser parser = context.getResources().getXml(id2);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new XmlPullParserException("No start tag found");
            }
            if (!TextUtils.equals((CharSequence)parser.getName(), (CharSequence)startTag)) {
                throw new XmlPullParserException("Must have a <" + startTag + "> start tag");
            }
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            return attrs;
        }
        catch (IOException | XmlPullParserException e) {
            Resources.NotFoundException exception = new Resources.NotFoundException("Can't load badge resource ID #0x" + Integer.toHexString(id2));
            exception.initCause(e);
            throw exception;
        }
    }

    @TargetApi(value=21)
    public static void setRippleDrawableRadius(@Nullable RippleDrawable drawable2, int radius) {
        if (Build.VERSION.SDK_INT >= 23) {
            drawable2.setRadius(radius);
        } else {
            try {
                Method setMaxRadiusMethod = RippleDrawable.class.getDeclaredMethod("setMaxRadius", Integer.TYPE);
                setMaxRadiusMethod.invoke((Object)drawable2, radius);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Couldn't set RippleDrawable radius", e);
            }
        }
    }

    @Nullable
    public static Drawable createTintableDrawableIfNeeded(@Nullable Drawable drawable2, @Nullable ColorStateList tintList, @Nullable PorterDuff.Mode tintMode) {
        return DrawableUtils.createTintableMutatedDrawableIfNeeded(drawable2, tintList, tintMode, false);
    }

    @Nullable
    public static Drawable createTintableMutatedDrawableIfNeeded(@Nullable Drawable drawable2, @Nullable ColorStateList tintList, @Nullable PorterDuff.Mode tintMode) {
        return DrawableUtils.createTintableMutatedDrawableIfNeeded(drawable2, tintList, tintMode, Build.VERSION.SDK_INT < 23);
    }

    @Nullable
    private static Drawable createTintableMutatedDrawableIfNeeded(@Nullable Drawable drawable2, @Nullable ColorStateList tintList, @Nullable PorterDuff.Mode tintMode, boolean forceMutate) {
        if (drawable2 == null) {
            return null;
        }
        if (tintList != null) {
            drawable2 = DrawableCompat.wrap(drawable2).mutate();
            if (tintMode != null) {
                DrawableCompat.setTintMode(drawable2, tintMode);
            }
        } else if (forceMutate) {
            drawable2.mutate();
        }
        return drawable2;
    }

    @Nullable
    public static Drawable compositeTwoLayeredDrawable(@Nullable Drawable bottomLayerDrawable, @Nullable Drawable topLayerDrawable) {
        return DrawableUtils.compositeTwoLayeredDrawable(bottomLayerDrawable, topLayerDrawable, -1, -1);
    }

    @Nullable
    public static Drawable compositeTwoLayeredDrawable(@Nullable Drawable bottomLayerDrawable, @Nullable Drawable topLayerDrawable, @Px int topLayerDesiredWidth, @Px int topLayerDesiredHeight) {
        LayerDrawable drawable2;
        int topLayerNewHeight;
        int topLayerNewWidth;
        boolean shouldScaleTopLayer;
        if (bottomLayerDrawable == null) {
            return topLayerDrawable;
        }
        if (topLayerDrawable == null) {
            return bottomLayerDrawable;
        }
        boolean bl = shouldScaleTopLayer = topLayerDesiredWidth != -1 && topLayerDesiredHeight != -1;
        if (topLayerDesiredWidth == -1) {
            topLayerDesiredWidth = DrawableUtils.getTopLayerIntrinsicWidth(bottomLayerDrawable, topLayerDrawable);
        }
        if (topLayerDesiredHeight == -1) {
            topLayerDesiredHeight = DrawableUtils.getTopLayerIntrinsicHeight(bottomLayerDrawable, topLayerDrawable);
        }
        if (topLayerDesiredWidth <= bottomLayerDrawable.getIntrinsicWidth() && topLayerDesiredHeight <= bottomLayerDrawable.getIntrinsicHeight()) {
            topLayerNewWidth = topLayerDesiredWidth;
            topLayerNewHeight = topLayerDesiredHeight;
        } else {
            float topLayerRatio = (float)topLayerDesiredWidth / (float)topLayerDesiredHeight;
            float bottomLayerRatio = (float)bottomLayerDrawable.getIntrinsicWidth() / (float)bottomLayerDrawable.getIntrinsicHeight();
            if (topLayerRatio >= bottomLayerRatio) {
                topLayerNewWidth = bottomLayerDrawable.getIntrinsicWidth();
                topLayerNewHeight = (int)((float)topLayerNewWidth / topLayerRatio);
            } else {
                topLayerNewHeight = bottomLayerDrawable.getIntrinsicHeight();
                topLayerNewWidth = (int)(topLayerRatio * (float)topLayerNewHeight);
            }
        }
        if (Build.VERSION.SDK_INT >= 23) {
            drawable2 = new LayerDrawable(new Drawable[]{bottomLayerDrawable, topLayerDrawable});
            drawable2.setLayerSize(1, topLayerNewWidth, topLayerNewHeight);
            drawable2.setLayerGravity(1, 17);
        } else {
            if (shouldScaleTopLayer) {
                topLayerDrawable = new ScaledDrawableWrapper(topLayerDrawable, topLayerNewWidth, topLayerNewHeight);
            }
            drawable2 = new LayerDrawable(new Drawable[]{bottomLayerDrawable, topLayerDrawable});
            int horizontalInset = Math.max((bottomLayerDrawable.getIntrinsicWidth() - topLayerNewWidth) / 2, 0);
            int verticalInset = Math.max((bottomLayerDrawable.getIntrinsicHeight() - topLayerNewHeight) / 2, 0);
            drawable2.setLayerInset(1, horizontalInset, verticalInset, horizontalInset, verticalInset);
        }
        return drawable2;
    }

    private static int getTopLayerIntrinsicWidth(@NonNull Drawable bottomLayerDrawable, @NonNull Drawable topLayerDrawable) {
        int topLayerIntrinsicWidth = topLayerDrawable.getIntrinsicWidth();
        return topLayerIntrinsicWidth != -1 ? topLayerIntrinsicWidth : bottomLayerDrawable.getIntrinsicWidth();
    }

    private static int getTopLayerIntrinsicHeight(@NonNull Drawable bottomLayerDrawable, @NonNull Drawable topLayerDrawable) {
        int topLayerIntrinsicHeight = topLayerDrawable.getIntrinsicHeight();
        return topLayerIntrinsicHeight != -1 ? topLayerIntrinsicHeight : bottomLayerDrawable.getIntrinsicHeight();
    }

    @NonNull
    public static int[] getCheckedState(@NonNull int[] state) {
        for (int i = 0; i < state.length; ++i) {
            if (state[i] == 0x10100A0) {
                return state;
            }
            if (state[i] != 0) continue;
            int[] newState = (int[])state.clone();
            newState[i] = 0x10100A0;
            return newState;
        }
        int[] newState = Arrays.copyOf(state, state.length + 1);
        newState[state.length] = 0x10100A0;
        return newState;
    }

    @NonNull
    public static int[] getUncheckedState(@NonNull int[] state) {
        int[] newState = new int[state.length];
        int i = 0;
        for (int subState : state) {
            if (subState == 0x10100A0) continue;
            newState[i++] = subState;
        }
        return newState;
    }

    public static void setOutlineToPath(@NonNull Outline outline, @NonNull Path path2) {
        if (Build.VERSION.SDK_INT >= 30) {
            OutlineCompatR.setPath(outline, path2);
        } else if (Build.VERSION.SDK_INT >= 29) {
            try {
                OutlineCompatL.setConvexPath(outline, path2);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if (Build.VERSION.SDK_INT >= 21 && path2.isConvex()) {
            OutlineCompatL.setConvexPath(outline, path2);
        }
    }

    @Nullable
    public static ColorStateList getColorStateListOrNull(@Nullable Drawable drawable2) {
        if (drawable2 instanceof ColorDrawable) {
            return ColorStateList.valueOf((int)((ColorDrawable)drawable2).getColor());
        }
        if (Build.VERSION.SDK_INT >= 29 && drawable2 instanceof ColorStateListDrawable) {
            return ((ColorStateListDrawable)drawable2).getColorStateList();
        }
        return null;
    }

    @RequiresApi(value=21)
    private static class OutlineCompatL {
        private OutlineCompatL() {
        }

        @DoNotInline
        static void setConvexPath(@NonNull Outline outline, @NonNull Path path2) {
            outline.setConvexPath(path2);
        }
    }

    @RequiresApi(value=30)
    private static class OutlineCompatR {
        private OutlineCompatR() {
        }

        @DoNotInline
        static void setPath(@NonNull Outline outline, @NonNull Path path2) {
            outline.setPath(path2);
        }
    }
}

