/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.floatingactionbutton;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.AnimatorRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.animation.MotionSpec;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.floatingactionbutton.AnimatorTracker;
import com.google.android.material.floatingactionbutton.BaseMotionStrategy;
import com.google.android.material.floatingactionbutton.MotionStrategy;
import com.google.android.material.internal.DescendantOffsetUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.util.List;

public class ExtendedFloatingActionButton
extends MaterialButton
implements CoordinatorLayout.AttachedBehavior {
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_ExtendedFloatingActionButton_Icon;
    private static final int ANIM_STATE_NONE = 0;
    private static final int ANIM_STATE_HIDING = 1;
    private static final int ANIM_STATE_SHOWING = 2;
    private int animState = 0;
    private static final int SHOW = 0;
    private static final int HIDE = 1;
    private static final int SHRINK = 2;
    private static final int EXTEND = 3;
    private final AnimatorTracker changeVisibilityTracker = new AnimatorTracker();
    @NonNull
    private final MotionStrategy shrinkStrategy;
    @NonNull
    private final MotionStrategy extendStrategy;
    private final MotionStrategy showStrategy = new ShowStrategy(this.changeVisibilityTracker);
    private final MotionStrategy hideStrategy = new HideStrategy(this.changeVisibilityTracker);
    private final int collapsedSize;
    private int extendedPaddingStart;
    private int extendedPaddingEnd;
    @NonNull
    private final CoordinatorLayout.Behavior<ExtendedFloatingActionButton> behavior;
    private boolean isExtended = true;
    private boolean isTransforming = false;
    private boolean animateShowBeforeLayout = false;
    @NonNull
    protected ColorStateList originalTextCsl;
    private static final int EXTEND_STRATEGY_AUTO = 0;
    private static final int EXTEND_STRATEGY_WRAP_CONTENT = 1;
    private static final int EXTEND_STRATEGY_MATCH_PARENT = 2;
    private int originalWidth;
    private int originalHeight;
    private final int extendStrategyType;
    static final Property<View, Float> WIDTH = new Property<View, Float>(Float.class, "width"){

        public void set(@NonNull View object, @NonNull Float value) {
            object.getLayoutParams().width = value.intValue();
            object.requestLayout();
        }

        @NonNull
        public Float get(@NonNull View object) {
            return Float.valueOf(object.getLayoutParams().width);
        }
    };
    static final Property<View, Float> HEIGHT = new Property<View, Float>(Float.class, "height"){

        public void set(@NonNull View object, @NonNull Float value) {
            object.getLayoutParams().height = value.intValue();
            object.requestLayout();
        }

        @NonNull
        public Float get(@NonNull View object) {
            return Float.valueOf(object.getLayoutParams().height);
        }
    };
    static final Property<View, Float> PADDING_START = new Property<View, Float>(Float.class, "paddingStart"){

        public void set(@NonNull View object, @NonNull Float value) {
            ViewCompat.setPaddingRelative(object, value.intValue(), object.getPaddingTop(), ViewCompat.getPaddingEnd(object), object.getPaddingBottom());
        }

        @NonNull
        public Float get(@NonNull View object) {
            return Float.valueOf(ViewCompat.getPaddingStart(object));
        }
    };
    static final Property<View, Float> PADDING_END = new Property<View, Float>(Float.class, "paddingEnd"){

        public void set(@NonNull View object, @NonNull Float value) {
            ViewCompat.setPaddingRelative(object, ViewCompat.getPaddingStart(object), object.getPaddingTop(), value.intValue(), object.getPaddingBottom());
        }

        @NonNull
        public Float get(@NonNull View object) {
            return Float.valueOf(ViewCompat.getPaddingEnd(object));
        }
    };

    public ExtendedFloatingActionButton(@NonNull Context context) {
        this(context, null);
    }

    public ExtendedFloatingActionButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.extendedFloatingActionButtonStyle);
    }

    public ExtendedFloatingActionButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        this.behavior = new ExtendedFloatingActionButtonBehavior<ExtendedFloatingActionButton>(context, attrs);
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.ExtendedFloatingActionButton, defStyleAttr, DEF_STYLE_RES, new int[0]);
        MotionSpec showMotionSpec = MotionSpec.createFromAttribute(context, a, R.styleable.ExtendedFloatingActionButton_showMotionSpec);
        MotionSpec hideMotionSpec = MotionSpec.createFromAttribute(context, a, R.styleable.ExtendedFloatingActionButton_hideMotionSpec);
        MotionSpec extendMotionSpec = MotionSpec.createFromAttribute(context, a, R.styleable.ExtendedFloatingActionButton_extendMotionSpec);
        MotionSpec shrinkMotionSpec = MotionSpec.createFromAttribute(context, a, R.styleable.ExtendedFloatingActionButton_shrinkMotionSpec);
        this.collapsedSize = a.getDimensionPixelSize(R.styleable.ExtendedFloatingActionButton_collapsedSize, -1);
        this.extendStrategyType = a.getInt(R.styleable.ExtendedFloatingActionButton_extendStrategy, 1);
        this.extendedPaddingStart = ViewCompat.getPaddingStart((View)this);
        this.extendedPaddingEnd = ViewCompat.getPaddingEnd((View)this);
        AnimatorTracker changeSizeTracker = new AnimatorTracker();
        this.extendStrategy = new ChangeSizeStrategy(changeSizeTracker, this.getSizeFromExtendStrategyType(this.extendStrategyType), true);
        this.shrinkStrategy = new ChangeSizeStrategy(changeSizeTracker, new Size(){

            @Override
            public int getWidth() {
                return ExtendedFloatingActionButton.this.getCollapsedSize();
            }

            @Override
            public int getHeight() {
                return ExtendedFloatingActionButton.this.getCollapsedSize();
            }

            @Override
            public int getPaddingStart() {
                return ExtendedFloatingActionButton.this.getCollapsedPadding();
            }

            @Override
            public int getPaddingEnd() {
                return ExtendedFloatingActionButton.this.getCollapsedPadding();
            }

            @Override
            public ViewGroup.LayoutParams getLayoutParams() {
                return new ViewGroup.LayoutParams(this.getWidth(), this.getHeight());
            }
        }, false);
        this.showStrategy.setMotionSpec(showMotionSpec);
        this.hideStrategy.setMotionSpec(hideMotionSpec);
        this.extendStrategy.setMotionSpec(extendMotionSpec);
        this.shrinkStrategy.setMotionSpec(shrinkMotionSpec);
        a.recycle();
        ShapeAppearanceModel shapeAppearanceModel = ShapeAppearanceModel.builder(context, attrs, defStyleAttr, DEF_STYLE_RES, ShapeAppearanceModel.PILL).build();
        this.setShapeAppearanceModel(shapeAppearanceModel);
        this.saveOriginalTextCsl();
    }

    private Size getSizeFromExtendStrategyType(int extendStrategyType) {
        final Size wrapContentSize = new Size(){

            @Override
            public int getWidth() {
                return ExtendedFloatingActionButton.this.getMeasuredWidth() - ExtendedFloatingActionButton.this.getCollapsedPadding() * 2 + ExtendedFloatingActionButton.this.extendedPaddingStart + ExtendedFloatingActionButton.this.extendedPaddingEnd;
            }

            @Override
            public int getHeight() {
                return ExtendedFloatingActionButton.this.getMeasuredHeight();
            }

            @Override
            public int getPaddingStart() {
                return ExtendedFloatingActionButton.this.extendedPaddingStart;
            }

            @Override
            public int getPaddingEnd() {
                return ExtendedFloatingActionButton.this.extendedPaddingEnd;
            }

            @Override
            public ViewGroup.LayoutParams getLayoutParams() {
                return new ViewGroup.LayoutParams(-2, -2);
            }
        };
        final Size matchParentSize = new Size(){

            @Override
            public int getWidth() {
                ViewGroup.MarginLayoutParams layoutParams;
                int padding = 0;
                int margins = 0;
                if (!(ExtendedFloatingActionButton.this.getParent() instanceof View)) {
                    return wrapContentSize.getWidth();
                }
                View parent = (View)ExtendedFloatingActionButton.this.getParent();
                ViewGroup.LayoutParams parentLayoutParams = parent.getLayoutParams();
                if (parentLayoutParams != null && parentLayoutParams.width == -2) {
                    return wrapContentSize.getWidth();
                }
                padding += parent.getPaddingLeft() + parent.getPaddingRight();
                if (ExtendedFloatingActionButton.this.getLayoutParams() instanceof ViewGroup.MarginLayoutParams && (layoutParams = (ViewGroup.MarginLayoutParams)ExtendedFloatingActionButton.this.getLayoutParams()) != null) {
                    margins += layoutParams.leftMargin + layoutParams.rightMargin;
                }
                return parent.getWidth() - margins - padding;
            }

            @Override
            public int getHeight() {
                if (ExtendedFloatingActionButton.this.originalHeight == -1) {
                    ViewGroup.MarginLayoutParams layoutParams;
                    if (!(ExtendedFloatingActionButton.this.getParent() instanceof View)) {
                        return wrapContentSize.getHeight();
                    }
                    int padding = 0;
                    int margins = 0;
                    View parent = (View)ExtendedFloatingActionButton.this.getParent();
                    ViewGroup.LayoutParams parentLayoutParams = parent.getLayoutParams();
                    if (parentLayoutParams != null && parentLayoutParams.height == -2) {
                        return wrapContentSize.getHeight();
                    }
                    padding += parent.getPaddingTop() + parent.getPaddingBottom();
                    if (ExtendedFloatingActionButton.this.getLayoutParams() instanceof ViewGroup.MarginLayoutParams && (layoutParams = (ViewGroup.MarginLayoutParams)ExtendedFloatingActionButton.this.getLayoutParams()) != null) {
                        margins += layoutParams.topMargin + layoutParams.bottomMargin;
                    }
                    return parent.getHeight() - margins - padding;
                }
                if (ExtendedFloatingActionButton.this.originalHeight == 0 || ExtendedFloatingActionButton.this.originalHeight == -2) {
                    return wrapContentSize.getHeight();
                }
                return ExtendedFloatingActionButton.this.originalHeight;
            }

            @Override
            public int getPaddingStart() {
                return ExtendedFloatingActionButton.this.extendedPaddingStart;
            }

            @Override
            public int getPaddingEnd() {
                return ExtendedFloatingActionButton.this.extendedPaddingEnd;
            }

            @Override
            public ViewGroup.LayoutParams getLayoutParams() {
                return new ViewGroup.LayoutParams(-1, ExtendedFloatingActionButton.this.originalHeight == 0 ? -2 : ExtendedFloatingActionButton.this.originalHeight);
            }
        };
        Size autoSize = new Size(){

            @Override
            public int getWidth() {
                if (ExtendedFloatingActionButton.this.originalWidth == -1) {
                    return matchParentSize.getWidth();
                }
                if (ExtendedFloatingActionButton.this.originalWidth == 0 || ExtendedFloatingActionButton.this.originalWidth == -2) {
                    return wrapContentSize.getWidth();
                }
                return ExtendedFloatingActionButton.this.originalWidth;
            }

            @Override
            public int getHeight() {
                if (ExtendedFloatingActionButton.this.originalHeight == -1) {
                    return matchParentSize.getHeight();
                }
                if (ExtendedFloatingActionButton.this.originalHeight == 0 || ExtendedFloatingActionButton.this.originalHeight == -2) {
                    return wrapContentSize.getHeight();
                }
                return ExtendedFloatingActionButton.this.originalHeight;
            }

            @Override
            public int getPaddingStart() {
                return ExtendedFloatingActionButton.this.extendedPaddingStart;
            }

            @Override
            public int getPaddingEnd() {
                return ExtendedFloatingActionButton.this.extendedPaddingEnd;
            }

            @Override
            public ViewGroup.LayoutParams getLayoutParams() {
                return new ViewGroup.LayoutParams(ExtendedFloatingActionButton.this.originalWidth == 0 ? -2 : ExtendedFloatingActionButton.this.originalWidth, ExtendedFloatingActionButton.this.originalHeight == 0 ? -2 : ExtendedFloatingActionButton.this.originalHeight);
            }
        };
        switch (extendStrategyType) {
            case 1: {
                return wrapContentSize;
            }
            case 2: {
                return matchParentSize;
            }
        }
        return autoSize;
    }

    public void setTextColor(int color2) {
        super.setTextColor(color2);
        this.saveOriginalTextCsl();
    }

    public void setTextColor(@NonNull ColorStateList colors) {
        super.setTextColor(colors);
        this.saveOriginalTextCsl();
    }

    private void saveOriginalTextCsl() {
        this.originalTextCsl = this.getTextColors();
    }

    protected void silentlyUpdateTextColor(@NonNull ColorStateList csl) {
        super.setTextColor(csl);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isExtended && TextUtils.isEmpty((CharSequence)this.getText()) && this.getIcon() != null) {
            this.isExtended = false;
            this.shrinkStrategy.performNow();
        }
    }

    @Override
    @NonNull
    public CoordinatorLayout.Behavior<ExtendedFloatingActionButton> getBehavior() {
        return this.behavior;
    }

    public void setExtended(boolean extended) {
        MotionStrategy motionStrategy;
        if (this.isExtended == extended) {
            return;
        }
        MotionStrategy motionStrategy2 = motionStrategy = extended ? this.extendStrategy : this.shrinkStrategy;
        if (motionStrategy.shouldCancel()) {
            return;
        }
        motionStrategy.performNow();
    }

    public final boolean isExtended() {
        return this.isExtended;
    }

    public void setAnimateShowBeforeLayout(boolean animateShowBeforeLayout) {
        this.animateShowBeforeLayout = animateShowBeforeLayout;
    }

    public void setPaddingRelative(int start, int top, int end, int bottom) {
        super.setPaddingRelative(start, top, end, bottom);
        if (this.isExtended && !this.isTransforming) {
            this.extendedPaddingStart = start;
            this.extendedPaddingEnd = end;
        }
    }

    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        if (this.isExtended && !this.isTransforming) {
            this.extendedPaddingStart = ViewCompat.getPaddingStart((View)this);
            this.extendedPaddingEnd = ViewCompat.getPaddingEnd((View)this);
        }
    }

    public void addOnShowAnimationListener(@NonNull Animator.AnimatorListener listener2) {
        this.showStrategy.addAnimationListener(listener2);
    }

    public void removeOnShowAnimationListener(@NonNull Animator.AnimatorListener listener2) {
        this.showStrategy.removeAnimationListener(listener2);
    }

    public void addOnHideAnimationListener(@NonNull Animator.AnimatorListener listener2) {
        this.hideStrategy.addAnimationListener(listener2);
    }

    public void removeOnHideAnimationListener(@NonNull Animator.AnimatorListener listener2) {
        this.hideStrategy.removeAnimationListener(listener2);
    }

    public void addOnShrinkAnimationListener(@NonNull Animator.AnimatorListener listener2) {
        this.shrinkStrategy.addAnimationListener(listener2);
    }

    public void removeOnShrinkAnimationListener(@NonNull Animator.AnimatorListener listener2) {
        this.shrinkStrategy.removeAnimationListener(listener2);
    }

    public void addOnExtendAnimationListener(@NonNull Animator.AnimatorListener listener2) {
        this.extendStrategy.addAnimationListener(listener2);
    }

    public void removeOnExtendAnimationListener(@NonNull Animator.AnimatorListener listener2) {
        this.extendStrategy.removeAnimationListener(listener2);
    }

    public void hide() {
        this.performMotion(1, null);
    }

    public void hide(@NonNull OnChangedCallback callback2) {
        this.performMotion(1, callback2);
    }

    public void show() {
        this.performMotion(0, null);
    }

    public void show(@NonNull OnChangedCallback callback2) {
        this.performMotion(0, callback2);
    }

    public void extend() {
        this.performMotion(3, null);
    }

    public void extend(@NonNull OnChangedCallback callback2) {
        this.performMotion(3, callback2);
    }

    public void shrink() {
        this.performMotion(2, null);
    }

    public void shrink(@NonNull OnChangedCallback callback2) {
        this.performMotion(2, callback2);
    }

    @Nullable
    public MotionSpec getShowMotionSpec() {
        return this.showStrategy.getMotionSpec();
    }

    public void setShowMotionSpec(@Nullable MotionSpec spec) {
        this.showStrategy.setMotionSpec(spec);
    }

    public void setShowMotionSpecResource(@AnimatorRes int id2) {
        this.setShowMotionSpec(MotionSpec.createFromResource(this.getContext(), id2));
    }

    @Nullable
    public MotionSpec getHideMotionSpec() {
        return this.hideStrategy.getMotionSpec();
    }

    public void setHideMotionSpec(@Nullable MotionSpec spec) {
        this.hideStrategy.setMotionSpec(spec);
    }

    public void setHideMotionSpecResource(@AnimatorRes int id2) {
        this.setHideMotionSpec(MotionSpec.createFromResource(this.getContext(), id2));
    }

    @Nullable
    public MotionSpec getExtendMotionSpec() {
        return this.extendStrategy.getMotionSpec();
    }

    public void setExtendMotionSpec(@Nullable MotionSpec spec) {
        this.extendStrategy.setMotionSpec(spec);
    }

    public void setExtendMotionSpecResource(@AnimatorRes int id2) {
        this.setExtendMotionSpec(MotionSpec.createFromResource(this.getContext(), id2));
    }

    @Nullable
    public MotionSpec getShrinkMotionSpec() {
        return this.shrinkStrategy.getMotionSpec();
    }

    public void setShrinkMotionSpec(@Nullable MotionSpec spec) {
        this.shrinkStrategy.setMotionSpec(spec);
    }

    public void setShrinkMotionSpecResource(@AnimatorRes int id2) {
        this.setShrinkMotionSpec(MotionSpec.createFromResource(this.getContext(), id2));
    }

    private void performMotion(int strategyType, final @Nullable OnChangedCallback callback2) {
        MotionStrategy strategy;
        switch (strategyType) {
            case 0: {
                strategy = this.showStrategy;
                break;
            }
            case 1: {
                strategy = this.hideStrategy;
                break;
            }
            case 2: {
                strategy = this.shrinkStrategy;
                break;
            }
            case 3: {
                strategy = this.extendStrategy;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown strategy type: " + strategyType);
            }
        }
        if (strategy.shouldCancel()) {
            return;
        }
        boolean shouldAnimate = this.shouldAnimateVisibilityChange();
        if (!shouldAnimate) {
            strategy.performNow();
            strategy.onChange(callback2);
            return;
        }
        if (strategyType == 2) {
            ViewGroup.LayoutParams lp = this.getLayoutParams();
            if (lp != null) {
                this.originalWidth = lp.width;
                this.originalHeight = lp.height;
            } else {
                this.originalWidth = this.getWidth();
                this.originalHeight = this.getHeight();
            }
        }
        this.measure(0, 0);
        AnimatorSet animator2 = strategy.createAnimator();
        animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
            private boolean cancelled;

            public void onAnimationStart(Animator animation) {
                strategy.onAnimationStart(animation);
                this.cancelled = false;
            }

            public void onAnimationCancel(Animator animation) {
                this.cancelled = true;
                strategy.onAnimationCancel();
            }

            public void onAnimationEnd(Animator animation) {
                strategy.onAnimationEnd();
                if (!this.cancelled) {
                    strategy.onChange(callback2);
                }
            }
        });
        for (Animator.AnimatorListener l : strategy.getListeners()) {
            animator2.addListener(l);
        }
        animator2.start();
    }

    private boolean isOrWillBeShown() {
        if (this.getVisibility() != 0) {
            return this.animState == 2;
        }
        return this.animState != 1;
    }

    private boolean isOrWillBeHidden() {
        if (this.getVisibility() == 0) {
            return this.animState == 1;
        }
        return this.animState != 2;
    }

    private boolean shouldAnimateVisibilityChange() {
        return (ViewCompat.isLaidOut((View)this) || !this.isOrWillBeShown() && this.animateShowBeforeLayout) && !this.isInEditMode();
    }

    @VisibleForTesting
    int getCollapsedSize() {
        return this.collapsedSize < 0 ? Math.min(ViewCompat.getPaddingStart((View)this), ViewCompat.getPaddingEnd((View)this)) * 2 + this.getIconSize() : this.collapsedSize;
    }

    int getCollapsedPadding() {
        return (this.getCollapsedSize() - this.getIconSize()) / 2;
    }

    class HideStrategy
    extends BaseMotionStrategy {
        private boolean isCancelled;

        public HideStrategy(AnimatorTracker animatorTracker) {
            super(ExtendedFloatingActionButton.this, animatorTracker);
        }

        @Override
        public void performNow() {
            ExtendedFloatingActionButton.this.setVisibility(8);
        }

        @Override
        public void onChange(@Nullable OnChangedCallback callback2) {
            if (callback2 != null) {
                callback2.onHidden(ExtendedFloatingActionButton.this);
            }
        }

        @Override
        public boolean shouldCancel() {
            return ExtendedFloatingActionButton.this.isOrWillBeHidden();
        }

        @Override
        public int getDefaultMotionSpecResource() {
            return R.animator.mtrl_extended_fab_hide_motion_spec;
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            super.onAnimationStart(animator2);
            this.isCancelled = false;
            ExtendedFloatingActionButton.this.setVisibility(0);
            ExtendedFloatingActionButton.this.animState = 1;
        }

        @Override
        public void onAnimationCancel() {
            super.onAnimationCancel();
            this.isCancelled = true;
        }

        @Override
        public void onAnimationEnd() {
            super.onAnimationEnd();
            ExtendedFloatingActionButton.this.animState = 0;
            if (!this.isCancelled) {
                ExtendedFloatingActionButton.this.setVisibility(8);
            }
        }
    }

    class ShowStrategy
    extends BaseMotionStrategy {
        public ShowStrategy(AnimatorTracker animatorTracker) {
            super(ExtendedFloatingActionButton.this, animatorTracker);
        }

        @Override
        public void performNow() {
            ExtendedFloatingActionButton.this.setVisibility(0);
            ExtendedFloatingActionButton.this.setAlpha(1.0f);
            ExtendedFloatingActionButton.this.setScaleY(1.0f);
            ExtendedFloatingActionButton.this.setScaleX(1.0f);
        }

        @Override
        public void onChange(@Nullable OnChangedCallback callback2) {
            if (callback2 != null) {
                callback2.onShown(ExtendedFloatingActionButton.this);
            }
        }

        @Override
        public int getDefaultMotionSpecResource() {
            return R.animator.mtrl_extended_fab_show_motion_spec;
        }

        @Override
        public void onAnimationStart(Animator animation) {
            super.onAnimationStart(animation);
            ExtendedFloatingActionButton.this.setVisibility(0);
            ExtendedFloatingActionButton.this.animState = 2;
        }

        @Override
        public void onAnimationEnd() {
            super.onAnimationEnd();
            ExtendedFloatingActionButton.this.animState = 0;
        }

        @Override
        public boolean shouldCancel() {
            return ExtendedFloatingActionButton.this.isOrWillBeShown();
        }
    }

    class ChangeSizeStrategy
    extends BaseMotionStrategy {
        private final Size size;
        private final boolean extending;

        ChangeSizeStrategy(AnimatorTracker animatorTracker, Size size, boolean extending) {
            super(ExtendedFloatingActionButton.this, animatorTracker);
            this.size = size;
            this.extending = extending;
        }

        @Override
        public void performNow() {
            ExtendedFloatingActionButton.this.isExtended = this.extending;
            ViewGroup.LayoutParams layoutParams = ExtendedFloatingActionButton.this.getLayoutParams();
            if (layoutParams == null) {
                return;
            }
            if (!this.extending) {
                ExtendedFloatingActionButton.this.originalWidth = layoutParams.width;
                ExtendedFloatingActionButton.this.originalHeight = layoutParams.height;
            }
            layoutParams.width = this.size.getLayoutParams().width;
            layoutParams.height = this.size.getLayoutParams().height;
            ViewCompat.setPaddingRelative((View)ExtendedFloatingActionButton.this, this.size.getPaddingStart(), ExtendedFloatingActionButton.this.getPaddingTop(), this.size.getPaddingEnd(), ExtendedFloatingActionButton.this.getPaddingBottom());
            ExtendedFloatingActionButton.this.requestLayout();
        }

        @Override
        public void onChange(@Nullable OnChangedCallback callback2) {
            if (callback2 == null) {
                return;
            }
            if (this.extending) {
                callback2.onExtended(ExtendedFloatingActionButton.this);
            } else {
                callback2.onShrunken(ExtendedFloatingActionButton.this);
            }
        }

        @Override
        public int getDefaultMotionSpecResource() {
            return this.extending ? R.animator.mtrl_extended_fab_change_size_expand_motion_spec : R.animator.mtrl_extended_fab_change_size_collapse_motion_spec;
        }

        @Override
        @NonNull
        public AnimatorSet createAnimator() {
            PropertyValuesHolder[] paddingValues;
            MotionSpec spec = this.getCurrentMotionSpec();
            if (spec.hasPropertyValues("width")) {
                PropertyValuesHolder[] widthValues = spec.getPropertyValues("width");
                widthValues[0].setFloatValues(new float[]{ExtendedFloatingActionButton.this.getWidth(), this.size.getWidth()});
                spec.setPropertyValues("width", widthValues);
            }
            if (spec.hasPropertyValues("height")) {
                PropertyValuesHolder[] heightValues = spec.getPropertyValues("height");
                heightValues[0].setFloatValues(new float[]{ExtendedFloatingActionButton.this.getHeight(), this.size.getHeight()});
                spec.setPropertyValues("height", heightValues);
            }
            if (spec.hasPropertyValues("paddingStart")) {
                paddingValues = spec.getPropertyValues("paddingStart");
                paddingValues[0].setFloatValues(new float[]{ViewCompat.getPaddingStart((View)ExtendedFloatingActionButton.this), this.size.getPaddingStart()});
                spec.setPropertyValues("paddingStart", paddingValues);
            }
            if (spec.hasPropertyValues("paddingEnd")) {
                paddingValues = spec.getPropertyValues("paddingEnd");
                paddingValues[0].setFloatValues(new float[]{ViewCompat.getPaddingEnd((View)ExtendedFloatingActionButton.this), this.size.getPaddingEnd()});
                spec.setPropertyValues("paddingEnd", paddingValues);
            }
            if (spec.hasPropertyValues("labelOpacity")) {
                PropertyValuesHolder[] labelOpacityValues = spec.getPropertyValues("labelOpacity");
                float startValue = this.extending ? 0.0f : 1.0f;
                float endValue = this.extending ? 1.0f : 0.0f;
                labelOpacityValues[0].setFloatValues(new float[]{startValue, endValue});
                spec.setPropertyValues("labelOpacity", labelOpacityValues);
            }
            return super.createAnimator(spec);
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            super.onAnimationStart(animator2);
            ExtendedFloatingActionButton.this.isExtended = this.extending;
            ExtendedFloatingActionButton.this.isTransforming = true;
            ExtendedFloatingActionButton.this.setHorizontallyScrolling(true);
        }

        @Override
        public void onAnimationEnd() {
            super.onAnimationEnd();
            ExtendedFloatingActionButton.this.isTransforming = false;
            ExtendedFloatingActionButton.this.setHorizontallyScrolling(false);
            ViewGroup.LayoutParams layoutParams = ExtendedFloatingActionButton.this.getLayoutParams();
            if (layoutParams == null) {
                return;
            }
            layoutParams.width = this.size.getLayoutParams().width;
            layoutParams.height = this.size.getLayoutParams().height;
        }

        @Override
        public boolean shouldCancel() {
            return this.extending == ExtendedFloatingActionButton.this.isExtended || ExtendedFloatingActionButton.this.getIcon() == null || TextUtils.isEmpty((CharSequence)ExtendedFloatingActionButton.this.getText());
        }
    }

    static interface Size {
        public int getWidth();

        public int getHeight();

        public int getPaddingStart();

        public int getPaddingEnd();

        public ViewGroup.LayoutParams getLayoutParams();
    }

    protected static class ExtendedFloatingActionButtonBehavior<T extends ExtendedFloatingActionButton>
    extends CoordinatorLayout.Behavior<T> {
        private static final boolean AUTO_HIDE_DEFAULT = false;
        private static final boolean AUTO_SHRINK_DEFAULT = true;
        private Rect tmpRect;
        @Nullable
        private OnChangedCallback internalAutoHideCallback;
        @Nullable
        private OnChangedCallback internalAutoShrinkCallback;
        private boolean autoHideEnabled;
        private boolean autoShrinkEnabled;

        public ExtendedFloatingActionButtonBehavior() {
            this.autoHideEnabled = false;
            this.autoShrinkEnabled = true;
        }

        public ExtendedFloatingActionButtonBehavior(@NonNull Context context, @Nullable AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ExtendedFloatingActionButton_Behavior_Layout);
            this.autoHideEnabled = a.getBoolean(R.styleable.ExtendedFloatingActionButton_Behavior_Layout_behavior_autoHide, false);
            this.autoShrinkEnabled = a.getBoolean(R.styleable.ExtendedFloatingActionButton_Behavior_Layout_behavior_autoShrink, true);
            a.recycle();
        }

        public void setAutoHideEnabled(boolean autoHide) {
            this.autoHideEnabled = autoHide;
        }

        public boolean isAutoHideEnabled() {
            return this.autoHideEnabled;
        }

        public void setAutoShrinkEnabled(boolean autoShrink) {
            this.autoShrinkEnabled = autoShrink;
        }

        public boolean isAutoShrinkEnabled() {
            return this.autoShrinkEnabled;
        }

        @Override
        public boolean getInsetDodgeRect(@NonNull CoordinatorLayout parent, @NonNull ExtendedFloatingActionButton child, @NonNull Rect rect) {
            return super.getInsetDodgeRect(parent, child, rect);
        }

        @Override
        public void onAttachedToLayoutParams(@NonNull CoordinatorLayout.LayoutParams lp) {
            if (lp.dodgeInsetEdges == 0) {
                lp.dodgeInsetEdges = 80;
            }
        }

        @Override
        public boolean onDependentViewChanged(CoordinatorLayout parent, @NonNull ExtendedFloatingActionButton child, View dependency) {
            if (dependency instanceof AppBarLayout) {
                this.updateFabVisibilityForAppBarLayout(parent, (AppBarLayout)dependency, child);
            } else if (ExtendedFloatingActionButtonBehavior.isBottomSheet(dependency)) {
                this.updateFabVisibilityForBottomSheet(dependency, child);
            }
            return false;
        }

        private static boolean isBottomSheet(@NonNull View view) {
            ViewGroup.LayoutParams lp = view.getLayoutParams();
            if (lp instanceof CoordinatorLayout.LayoutParams) {
                return ((CoordinatorLayout.LayoutParams)lp).getBehavior() instanceof BottomSheetBehavior;
            }
            return false;
        }

        @VisibleForTesting
        void setInternalAutoHideCallback(@Nullable OnChangedCallback callback2) {
            this.internalAutoHideCallback = callback2;
        }

        @VisibleForTesting
        void setInternalAutoShrinkCallback(@Nullable OnChangedCallback callback2) {
            this.internalAutoShrinkCallback = callback2;
        }

        private boolean shouldUpdateVisibility(@NonNull View dependency, @NonNull ExtendedFloatingActionButton child) {
            CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)child.getLayoutParams();
            if (!this.autoHideEnabled && !this.autoShrinkEnabled) {
                return false;
            }
            return lp.getAnchorId() == dependency.getId();
        }

        private boolean updateFabVisibilityForAppBarLayout(CoordinatorLayout parent, @NonNull AppBarLayout appBarLayout, @NonNull ExtendedFloatingActionButton child) {
            if (!this.shouldUpdateVisibility((View)appBarLayout, child)) {
                return false;
            }
            if (this.tmpRect == null) {
                this.tmpRect = new Rect();
            }
            Rect rect = this.tmpRect;
            DescendantOffsetUtils.getDescendantRect(parent, (View)appBarLayout, rect);
            if (rect.bottom <= appBarLayout.getMinimumHeightForVisibleOverlappingContent()) {
                this.shrinkOrHide(child);
            } else {
                this.extendOrShow(child);
            }
            return true;
        }

        private boolean updateFabVisibilityForBottomSheet(@NonNull View bottomSheet, @NonNull ExtendedFloatingActionButton child) {
            if (!this.shouldUpdateVisibility(bottomSheet, child)) {
                return false;
            }
            CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)child.getLayoutParams();
            if (bottomSheet.getTop() < child.getHeight() / 2 + lp.topMargin) {
                this.shrinkOrHide(child);
            } else {
                this.extendOrShow(child);
            }
            return true;
        }

        protected void shrinkOrHide(@NonNull ExtendedFloatingActionButton fab) {
            OnChangedCallback callback2 = this.autoShrinkEnabled ? this.internalAutoShrinkCallback : this.internalAutoHideCallback;
            fab.performMotion(this.autoShrinkEnabled ? 2 : 1, callback2);
        }

        protected void extendOrShow(@NonNull ExtendedFloatingActionButton fab) {
            OnChangedCallback callback2 = this.autoShrinkEnabled ? this.internalAutoShrinkCallback : this.internalAutoHideCallback;
            fab.performMotion(this.autoShrinkEnabled ? 3 : 0, callback2);
        }

        @Override
        public boolean onLayoutChild(@NonNull CoordinatorLayout parent, @NonNull ExtendedFloatingActionButton child, int layoutDirection) {
            View dependency;
            List<View> dependencies = parent.getDependencies((View)child);
            int count2 = dependencies.size();
            for (int i = 0; i < count2 && !((dependency = dependencies.get(i)) instanceof AppBarLayout ? this.updateFabVisibilityForAppBarLayout(parent, (AppBarLayout)dependency, child) : ExtendedFloatingActionButtonBehavior.isBottomSheet(dependency) && this.updateFabVisibilityForBottomSheet(dependency, child)); ++i) {
            }
            parent.onLayoutChild((View)child, layoutDirection);
            return true;
        }
    }

    public static abstract class OnChangedCallback {
        public void onShown(ExtendedFloatingActionButton extendedFab) {
        }

        public void onHidden(ExtendedFloatingActionButton extendedFab) {
        }

        public void onExtended(ExtendedFloatingActionButton extendedFab) {
        }

        public void onShrunken(ExtendedFloatingActionButton extendedFab) {
        }
    }
}

