/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ClippableRoundedCornerLayout
extends FrameLayout {
    @Nullable
    private Path path;
    private float cornerRadius;

    public ClippableRoundedCornerLayout(@NonNull Context context) {
        super(context);
    }

    public ClippableRoundedCornerLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ClippableRoundedCornerLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.path == null) {
            super.dispatchDraw(canvas);
            return;
        }
        int save = canvas.save();
        canvas.clipPath(this.path);
        super.dispatchDraw(canvas);
        canvas.restoreToCount(save);
    }

    public void resetClipBoundsAndCornerRadius() {
        this.path = null;
        this.cornerRadius = 0.0f;
        this.invalidate();
    }

    public float getCornerRadius() {
        return this.cornerRadius;
    }

    public void updateCornerRadius(float cornerRadius) {
        this.updateClipBoundsAndCornerRadius(this.getLeft(), this.getTop(), this.getRight(), this.getBottom(), cornerRadius);
    }

    public void updateClipBoundsAndCornerRadius(@NonNull Rect rect, float cornerRadius) {
        this.updateClipBoundsAndCornerRadius(rect.left, rect.top, rect.right, rect.bottom, cornerRadius);
    }

    public void updateClipBoundsAndCornerRadius(float left, float top, float right, float bottom, float cornerRadius) {
        this.updateClipBoundsAndCornerRadius(new RectF(left, top, right, bottom), cornerRadius);
    }

    public void updateClipBoundsAndCornerRadius(@NonNull RectF rectF, float cornerRadius) {
        if (this.path == null) {
            this.path = new Path();
        }
        this.cornerRadius = cornerRadius;
        this.path.reset();
        this.path.addRoundRect(rectF, cornerRadius, cornerRadius, Path.Direction.CW);
        this.path.close();
        this.invalidate();
    }
}

