/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.internal.MultiViewUpdateListener;
import com.google.android.material.internal.RectEvaluator;
import com.google.android.material.internal.ReversableAnimatedValueInterpolator;
import com.google.android.material.internal.ViewUtils;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ExpandCollapseAnimationHelper {
    private final View collapsedView;
    private final View expandedView;
    private final List<AnimatorListenerAdapter> listeners;
    private final List<View> endAnchoredViews;
    @Nullable
    private ValueAnimator.AnimatorUpdateListener additionalUpdateListener;
    private long duration;
    private int collapsedViewOffsetY;
    private int expandedViewOffsetY;

    public ExpandCollapseAnimationHelper(@NonNull View collapsedView, @NonNull View expandedView) {
        this.collapsedView = collapsedView;
        this.expandedView = expandedView;
        this.listeners = new ArrayList<AnimatorListenerAdapter>();
        this.endAnchoredViews = new ArrayList<View>();
    }

    @NonNull
    public Animator getExpandAnimator() {
        AnimatorSet animator2 = this.getAnimatorSet(true);
        animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                ExpandCollapseAnimationHelper.this.expandedView.setVisibility(0);
            }
        });
        this.addListeners((Animator)animator2, this.listeners);
        return animator2;
    }

    @NonNull
    public Animator getCollapseAnimator() {
        AnimatorSet animator2 = this.getAnimatorSet(false);
        animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                ExpandCollapseAnimationHelper.this.expandedView.setVisibility(8);
            }
        });
        this.addListeners((Animator)animator2, this.listeners);
        return animator2;
    }

    @NonNull
    @CanIgnoreReturnValue
    public ExpandCollapseAnimationHelper setDuration(long duration) {
        this.duration = duration;
        return this;
    }

    @NonNull
    @CanIgnoreReturnValue
    public ExpandCollapseAnimationHelper addListener(@NonNull AnimatorListenerAdapter listener2) {
        this.listeners.add(listener2);
        return this;
    }

    @NonNull
    @CanIgnoreReturnValue
    public ExpandCollapseAnimationHelper addEndAnchoredViews(View ... views) {
        Collections.addAll(this.endAnchoredViews, views);
        return this;
    }

    @NonNull
    @CanIgnoreReturnValue
    public ExpandCollapseAnimationHelper addEndAnchoredViews(@NonNull Collection<View> views) {
        this.endAnchoredViews.addAll(views);
        return this;
    }

    @NonNull
    @CanIgnoreReturnValue
    public ExpandCollapseAnimationHelper setAdditionalUpdateListener(@Nullable ValueAnimator.AnimatorUpdateListener additionalUpdateListener) {
        this.additionalUpdateListener = additionalUpdateListener;
        return this;
    }

    @NonNull
    @CanIgnoreReturnValue
    public ExpandCollapseAnimationHelper setCollapsedViewOffsetY(int collapsedViewOffsetY) {
        this.collapsedViewOffsetY = collapsedViewOffsetY;
        return this;
    }

    @NonNull
    @CanIgnoreReturnValue
    public ExpandCollapseAnimationHelper setExpandedViewOffsetY(int expandedViewOffsetY) {
        this.expandedViewOffsetY = expandedViewOffsetY;
        return this;
    }

    private AnimatorSet getAnimatorSet(boolean expand) {
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{this.getExpandCollapseAnimator(expand), this.getExpandedViewChildrenAlphaAnimator(expand), this.getEndAnchoredViewsTranslateAnimator(expand)});
        return animatorSet;
    }

    private Animator getExpandCollapseAnimator(boolean expand) {
        Rect fromBounds = ViewUtils.calculateRectFromBounds(this.collapsedView, this.collapsedViewOffsetY);
        Rect toBounds = ViewUtils.calculateRectFromBounds(this.expandedView, this.expandedViewOffsetY);
        Rect bounds = new Rect(fromBounds);
        ValueAnimator animator2 = ValueAnimator.ofObject((TypeEvaluator)new RectEvaluator(bounds), (Object[])new Object[]{fromBounds, toBounds});
        animator2.addUpdateListener(valueAnimator -> ViewUtils.setBoundsFromRect(this.expandedView, bounds));
        if (this.additionalUpdateListener != null) {
            animator2.addUpdateListener(this.additionalUpdateListener);
        }
        animator2.setDuration(this.duration);
        animator2.setInterpolator(ReversableAnimatedValueInterpolator.of(expand, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        return animator2;
    }

    private Animator getExpandedViewChildrenAlphaAnimator(boolean expand) {
        List<View> expandedViewChildren = ViewUtils.getChildren(this.expandedView);
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator2.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.alphaListener(expandedViewChildren));
        animator2.setDuration(this.duration);
        animator2.setInterpolator(ReversableAnimatedValueInterpolator.of(expand, AnimationUtils.LINEAR_INTERPOLATOR));
        return animator2;
    }

    private Animator getEndAnchoredViewsTranslateAnimator(boolean expand) {
        int leftDelta = this.expandedView.getLeft() - this.collapsedView.getLeft();
        int rightDelta = this.collapsedView.getRight() - this.expandedView.getRight();
        int fromTranslationX = leftDelta + rightDelta;
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{fromTranslationX, 0.0f});
        animator2.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.translationXListener(this.endAnchoredViews));
        animator2.setDuration(this.duration);
        animator2.setInterpolator(ReversableAnimatedValueInterpolator.of(expand, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        return animator2;
    }

    private void addListeners(Animator animator2, List<AnimatorListenerAdapter> listeners) {
        for (AnimatorListenerAdapter listener2 : listeners) {
            animator2.addListener((Animator.AnimatorListener)listener2);
        }
    }
}

