/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Dimension;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.appcompat.view.menu.MenuItemImpl;
import androidx.appcompat.view.menu.MenuPresenter;
import androidx.appcompat.view.menu.MenuView;
import androidx.appcompat.view.menu.SubMenuBuilder;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.widget.TextViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.RecyclerViewAccessibilityDelegate;
import com.google.android.material.R;
import com.google.android.material.internal.NavigationMenuItemView;
import com.google.android.material.internal.NavigationMenuView;
import com.google.android.material.internal.ParcelableSparseArray;
import java.util.ArrayList;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class NavigationMenuPresenter
implements MenuPresenter {
    public static final int NO_TEXT_APPEARANCE_SET = 0;
    private static final String STATE_HIERARCHY = "android:menu:list";
    private static final String STATE_ADAPTER = "android:menu:adapter";
    private static final String STATE_HEADER = "android:menu:header";
    private NavigationMenuView menuView;
    LinearLayout headerLayout;
    private MenuPresenter.Callback callback;
    MenuBuilder menu;
    private int id;
    NavigationMenuAdapter adapter;
    LayoutInflater layoutInflater;
    int subheaderTextAppearance = 0;
    @Nullable
    ColorStateList subheaderColor;
    int textAppearance = 0;
    boolean textAppearanceActiveBoldEnabled = true;
    ColorStateList textColor;
    ColorStateList iconTintList;
    Drawable itemBackground;
    RippleDrawable itemForeground;
    int itemHorizontalPadding;
    @Px
    int itemVerticalPadding;
    int itemIconPadding;
    int itemIconSize;
    @Px
    int dividerInsetStart;
    @Px
    int dividerInsetEnd;
    @Px
    int subheaderInsetStart;
    @Px
    int subheaderInsetEnd;
    boolean hasCustomItemIconSize;
    boolean isBehindStatusBar = true;
    private int itemMaxLines;
    private int paddingTopDefault;
    int paddingSeparator;
    private int overScrollMode = -1;
    final View.OnClickListener onClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            NavigationMenuItemView itemView = (NavigationMenuItemView)view;
            NavigationMenuPresenter.this.setUpdateSuspended(true);
            MenuItemImpl item = itemView.getItemData();
            boolean result2 = NavigationMenuPresenter.this.menu.performItemAction(item, NavigationMenuPresenter.this, 0);
            boolean checkStateChanged = false;
            if (item != null && item.isCheckable() && result2) {
                NavigationMenuPresenter.this.adapter.setCheckedItem(item);
                checkStateChanged = true;
            }
            NavigationMenuPresenter.this.setUpdateSuspended(false);
            if (checkStateChanged) {
                NavigationMenuPresenter.this.updateMenuView(false);
            }
        }
    };

    @Override
    public void initForMenu(@NonNull Context context, @NonNull MenuBuilder menu2) {
        this.layoutInflater = LayoutInflater.from((Context)context);
        this.menu = menu2;
        Resources res = context.getResources();
        this.paddingSeparator = res.getDimensionPixelOffset(R.dimen.design_navigation_separator_vertical_padding);
    }

    @Override
    public MenuView getMenuView(ViewGroup root) {
        if (this.menuView == null) {
            this.menuView = (NavigationMenuView)this.layoutInflater.inflate(R.layout.design_navigation_menu, root, false);
            this.menuView.setAccessibilityDelegateCompat(new NavigationMenuViewAccessibilityDelegate(this.menuView));
            if (this.adapter == null) {
                this.adapter = new NavigationMenuAdapter();
                this.adapter.setHasStableIds(true);
            }
            if (this.overScrollMode != -1) {
                this.menuView.setOverScrollMode(this.overScrollMode);
            }
            this.headerLayout = (LinearLayout)this.layoutInflater.inflate(R.layout.design_navigation_item_header, (ViewGroup)this.menuView, false);
            ViewCompat.setImportantForAccessibility((View)this.headerLayout, 2);
            this.menuView.setAdapter(this.adapter);
        }
        return this.menuView;
    }

    @Override
    public void updateMenuView(boolean cleared) {
        if (this.adapter != null) {
            this.adapter.update();
        }
    }

    @Override
    public void setCallback(MenuPresenter.Callback cb) {
        this.callback = cb;
    }

    @Override
    public boolean onSubMenuSelected(SubMenuBuilder subMenu) {
        return false;
    }

    @Override
    public void onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
        if (this.callback != null) {
            this.callback.onCloseMenu(menu2, allMenusAreClosing);
        }
    }

    @Override
    public boolean flagActionItems() {
        return false;
    }

    @Override
    public boolean expandItemActionView(MenuBuilder menu2, MenuItemImpl item) {
        return false;
    }

    @Override
    public boolean collapseItemActionView(MenuBuilder menu2, MenuItemImpl item) {
        return false;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id2) {
        this.id = id2;
    }

    @Override
    @NonNull
    public Parcelable onSaveInstanceState() {
        Bundle state = new Bundle();
        if (this.menuView != null) {
            SparseArray hierarchy = new SparseArray();
            this.menuView.saveHierarchyState(hierarchy);
            state.putSparseParcelableArray(STATE_HIERARCHY, hierarchy);
        }
        if (this.adapter != null) {
            state.putBundle(STATE_ADAPTER, this.adapter.createInstanceState());
        }
        if (this.headerLayout != null) {
            SparseArray header = new SparseArray();
            this.headerLayout.saveHierarchyState(header);
            state.putSparseParcelableArray(STATE_HEADER, header);
        }
        return state;
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable instanceof Bundle) {
            SparseArray header;
            Bundle adapterState;
            Bundle state = (Bundle)parcelable;
            SparseArray hierarchy = state.getSparseParcelableArray(STATE_HIERARCHY);
            if (hierarchy != null) {
                this.menuView.restoreHierarchyState(hierarchy);
            }
            if ((adapterState = state.getBundle(STATE_ADAPTER)) != null) {
                this.adapter.restoreInstanceState(adapterState);
            }
            if ((header = state.getSparseParcelableArray(STATE_HEADER)) != null) {
                this.headerLayout.restoreHierarchyState(header);
            }
        }
    }

    public void setCheckedItem(@NonNull MenuItemImpl item) {
        this.adapter.setCheckedItem(item);
    }

    @Nullable
    public MenuItemImpl getCheckedItem() {
        return this.adapter.getCheckedItem();
    }

    public View inflateHeaderView(@LayoutRes int res) {
        View view = this.layoutInflater.inflate(res, (ViewGroup)this.headerLayout, false);
        this.addHeaderView(view);
        return view;
    }

    public void addHeaderView(@NonNull View view) {
        this.headerLayout.addView(view);
        this.menuView.setPadding(0, 0, 0, this.menuView.getPaddingBottom());
    }

    public void removeHeaderView(@NonNull View view) {
        this.headerLayout.removeView(view);
        if (!this.hasHeader()) {
            this.menuView.setPadding(0, this.paddingTopDefault, 0, this.menuView.getPaddingBottom());
        }
    }

    public int getHeaderCount() {
        return this.headerLayout.getChildCount();
    }

    private boolean hasHeader() {
        return this.getHeaderCount() > 0;
    }

    public View getHeaderView(int index) {
        return this.headerLayout.getChildAt(index);
    }

    public void setSubheaderColor(@Nullable ColorStateList subheaderColor) {
        this.subheaderColor = subheaderColor;
        this.updateMenuView(false);
    }

    public void setSubheaderTextAppearance(@StyleRes int resId) {
        this.subheaderTextAppearance = resId;
        this.updateMenuView(false);
    }

    @Nullable
    public ColorStateList getItemTintList() {
        return this.iconTintList;
    }

    public void setItemIconTintList(@Nullable ColorStateList tint) {
        this.iconTintList = tint;
        this.updateMenuView(false);
    }

    @Nullable
    public ColorStateList getItemTextColor() {
        return this.textColor;
    }

    public void setItemTextColor(@Nullable ColorStateList textColor) {
        this.textColor = textColor;
        this.updateMenuView(false);
    }

    public void setItemTextAppearance(@StyleRes int resId) {
        this.textAppearance = resId;
        this.updateMenuView(false);
    }

    public void setItemTextAppearanceActiveBoldEnabled(boolean isBold) {
        this.textAppearanceActiveBoldEnabled = isBold;
        this.updateMenuView(false);
    }

    @Nullable
    public Drawable getItemBackground() {
        return this.itemBackground;
    }

    public void setItemBackground(@Nullable Drawable itemBackground) {
        this.itemBackground = itemBackground;
        this.updateMenuView(false);
    }

    public void setItemForeground(@Nullable RippleDrawable itemForeground) {
        this.itemForeground = itemForeground;
        this.updateMenuView(false);
    }

    public int getItemHorizontalPadding() {
        return this.itemHorizontalPadding;
    }

    public void setItemHorizontalPadding(int itemHorizontalPadding) {
        this.itemHorizontalPadding = itemHorizontalPadding;
        this.updateMenuView(false);
    }

    @Px
    public int getItemVerticalPadding() {
        return this.itemVerticalPadding;
    }

    public void setItemVerticalPadding(@Px int itemVerticalPadding) {
        this.itemVerticalPadding = itemVerticalPadding;
        this.updateMenuView(false);
    }

    @Px
    public int getDividerInsetStart() {
        return this.dividerInsetStart;
    }

    public void setDividerInsetStart(@Px int dividerInsetStart) {
        this.dividerInsetStart = dividerInsetStart;
        this.updateMenuView(false);
    }

    @Px
    public int getDividerInsetEnd() {
        return this.dividerInsetEnd;
    }

    public void setDividerInsetEnd(@Px int dividerInsetEnd) {
        this.dividerInsetEnd = dividerInsetEnd;
        this.updateMenuView(false);
    }

    @Px
    public int getSubheaderInsetStart() {
        return this.subheaderInsetStart;
    }

    public void setSubheaderInsetStart(@Px int subheaderInsetStart) {
        this.subheaderInsetStart = subheaderInsetStart;
        this.updateMenuView(false);
    }

    @Px
    public int getSubheaderInsetEnd() {
        return this.subheaderInsetEnd;
    }

    public void setSubheaderInsetEnd(@Px int subheaderInsetEnd) {
        this.subheaderInsetEnd = subheaderInsetEnd;
        this.updateMenuView(false);
    }

    public int getItemIconPadding() {
        return this.itemIconPadding;
    }

    public void setItemIconPadding(int itemIconPadding) {
        this.itemIconPadding = itemIconPadding;
        this.updateMenuView(false);
    }

    public void setItemMaxLines(int itemMaxLines) {
        this.itemMaxLines = itemMaxLines;
        this.updateMenuView(false);
    }

    public int getItemMaxLines() {
        return this.itemMaxLines;
    }

    public void setItemIconSize(@Dimension int itemIconSize) {
        if (this.itemIconSize != itemIconSize) {
            this.itemIconSize = itemIconSize;
            this.hasCustomItemIconSize = true;
            this.updateMenuView(false);
        }
    }

    public void setUpdateSuspended(boolean updateSuspended) {
        if (this.adapter != null) {
            this.adapter.setUpdateSuspended(updateSuspended);
        }
    }

    public void setBehindStatusBar(boolean behindStatusBar) {
        if (this.isBehindStatusBar != behindStatusBar) {
            this.isBehindStatusBar = behindStatusBar;
            this.updateTopPadding();
        }
    }

    public boolean isBehindStatusBar() {
        return this.isBehindStatusBar;
    }

    private void updateTopPadding() {
        int topPadding = 0;
        if (!this.hasHeader() && this.isBehindStatusBar) {
            topPadding = this.paddingTopDefault;
        }
        this.menuView.setPadding(0, topPadding, 0, this.menuView.getPaddingBottom());
    }

    public void dispatchApplyWindowInsets(@NonNull WindowInsetsCompat insets) {
        int top = insets.getSystemWindowInsetTop();
        if (this.paddingTopDefault != top) {
            this.paddingTopDefault = top;
            this.updateTopPadding();
        }
        this.menuView.setPadding(0, this.menuView.getPaddingTop(), 0, insets.getSystemWindowInsetBottom());
        ViewCompat.dispatchApplyWindowInsets((View)this.headerLayout, insets);
    }

    public void setOverScrollMode(int overScrollMode) {
        this.overScrollMode = overScrollMode;
        if (this.menuView != null) {
            this.menuView.setOverScrollMode(overScrollMode);
        }
    }

    private class NavigationMenuViewAccessibilityDelegate
    extends RecyclerViewAccessibilityDelegate {
        NavigationMenuViewAccessibilityDelegate(RecyclerView recyclerView) {
            super(recyclerView);
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View host, @NonNull AccessibilityNodeInfoCompat info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            info.setCollectionInfo(AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain(NavigationMenuPresenter.this.adapter.getRowCount(), 1, false));
        }
    }

    private static class NavigationMenuHeaderItem
    implements NavigationMenuItem {
        NavigationMenuHeaderItem() {
        }
    }

    private static class NavigationMenuSeparatorItem
    implements NavigationMenuItem {
        private final int paddingTop;
        private final int paddingBottom;

        public NavigationMenuSeparatorItem(int paddingTop, int paddingBottom) {
            this.paddingTop = paddingTop;
            this.paddingBottom = paddingBottom;
        }

        public int getPaddingTop() {
            return this.paddingTop;
        }

        public int getPaddingBottom() {
            return this.paddingBottom;
        }
    }

    private static class NavigationMenuTextItem
    implements NavigationMenuItem {
        private final MenuItemImpl menuItem;
        boolean needsEmptyIcon;

        NavigationMenuTextItem(MenuItemImpl item) {
            this.menuItem = item;
        }

        public MenuItemImpl getMenuItem() {
            return this.menuItem;
        }
    }

    private static interface NavigationMenuItem {
    }

    private class NavigationMenuAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        private static final String STATE_CHECKED_ITEM = "android:menu:checked";
        private static final String STATE_ACTION_VIEWS = "android:menu:action_views";
        private static final int VIEW_TYPE_NORMAL = 0;
        private static final int VIEW_TYPE_SUBHEADER = 1;
        private static final int VIEW_TYPE_SEPARATOR = 2;
        private static final int VIEW_TYPE_HEADER = 3;
        private final ArrayList<NavigationMenuItem> items = new ArrayList();
        private MenuItemImpl checkedItem;
        private boolean updateSuspended;

        NavigationMenuAdapter() {
            this.prepareMenuItems();
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public int getItemCount() {
            return this.items.size();
        }

        @Override
        public int getItemViewType(int position) {
            NavigationMenuItem item = this.items.get(position);
            if (item instanceof NavigationMenuSeparatorItem) {
                return 2;
            }
            if (item instanceof NavigationMenuHeaderItem) {
                return 3;
            }
            if (item instanceof NavigationMenuTextItem) {
                NavigationMenuTextItem textItem = (NavigationMenuTextItem)item;
                if (textItem.getMenuItem().hasSubMenu()) {
                    return 1;
                }
                return 0;
            }
            throw new RuntimeException("Unknown item type.");
        }

        @Override
        @Nullable
        public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            switch (viewType) {
                case 0: {
                    return new NormalViewHolder(NavigationMenuPresenter.this.layoutInflater, parent, NavigationMenuPresenter.this.onClickListener);
                }
                case 1: {
                    return new SubheaderViewHolder(NavigationMenuPresenter.this.layoutInflater, parent);
                }
                case 2: {
                    return new SeparatorViewHolder(NavigationMenuPresenter.this.layoutInflater, parent);
                }
                case 3: {
                    return new HeaderViewHolder((View)NavigationMenuPresenter.this.headerLayout);
                }
            }
            return null;
        }

        @Override
        public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
            switch (this.getItemViewType(position)) {
                case 0: {
                    NavigationMenuItemView itemView = (NavigationMenuItemView)holder.itemView;
                    itemView.setIconTintList(NavigationMenuPresenter.this.iconTintList);
                    itemView.setTextAppearance(NavigationMenuPresenter.this.textAppearance);
                    if (NavigationMenuPresenter.this.textColor != null) {
                        itemView.setTextColor(NavigationMenuPresenter.this.textColor);
                    }
                    ViewCompat.setBackground((View)itemView, NavigationMenuPresenter.this.itemBackground != null ? NavigationMenuPresenter.this.itemBackground.getConstantState().newDrawable() : null);
                    if (NavigationMenuPresenter.this.itemForeground != null) {
                        itemView.setForeground(NavigationMenuPresenter.this.itemForeground.getConstantState().newDrawable());
                    }
                    NavigationMenuTextItem item = (NavigationMenuTextItem)this.items.get(position);
                    itemView.setNeedsEmptyIcon(item.needsEmptyIcon);
                    itemView.setPadding(NavigationMenuPresenter.this.itemHorizontalPadding, NavigationMenuPresenter.this.itemVerticalPadding, NavigationMenuPresenter.this.itemHorizontalPadding, NavigationMenuPresenter.this.itemVerticalPadding);
                    itemView.setIconPadding(NavigationMenuPresenter.this.itemIconPadding);
                    if (NavigationMenuPresenter.this.hasCustomItemIconSize) {
                        itemView.setIconSize(NavigationMenuPresenter.this.itemIconSize);
                    }
                    itemView.setMaxLines(NavigationMenuPresenter.this.itemMaxLines);
                    itemView.initialize(item.getMenuItem(), NavigationMenuPresenter.this.textAppearanceActiveBoldEnabled);
                    this.setAccessibilityDelegate((View)itemView, position, false);
                    break;
                }
                case 1: {
                    TextView subHeader = (TextView)holder.itemView;
                    NavigationMenuTextItem item = (NavigationMenuTextItem)this.items.get(position);
                    subHeader.setText(item.getMenuItem().getTitle());
                    TextViewCompat.setTextAppearance(subHeader, NavigationMenuPresenter.this.subheaderTextAppearance);
                    subHeader.setPadding(NavigationMenuPresenter.this.subheaderInsetStart, subHeader.getPaddingTop(), NavigationMenuPresenter.this.subheaderInsetEnd, subHeader.getPaddingBottom());
                    if (NavigationMenuPresenter.this.subheaderColor != null) {
                        subHeader.setTextColor(NavigationMenuPresenter.this.subheaderColor);
                    }
                    this.setAccessibilityDelegate((View)subHeader, position, true);
                    break;
                }
                case 2: {
                    NavigationMenuSeparatorItem item = (NavigationMenuSeparatorItem)this.items.get(position);
                    holder.itemView.setPadding(NavigationMenuPresenter.this.dividerInsetStart, item.getPaddingTop(), NavigationMenuPresenter.this.dividerInsetEnd, item.getPaddingBottom());
                    break;
                }
            }
        }

        private void setAccessibilityDelegate(View view, final int position, final boolean isHeader) {
            ViewCompat.setAccessibilityDelegate(view, new AccessibilityDelegateCompat(){

                @Override
                public void onInitializeAccessibilityNodeInfo(@NonNull View host, @NonNull AccessibilityNodeInfoCompat info) {
                    super.onInitializeAccessibilityNodeInfo(host, info);
                    info.setCollectionItemInfo(AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain(NavigationMenuAdapter.this.adjustItemPositionForA11yDelegate(position), 1, 1, 1, isHeader, host.isSelected()));
                }
            });
        }

        private int adjustItemPositionForA11yDelegate(int position) {
            int adjustedPosition = position;
            for (int i = 0; i < position; ++i) {
                if (NavigationMenuPresenter.this.adapter.getItemViewType(i) != 2 && NavigationMenuPresenter.this.adapter.getItemViewType(i) != 3) continue;
                --adjustedPosition;
            }
            return adjustedPosition;
        }

        @Override
        public void onViewRecycled(ViewHolder holder) {
            if (holder instanceof NormalViewHolder) {
                ((NavigationMenuItemView)holder.itemView).recycle();
            }
        }

        public void update() {
            this.prepareMenuItems();
            this.notifyDataSetChanged();
        }

        private void prepareMenuItems() {
            if (this.updateSuspended) {
                return;
            }
            this.updateSuspended = true;
            this.items.clear();
            this.items.add(new NavigationMenuHeaderItem());
            int currentGroupId = -1;
            int currentGroupStart = 0;
            boolean currentGroupHasIcon = false;
            int totalSize = NavigationMenuPresenter.this.menu.getVisibleItems().size();
            for (int i = 0; i < totalSize; ++i) {
                MenuItemImpl item = NavigationMenuPresenter.this.menu.getVisibleItems().get(i);
                if (item.isChecked()) {
                    this.setCheckedItem(item);
                }
                if (item.isCheckable()) {
                    item.setExclusiveCheckable(false);
                }
                if (item.hasSubMenu()) {
                    SubMenu subMenu = item.getSubMenu();
                    if (!subMenu.hasVisibleItems()) continue;
                    if (i != 0) {
                        this.items.add(new NavigationMenuSeparatorItem(NavigationMenuPresenter.this.paddingSeparator, 0));
                    }
                    this.items.add(new NavigationMenuTextItem(item));
                    boolean subMenuHasIcon = false;
                    int subMenuStart = this.items.size();
                    int size = subMenu.size();
                    for (int j = 0; j < size; ++j) {
                        MenuItemImpl subMenuItem = (MenuItemImpl)subMenu.getItem(j);
                        if (!subMenuItem.isVisible()) continue;
                        if (!subMenuHasIcon && subMenuItem.getIcon() != null) {
                            subMenuHasIcon = true;
                        }
                        if (subMenuItem.isCheckable()) {
                            subMenuItem.setExclusiveCheckable(false);
                        }
                        if (item.isChecked()) {
                            this.setCheckedItem(item);
                        }
                        this.items.add(new NavigationMenuTextItem(subMenuItem));
                    }
                    if (!subMenuHasIcon) continue;
                    this.appendTransparentIconIfMissing(subMenuStart, this.items.size());
                    continue;
                }
                int groupId = item.getGroupId();
                if (groupId != currentGroupId) {
                    currentGroupStart = this.items.size();
                    boolean bl = currentGroupHasIcon = item.getIcon() != null;
                    if (i != 0) {
                        ++currentGroupStart;
                        this.items.add(new NavigationMenuSeparatorItem(NavigationMenuPresenter.this.paddingSeparator, NavigationMenuPresenter.this.paddingSeparator));
                    }
                } else if (!currentGroupHasIcon && item.getIcon() != null) {
                    currentGroupHasIcon = true;
                    this.appendTransparentIconIfMissing(currentGroupStart, this.items.size());
                }
                NavigationMenuTextItem textItem = new NavigationMenuTextItem(item);
                textItem.needsEmptyIcon = currentGroupHasIcon;
                this.items.add(textItem);
                currentGroupId = groupId;
            }
            this.updateSuspended = false;
        }

        private void appendTransparentIconIfMissing(int startIndex, int endIndex) {
            for (int i = startIndex; i < endIndex; ++i) {
                NavigationMenuTextItem textItem = (NavigationMenuTextItem)this.items.get(i);
                textItem.needsEmptyIcon = true;
            }
        }

        public void setCheckedItem(@NonNull MenuItemImpl checkedItem) {
            if (this.checkedItem == checkedItem || !checkedItem.isCheckable()) {
                return;
            }
            if (this.checkedItem != null) {
                this.checkedItem.setChecked(false);
            }
            this.checkedItem = checkedItem;
            checkedItem.setChecked(true);
        }

        public MenuItemImpl getCheckedItem() {
            return this.checkedItem;
        }

        @NonNull
        public Bundle createInstanceState() {
            Bundle state = new Bundle();
            if (this.checkedItem != null) {
                state.putInt(STATE_CHECKED_ITEM, this.checkedItem.getItemId());
            }
            SparseArray actionViewStates = new SparseArray();
            int size = this.items.size();
            for (int i = 0; i < size; ++i) {
                View actionView;
                NavigationMenuItem navigationMenuItem = this.items.get(i);
                if (!(navigationMenuItem instanceof NavigationMenuTextItem)) continue;
                MenuItemImpl item = ((NavigationMenuTextItem)navigationMenuItem).getMenuItem();
                View view = actionView = item != null ? item.getActionView() : null;
                if (actionView == null) continue;
                ParcelableSparseArray container = new ParcelableSparseArray();
                actionView.saveHierarchyState((SparseArray)container);
                actionViewStates.put(item.getItemId(), (Object)container);
            }
            state.putSparseParcelableArray(STATE_ACTION_VIEWS, actionViewStates);
            return state;
        }

        public void restoreInstanceState(@NonNull Bundle state) {
            SparseArray actionViewStates;
            int checkedItem = state.getInt(STATE_CHECKED_ITEM, 0);
            if (checkedItem != 0) {
                this.updateSuspended = true;
                int size = this.items.size();
                for (int i = 0; i < size; ++i) {
                    MenuItemImpl menuItem;
                    NavigationMenuItem item = this.items.get(i);
                    if (!(item instanceof NavigationMenuTextItem) || (menuItem = ((NavigationMenuTextItem)item).getMenuItem()) == null || menuItem.getItemId() != checkedItem) continue;
                    this.setCheckedItem(menuItem);
                    break;
                }
                this.updateSuspended = false;
                this.prepareMenuItems();
            }
            if ((actionViewStates = state.getSparseParcelableArray(STATE_ACTION_VIEWS)) != null) {
                int size = this.items.size();
                for (int i = 0; i < size; ++i) {
                    ParcelableSparseArray container;
                    View actionView;
                    MenuItemImpl item;
                    NavigationMenuItem navigationMenuItem = this.items.get(i);
                    if (!(navigationMenuItem instanceof NavigationMenuTextItem) || (item = ((NavigationMenuTextItem)navigationMenuItem).getMenuItem()) == null || (actionView = item.getActionView()) == null || (container = (ParcelableSparseArray)((Object)actionViewStates.get(item.getItemId()))) == null) continue;
                    actionView.restoreHierarchyState((SparseArray)container);
                }
            }
        }

        public void setUpdateSuspended(boolean updateSuspended) {
            this.updateSuspended = updateSuspended;
        }

        int getRowCount() {
            int itemCount = 0;
            for (int i = 0; i < NavigationMenuPresenter.this.adapter.getItemCount(); ++i) {
                int type = NavigationMenuPresenter.this.adapter.getItemViewType(i);
                if (type != 0 && type != 1) continue;
                ++itemCount;
            }
            return itemCount;
        }
    }

    private static class HeaderViewHolder
    extends ViewHolder {
        public HeaderViewHolder(View itemView) {
            super(itemView);
        }
    }

    private static class SeparatorViewHolder
    extends ViewHolder {
        public SeparatorViewHolder(@NonNull LayoutInflater inflater, ViewGroup parent) {
            super(inflater.inflate(R.layout.design_navigation_item_separator, parent, false));
        }
    }

    private static class SubheaderViewHolder
    extends ViewHolder {
        public SubheaderViewHolder(@NonNull LayoutInflater inflater, ViewGroup parent) {
            super(inflater.inflate(R.layout.design_navigation_item_subheader, parent, false));
        }
    }

    private static class NormalViewHolder
    extends ViewHolder {
        public NormalViewHolder(@NonNull LayoutInflater inflater, ViewGroup parent, View.OnClickListener listener2) {
            super(inflater.inflate(R.layout.design_navigation_item, parent, false));
            this.itemView.setOnClickListener(listener2);
        }
    }

    private static abstract class ViewHolder
    extends RecyclerView.ViewHolder {
        public ViewHolder(View itemView) {
            super(itemView);
        }
    }
}

