/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.util.StateSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import java.util.ArrayList;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class StateListAnimator {
    private final ArrayList<Tuple> tuples = new ArrayList();
    @Nullable
    private Tuple lastMatch = null;
    @Nullable
    ValueAnimator runningAnimator = null;
    private final Animator.AnimatorListener animationListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animator2) {
            if (StateListAnimator.this.runningAnimator == animator2) {
                StateListAnimator.this.runningAnimator = null;
            }
        }
    };

    public void addState(int[] specs, ValueAnimator animator2) {
        Tuple tuple = new Tuple(specs, animator2);
        animator2.addListener(this.animationListener);
        this.tuples.add(tuple);
    }

    public void setState(int[] state) {
        Tuple match = null;
        int count2 = this.tuples.size();
        for (int i = 0; i < count2; ++i) {
            Tuple tuple = this.tuples.get(i);
            if (!StateSet.stateSetMatches((int[])tuple.specs, (int[])state)) continue;
            match = tuple;
            break;
        }
        if (match == this.lastMatch) {
            return;
        }
        if (this.lastMatch != null) {
            this.cancel();
        }
        this.lastMatch = match;
        if (match != null) {
            this.start(match);
        }
    }

    private void start(@NonNull Tuple match) {
        this.runningAnimator = match.animator;
        this.runningAnimator.start();
    }

    private void cancel() {
        if (this.runningAnimator != null) {
            this.runningAnimator.cancel();
            this.runningAnimator = null;
        }
    }

    public void jumpToCurrentState() {
        if (this.runningAnimator != null) {
            this.runningAnimator.end();
            this.runningAnimator = null;
        }
    }

    static class Tuple {
        final int[] specs;
        final ValueAnimator animator;

        Tuple(int[] specs, ValueAnimator animator2) {
            this.specs = specs;
            this.animator = animator2;
        }
    }
}

