/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.util.Preconditions;
import com.google.android.material.internal.StaticLayoutBuilderConfigurer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.Constructor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
final class StaticLayoutBuilderCompat {
    static final int DEFAULT_HYPHENATION_FREQUENCY = Build.VERSION.SDK_INT >= 23 ? 1 : 0;
    static final float DEFAULT_LINE_SPACING_ADD = 0.0f;
    static final float DEFAULT_LINE_SPACING_MULTIPLIER = 1.0f;
    private static final String TEXT_DIR_CLASS = "android.text.TextDirectionHeuristic";
    private static final String TEXT_DIRS_CLASS = "android.text.TextDirectionHeuristics";
    private static final String TEXT_DIR_CLASS_LTR = "LTR";
    private static final String TEXT_DIR_CLASS_RTL = "RTL";
    private static boolean initialized;
    @Nullable
    private static Constructor<StaticLayout> constructor;
    @Nullable
    private static Object textDirection;
    private CharSequence source;
    private final TextPaint paint;
    private final int width;
    private int start;
    private int end;
    private Layout.Alignment alignment;
    private int maxLines;
    private float lineSpacingAdd;
    private float lineSpacingMultiplier;
    private int hyphenationFrequency;
    private boolean includePad;
    private boolean isRtl;
    @Nullable
    private TextUtils.TruncateAt ellipsize;
    @Nullable
    private StaticLayoutBuilderConfigurer staticLayoutBuilderConfigurer;

    private StaticLayoutBuilderCompat(CharSequence source, TextPaint paint, int width) {
        this.source = source;
        this.paint = paint;
        this.width = width;
        this.start = 0;
        this.end = source.length();
        this.alignment = Layout.Alignment.ALIGN_NORMAL;
        this.maxLines = Integer.MAX_VALUE;
        this.lineSpacingAdd = 0.0f;
        this.lineSpacingMultiplier = 1.0f;
        this.hyphenationFrequency = DEFAULT_HYPHENATION_FREQUENCY;
        this.includePad = true;
        this.ellipsize = null;
    }

    @NonNull
    public static StaticLayoutBuilderCompat obtain(@NonNull CharSequence source, @NonNull TextPaint paint, @IntRange(from=0L) int width) {
        return new StaticLayoutBuilderCompat(source, paint, width);
    }

    @NonNull
    @CanIgnoreReturnValue
    public StaticLayoutBuilderCompat setAlignment(@NonNull Layout.Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    @NonNull
    @CanIgnoreReturnValue
    public StaticLayoutBuilderCompat setIncludePad(boolean includePad) {
        this.includePad = includePad;
        return this;
    }

    @NonNull
    @CanIgnoreReturnValue
    public StaticLayoutBuilderCompat setStart(@IntRange(from=0L) int start) {
        this.start = start;
        return this;
    }

    @NonNull
    @CanIgnoreReturnValue
    public StaticLayoutBuilderCompat setEnd(@IntRange(from=0L) int end) {
        this.end = end;
        return this;
    }

    @NonNull
    @CanIgnoreReturnValue
    public StaticLayoutBuilderCompat setMaxLines(@IntRange(from=0L) int maxLines) {
        this.maxLines = maxLines;
        return this;
    }

    @NonNull
    @CanIgnoreReturnValue
    public StaticLayoutBuilderCompat setLineSpacing(float spacingAdd, float lineSpacingMultiplier) {
        this.lineSpacingAdd = spacingAdd;
        this.lineSpacingMultiplier = lineSpacingMultiplier;
        return this;
    }

    @NonNull
    @CanIgnoreReturnValue
    public StaticLayoutBuilderCompat setHyphenationFrequency(int hyphenationFrequency) {
        this.hyphenationFrequency = hyphenationFrequency;
        return this;
    }

    @NonNull
    @CanIgnoreReturnValue
    public StaticLayoutBuilderCompat setEllipsize(@Nullable TextUtils.TruncateAt ellipsize) {
        this.ellipsize = ellipsize;
        return this;
    }

    @NonNull
    @CanIgnoreReturnValue
    public StaticLayoutBuilderCompat setStaticLayoutBuilderConfigurer(@Nullable StaticLayoutBuilderConfigurer staticLayoutBuilderConfigurer) {
        this.staticLayoutBuilderConfigurer = staticLayoutBuilderConfigurer;
        return this;
    }

    public StaticLayout build() throws StaticLayoutBuilderCompatException {
        if (this.source == null) {
            this.source = "";
        }
        int availableWidth = Math.max(0, this.width);
        CharSequence textToDraw = this.source;
        if (this.maxLines == 1) {
            textToDraw = TextUtils.ellipsize((CharSequence)this.source, (TextPaint)this.paint, (float)availableWidth, (TextUtils.TruncateAt)this.ellipsize);
        }
        this.end = Math.min(textToDraw.length(), this.end);
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.isRtl && this.maxLines == 1) {
                this.alignment = Layout.Alignment.ALIGN_OPPOSITE;
            }
            StaticLayout.Builder builder = StaticLayout.Builder.obtain((CharSequence)textToDraw, (int)this.start, (int)this.end, (TextPaint)this.paint, (int)availableWidth);
            builder.setAlignment(this.alignment);
            builder.setIncludePad(this.includePad);
            TextDirectionHeuristic textDirectionHeuristic = this.isRtl ? TextDirectionHeuristics.RTL : TextDirectionHeuristics.LTR;
            builder.setTextDirection(textDirectionHeuristic);
            if (this.ellipsize != null) {
                builder.setEllipsize(this.ellipsize);
            }
            builder.setMaxLines(this.maxLines);
            if (this.lineSpacingAdd != 0.0f || this.lineSpacingMultiplier != 1.0f) {
                builder.setLineSpacing(this.lineSpacingAdd, this.lineSpacingMultiplier);
            }
            if (this.maxLines > 1) {
                builder.setHyphenationFrequency(this.hyphenationFrequency);
            }
            if (this.staticLayoutBuilderConfigurer != null) {
                this.staticLayoutBuilderConfigurer.configure(builder);
            }
            return builder.build();
        }
        this.createConstructorWithReflection();
        try {
            return Preconditions.checkNotNull(constructor).newInstance(textToDraw, this.start, this.end, this.paint, availableWidth, this.alignment, Preconditions.checkNotNull(textDirection), Float.valueOf(1.0f), Float.valueOf(0.0f), this.includePad, null, availableWidth, this.maxLines);
        }
        catch (Exception cause) {
            throw new StaticLayoutBuilderCompatException(cause);
        }
    }

    private void createConstructorWithReflection() throws StaticLayoutBuilderCompatException {
        if (initialized) {
            return;
        }
        try {
            Class textDirClass;
            boolean useRtl;
            boolean bl = useRtl = this.isRtl && Build.VERSION.SDK_INT >= 23;
            if (Build.VERSION.SDK_INT >= 18) {
                textDirClass = TextDirectionHeuristic.class;
                textDirection = useRtl ? TextDirectionHeuristics.RTL : TextDirectionHeuristics.LTR;
            } else {
                ClassLoader loader = StaticLayoutBuilderCompat.class.getClassLoader();
                String textDirClassName = this.isRtl ? TEXT_DIR_CLASS_RTL : TEXT_DIR_CLASS_LTR;
                textDirClass = loader.loadClass(TEXT_DIR_CLASS);
                Class<?> textDirsClass = loader.loadClass(TEXT_DIRS_CLASS);
                textDirection = textDirsClass.getField(textDirClassName).get(textDirsClass);
            }
            Class[] signature = new Class[]{CharSequence.class, Integer.TYPE, Integer.TYPE, TextPaint.class, Integer.TYPE, Layout.Alignment.class, textDirClass, Float.TYPE, Float.TYPE, Boolean.TYPE, TextUtils.TruncateAt.class, Integer.TYPE, Integer.TYPE};
            constructor = StaticLayout.class.getDeclaredConstructor(signature);
            constructor.setAccessible(true);
            initialized = true;
        }
        catch (Exception cause) {
            throw new StaticLayoutBuilderCompatException(cause);
        }
    }

    public StaticLayoutBuilderCompat setIsRtl(boolean isRtl) {
        this.isRtl = isRtl;
        return this;
    }

    static class StaticLayoutBuilderCompatException
    extends Exception {
        StaticLayoutBuilderCompatException(Throwable cause) {
            super("Error thrown initializing StaticLayout " + cause.getMessage(), cause);
        }
    }
}

