/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.transition.Transition;
import androidx.transition.TransitionValues;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TextScale
extends Transition {
    private static final String PROPNAME_SCALE = "android:textscale:scale";

    @Override
    public void captureStartValues(@NonNull TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public void captureEndValues(@NonNull TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    private void captureValues(@NonNull TransitionValues transitionValues) {
        if (transitionValues.view instanceof TextView) {
            TextView textview = (TextView)transitionValues.view;
            transitionValues.values.put(PROPNAME_SCALE, Float.valueOf(textview.getScaleX()));
        }
    }

    @Override
    public Animator createAnimator(@NonNull ViewGroup sceneRoot, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        float endSize;
        if (startValues == null || endValues == null || !(startValues.view instanceof TextView) || !(endValues.view instanceof TextView)) {
            return null;
        }
        final TextView view = (TextView)endValues.view;
        Map<String, Object> startVals = startValues.values;
        Map<String, Object> endVals = endValues.values;
        float startSize = startVals.get(PROPNAME_SCALE) != null ? ((Float)startVals.get(PROPNAME_SCALE)).floatValue() : 1.0f;
        float f = endSize = endVals.get(PROPNAME_SCALE) != null ? ((Float)endVals.get(PROPNAME_SCALE)).floatValue() : 1.0f;
        if (startSize == endSize) {
            return null;
        }
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{startSize, endSize});
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(@NonNull ValueAnimator valueAnimator) {
                float animatedValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                view.setScaleX(animatedValue);
                view.setScaleY(animatedValue);
            }
        });
        return animator2;
    }
}

