/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WindowUtils {
    private static final String TAG = WindowUtils.class.getSimpleName();

    private WindowUtils() {
    }

    @NonNull
    public static Rect getCurrentWindowBounds(@NonNull Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (Build.VERSION.SDK_INT >= 30) {
            return Api30Impl.getCurrentWindowBounds(windowManager);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            return Api17Impl.getCurrentWindowBounds(windowManager);
        }
        return Api14Impl.getCurrentWindowBounds(windowManager);
    }

    private static class Api14Impl {
        private Api14Impl() {
        }

        @NonNull
        static Rect getCurrentWindowBounds(@NonNull WindowManager windowManager) {
            Display defaultDisplay = windowManager.getDefaultDisplay();
            Point defaultDisplaySize = Api14Impl.getRealSizeForDisplay(defaultDisplay);
            Rect bounds = new Rect();
            if (defaultDisplaySize.x == 0 || defaultDisplaySize.y == 0) {
                defaultDisplay.getRectSize(bounds);
            } else {
                bounds.right = defaultDisplaySize.x;
                bounds.bottom = defaultDisplaySize.y;
            }
            return bounds;
        }

        private static Point getRealSizeForDisplay(Display display) {
            Point size = new Point();
            try {
                Method getRealSizeMethod = Display.class.getDeclaredMethod("getRealSize", Point.class);
                getRealSizeMethod.setAccessible(true);
                getRealSizeMethod.invoke((Object)display, size);
            }
            catch (NoSuchMethodException e) {
                Log.w((String)TAG, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.w((String)TAG, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Log.w((String)TAG, (Throwable)e);
            }
            return size;
        }
    }

    @RequiresApi(api=17)
    private static class Api17Impl {
        private Api17Impl() {
        }

        @NonNull
        static Rect getCurrentWindowBounds(@NonNull WindowManager windowManager) {
            Display defaultDisplay = windowManager.getDefaultDisplay();
            Point defaultDisplaySize = new Point();
            defaultDisplay.getRealSize(defaultDisplaySize);
            Rect bounds = new Rect();
            bounds.right = defaultDisplaySize.x;
            bounds.bottom = defaultDisplaySize.y;
            return bounds;
        }
    }

    @RequiresApi(api=30)
    private static class Api30Impl {
        private Api30Impl() {
        }

        @NonNull
        static Rect getCurrentWindowBounds(@NonNull WindowManager windowManager) {
            return windowManager.getCurrentWindowMetrics().getBounds();
        }
    }
}

