/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.motion;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Build;
import android.util.Property;
import android.view.RoundedCorner;
import android.view.View;
import android.view.WindowInsets;
import androidx.activity.BackEventCompat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.internal.ClippableRoundedCornerLayout;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.motion.MaterialBackAnimationHelper;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class MaterialMainContainerBackHelper
extends MaterialBackAnimationHelper<View> {
    private static final float MIN_SCALE = 0.9f;
    private final float minEdgeGap;
    private final float maxTranslationY;
    private float initialTouchY;
    @Nullable
    private Rect initialHideToClipBounds;
    @Nullable
    private Rect initialHideFromClipBounds;
    @Nullable
    private Integer expandedCornerSize;

    public MaterialMainContainerBackHelper(@NonNull View view) {
        super(view);
        Resources resources = view.getResources();
        this.minEdgeGap = resources.getDimension(R.dimen.m3_back_progress_main_container_min_edge_gap);
        this.maxTranslationY = resources.getDimension(R.dimen.m3_back_progress_main_container_max_translation_y);
    }

    @Nullable
    public Rect getInitialHideToClipBounds() {
        return this.initialHideToClipBounds;
    }

    @Nullable
    public Rect getInitialHideFromClipBounds() {
        return this.initialHideFromClipBounds;
    }

    public void startBackProgress(@NonNull BackEventCompat backEvent, @Nullable View collapsedView) {
        super.onStartBackProgress(backEvent);
        this.startBackProgress(backEvent.getTouchY(), collapsedView);
    }

    @VisibleForTesting
    public void startBackProgress(float touchY, @Nullable View collapsedView) {
        this.initialHideToClipBounds = ViewUtils.calculateRectFromBounds(this.view);
        if (collapsedView != null) {
            this.initialHideFromClipBounds = ViewUtils.calculateOffsetRectFromBounds(this.view, collapsedView);
        }
        this.initialTouchY = touchY;
    }

    public void updateBackProgress(@NonNull BackEventCompat backEvent, @Nullable View collapsedView, float collapsedCornerSize) {
        if (super.onUpdateBackProgress(backEvent) == null) {
            return;
        }
        if (collapsedView != null && collapsedView.getVisibility() != 4) {
            collapsedView.setVisibility(4);
        }
        boolean leftSwipeEdge = backEvent.getSwipeEdge() == 0;
        this.updateBackProgress(backEvent.getProgress(), leftSwipeEdge, backEvent.getTouchY(), collapsedCornerSize);
    }

    @VisibleForTesting
    public void updateBackProgress(float progress, boolean leftSwipeEdge, float touchY, float collapsedCornerSize) {
        progress = this.interpolateProgress(progress);
        float width = this.view.getWidth();
        float height = this.view.getHeight();
        if (width <= 0.0f || height <= 0.0f) {
            return;
        }
        float scale = AnimationUtils.lerp(1.0f, 0.9f, progress);
        float availableHorizontalSpace = Math.max(0.0f, (width - 0.9f * width) / 2.0f - this.minEdgeGap);
        float translationX = AnimationUtils.lerp(0.0f, availableHorizontalSpace, progress) * (float)(leftSwipeEdge ? 1 : -1);
        float availableVerticalSpace = Math.max(0.0f, (height - scale * height) / 2.0f - this.minEdgeGap);
        float maxTranslationY = Math.min(availableVerticalSpace, this.maxTranslationY);
        float yDelta = touchY - this.initialTouchY;
        float yProgress = Math.abs(yDelta) / height;
        float translationYDirection = Math.signum(yDelta);
        float translationY = AnimationUtils.lerp(0.0f, maxTranslationY, yProgress) * translationYDirection;
        this.view.setScaleX(scale);
        this.view.setScaleY(scale);
        this.view.setTranslationX(translationX);
        this.view.setTranslationY(translationY);
        if (this.view instanceof ClippableRoundedCornerLayout) {
            ((ClippableRoundedCornerLayout)this.view).updateCornerRadius(AnimationUtils.lerp((float)this.getExpandedCornerSize(), collapsedCornerSize, progress));
        }
    }

    public void finishBackProgress(long duration, @Nullable View collapsedView) {
        AnimatorSet resetAnimator = this.createResetScaleAndTranslationAnimator(collapsedView);
        resetAnimator.setDuration(duration);
        resetAnimator.start();
        this.resetInitialValues();
    }

    public void cancelBackProgress(@Nullable View collapsedView) {
        if (super.onCancelBackProgress() == null) {
            return;
        }
        AnimatorSet cancelAnimatorSet = this.createResetScaleAndTranslationAnimator(collapsedView);
        if (this.view instanceof ClippableRoundedCornerLayout) {
            cancelAnimatorSet.playTogether(new Animator[]{this.createCornerAnimator((ClippableRoundedCornerLayout)this.view)});
        }
        cancelAnimatorSet.setDuration((long)this.cancelDuration);
        cancelAnimatorSet.start();
        this.resetInitialValues();
    }

    private void resetInitialValues() {
        this.initialTouchY = 0.0f;
        this.initialHideToClipBounds = null;
        this.initialHideFromClipBounds = null;
    }

    @NonNull
    private AnimatorSet createResetScaleAndTranslationAnimator(final @Nullable View collapsedView) {
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.view, (Property)View.SCALE_X, (float[])new float[]{1.0f}), ObjectAnimator.ofFloat((Object)this.view, (Property)View.SCALE_Y, (float[])new float[]{1.0f}), ObjectAnimator.ofFloat((Object)this.view, (Property)View.TRANSLATION_X, (float[])new float[]{0.0f}), ObjectAnimator.ofFloat((Object)this.view, (Property)View.TRANSLATION_Y, (float[])new float[]{0.0f})});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (collapsedView != null) {
                    collapsedView.setVisibility(0);
                }
            }
        });
        return animatorSet;
    }

    @NonNull
    private ValueAnimator createCornerAnimator(ClippableRoundedCornerLayout clippableRoundedCornerLayout) {
        ValueAnimator cornerAnimator = ValueAnimator.ofFloat((float[])new float[]{clippableRoundedCornerLayout.getCornerRadius(), this.getExpandedCornerSize()});
        cornerAnimator.addUpdateListener(animation -> clippableRoundedCornerLayout.updateCornerRadius(((Float)animation.getAnimatedValue()).floatValue()));
        return cornerAnimator;
    }

    public int getExpandedCornerSize() {
        if (this.expandedCornerSize == null) {
            this.expandedCornerSize = this.isAtTopOfScreen() ? this.getMaxDeviceCornerRadius() : 0;
        }
        return this.expandedCornerSize;
    }

    private boolean isAtTopOfScreen() {
        int[] location = new int[2];
        this.view.getLocationOnScreen(location);
        return location[1] == 0;
    }

    private int getMaxDeviceCornerRadius() {
        WindowInsets insets;
        if (Build.VERSION.SDK_INT >= 31 && (insets = this.view.getRootWindowInsets()) != null) {
            return Math.max(Math.max(this.getRoundedCornerRadius(insets, 0), this.getRoundedCornerRadius(insets, 1)), Math.max(this.getRoundedCornerRadius(insets, 3), this.getRoundedCornerRadius(insets, 2)));
        }
        return 0;
    }

    @RequiresApi(value=31)
    private int getRoundedCornerRadius(WindowInsets insets, int position) {
        RoundedCorner roundedCorner = insets.getRoundedCorner(position);
        return roundedCorner != null ? roundedCorner.getRadius() : 0;
    }
}

