/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.motion;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.res.Resources;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import androidx.activity.BackEventCompat;
import androidx.annotation.GravityInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.motion.MaterialBackAnimationHelper;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class MaterialSideContainerBackHelper
extends MaterialBackAnimationHelper<View> {
    private final float maxScaleXDistanceShrink;
    private final float maxScaleXDistanceGrow;
    private final float maxScaleYDistance;

    public MaterialSideContainerBackHelper(@NonNull View view) {
        super(view);
        Resources resources = view.getResources();
        this.maxScaleXDistanceShrink = resources.getDimension(R.dimen.m3_back_progress_side_container_max_scale_x_distance_shrink);
        this.maxScaleXDistanceGrow = resources.getDimension(R.dimen.m3_back_progress_side_container_max_scale_x_distance_grow);
        this.maxScaleYDistance = resources.getDimension(R.dimen.m3_back_progress_side_container_max_scale_y_distance);
    }

    public void startBackProgress(@NonNull BackEventCompat backEvent) {
        super.onStartBackProgress(backEvent);
    }

    public void updateBackProgress(@NonNull BackEventCompat backEvent, @GravityInt int gravity) {
        if (super.onUpdateBackProgress(backEvent) == null) {
            return;
        }
        boolean leftSwipeEdge = backEvent.getSwipeEdge() == 0;
        this.updateBackProgress(backEvent.getProgress(), leftSwipeEdge, gravity);
    }

    @VisibleForTesting
    public void updateBackProgress(float progress, boolean leftSwipeEdge, @GravityInt int gravity) {
        progress = this.interpolateProgress(progress);
        boolean leftGravity = this.checkAbsoluteGravity(gravity, 3);
        boolean swipeEdgeMatchesGravity = leftSwipeEdge == leftGravity;
        int width = this.view.getWidth();
        int height = this.view.getHeight();
        if ((float)width <= 0.0f || (float)height <= 0.0f) {
            return;
        }
        float maxScaleXDeltaShrink = this.maxScaleXDistanceShrink / (float)width;
        float maxScaleXDeltaGrow = this.maxScaleXDistanceGrow / (float)width;
        float maxScaleYDelta = this.maxScaleYDistance / (float)height;
        this.view.setPivotX(leftGravity ? 0.0f : (float)width);
        float endScaleXDelta = swipeEdgeMatchesGravity ? maxScaleXDeltaGrow : -maxScaleXDeltaShrink;
        float scaleXDelta = AnimationUtils.lerp(0.0f, endScaleXDelta, progress);
        float scaleX = 1.0f + scaleXDelta;
        this.view.setScaleX(scaleX);
        float scaleYDelta = AnimationUtils.lerp(0.0f, maxScaleYDelta, progress);
        float scaleY = 1.0f - scaleYDelta;
        this.view.setScaleY(scaleY);
        if (this.view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)this.view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View childView = viewGroup.getChildAt(i);
                childView.setPivotX(leftGravity ? (float)(width - childView.getRight() + childView.getWidth()) : (float)(-childView.getLeft()));
                childView.setPivotY((float)(-childView.getTop()));
                float childScaleX = swipeEdgeMatchesGravity ? 1.0f - scaleXDelta : 1.0f;
                float childScaleY = scaleY != 0.0f ? scaleX / scaleY * childScaleX : 1.0f;
                childView.setScaleX(childScaleX);
                childView.setScaleY(childScaleY);
            }
        }
    }

    public void finishBackProgress(@NonNull BackEventCompat backEvent, final @GravityInt int gravity, @Nullable Animator.AnimatorListener animatorListener, @Nullable ValueAnimator.AnimatorUpdateListener finishAnimatorUpdateListener) {
        final boolean leftSwipeEdge = backEvent.getSwipeEdge() == 0;
        boolean leftGravity = this.checkAbsoluteGravity(gravity, 3);
        float scaledWidth = (float)this.view.getWidth() * this.view.getScaleX() + (float)this.getEdgeMargin(leftGravity);
        ObjectAnimator finishAnimator = ObjectAnimator.ofFloat((Object)this.view, (Property)View.TRANSLATION_X, (float[])new float[]{leftGravity ? -scaledWidth : scaledWidth});
        if (finishAnimatorUpdateListener != null) {
            finishAnimator.addUpdateListener(finishAnimatorUpdateListener);
        }
        finishAnimator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        finishAnimator.setDuration((long)AnimationUtils.lerp(this.hideDurationMax, this.hideDurationMin, backEvent.getProgress()));
        finishAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                MaterialSideContainerBackHelper.this.view.setTranslationX(0.0f);
                MaterialSideContainerBackHelper.this.updateBackProgress(0.0f, leftSwipeEdge, gravity);
            }
        });
        if (animatorListener != null) {
            finishAnimator.addListener(animatorListener);
        }
        finishAnimator.start();
    }

    public void cancelBackProgress() {
        if (super.onCancelBackProgress() == null) {
            return;
        }
        AnimatorSet cancelAnimatorSet = new AnimatorSet();
        cancelAnimatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.view, (Property)View.SCALE_X, (float[])new float[]{1.0f}), ObjectAnimator.ofFloat((Object)this.view, (Property)View.SCALE_Y, (float[])new float[]{1.0f})});
        if (this.view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)this.view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View childView = viewGroup.getChildAt(i);
                cancelAnimatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)childView, (Property)View.SCALE_Y, (float[])new float[]{1.0f})});
            }
        }
        cancelAnimatorSet.setDuration((long)this.cancelDuration);
        cancelAnimatorSet.start();
    }

    private boolean checkAbsoluteGravity(@GravityInt int gravity, @GravityInt int checkFor) {
        int absoluteGravity = GravityCompat.getAbsoluteGravity(gravity, ViewCompat.getLayoutDirection(this.view));
        return (absoluteGravity & checkFor) == checkFor;
    }

    private int getEdgeMargin(boolean leftGravity) {
        ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
            return leftGravity ? marginLayoutParams.leftMargin : marginLayoutParams.rightMargin;
        }
        return 0;
    }
}

