/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.navigation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.graphics.Color;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.ColorUtils;
import androidx.drawerlayout.widget.DrawerLayout;
import com.google.android.material.animation.AnimationUtils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class DrawerLayoutUtils {
    private static final int DEFAULT_SCRIM_COLOR = -1728053248;
    private static final int DEFAULT_SCRIM_ALPHA = Color.alpha((int)-1728053248);

    private DrawerLayoutUtils() {
    }

    @NonNull
    public static ValueAnimator.AnimatorUpdateListener getScrimCloseAnimatorUpdateListener(@NonNull DrawerLayout drawerLayout) {
        return animation -> {
            int newScrimAlpha = AnimationUtils.lerp(DEFAULT_SCRIM_ALPHA, 0, animation.getAnimatedFraction());
            drawerLayout.setScrimColor(ColorUtils.setAlphaComponent(-1728053248, newScrimAlpha));
        };
    }

    @NonNull
    public static Animator.AnimatorListener getScrimCloseAnimatorListener(final @NonNull DrawerLayout drawerLayout, final @NonNull View drawerView) {
        return new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                drawerLayout.closeDrawer(drawerView, false);
                drawerLayout.setScrimColor(-1728053248);
            }
        };
    }
}

