/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.navigation;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import androidx.appcompat.view.menu.MenuItemImpl;
import androidx.appcompat.view.menu.MenuView;
import androidx.appcompat.widget.TooltipCompat;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.PointerIconCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.widget.TextViewCompat;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.badge.BadgeDrawable;
import com.google.android.material.badge.BadgeUtils;
import com.google.android.material.motion.MotionUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.ripple.RippleUtils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class NavigationBarItemView
extends FrameLayout
implements MenuView.ItemView {
    private static final int INVALID_ITEM_POSITION = -1;
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private boolean initialized = false;
    private ColorStateList itemRippleColor;
    @Nullable
    Drawable itemBackground;
    private int itemPaddingTop;
    private int itemPaddingBottom;
    private int activeIndicatorLabelPadding;
    private float shiftAmount;
    private float scaleUpFactor;
    private float scaleDownFactor;
    private int labelVisibilityMode;
    private boolean isShifting;
    @Nullable
    private final FrameLayout iconContainer;
    @Nullable
    private final View activeIndicatorView;
    private final ImageView icon;
    private final ViewGroup labelGroup;
    private final TextView smallLabel;
    private final TextView largeLabel;
    private int itemPosition = -1;
    @StyleRes
    private int activeTextAppearance = 0;
    @Nullable
    private MenuItemImpl itemData;
    @Nullable
    private ColorStateList iconTint;
    @Nullable
    private Drawable originalIconDrawable;
    @Nullable
    private Drawable wrappedIconDrawable;
    private static final ActiveIndicatorTransform ACTIVE_INDICATOR_LABELED_TRANSFORM = new ActiveIndicatorTransform();
    private static final ActiveIndicatorTransform ACTIVE_INDICATOR_UNLABELED_TRANSFORM = new ActiveIndicatorUnlabeledTransform();
    private ValueAnimator activeIndicatorAnimator;
    private ActiveIndicatorTransform activeIndicatorTransform = ACTIVE_INDICATOR_LABELED_TRANSFORM;
    private float activeIndicatorProgress = 0.0f;
    private boolean activeIndicatorEnabled = false;
    private int activeIndicatorDesiredWidth = 0;
    private int activeIndicatorDesiredHeight = 0;
    private boolean activeIndicatorResizeable = false;
    private int activeIndicatorMarginHorizontal = 0;
    @Nullable
    private BadgeDrawable badgeDrawable;

    public NavigationBarItemView(@NonNull Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(this.getItemLayoutResId(), (ViewGroup)this, true);
        this.iconContainer = (FrameLayout)this.findViewById(R.id.navigation_bar_item_icon_container);
        this.activeIndicatorView = this.findViewById(R.id.navigation_bar_item_active_indicator_view);
        this.icon = (ImageView)this.findViewById(R.id.navigation_bar_item_icon_view);
        this.labelGroup = (ViewGroup)this.findViewById(R.id.navigation_bar_item_labels_group);
        this.smallLabel = (TextView)this.findViewById(R.id.navigation_bar_item_small_label_view);
        this.largeLabel = (TextView)this.findViewById(R.id.navigation_bar_item_large_label_view);
        this.setBackgroundResource(this.getItemBackgroundResId());
        this.itemPaddingTop = this.getResources().getDimensionPixelSize(this.getItemDefaultMarginResId());
        this.itemPaddingBottom = this.labelGroup.getPaddingBottom();
        this.activeIndicatorLabelPadding = this.getResources().getDimensionPixelSize(R.dimen.m3_navigation_item_active_indicator_label_padding);
        ViewCompat.setImportantForAccessibility((View)this.smallLabel, 2);
        ViewCompat.setImportantForAccessibility((View)this.largeLabel, 2);
        this.setFocusable(true);
        this.calculateTextScaleFactors(this.smallLabel.getTextSize(), this.largeLabel.getTextSize());
        if (this.icon != null) {
            this.icon.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    if (NavigationBarItemView.this.icon.getVisibility() == 0) {
                        NavigationBarItemView.this.tryUpdateBadgeBounds((View)NavigationBarItemView.this.icon);
                    }
                }
            });
        }
    }

    protected int getSuggestedMinimumWidth() {
        FrameLayout.LayoutParams labelGroupParams = (FrameLayout.LayoutParams)this.labelGroup.getLayoutParams();
        int labelWidth = labelGroupParams.leftMargin + this.labelGroup.getMeasuredWidth() + labelGroupParams.rightMargin;
        return Math.max(this.getSuggestedIconWidth(), labelWidth);
    }

    protected int getSuggestedMinimumHeight() {
        FrameLayout.LayoutParams labelGroupParams = (FrameLayout.LayoutParams)this.labelGroup.getLayoutParams();
        return this.getSuggestedIconHeight() + (this.labelGroup.getVisibility() == 0 ? this.activeIndicatorLabelPadding : 0) + labelGroupParams.topMargin + this.labelGroup.getMeasuredHeight() + labelGroupParams.bottomMargin;
    }

    @Override
    public void initialize(@NonNull MenuItemImpl itemData, int menuType) {
        CharSequence tooltipText;
        this.itemData = itemData;
        this.setCheckable(itemData.isCheckable());
        this.setChecked(itemData.isChecked());
        this.setEnabled(itemData.isEnabled());
        this.setIcon(itemData.getIcon());
        this.setTitle(itemData.getTitle());
        this.setId(itemData.getItemId());
        if (!TextUtils.isEmpty((CharSequence)itemData.getContentDescription())) {
            this.setContentDescription(itemData.getContentDescription());
        }
        CharSequence charSequence = tooltipText = !TextUtils.isEmpty((CharSequence)itemData.getTooltipText()) ? itemData.getTooltipText() : itemData.getTitle();
        if (Build.VERSION.SDK_INT < 21 || Build.VERSION.SDK_INT > 23) {
            TooltipCompat.setTooltipText((View)this, tooltipText);
        }
        this.setVisibility(itemData.isVisible() ? 0 : 8);
        this.initialized = true;
    }

    void clear() {
        this.removeBadge();
        this.itemData = null;
        this.activeIndicatorProgress = 0.0f;
        this.initialized = false;
    }

    private View getIconOrContainer() {
        return this.iconContainer != null ? this.iconContainer : this.icon;
    }

    public void setItemPosition(int position) {
        this.itemPosition = position;
    }

    public int getItemPosition() {
        return this.itemPosition;
    }

    public void setShifting(boolean shifting) {
        if (this.isShifting != shifting) {
            this.isShifting = shifting;
            this.refreshChecked();
        }
    }

    public void setLabelVisibilityMode(int mode) {
        if (this.labelVisibilityMode != mode) {
            this.labelVisibilityMode = mode;
            this.updateActiveIndicatorTransform();
            this.updateActiveIndicatorLayoutParams(this.getWidth());
            this.refreshChecked();
        }
    }

    @Override
    @Nullable
    public MenuItemImpl getItemData() {
        return this.itemData;
    }

    @Override
    public void setTitle(@Nullable CharSequence title) {
        CharSequence tooltipText;
        this.smallLabel.setText(title);
        this.largeLabel.setText(title);
        if (this.itemData == null || TextUtils.isEmpty((CharSequence)this.itemData.getContentDescription())) {
            this.setContentDescription(title);
        }
        CharSequence charSequence = tooltipText = this.itemData == null || TextUtils.isEmpty((CharSequence)this.itemData.getTooltipText()) ? title : this.itemData.getTooltipText();
        if (Build.VERSION.SDK_INT < 21 || Build.VERSION.SDK_INT > 23) {
            TooltipCompat.setTooltipText((View)this, tooltipText);
        }
    }

    @Override
    public void setCheckable(boolean checkable) {
        this.refreshDrawableState();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        final int width = w;
        this.post(new Runnable(){

            @Override
            public void run() {
                NavigationBarItemView.this.updateActiveIndicatorLayoutParams(width);
            }
        });
    }

    private void updateActiveIndicatorTransform() {
        this.activeIndicatorTransform = this.isActiveIndicatorResizeableAndUnlabeled() ? ACTIVE_INDICATOR_UNLABELED_TRANSFORM : ACTIVE_INDICATOR_LABELED_TRANSFORM;
    }

    private void setActiveIndicatorProgress(@FloatRange(from=0.0, to=1.0) float progress, float target) {
        if (this.activeIndicatorView != null) {
            this.activeIndicatorTransform.updateForProgress(progress, target, this.activeIndicatorView);
        }
        this.activeIndicatorProgress = progress;
    }

    private void maybeAnimateActiveIndicatorToProgress(final @FloatRange(from=0.0, to=1.0) float newProgress) {
        if (!(this.activeIndicatorEnabled && this.initialized && ViewCompat.isAttachedToWindow((View)this))) {
            this.setActiveIndicatorProgress(newProgress, newProgress);
            return;
        }
        if (this.activeIndicatorAnimator != null) {
            this.activeIndicatorAnimator.cancel();
            this.activeIndicatorAnimator = null;
        }
        this.activeIndicatorAnimator = ValueAnimator.ofFloat((float[])new float[]{this.activeIndicatorProgress, newProgress});
        this.activeIndicatorAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float progress = ((Float)animation.getAnimatedValue()).floatValue();
                NavigationBarItemView.this.setActiveIndicatorProgress(progress, newProgress);
            }
        });
        this.activeIndicatorAnimator.setInterpolator(MotionUtils.resolveThemeInterpolator(this.getContext(), R.attr.motionEasingEmphasizedInterpolator, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        this.activeIndicatorAnimator.setDuration((long)MotionUtils.resolveThemeDuration(this.getContext(), R.attr.motionDurationLong2, this.getResources().getInteger(R.integer.material_motion_duration_long_1)));
        this.activeIndicatorAnimator.start();
    }

    private void refreshChecked() {
        if (this.itemData != null) {
            this.setChecked(this.itemData.isChecked());
        }
    }

    @Override
    public void setChecked(boolean checked) {
        this.largeLabel.setPivotX((float)(this.largeLabel.getWidth() / 2));
        this.largeLabel.setPivotY((float)this.largeLabel.getBaseline());
        this.smallLabel.setPivotX((float)(this.smallLabel.getWidth() / 2));
        this.smallLabel.setPivotY((float)this.smallLabel.getBaseline());
        float newIndicatorProgress = checked ? 1.0f : 0.0f;
        this.maybeAnimateActiveIndicatorToProgress(newIndicatorProgress);
        switch (this.labelVisibilityMode) {
            case -1: {
                if (this.isShifting) {
                    if (checked) {
                        NavigationBarItemView.setViewTopMarginAndGravity(this.getIconOrContainer(), this.itemPaddingTop, 49);
                        NavigationBarItemView.updateViewPaddingBottom((View)this.labelGroup, this.itemPaddingBottom);
                        this.largeLabel.setVisibility(0);
                    } else {
                        NavigationBarItemView.setViewTopMarginAndGravity(this.getIconOrContainer(), this.itemPaddingTop, 17);
                        NavigationBarItemView.updateViewPaddingBottom((View)this.labelGroup, 0);
                        this.largeLabel.setVisibility(4);
                    }
                    this.smallLabel.setVisibility(4);
                    break;
                }
                NavigationBarItemView.updateViewPaddingBottom((View)this.labelGroup, this.itemPaddingBottom);
                if (checked) {
                    NavigationBarItemView.setViewTopMarginAndGravity(this.getIconOrContainer(), (int)((float)this.itemPaddingTop + this.shiftAmount), 49);
                    NavigationBarItemView.setViewScaleValues((View)this.largeLabel, 1.0f, 1.0f, 0);
                    NavigationBarItemView.setViewScaleValues((View)this.smallLabel, this.scaleUpFactor, this.scaleUpFactor, 4);
                    break;
                }
                NavigationBarItemView.setViewTopMarginAndGravity(this.getIconOrContainer(), this.itemPaddingTop, 49);
                NavigationBarItemView.setViewScaleValues((View)this.largeLabel, this.scaleDownFactor, this.scaleDownFactor, 4);
                NavigationBarItemView.setViewScaleValues((View)this.smallLabel, 1.0f, 1.0f, 0);
                break;
            }
            case 0: {
                if (checked) {
                    NavigationBarItemView.setViewTopMarginAndGravity(this.getIconOrContainer(), this.itemPaddingTop, 49);
                    NavigationBarItemView.updateViewPaddingBottom((View)this.labelGroup, this.itemPaddingBottom);
                    this.largeLabel.setVisibility(0);
                } else {
                    NavigationBarItemView.setViewTopMarginAndGravity(this.getIconOrContainer(), this.itemPaddingTop, 17);
                    NavigationBarItemView.updateViewPaddingBottom((View)this.labelGroup, 0);
                    this.largeLabel.setVisibility(4);
                }
                this.smallLabel.setVisibility(4);
                break;
            }
            case 1: {
                NavigationBarItemView.updateViewPaddingBottom((View)this.labelGroup, this.itemPaddingBottom);
                if (checked) {
                    NavigationBarItemView.setViewTopMarginAndGravity(this.getIconOrContainer(), (int)((float)this.itemPaddingTop + this.shiftAmount), 49);
                    NavigationBarItemView.setViewScaleValues((View)this.largeLabel, 1.0f, 1.0f, 0);
                    NavigationBarItemView.setViewScaleValues((View)this.smallLabel, this.scaleUpFactor, this.scaleUpFactor, 4);
                    break;
                }
                NavigationBarItemView.setViewTopMarginAndGravity(this.getIconOrContainer(), this.itemPaddingTop, 49);
                NavigationBarItemView.setViewScaleValues((View)this.largeLabel, this.scaleDownFactor, this.scaleDownFactor, 4);
                NavigationBarItemView.setViewScaleValues((View)this.smallLabel, 1.0f, 1.0f, 0);
                break;
            }
            case 2: {
                NavigationBarItemView.setViewTopMarginAndGravity(this.getIconOrContainer(), this.itemPaddingTop, 17);
                this.largeLabel.setVisibility(8);
                this.smallLabel.setVisibility(8);
                break;
            }
        }
        this.refreshDrawableState();
        this.setSelected(checked);
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        if (this.badgeDrawable != null && this.badgeDrawable.isVisible()) {
            CharSequence customContentDescription = this.itemData.getTitle();
            if (!TextUtils.isEmpty((CharSequence)this.itemData.getContentDescription())) {
                customContentDescription = this.itemData.getContentDescription();
            }
            info.setContentDescription((CharSequence)(customContentDescription + ", " + this.badgeDrawable.getContentDescription()));
        }
        AccessibilityNodeInfoCompat infoCompat = AccessibilityNodeInfoCompat.wrap(info);
        infoCompat.setCollectionItemInfo(AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain(0, 1, this.getItemVisiblePosition(), 1, false, this.isSelected()));
        if (this.isSelected()) {
            infoCompat.setClickable(false);
            infoCompat.removeAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLICK);
        }
        infoCompat.setRoleDescription(this.getResources().getString(R.string.item_view_role_description));
    }

    private int getItemVisiblePosition() {
        ViewGroup parent = (ViewGroup)this.getParent();
        int index = parent.indexOfChild((View)this);
        int visiblePosition = 0;
        for (int i = 0; i < index; ++i) {
            View child = parent.getChildAt(i);
            if (!(child instanceof NavigationBarItemView) || child.getVisibility() != 0) continue;
            ++visiblePosition;
        }
        return visiblePosition;
    }

    private static void setViewTopMarginAndGravity(@NonNull View view, int topMargin, int gravity) {
        FrameLayout.LayoutParams viewParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        viewParams.topMargin = topMargin;
        viewParams.bottomMargin = topMargin;
        viewParams.gravity = gravity;
        view.setLayoutParams((ViewGroup.LayoutParams)viewParams);
    }

    private static void setViewScaleValues(@NonNull View view, float scaleX, float scaleY, int visibility) {
        view.setScaleX(scaleX);
        view.setScaleY(scaleY);
        view.setVisibility(visibility);
    }

    private static void updateViewPaddingBottom(@NonNull View view, int paddingBottom) {
        view.setPadding(view.getPaddingLeft(), view.getPaddingTop(), view.getPaddingRight(), paddingBottom);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.smallLabel.setEnabled(enabled);
        this.largeLabel.setEnabled(enabled);
        this.icon.setEnabled(enabled);
        if (enabled) {
            ViewCompat.setPointerIcon((View)this, PointerIconCompat.getSystemIcon(this.getContext(), 1002));
        } else {
            ViewCompat.setPointerIcon((View)this, null);
        }
    }

    @NonNull
    public int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.itemData != null && this.itemData.isCheckable() && this.itemData.isChecked()) {
            NavigationBarItemView.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    @Override
    public void setShortcut(boolean showShortcut, char shortcutKey) {
    }

    @Override
    public void setIcon(@Nullable Drawable iconDrawable) {
        if (iconDrawable == this.originalIconDrawable) {
            return;
        }
        this.originalIconDrawable = iconDrawable;
        if (iconDrawable != null) {
            Drawable.ConstantState state = iconDrawable.getConstantState();
            this.wrappedIconDrawable = iconDrawable = DrawableCompat.wrap(state == null ? iconDrawable : state.newDrawable()).mutate();
            if (this.iconTint != null) {
                DrawableCompat.setTintList(this.wrappedIconDrawable, this.iconTint);
            }
        }
        this.icon.setImageDrawable(iconDrawable);
    }

    @Override
    public boolean prefersCondensedTitle() {
        return false;
    }

    @Override
    public boolean showsIcon() {
        return true;
    }

    public void setIconTintList(@Nullable ColorStateList tint) {
        this.iconTint = tint;
        if (this.itemData != null && this.wrappedIconDrawable != null) {
            DrawableCompat.setTintList(this.wrappedIconDrawable, this.iconTint);
            this.wrappedIconDrawable.invalidateSelf();
        }
    }

    public void setIconSize(int iconSize) {
        FrameLayout.LayoutParams iconParams = (FrameLayout.LayoutParams)this.icon.getLayoutParams();
        iconParams.width = iconSize;
        iconParams.height = iconSize;
        this.icon.setLayoutParams((ViewGroup.LayoutParams)iconParams);
    }

    public void setTextAppearanceInactive(@StyleRes int inactiveTextAppearance) {
        NavigationBarItemView.setTextAppearanceWithoutFontScaling(this.smallLabel, inactiveTextAppearance);
        this.calculateTextScaleFactors(this.smallLabel.getTextSize(), this.largeLabel.getTextSize());
    }

    public void setTextAppearanceActive(@StyleRes int activeTextAppearance) {
        this.activeTextAppearance = activeTextAppearance;
        NavigationBarItemView.setTextAppearanceWithoutFontScaling(this.largeLabel, activeTextAppearance);
        this.calculateTextScaleFactors(this.smallLabel.getTextSize(), this.largeLabel.getTextSize());
    }

    public void setTextAppearanceActiveBoldEnabled(boolean isBold) {
        this.setTextAppearanceActive(this.activeTextAppearance);
        this.largeLabel.setTypeface(this.largeLabel.getTypeface(), isBold ? 1 : 0);
    }

    private static void setTextAppearanceWithoutFontScaling(TextView textView, @StyleRes int textAppearance) {
        TextViewCompat.setTextAppearance(textView, textAppearance);
        int unscaledSize = MaterialResources.getUnscaledTextSize(textView.getContext(), textAppearance, 0);
        if (unscaledSize != 0) {
            textView.setTextSize(0, (float)unscaledSize);
        }
    }

    public void setTextColor(@Nullable ColorStateList color2) {
        if (color2 != null) {
            this.smallLabel.setTextColor(color2);
            this.largeLabel.setTextColor(color2);
        }
    }

    private void calculateTextScaleFactors(float smallLabelSize, float largeLabelSize) {
        this.shiftAmount = smallLabelSize - largeLabelSize;
        this.scaleUpFactor = 1.0f * largeLabelSize / smallLabelSize;
        this.scaleDownFactor = 1.0f * smallLabelSize / largeLabelSize;
    }

    public void setItemBackground(int background) {
        Drawable backgroundDrawable = background == 0 ? null : ContextCompat.getDrawable(this.getContext(), background);
        this.setItemBackground(backgroundDrawable);
    }

    public void setItemBackground(@Nullable Drawable background) {
        if (background != null && background.getConstantState() != null) {
            background = background.getConstantState().newDrawable().mutate();
        }
        this.itemBackground = background;
        this.refreshItemBackground();
    }

    public void setItemRippleColor(@Nullable ColorStateList itemRippleColor) {
        this.itemRippleColor = itemRippleColor;
        this.refreshItemBackground();
    }

    private void refreshItemBackground() {
        RippleDrawable iconContainerRippleDrawable = null;
        Drawable itemBackgroundDrawable = this.itemBackground;
        boolean defaultHighlightEnabled = true;
        if (this.itemRippleColor != null) {
            Drawable maskDrawable = this.getActiveIndicatorDrawable();
            if (Build.VERSION.SDK_INT >= 21 && this.activeIndicatorEnabled && this.getActiveIndicatorDrawable() != null && this.iconContainer != null && maskDrawable != null) {
                defaultHighlightEnabled = false;
                iconContainerRippleDrawable = new RippleDrawable(RippleUtils.sanitizeRippleDrawableColor(this.itemRippleColor), null, maskDrawable);
            } else if (itemBackgroundDrawable == null) {
                itemBackgroundDrawable = NavigationBarItemView.createItemBackgroundCompat(this.itemRippleColor);
            }
        }
        if (this.iconContainer != null) {
            this.iconContainer.setPadding(0, 0, 0, 0);
            this.iconContainer.setForeground(iconContainerRippleDrawable);
        }
        ViewCompat.setBackground((View)this, itemBackgroundDrawable);
        if (Build.VERSION.SDK_INT >= 26) {
            this.setDefaultFocusHighlightEnabled(defaultHighlightEnabled);
        }
    }

    private static Drawable createItemBackgroundCompat(@NonNull ColorStateList rippleColor) {
        RippleDrawable backgroundDrawable;
        ColorStateList rippleDrawableColor = RippleUtils.convertToRippleDrawableColor(rippleColor);
        if (Build.VERSION.SDK_INT >= 21) {
            backgroundDrawable = new RippleDrawable(rippleDrawableColor, null, null);
        } else {
            GradientDrawable rippleDrawable = new GradientDrawable();
            rippleDrawable.setCornerRadius(1.0E-5f);
            Drawable rippleDrawableCompat = DrawableCompat.wrap((Drawable)rippleDrawable);
            DrawableCompat.setTintList(rippleDrawableCompat, rippleDrawableColor);
            backgroundDrawable = rippleDrawableCompat;
        }
        return backgroundDrawable;
    }

    public void setItemPaddingTop(int paddingTop) {
        if (this.itemPaddingTop != paddingTop) {
            this.itemPaddingTop = paddingTop;
            this.refreshChecked();
        }
    }

    public void setItemPaddingBottom(int paddingBottom) {
        if (this.itemPaddingBottom != paddingBottom) {
            this.itemPaddingBottom = paddingBottom;
            this.refreshChecked();
        }
    }

    public void setActiveIndicatorLabelPadding(int activeIndicatorLabelPadding) {
        if (this.activeIndicatorLabelPadding != activeIndicatorLabelPadding) {
            this.activeIndicatorLabelPadding = activeIndicatorLabelPadding;
            this.refreshChecked();
        }
    }

    public void setActiveIndicatorEnabled(boolean enabled) {
        this.activeIndicatorEnabled = enabled;
        this.refreshItemBackground();
        if (this.activeIndicatorView != null) {
            this.activeIndicatorView.setVisibility(enabled ? 0 : 8);
            this.requestLayout();
        }
    }

    public void setActiveIndicatorWidth(int width) {
        this.activeIndicatorDesiredWidth = width;
        this.updateActiveIndicatorLayoutParams(this.getWidth());
    }

    private void updateActiveIndicatorLayoutParams(int availableWidth) {
        if (this.activeIndicatorView == null || availableWidth <= 0) {
            return;
        }
        int newWidth = Math.min(this.activeIndicatorDesiredWidth, availableWidth - this.activeIndicatorMarginHorizontal * 2);
        FrameLayout.LayoutParams indicatorParams = (FrameLayout.LayoutParams)this.activeIndicatorView.getLayoutParams();
        indicatorParams.height = this.isActiveIndicatorResizeableAndUnlabeled() ? newWidth : this.activeIndicatorDesiredHeight;
        indicatorParams.width = newWidth;
        this.activeIndicatorView.setLayoutParams((ViewGroup.LayoutParams)indicatorParams);
    }

    private boolean isActiveIndicatorResizeableAndUnlabeled() {
        return this.activeIndicatorResizeable && this.labelVisibilityMode == 2;
    }

    public void setActiveIndicatorHeight(int height) {
        this.activeIndicatorDesiredHeight = height;
        this.updateActiveIndicatorLayoutParams(this.getWidth());
    }

    public void setActiveIndicatorMarginHorizontal(@Px int marginHorizontal) {
        this.activeIndicatorMarginHorizontal = marginHorizontal;
        this.updateActiveIndicatorLayoutParams(this.getWidth());
    }

    @Nullable
    public Drawable getActiveIndicatorDrawable() {
        if (this.activeIndicatorView == null) {
            return null;
        }
        return this.activeIndicatorView.getBackground();
    }

    public void setActiveIndicatorDrawable(@Nullable Drawable activeIndicatorDrawable) {
        if (this.activeIndicatorView == null) {
            return;
        }
        this.activeIndicatorView.setBackgroundDrawable(activeIndicatorDrawable);
        this.refreshItemBackground();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.iconContainer != null && this.activeIndicatorEnabled) {
            this.iconContainer.dispatchTouchEvent(ev);
        }
        return super.dispatchTouchEvent(ev);
    }

    public void setActiveIndicatorResizeable(boolean resizeable) {
        this.activeIndicatorResizeable = resizeable;
    }

    void setBadge(@NonNull BadgeDrawable badgeDrawable) {
        if (this.badgeDrawable == badgeDrawable) {
            return;
        }
        if (this.hasBadge() && this.icon != null) {
            Log.w((String)"NavigationBar", (String)"Multiple badges shouldn't be attached to one item.");
            this.tryRemoveBadgeFromAnchor((View)this.icon);
        }
        this.badgeDrawable = badgeDrawable;
        if (this.icon != null) {
            this.tryAttachBadgeToAnchor((View)this.icon);
        }
    }

    @Nullable
    public BadgeDrawable getBadge() {
        return this.badgeDrawable;
    }

    void removeBadge() {
        this.tryRemoveBadgeFromAnchor((View)this.icon);
    }

    private boolean hasBadge() {
        return this.badgeDrawable != null;
    }

    private void tryUpdateBadgeBounds(View anchorView) {
        if (!this.hasBadge()) {
            return;
        }
        BadgeUtils.setBadgeDrawableBounds(this.badgeDrawable, anchorView, this.getCustomParentForBadge(anchorView));
    }

    private void tryAttachBadgeToAnchor(@Nullable View anchorView) {
        if (!this.hasBadge()) {
            return;
        }
        if (anchorView != null) {
            this.setClipChildren(false);
            this.setClipToPadding(false);
            BadgeUtils.attachBadgeDrawable(this.badgeDrawable, anchorView, this.getCustomParentForBadge(anchorView));
        }
    }

    private void tryRemoveBadgeFromAnchor(@Nullable View anchorView) {
        if (!this.hasBadge()) {
            return;
        }
        if (anchorView != null) {
            this.setClipChildren(true);
            this.setClipToPadding(true);
            BadgeUtils.detachBadgeDrawable(this.badgeDrawable, anchorView);
        }
        this.badgeDrawable = null;
    }

    @Nullable
    private FrameLayout getCustomParentForBadge(View anchorView) {
        if (anchorView == this.icon) {
            return BadgeUtils.USE_COMPAT_PARENT ? (FrameLayout)this.icon.getParent() : null;
        }
        return null;
    }

    private int getSuggestedIconWidth() {
        int badgeWidth = this.badgeDrawable == null ? 0 : this.badgeDrawable.getMinimumWidth() - this.badgeDrawable.getHorizontalOffset();
        FrameLayout.LayoutParams iconContainerParams = (FrameLayout.LayoutParams)this.getIconOrContainer().getLayoutParams();
        return Math.max(badgeWidth, iconContainerParams.leftMargin) + this.icon.getMeasuredWidth() + Math.max(badgeWidth, iconContainerParams.rightMargin);
    }

    private int getSuggestedIconHeight() {
        FrameLayout.LayoutParams iconContainerParams = (FrameLayout.LayoutParams)this.getIconOrContainer().getLayoutParams();
        return iconContainerParams.topMargin + this.getIconOrContainer().getMeasuredHeight();
    }

    @DrawableRes
    protected int getItemBackgroundResId() {
        return R.drawable.mtrl_navigation_bar_item_background;
    }

    @DimenRes
    protected int getItemDefaultMarginResId() {
        return R.dimen.mtrl_navigation_bar_item_default_margin;
    }

    @LayoutRes
    protected abstract int getItemLayoutResId();

    private static class ActiveIndicatorUnlabeledTransform
    extends ActiveIndicatorTransform {
        private ActiveIndicatorUnlabeledTransform() {
        }

        @Override
        protected float calculateScaleY(float progress, float targetValue) {
            return this.calculateScaleX(progress, targetValue);
        }
    }

    private static class ActiveIndicatorTransform {
        private static final float SCALE_X_HIDDEN = 0.4f;
        private static final float SCALE_X_SHOWN = 1.0f;
        private static final float ALPHA_FRACTION = 0.2f;

        private ActiveIndicatorTransform() {
        }

        protected float calculateAlpha(@FloatRange(from=0.0, to=1.0) float progress, @FloatRange(from=0.0, to=1.0) float targetValue) {
            float startAlphaFraction = targetValue == 0.0f ? 0.8f : 0.0f;
            float endAlphaFraction = targetValue == 0.0f ? 1.0f : 0.2f;
            return AnimationUtils.lerp(0.0f, 1.0f, startAlphaFraction, endAlphaFraction, progress);
        }

        protected float calculateScaleX(@FloatRange(from=0.0, to=1.0) float progress, @FloatRange(from=0.0, to=1.0) float targetValue) {
            return AnimationUtils.lerp(0.4f, 1.0f, progress);
        }

        protected float calculateScaleY(@FloatRange(from=0.0, to=1.0) float progress, @FloatRange(from=0.0, to=1.0) float targetValue) {
            return 1.0f;
        }

        public void updateForProgress(@FloatRange(from=0.0, to=1.0) float progress, @FloatRange(from=0.0, to=1.0) float targetValue, @NonNull View indicator) {
            indicator.setScaleX(this.calculateScaleX(progress, targetValue));
            indicator.setScaleY(this.calculateScaleY(progress, targetValue));
            indicator.setAlpha(this.calculateAlpha(progress, targetValue));
        }
    }
}

