/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.navigation;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.appcompat.view.menu.MenuItemImpl;
import androidx.appcompat.view.menu.MenuPresenter;
import androidx.appcompat.view.menu.MenuView;
import androidx.appcompat.view.menu.SubMenuBuilder;
import com.google.android.material.badge.BadgeDrawable;
import com.google.android.material.badge.BadgeUtils;
import com.google.android.material.internal.ParcelableSparseArray;
import com.google.android.material.navigation.NavigationBarMenuView;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class NavigationBarPresenter
implements MenuPresenter {
    private MenuBuilder menu;
    private NavigationBarMenuView menuView;
    private boolean updateSuspended = false;
    private int id;

    public void setMenuView(@NonNull NavigationBarMenuView menuView) {
        this.menuView = menuView;
    }

    @Override
    public void initForMenu(@NonNull Context context, @NonNull MenuBuilder menu2) {
        this.menu = menu2;
        this.menuView.initialize(this.menu);
    }

    @Override
    @Nullable
    public MenuView getMenuView(@Nullable ViewGroup root) {
        return this.menuView;
    }

    @Override
    public void updateMenuView(boolean cleared) {
        if (this.updateSuspended) {
            return;
        }
        if (cleared) {
            this.menuView.buildMenuView();
        } else {
            this.menuView.updateMenuView();
        }
    }

    @Override
    public void setCallback(@Nullable MenuPresenter.Callback cb) {
    }

    @Override
    public boolean onSubMenuSelected(@Nullable SubMenuBuilder subMenu) {
        return false;
    }

    @Override
    public void onCloseMenu(@Nullable MenuBuilder menu2, boolean allMenusAreClosing) {
    }

    @Override
    public boolean flagActionItems() {
        return false;
    }

    @Override
    public boolean expandItemActionView(@Nullable MenuBuilder menu2, @Nullable MenuItemImpl item) {
        return false;
    }

    @Override
    public boolean collapseItemActionView(@Nullable MenuBuilder menu2, @Nullable MenuItemImpl item) {
        return false;
    }

    public void setId(int id2) {
        this.id = id2;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    @NonNull
    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState();
        savedState.selectedItemId = this.menuView.getSelectedItemId();
        savedState.badgeSavedStates = BadgeUtils.createParcelableBadgeStates(this.menuView.getBadgeDrawables());
        return savedState;
    }

    @Override
    public void onRestoreInstanceState(@NonNull Parcelable state) {
        if (state instanceof SavedState) {
            this.menuView.tryRestoreSelectedItemId(((SavedState)state).selectedItemId);
            SparseArray<BadgeDrawable> badgeDrawables = BadgeUtils.createBadgeDrawablesFromSavedStates(this.menuView.getContext(), ((SavedState)state).badgeSavedStates);
            this.menuView.restoreBadgeDrawables(badgeDrawables);
        }
    }

    public void setUpdateSuspended(boolean updateSuspended) {
        this.updateSuspended = updateSuspended;
    }

    static class SavedState
    implements Parcelable {
        int selectedItemId;
        @Nullable
        ParcelableSparseArray badgeSavedStates;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @NonNull
            public SavedState createFromParcel(@NonNull Parcel in) {
                return new SavedState(in);
            }

            @NonNull
            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState() {
        }

        SavedState(@NonNull Parcel in) {
            this.selectedItemId = in.readInt();
            this.badgeSavedStates = (ParcelableSparseArray)in.readParcelable(this.getClass().getClassLoader());
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            out.writeInt(this.selectedItemId);
            out.writeParcelable((Parcelable)this.badgeSavedStates, 0);
        }
    }
}

