/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.navigationrail;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.navigation.NavigationBarView;
import com.google.android.material.navigationrail.NavigationRailMenuView;
import com.google.android.material.resources.MaterialResources;

public class NavigationRailView
extends NavigationBarView {
    static final int DEFAULT_MENU_GRAVITY = 49;
    static final int MAX_ITEM_COUNT = 7;
    private static final int DEFAULT_HEADER_GRAVITY = 49;
    static final int NO_ITEM_MINIMUM_HEIGHT = -1;
    private final int topMargin;
    @Nullable
    private View headerView;
    @Nullable
    private Boolean paddingTopSystemWindowInsets = null;
    @Nullable
    private Boolean paddingBottomSystemWindowInsets = null;
    @Nullable
    private Boolean paddingStartSystemWindowInsets = null;

    public NavigationRailView(@NonNull Context context) {
        this(context, null);
    }

    public NavigationRailView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.navigationRailStyle);
    }

    public NavigationRailView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, R.style.Widget_MaterialComponents_NavigationRailView);
    }

    public NavigationRailView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        Resources res = this.getResources();
        this.topMargin = res.getDimensionPixelSize(R.dimen.mtrl_navigation_rail_margin);
        context = this.getContext();
        TintTypedArray attributes = ThemeEnforcement.obtainTintedStyledAttributes(context, attrs, R.styleable.NavigationRailView, defStyleAttr, defStyleRes, new int[0]);
        int headerLayoutRes = attributes.getResourceId(R.styleable.NavigationRailView_headerLayout, 0);
        if (headerLayoutRes != 0) {
            this.addHeaderView(headerLayoutRes);
        }
        this.setMenuGravity(attributes.getInt(R.styleable.NavigationRailView_menuGravity, 49));
        if (attributes.hasValue(R.styleable.NavigationRailView_itemMinHeight)) {
            this.setItemMinimumHeight(attributes.getDimensionPixelSize(R.styleable.NavigationRailView_itemMinHeight, -1));
        }
        if (attributes.hasValue(R.styleable.NavigationRailView_paddingTopSystemWindowInsets)) {
            this.paddingTopSystemWindowInsets = attributes.getBoolean(R.styleable.NavigationRailView_paddingTopSystemWindowInsets, false);
        }
        if (attributes.hasValue(R.styleable.NavigationRailView_paddingBottomSystemWindowInsets)) {
            this.paddingBottomSystemWindowInsets = attributes.getBoolean(R.styleable.NavigationRailView_paddingBottomSystemWindowInsets, false);
        }
        if (attributes.hasValue(R.styleable.NavigationRailView_paddingStartSystemWindowInsets)) {
            this.paddingStartSystemWindowInsets = attributes.getBoolean(R.styleable.NavigationRailView_paddingStartSystemWindowInsets, false);
        }
        int largeFontTopPadding = this.getResources().getDimensionPixelOffset(R.dimen.m3_navigation_rail_item_padding_top_with_large_font);
        int largeFontBottomPadding = this.getResources().getDimensionPixelOffset(R.dimen.m3_navigation_rail_item_padding_bottom_with_large_font);
        float progress = AnimationUtils.lerp(0.0f, 1.0f, 0.3f, 1.0f, MaterialResources.getFontScale(context) - 1.0f);
        float topPadding = AnimationUtils.lerp(this.getItemPaddingTop(), largeFontTopPadding, progress);
        float bottomPadding = AnimationUtils.lerp(this.getItemPaddingBottom(), largeFontBottomPadding, progress);
        this.setItemPaddingTop(Math.round(topPadding));
        this.setItemPaddingBottom(Math.round(bottomPadding));
        attributes.recycle();
        this.applyWindowInsets();
    }

    private void applyWindowInsets() {
        ViewUtils.doOnApplyWindowInsets((View)this, new ViewUtils.OnApplyWindowInsetsListener(){

            @Override
            @NonNull
            public WindowInsetsCompat onApplyWindowInsets(View view, @NonNull WindowInsetsCompat insets, @NonNull ViewUtils.RelativePadding initialPadding) {
                Insets systemBarInsets = insets.getInsets(WindowInsetsCompat.Type.systemBars());
                if (NavigationRailView.this.shouldApplyWindowInsetPadding(NavigationRailView.this.paddingTopSystemWindowInsets)) {
                    initialPadding.top += systemBarInsets.top;
                }
                if (NavigationRailView.this.shouldApplyWindowInsetPadding(NavigationRailView.this.paddingBottomSystemWindowInsets)) {
                    initialPadding.bottom += systemBarInsets.bottom;
                }
                if (NavigationRailView.this.shouldApplyWindowInsetPadding(NavigationRailView.this.paddingStartSystemWindowInsets)) {
                    initialPadding.start = initialPadding.start + (ViewUtils.isLayoutRtl(view) ? systemBarInsets.right : systemBarInsets.left);
                }
                initialPadding.applyToView(view);
                return insets;
            }
        });
    }

    private boolean shouldApplyWindowInsetPadding(Boolean paddingInsetFlag) {
        return paddingInsetFlag != null ? paddingInsetFlag : ViewCompat.getFitsSystemWindows((View)this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minWidthSpec = this.makeMinWidthSpec(widthMeasureSpec);
        super.onMeasure(minWidthSpec, heightMeasureSpec);
        if (this.isHeaderViewVisible()) {
            int maxMenuHeight = this.getMeasuredHeight() - this.headerView.getMeasuredHeight() - this.topMargin;
            int menuHeightSpec = View.MeasureSpec.makeMeasureSpec((int)maxMenuHeight, (int)Integer.MIN_VALUE);
            this.measureChild((View)this.getNavigationRailMenuView(), minWidthSpec, menuHeightSpec);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        NavigationRailMenuView menuView = this.getNavigationRailMenuView();
        int offsetY = 0;
        if (this.isHeaderViewVisible()) {
            int usedTop = this.headerView.getBottom() + this.topMargin;
            int menuTop = menuView.getTop();
            if (menuTop < usedTop) {
                offsetY = usedTop - menuTop;
            }
        } else if (menuView.isTopGravity()) {
            offsetY = this.topMargin;
        }
        if (offsetY > 0) {
            menuView.layout(menuView.getLeft(), menuView.getTop() + offsetY, menuView.getRight(), menuView.getBottom() + offsetY);
        }
    }

    public void addHeaderView(@LayoutRes int layoutRes) {
        this.addHeaderView(LayoutInflater.from((Context)this.getContext()).inflate(layoutRes, (ViewGroup)this, false));
    }

    public void addHeaderView(@NonNull View headerView) {
        this.removeHeaderView();
        this.headerView = headerView;
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 49;
        params.topMargin = this.topMargin;
        this.addView(headerView, 0, (ViewGroup.LayoutParams)params);
    }

    @Nullable
    public View getHeaderView() {
        return this.headerView;
    }

    public void removeHeaderView() {
        if (this.headerView != null) {
            this.removeView(this.headerView);
            this.headerView = null;
        }
    }

    public void setMenuGravity(int gravity) {
        this.getNavigationRailMenuView().setMenuGravity(gravity);
    }

    public int getMenuGravity() {
        return this.getNavigationRailMenuView().getMenuGravity();
    }

    public int getItemMinimumHeight() {
        NavigationRailMenuView menuView = (NavigationRailMenuView)this.getMenuView();
        return menuView.getItemMinimumHeight();
    }

    public void setItemMinimumHeight(@Px int minHeight) {
        NavigationRailMenuView menuView = (NavigationRailMenuView)this.getMenuView();
        menuView.setItemMinimumHeight(minHeight);
    }

    @Override
    public int getMaxItemCount() {
        return 7;
    }

    private NavigationRailMenuView getNavigationRailMenuView() {
        return (NavigationRailMenuView)this.getMenuView();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected NavigationRailMenuView createNavigationBarMenuView(@NonNull Context context) {
        return new NavigationRailMenuView(context);
    }

    private int makeMinWidthSpec(int measureSpec) {
        int minWidth = this.getSuggestedMinimumWidth();
        if (View.MeasureSpec.getMode((int)measureSpec) != 0x40000000 && minWidth > 0) {
            return View.MeasureSpec.makeMeasureSpec((int)Math.min(View.MeasureSpec.getSize((int)measureSpec), minWidth += this.getPaddingLeft() + this.getPaddingRight()), (int)0x40000000);
        }
        return measureSpec;
    }

    private boolean isHeaderViewVisible() {
        return this.headerView != null && this.headerView.getVisibility() != 8;
    }
}

