/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Property;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.progressindicator.AnimatorDurationScaleProvider;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;
import java.util.ArrayList;
import java.util.List;

abstract class DrawableWithAnimatedVisibilityChange
extends Drawable
implements Animatable2Compat {
    private static final boolean DEFAULT_DRAWABLE_RESTART = false;
    private static final int GROW_DURATION = 500;
    final Context context;
    final BaseProgressIndicatorSpec baseSpec;
    AnimatorDurationScaleProvider animatorDurationScaleProvider;
    private ValueAnimator showAnimator;
    private ValueAnimator hideAnimator;
    private boolean mockShowAnimationRunning;
    private boolean mockHideAnimationRunning;
    private float mockGrowFraction;
    private List<Animatable2Compat.AnimationCallback> animationCallbacks;
    private Animatable2Compat.AnimationCallback internalAnimationCallback;
    private boolean ignoreCallbacks;
    private float growFraction;
    final Paint paint = new Paint();
    @IntRange(from=0L, to=255L)
    private int totalAlpha;
    private static final Property<DrawableWithAnimatedVisibilityChange, Float> GROW_FRACTION = new Property<DrawableWithAnimatedVisibilityChange, Float>(Float.class, "growFraction"){

        public Float get(DrawableWithAnimatedVisibilityChange drawable2) {
            return Float.valueOf(drawable2.getGrowFraction());
        }

        public void set(DrawableWithAnimatedVisibilityChange drawable2, Float value) {
            drawable2.setGrowFraction(value.floatValue());
        }
    };

    DrawableWithAnimatedVisibilityChange(@NonNull Context context, @NonNull BaseProgressIndicatorSpec baseSpec) {
        this.context = context;
        this.baseSpec = baseSpec;
        this.animatorDurationScaleProvider = new AnimatorDurationScaleProvider();
        this.setAlpha(255);
    }

    private void maybeInitializeAnimators() {
        if (this.showAnimator == null) {
            this.showAnimator = ObjectAnimator.ofFloat((Object)this, GROW_FRACTION, (float[])new float[]{0.0f, 1.0f});
            this.showAnimator.setDuration(500L);
            this.showAnimator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
            this.setShowAnimator(this.showAnimator);
        }
        if (this.hideAnimator == null) {
            this.hideAnimator = ObjectAnimator.ofFloat((Object)this, GROW_FRACTION, (float[])new float[]{1.0f, 0.0f});
            this.hideAnimator.setDuration(500L);
            this.hideAnimator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
            this.setHideAnimator(this.hideAnimator);
        }
    }

    @Override
    public void registerAnimationCallback(@NonNull Animatable2Compat.AnimationCallback callback2) {
        if (this.animationCallbacks == null) {
            this.animationCallbacks = new ArrayList<Animatable2Compat.AnimationCallback>();
        }
        if (!this.animationCallbacks.contains(callback2)) {
            this.animationCallbacks.add(callback2);
        }
    }

    @Override
    public boolean unregisterAnimationCallback(@NonNull Animatable2Compat.AnimationCallback callback2) {
        if (this.animationCallbacks != null && this.animationCallbacks.contains(callback2)) {
            this.animationCallbacks.remove(callback2);
            if (this.animationCallbacks.isEmpty()) {
                this.animationCallbacks = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public void clearAnimationCallbacks() {
        this.animationCallbacks.clear();
        this.animationCallbacks = null;
    }

    void setInternalAnimationCallback(@NonNull Animatable2Compat.AnimationCallback callback2) {
        this.internalAnimationCallback = callback2;
    }

    private void dispatchAnimationStart() {
        if (this.internalAnimationCallback != null) {
            this.internalAnimationCallback.onAnimationStart(this);
        }
        if (this.animationCallbacks != null && !this.ignoreCallbacks) {
            for (Animatable2Compat.AnimationCallback callback2 : this.animationCallbacks) {
                callback2.onAnimationStart(this);
            }
        }
    }

    private void dispatchAnimationEnd() {
        if (this.internalAnimationCallback != null) {
            this.internalAnimationCallback.onAnimationEnd(this);
        }
        if (this.animationCallbacks != null && !this.ignoreCallbacks) {
            for (Animatable2Compat.AnimationCallback callback2 : this.animationCallbacks) {
                callback2.onAnimationEnd(this);
            }
        }
    }

    public void start() {
        this.setVisibleInternal(true, true, false);
    }

    public void stop() {
        this.setVisibleInternal(false, true, false);
    }

    public boolean isRunning() {
        return this.isShowing() || this.isHiding();
    }

    public boolean isShowing() {
        return this.showAnimator != null && this.showAnimator.isRunning() || this.mockShowAnimationRunning;
    }

    public boolean isHiding() {
        return this.hideAnimator != null && this.hideAnimator.isRunning() || this.mockHideAnimationRunning;
    }

    public boolean hideNow() {
        return this.setVisible(false, false, false);
    }

    public boolean setVisible(boolean visible, boolean restart) {
        return this.setVisible(visible, restart, true);
    }

    public boolean setVisible(boolean visible, boolean restart, boolean animate) {
        float systemAnimatorDurationScale = this.animatorDurationScaleProvider.getSystemAnimatorDurationScale(this.context.getContentResolver());
        return this.setVisibleInternal(visible, restart, animate && systemAnimatorDurationScale > 0.0f);
    }

    boolean setVisibleInternal(boolean visible, boolean restart, boolean animate) {
        boolean specAnimationEnabled;
        ValueAnimator animatorNotInAction;
        this.maybeInitializeAnimators();
        if (!this.isVisible() && !visible) {
            return false;
        }
        ValueAnimator animatorInAction = visible ? this.showAnimator : this.hideAnimator;
        ValueAnimator valueAnimator = animatorNotInAction = visible ? this.hideAnimator : this.showAnimator;
        if (!animate) {
            if (animatorNotInAction.isRunning()) {
                this.cancelAnimatorsWithoutCallbacks(animatorNotInAction);
            }
            if (animatorInAction.isRunning()) {
                animatorInAction.end();
            } else {
                this.endAnimatorsWithoutCallbacks(animatorInAction);
            }
            return super.setVisible(visible, false);
        }
        if (animatorInAction.isRunning()) {
            return false;
        }
        boolean changed = !visible || super.setVisible(visible, false);
        boolean bl = specAnimationEnabled = visible ? this.baseSpec.isShowAnimationEnabled() : this.baseSpec.isHideAnimationEnabled();
        if (!specAnimationEnabled) {
            this.endAnimatorsWithoutCallbacks(animatorInAction);
            return changed;
        }
        if (restart || Build.VERSION.SDK_INT < 19 || !animatorInAction.isPaused()) {
            animatorInAction.start();
        } else {
            animatorInAction.resume();
        }
        return changed;
    }

    private void cancelAnimatorsWithoutCallbacks(ValueAnimator ... animators) {
        boolean ignoreCallbacksOrig = this.ignoreCallbacks;
        this.ignoreCallbacks = true;
        for (ValueAnimator animator2 : animators) {
            animator2.cancel();
        }
        this.ignoreCallbacks = ignoreCallbacksOrig;
    }

    private void endAnimatorsWithoutCallbacks(ValueAnimator ... animators) {
        boolean ignoreCallbacksOrig = this.ignoreCallbacks;
        this.ignoreCallbacks = true;
        for (ValueAnimator animator2 : animators) {
            animator2.end();
        }
        this.ignoreCallbacks = ignoreCallbacksOrig;
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.totalAlpha = alpha;
        this.invalidateSelf();
    }

    public int getAlpha() {
        return this.totalAlpha;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    private void setShowAnimator(@NonNull ValueAnimator showAnimator) {
        if (this.showAnimator != null && this.showAnimator.isRunning()) {
            throw new IllegalArgumentException("Cannot set showAnimator while the current showAnimator is running.");
        }
        this.showAnimator = showAnimator;
        showAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                DrawableWithAnimatedVisibilityChange.this.dispatchAnimationStart();
            }
        });
    }

    @NonNull
    ValueAnimator getHideAnimator() {
        return this.hideAnimator;
    }

    private void setHideAnimator(@NonNull ValueAnimator hideAnimator) {
        if (this.hideAnimator != null && this.hideAnimator.isRunning()) {
            throw new IllegalArgumentException("Cannot set hideAnimator while the current hideAnimator is running.");
        }
        this.hideAnimator = hideAnimator;
        hideAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                DrawableWithAnimatedVisibilityChange.super.setVisible(false, false);
                DrawableWithAnimatedVisibilityChange.this.dispatchAnimationEnd();
            }
        });
    }

    float getGrowFraction() {
        if (!this.baseSpec.isShowAnimationEnabled() && !this.baseSpec.isHideAnimationEnabled()) {
            return 1.0f;
        }
        if (this.mockHideAnimationRunning || this.mockShowAnimationRunning) {
            return this.mockGrowFraction;
        }
        return this.growFraction;
    }

    void setGrowFraction(@FloatRange(from=0.0, to=1.0) float growFraction) {
        if (this.growFraction != growFraction) {
            this.growFraction = growFraction;
            this.invalidateSelf();
        }
    }

    @VisibleForTesting
    void setMockShowAnimationRunning(boolean running, @FloatRange(from=0.0, to=1.0) float fraction) {
        this.mockShowAnimationRunning = running;
        this.mockGrowFraction = fraction;
    }

    @VisibleForTesting
    void setMockHideAnimationRunning(boolean running, @FloatRange(from=0.0, to=1.0) float fraction) {
        this.mockHideAnimationRunning = running;
        this.mockGrowFraction = fraction;
    }
}

