/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Px;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;

abstract class DrawingDelegate<S extends BaseProgressIndicatorSpec> {
    S spec;

    public DrawingDelegate(S spec) {
        this.spec = spec;
    }

    abstract int getPreferredWidth();

    abstract int getPreferredHeight();

    abstract void adjustCanvas(@NonNull Canvas var1, @NonNull Rect var2, @FloatRange(from=-1.0, to=1.0) float var3, boolean var4, boolean var5);

    abstract void fillIndicator(@NonNull Canvas var1, @NonNull Paint var2, @NonNull ActiveIndicator var3, @IntRange(from=0L, to=255L) int var4);

    abstract void fillTrack(@NonNull Canvas var1, @NonNull Paint var2, @FloatRange(from=0.0, to=1.0) float var3, @FloatRange(from=0.0, to=1.0) float var4, @ColorInt int var5, @IntRange(from=0L, to=255L) int var6, @Px int var7);

    abstract void drawStopIndicator(@NonNull Canvas var1, @NonNull Paint var2, @ColorInt int var3, @IntRange(from=0L, to=255L) int var4);

    void validateSpecAndAdjustCanvas(@NonNull Canvas canvas, @NonNull Rect bounds, @FloatRange(from=0.0, to=1.0) float trackThicknessFraction, boolean isShowing, boolean isHiding) {
        ((BaseProgressIndicatorSpec)this.spec).validateSpec();
        this.adjustCanvas(canvas, bounds, trackThicknessFraction, isShowing, isHiding);
    }

    protected static class ActiveIndicator {
        @FloatRange(from=0.0, to=1.0)
        float startFraction;
        @FloatRange(from=0.0, to=1.0)
        float endFraction;
        @ColorInt
        int color;
        @Px
        int gapSize;

        protected ActiveIndicator() {
        }
    }
}

