/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import com.google.android.material.R;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;
import com.google.android.material.progressindicator.CircularDrawingDelegate;
import com.google.android.material.progressindicator.CircularIndeterminateAnimatorDelegate;
import com.google.android.material.progressindicator.CircularProgressIndicatorSpec;
import com.google.android.material.progressindicator.DrawableWithAnimatedVisibilityChange;
import com.google.android.material.progressindicator.DrawingDelegate;
import com.google.android.material.progressindicator.IndeterminateAnimatorDelegate;
import com.google.android.material.progressindicator.LinearDrawingDelegate;
import com.google.android.material.progressindicator.LinearIndeterminateContiguousAnimatorDelegate;
import com.google.android.material.progressindicator.LinearIndeterminateDisjointAnimatorDelegate;
import com.google.android.material.progressindicator.LinearProgressIndicatorSpec;

public final class IndeterminateDrawable<S extends BaseProgressIndicatorSpec>
extends DrawableWithAnimatedVisibilityChange {
    private DrawingDelegate<S> drawingDelegate;
    private IndeterminateAnimatorDelegate<ObjectAnimator> animatorDelegate;
    private Drawable staticDummyDrawable;

    IndeterminateDrawable(@NonNull Context context, @NonNull BaseProgressIndicatorSpec baseSpec, @NonNull DrawingDelegate<S> drawingDelegate, @NonNull IndeterminateAnimatorDelegate<ObjectAnimator> animatorDelegate) {
        super(context, baseSpec);
        this.setDrawingDelegate(drawingDelegate);
        this.setAnimatorDelegate(animatorDelegate);
    }

    @NonNull
    public static IndeterminateDrawable<LinearProgressIndicatorSpec> createLinearDrawable(@NonNull Context context, @NonNull LinearProgressIndicatorSpec spec) {
        return IndeterminateDrawable.createLinearDrawable(context, spec, new LinearDrawingDelegate(spec));
    }

    @NonNull
    static IndeterminateDrawable<LinearProgressIndicatorSpec> createLinearDrawable(@NonNull Context context, @NonNull LinearProgressIndicatorSpec spec, @NonNull LinearDrawingDelegate drawingDelegate) {
        return new IndeterminateDrawable<LinearProgressIndicatorSpec>(context, spec, drawingDelegate, spec.indeterminateAnimationType == 0 ? new LinearIndeterminateContiguousAnimatorDelegate(spec) : new LinearIndeterminateDisjointAnimatorDelegate(context, spec));
    }

    @NonNull
    public static IndeterminateDrawable<CircularProgressIndicatorSpec> createCircularDrawable(@NonNull Context context, @NonNull CircularProgressIndicatorSpec spec) {
        return IndeterminateDrawable.createCircularDrawable(context, spec, new CircularDrawingDelegate(spec));
    }

    @NonNull
    static IndeterminateDrawable<CircularProgressIndicatorSpec> createCircularDrawable(@NonNull Context context, @NonNull CircularProgressIndicatorSpec spec, @NonNull CircularDrawingDelegate drawingDelegate) {
        IndeterminateDrawable<CircularProgressIndicatorSpec> indeterminateDrawable = new IndeterminateDrawable<CircularProgressIndicatorSpec>(context, spec, drawingDelegate, new CircularIndeterminateAnimatorDelegate(spec));
        indeterminateDrawable.setStaticDummyDrawable(VectorDrawableCompat.create(context.getResources(), R.drawable.indeterminate_static, null));
        return indeterminateDrawable;
    }

    @Override
    boolean setVisibleInternal(boolean visible, boolean restart, boolean animate) {
        boolean changed = super.setVisibleInternal(visible, restart, animate);
        if (this.isSystemAnimatorDisabled() && this.staticDummyDrawable != null) {
            return this.staticDummyDrawable.setVisible(visible, restart);
        }
        if (!this.isRunning()) {
            this.animatorDelegate.cancelAnimatorImmediately();
        }
        if (visible && (animate || Build.VERSION.SDK_INT <= 22 && !this.isSystemAnimatorDisabled())) {
            this.animatorDelegate.startAnimator();
        }
        return changed;
    }

    public int getIntrinsicWidth() {
        return this.drawingDelegate.getPreferredWidth();
    }

    public int getIntrinsicHeight() {
        return this.drawingDelegate.getPreferredHeight();
    }

    public void draw(@NonNull Canvas canvas) {
        Rect clipBounds = new Rect();
        if (this.getBounds().isEmpty() || !this.isVisible() || !canvas.getClipBounds(clipBounds)) {
            return;
        }
        if (this.isSystemAnimatorDisabled() && this.staticDummyDrawable != null) {
            this.staticDummyDrawable.setBounds(this.getBounds());
            DrawableCompat.setTint(this.staticDummyDrawable, this.baseSpec.indicatorColors[0]);
            this.staticDummyDrawable.draw(canvas);
            return;
        }
        canvas.save();
        this.drawingDelegate.validateSpecAndAdjustCanvas(canvas, this.getBounds(), this.getGrowFraction(), this.isShowing(), this.isHiding());
        int gapSize = this.baseSpec.indicatorTrackGapSize;
        int trackAlpha = this.getAlpha();
        if (gapSize == 0) {
            this.drawingDelegate.fillTrack(canvas, this.paint, 0.0f, 1.0f, this.baseSpec.trackColor, trackAlpha, 0);
        } else {
            DrawingDelegate.ActiveIndicator firstIndicator = this.animatorDelegate.activeIndicators.get(0);
            DrawingDelegate.ActiveIndicator lastIndicator = this.animatorDelegate.activeIndicators.get(this.animatorDelegate.activeIndicators.size() - 1);
            if (this.drawingDelegate instanceof LinearDrawingDelegate) {
                this.drawingDelegate.fillTrack(canvas, this.paint, 0.0f, firstIndicator.startFraction, this.baseSpec.trackColor, trackAlpha, gapSize);
                this.drawingDelegate.fillTrack(canvas, this.paint, lastIndicator.endFraction, 1.0f, this.baseSpec.trackColor, trackAlpha, gapSize);
            } else {
                trackAlpha = 0;
                this.drawingDelegate.fillTrack(canvas, this.paint, lastIndicator.endFraction, firstIndicator.startFraction + 1.0f, this.baseSpec.trackColor, trackAlpha, gapSize);
            }
        }
        for (int indicatorIndex = 0; indicatorIndex < this.animatorDelegate.activeIndicators.size(); ++indicatorIndex) {
            DrawingDelegate.ActiveIndicator curIndicator = this.animatorDelegate.activeIndicators.get(indicatorIndex);
            this.drawingDelegate.fillIndicator(canvas, this.paint, curIndicator, this.getAlpha());
            if (indicatorIndex <= 0 || gapSize <= 0) continue;
            DrawingDelegate.ActiveIndicator prevIndicator = this.animatorDelegate.activeIndicators.get(indicatorIndex - 1);
            this.drawingDelegate.fillTrack(canvas, this.paint, prevIndicator.endFraction, curIndicator.startFraction, this.baseSpec.trackColor, trackAlpha, gapSize);
        }
        canvas.restore();
    }

    private boolean isSystemAnimatorDisabled() {
        if (this.animatorDurationScaleProvider != null) {
            float systemAnimatorDurationScale = this.animatorDurationScaleProvider.getSystemAnimatorDurationScale(this.context.getContentResolver());
            return systemAnimatorDurationScale == 0.0f;
        }
        return false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Drawable getStaticDummyDrawable() {
        return this.staticDummyDrawable;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @VisibleForTesting
    public void setStaticDummyDrawable(@Nullable Drawable staticDummyDrawable) {
        this.staticDummyDrawable = staticDummyDrawable;
    }

    @NonNull
    IndeterminateAnimatorDelegate<ObjectAnimator> getAnimatorDelegate() {
        return this.animatorDelegate;
    }

    void setAnimatorDelegate(@NonNull IndeterminateAnimatorDelegate<ObjectAnimator> animatorDelegate) {
        this.animatorDelegate = animatorDelegate;
        animatorDelegate.registerDrawable(this);
    }

    @NonNull
    DrawingDelegate<S> getDrawingDelegate() {
        return this.drawingDelegate;
    }

    void setDrawingDelegate(@NonNull DrawingDelegate<S> drawingDelegate) {
        this.drawingDelegate = drawingDelegate;
    }
}

