/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import com.google.android.material.progressindicator.DeterminateDrawable;
import com.google.android.material.progressindicator.IndeterminateDrawable;
import com.google.android.material.progressindicator.LinearDrawingDelegate;
import com.google.android.material.progressindicator.LinearIndeterminateContiguousAnimatorDelegate;
import com.google.android.material.progressindicator.LinearIndeterminateDisjointAnimatorDelegate;
import com.google.android.material.progressindicator.LinearProgressIndicatorSpec;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class LinearProgressIndicator
extends BaseProgressIndicator<LinearProgressIndicatorSpec> {
    public static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_LinearProgressIndicator;
    public static final int INDETERMINATE_ANIMATION_TYPE_CONTIGUOUS = 0;
    public static final int INDETERMINATE_ANIMATION_TYPE_DISJOINT = 1;
    public static final int INDICATOR_DIRECTION_LEFT_TO_RIGHT = 0;
    public static final int INDICATOR_DIRECTION_RIGHT_TO_LEFT = 1;
    public static final int INDICATOR_DIRECTION_START_TO_END = 2;
    public static final int INDICATOR_DIRECTION_END_TO_START = 3;

    public LinearProgressIndicator(@NonNull Context context) {
        this(context, null);
    }

    public LinearProgressIndicator(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.linearProgressIndicatorStyle);
    }

    public LinearProgressIndicator(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr, DEF_STYLE_RES);
        this.initializeDrawables();
    }

    @Override
    LinearProgressIndicatorSpec createSpec(@NonNull Context context, @NonNull AttributeSet attrs) {
        return new LinearProgressIndicatorSpec(context, attrs);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        ((LinearProgressIndicatorSpec)this.spec).drawHorizontallyInverse = ((LinearProgressIndicatorSpec)this.spec).indicatorDirection == 1 || ViewCompat.getLayoutDirection((View)this) == 1 && ((LinearProgressIndicatorSpec)this.spec).indicatorDirection == 2 || ViewCompat.getLayoutDirection((View)this) == 0 && ((LinearProgressIndicatorSpec)this.spec).indicatorDirection == 3;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        int contentWidth = w - (this.getPaddingLeft() + this.getPaddingRight());
        int contentHeight = h - (this.getPaddingTop() + this.getPaddingBottom());
        Drawable drawable2 = this.getIndeterminateDrawable();
        if (drawable2 != null) {
            drawable2.setBounds(0, 0, contentWidth, contentHeight);
        }
        if ((drawable2 = this.getProgressDrawable()) != null) {
            drawable2.setBounds(0, 0, contentWidth, contentHeight);
        }
    }

    private void initializeDrawables() {
        LinearDrawingDelegate drawingDelegate = new LinearDrawingDelegate((LinearProgressIndicatorSpec)this.spec);
        this.setIndeterminateDrawable(IndeterminateDrawable.createLinearDrawable(this.getContext(), (LinearProgressIndicatorSpec)this.spec, drawingDelegate));
        this.setProgressDrawable(DeterminateDrawable.createLinearDrawable(this.getContext(), (LinearProgressIndicatorSpec)this.spec, drawingDelegate));
    }

    @Override
    public void setIndicatorColor(int ... indicatorColors) {
        super.setIndicatorColor(indicatorColors);
        ((LinearProgressIndicatorSpec)this.spec).validateSpec();
    }

    @Override
    public void setTrackCornerRadius(int trackCornerRadius) {
        super.setTrackCornerRadius(trackCornerRadius);
        ((LinearProgressIndicatorSpec)this.spec).validateSpec();
        this.invalidate();
    }

    @Px
    public int getTrackStopIndicatorSize() {
        return ((LinearProgressIndicatorSpec)this.spec).trackStopIndicatorSize;
    }

    public void setTrackStopIndicatorSize(@Px int trackStopIndicatorSize) {
        if (((LinearProgressIndicatorSpec)this.spec).trackStopIndicatorSize != trackStopIndicatorSize) {
            ((LinearProgressIndicatorSpec)this.spec).trackStopIndicatorSize = Math.min(trackStopIndicatorSize, ((LinearProgressIndicatorSpec)this.spec).trackThickness);
            ((LinearProgressIndicatorSpec)this.spec).validateSpec();
            this.invalidate();
        }
    }

    public int getIndeterminateAnimationType() {
        return ((LinearProgressIndicatorSpec)this.spec).indeterminateAnimationType;
    }

    public void setIndeterminateAnimationType(int indeterminateAnimationType) {
        if (((LinearProgressIndicatorSpec)this.spec).indeterminateAnimationType == indeterminateAnimationType) {
            return;
        }
        if (this.visibleToUser() && this.isIndeterminate()) {
            throw new IllegalStateException("Cannot change indeterminate animation type while the progress indicator is show in indeterminate mode.");
        }
        ((LinearProgressIndicatorSpec)this.spec).indeterminateAnimationType = indeterminateAnimationType;
        ((LinearProgressIndicatorSpec)this.spec).validateSpec();
        if (indeterminateAnimationType == 0) {
            this.getIndeterminateDrawable().setAnimatorDelegate(new LinearIndeterminateContiguousAnimatorDelegate((LinearProgressIndicatorSpec)this.spec));
        } else {
            this.getIndeterminateDrawable().setAnimatorDelegate(new LinearIndeterminateDisjointAnimatorDelegate(this.getContext(), (LinearProgressIndicatorSpec)this.spec));
        }
        this.invalidate();
    }

    public int getIndicatorDirection() {
        return ((LinearProgressIndicatorSpec)this.spec).indicatorDirection;
    }

    public void setIndicatorDirection(int indicatorDirection) {
        ((LinearProgressIndicatorSpec)this.spec).indicatorDirection = indicatorDirection;
        ((LinearProgressIndicatorSpec)this.spec).drawHorizontallyInverse = indicatorDirection == 1 || ViewCompat.getLayoutDirection((View)this) == 1 && ((LinearProgressIndicatorSpec)this.spec).indicatorDirection == 2 || ViewCompat.getLayoutDirection((View)this) == 0 && indicatorDirection == 3;
        this.invalidate();
    }

    @Override
    public void setProgressCompat(int progress, boolean animated) {
        if (this.spec != null && ((LinearProgressIndicatorSpec)this.spec).indeterminateAnimationType == 0 && this.isIndeterminate()) {
            return;
        }
        super.setProgressCompat(progress, animated);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface IndicatorDirection {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface IndeterminateAnimationType {
    }
}

