/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.resources;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.os.Build;
import android.text.TextPaint;
import android.util.Log;
import androidx.annotation.FontRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.res.ResourcesCompat;
import com.google.android.material.R;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.resources.TextAppearanceConfig;
import com.google.android.material.resources.TextAppearanceFontCallback;
import com.google.android.material.resources.TypefaceUtils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TextAppearance {
    private static final String TAG = "TextAppearance";
    private static final int TYPEFACE_SANS = 1;
    private static final int TYPEFACE_SERIF = 2;
    private static final int TYPEFACE_MONOSPACE = 3;
    @Nullable
    public final ColorStateList textColorHint;
    @Nullable
    public final ColorStateList textColorLink;
    @Nullable
    public final ColorStateList shadowColor;
    @Nullable
    public final String fontFamily;
    public final int textStyle;
    public final int typeface;
    public final boolean textAllCaps;
    public final float shadowDx;
    public final float shadowDy;
    public final float shadowRadius;
    public final boolean hasLetterSpacing;
    public final float letterSpacing;
    @Nullable
    private ColorStateList textColor;
    private float textSize;
    @FontRes
    private final int fontFamilyResourceId;
    private boolean fontResolved = false;
    private Typeface font;

    public TextAppearance(@NonNull Context context, @StyleRes int id2) {
        TypedArray a = context.obtainStyledAttributes(id2, R.styleable.TextAppearance);
        this.setTextSize(a.getDimension(R.styleable.TextAppearance_android_textSize, 0.0f));
        this.setTextColor(MaterialResources.getColorStateList(context, a, R.styleable.TextAppearance_android_textColor));
        this.textColorHint = MaterialResources.getColorStateList(context, a, R.styleable.TextAppearance_android_textColorHint);
        this.textColorLink = MaterialResources.getColorStateList(context, a, R.styleable.TextAppearance_android_textColorLink);
        this.textStyle = a.getInt(R.styleable.TextAppearance_android_textStyle, 0);
        this.typeface = a.getInt(R.styleable.TextAppearance_android_typeface, 1);
        int fontFamilyIndex = MaterialResources.getIndexWithValue(a, R.styleable.TextAppearance_fontFamily, R.styleable.TextAppearance_android_fontFamily);
        this.fontFamilyResourceId = a.getResourceId(fontFamilyIndex, 0);
        this.fontFamily = a.getString(fontFamilyIndex);
        this.textAllCaps = a.getBoolean(R.styleable.TextAppearance_textAllCaps, false);
        this.shadowColor = MaterialResources.getColorStateList(context, a, R.styleable.TextAppearance_android_shadowColor);
        this.shadowDx = a.getFloat(R.styleable.TextAppearance_android_shadowDx, 0.0f);
        this.shadowDy = a.getFloat(R.styleable.TextAppearance_android_shadowDy, 0.0f);
        this.shadowRadius = a.getFloat(R.styleable.TextAppearance_android_shadowRadius, 0.0f);
        a.recycle();
        if (Build.VERSION.SDK_INT >= 21) {
            a = context.obtainStyledAttributes(id2, R.styleable.MaterialTextAppearance);
            this.hasLetterSpacing = a.hasValue(R.styleable.MaterialTextAppearance_android_letterSpacing);
            this.letterSpacing = a.getFloat(R.styleable.MaterialTextAppearance_android_letterSpacing, 0.0f);
            a.recycle();
        } else {
            this.hasLetterSpacing = false;
            this.letterSpacing = 0.0f;
        }
    }

    @VisibleForTesting
    @NonNull
    public Typeface getFont(@NonNull Context context) {
        if (this.fontResolved) {
            return this.font;
        }
        if (!context.isRestricted()) {
            try {
                this.font = ResourcesCompat.getFont(context, this.fontFamilyResourceId);
                if (this.font != null) {
                    this.font = Typeface.create((Typeface)this.font, (int)this.textStyle);
                }
            }
            catch (Resources.NotFoundException | UnsupportedOperationException throwable) {
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)("Error loading font " + this.fontFamily), (Throwable)e);
            }
        }
        this.createFallbackFont();
        this.fontResolved = true;
        return this.font;
    }

    public void getFontAsync(@NonNull Context context, final @NonNull TextAppearanceFontCallback callback2) {
        if (this.shouldLoadFontSynchronously(context)) {
            this.getFont(context);
        } else {
            this.createFallbackFont();
        }
        if (this.fontFamilyResourceId == 0) {
            this.fontResolved = true;
        }
        if (this.fontResolved) {
            callback2.onFontRetrieved(this.font, true);
            return;
        }
        try {
            ResourcesCompat.getFont(context, this.fontFamilyResourceId, new ResourcesCompat.FontCallback(){

                @Override
                public void onFontRetrieved(@NonNull Typeface typeface) {
                    TextAppearance.this.font = Typeface.create((Typeface)typeface, (int)TextAppearance.this.textStyle);
                    TextAppearance.this.fontResolved = true;
                    callback2.onFontRetrieved(TextAppearance.this.font, false);
                }

                @Override
                public void onFontRetrievalFailed(int reason) {
                    TextAppearance.this.fontResolved = true;
                    callback2.onFontRetrievalFailed(reason);
                }
            }, null);
        }
        catch (Resources.NotFoundException e) {
            this.fontResolved = true;
            callback2.onFontRetrievalFailed(1);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Error loading font " + this.fontFamily), (Throwable)e);
            this.fontResolved = true;
            callback2.onFontRetrievalFailed(-3);
        }
    }

    public void getFontAsync(final @NonNull Context context, final @NonNull TextPaint textPaint, final @NonNull TextAppearanceFontCallback callback2) {
        this.updateTextPaintMeasureState(context, textPaint, this.getFallbackFont());
        this.getFontAsync(context, new TextAppearanceFontCallback(){

            @Override
            public void onFontRetrieved(@NonNull Typeface typeface, boolean fontResolvedSynchronously) {
                TextAppearance.this.updateTextPaintMeasureState(context, textPaint, typeface);
                callback2.onFontRetrieved(typeface, fontResolvedSynchronously);
            }

            @Override
            public void onFontRetrievalFailed(int i) {
                callback2.onFontRetrievalFailed(i);
            }
        });
    }

    public Typeface getFallbackFont() {
        this.createFallbackFont();
        return this.font;
    }

    private void createFallbackFont() {
        if (this.font == null && this.fontFamily != null) {
            this.font = Typeface.create((String)this.fontFamily, (int)this.textStyle);
        }
        if (this.font == null) {
            switch (this.typeface) {
                case 1: {
                    this.font = Typeface.SANS_SERIF;
                    break;
                }
                case 2: {
                    this.font = Typeface.SERIF;
                    break;
                }
                case 3: {
                    this.font = Typeface.MONOSPACE;
                    break;
                }
                default: {
                    this.font = Typeface.DEFAULT;
                }
            }
            this.font = Typeface.create((Typeface)this.font, (int)this.textStyle);
        }
    }

    public void updateDrawState(@NonNull Context context, @NonNull TextPaint textPaint, @NonNull TextAppearanceFontCallback callback2) {
        this.updateMeasureState(context, textPaint, callback2);
        textPaint.setColor(this.textColor != null ? this.textColor.getColorForState(textPaint.drawableState, this.textColor.getDefaultColor()) : -16777216);
        textPaint.setShadowLayer(this.shadowRadius, this.shadowDx, this.shadowDy, this.shadowColor != null ? this.shadowColor.getColorForState(textPaint.drawableState, this.shadowColor.getDefaultColor()) : 0);
    }

    public void updateMeasureState(@NonNull Context context, @NonNull TextPaint textPaint, @NonNull TextAppearanceFontCallback callback2) {
        if (this.shouldLoadFontSynchronously(context)) {
            this.updateTextPaintMeasureState(context, textPaint, this.getFont(context));
        } else {
            this.getFontAsync(context, textPaint, callback2);
        }
    }

    public void updateTextPaintMeasureState(@NonNull Context context, @NonNull TextPaint textPaint, @NonNull Typeface typeface) {
        Typeface boldTypeface = TypefaceUtils.maybeCopyWithFontWeightAdjustment(context, typeface);
        if (boldTypeface != null) {
            typeface = boldTypeface;
        }
        textPaint.setTypeface(typeface);
        int fake = this.textStyle & ~typeface.getStyle();
        textPaint.setFakeBoldText((fake & 1) != 0);
        textPaint.setTextSkewX((fake & 2) != 0 ? -0.25f : 0.0f);
        textPaint.setTextSize(this.textSize);
        if (Build.VERSION.SDK_INT >= 21 && this.hasLetterSpacing) {
            textPaint.setLetterSpacing(this.letterSpacing);
        }
    }

    @Nullable
    public ColorStateList getTextColor() {
        return this.textColor;
    }

    public void setTextColor(@Nullable ColorStateList textColor) {
        this.textColor = textColor;
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
    }

    private boolean shouldLoadFontSynchronously(Context context) {
        if (TextAppearanceConfig.shouldLoadFontSynchronously()) {
            return true;
        }
        Typeface typeface = this.fontFamilyResourceId != 0 ? ResourcesCompat.getCachedFont(context, this.fontFamilyResourceId) : null;
        return typeface != null;
    }
}

