/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.search;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.TextView;
import androidx.activity.BackEventCompat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.graphics.drawable.DrawerArrowDrawable;
import androidx.appcompat.widget.ActionMenuView;
import androidx.appcompat.widget.Toolbar;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.MarginLayoutParamsCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.internal.ClippableRoundedCornerLayout;
import com.google.android.material.internal.FadeThroughDrawable;
import com.google.android.material.internal.FadeThroughUpdateListener;
import com.google.android.material.internal.MultiViewUpdateListener;
import com.google.android.material.internal.RectEvaluator;
import com.google.android.material.internal.ReversableAnimatedValueInterpolator;
import com.google.android.material.internal.ToolbarUtils;
import com.google.android.material.internal.TouchObserverFrameLayout;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.motion.MaterialMainContainerBackHelper;
import com.google.android.material.search.SearchBar;
import com.google.android.material.search.SearchView;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

class SearchViewAnimationHelper {
    private static final long SHOW_DURATION_MS = 300L;
    private static final long SHOW_CLEAR_BUTTON_ALPHA_DURATION_MS = 50L;
    private static final long SHOW_CLEAR_BUTTON_ALPHA_START_DELAY_MS = 250L;
    private static final long SHOW_CONTENT_ALPHA_DURATION_MS = 150L;
    private static final long SHOW_CONTENT_ALPHA_START_DELAY_MS = 75L;
    private static final long SHOW_CONTENT_SCALE_DURATION_MS = 300L;
    private static final long HIDE_DURATION_MS = 250L;
    private static final long HIDE_CLEAR_BUTTON_ALPHA_DURATION_MS = 42L;
    private static final long HIDE_CLEAR_BUTTON_ALPHA_START_DELAY_MS = 0L;
    private static final long HIDE_CONTENT_ALPHA_DURATION_MS = 83L;
    private static final long HIDE_CONTENT_ALPHA_START_DELAY_MS = 0L;
    private static final long HIDE_CONTENT_SCALE_DURATION_MS = 250L;
    private static final float CONTENT_FROM_SCALE = 0.95f;
    private static final long SHOW_TRANSLATE_DURATION_MS = 350L;
    private static final long SHOW_TRANSLATE_KEYBOARD_START_DELAY_MS = 150L;
    private static final long HIDE_TRANSLATE_DURATION_MS = 300L;
    private final SearchView searchView;
    private final View scrim;
    private final ClippableRoundedCornerLayout rootView;
    private final FrameLayout headerContainer;
    private final FrameLayout toolbarContainer;
    private final Toolbar toolbar;
    private final Toolbar dummyToolbar;
    private final TextView searchPrefix;
    private final EditText editText;
    private final ImageButton clearButton;
    private final View divider;
    private final TouchObserverFrameLayout contentContainer;
    private final MaterialMainContainerBackHelper backHelper;
    @Nullable
    private AnimatorSet backProgressAnimatorSet;
    private SearchBar searchBar;

    SearchViewAnimationHelper(SearchView searchView) {
        this.searchView = searchView;
        this.scrim = searchView.scrim;
        this.rootView = searchView.rootView;
        this.headerContainer = searchView.headerContainer;
        this.toolbarContainer = searchView.toolbarContainer;
        this.toolbar = searchView.toolbar;
        this.dummyToolbar = searchView.dummyToolbar;
        this.searchPrefix = searchView.searchPrefix;
        this.editText = searchView.editText;
        this.clearButton = searchView.clearButton;
        this.divider = searchView.divider;
        this.contentContainer = searchView.contentContainer;
        this.backHelper = new MaterialMainContainerBackHelper((View)this.rootView);
    }

    void setSearchBar(SearchBar searchBar) {
        this.searchBar = searchBar;
    }

    void show() {
        if (this.searchBar != null) {
            this.startShowAnimationExpand();
        } else {
            this.startShowAnimationTranslate();
        }
    }

    @CanIgnoreReturnValue
    AnimatorSet hide() {
        if (this.searchBar != null) {
            return this.startHideAnimationCollapse();
        }
        return this.startHideAnimationTranslate();
    }

    private void startShowAnimationExpand() {
        if (this.searchView.isAdjustNothingSoftInputMode()) {
            this.searchView.requestFocusAndShowKeyboardIfNeeded();
        }
        this.searchView.setTransitionState(SearchView.TransitionState.SHOWING);
        this.setUpDummyToolbarIfNeeded();
        this.editText.setText(this.searchBar.getText());
        this.editText.setSelection(this.editText.getText().length());
        this.rootView.setVisibility(4);
        this.rootView.post(() -> {
            AnimatorSet animatorSet = this.getExpandCollapseAnimatorSet(true);
            animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    SearchViewAnimationHelper.this.rootView.setVisibility(0);
                    SearchViewAnimationHelper.this.searchBar.stopOnLoadAnimation();
                }

                public void onAnimationEnd(Animator animation) {
                    if (!SearchViewAnimationHelper.this.searchView.isAdjustNothingSoftInputMode()) {
                        SearchViewAnimationHelper.this.searchView.requestFocusAndShowKeyboardIfNeeded();
                    }
                    SearchViewAnimationHelper.this.searchView.setTransitionState(SearchView.TransitionState.SHOWN);
                }
            });
            animatorSet.start();
        });
    }

    private AnimatorSet startHideAnimationCollapse() {
        if (this.searchView.isAdjustNothingSoftInputMode()) {
            this.searchView.clearFocusAndHideKeyboard();
        }
        AnimatorSet animatorSet = this.getExpandCollapseAnimatorSet(false);
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                SearchViewAnimationHelper.this.searchView.setTransitionState(SearchView.TransitionState.HIDING);
            }

            public void onAnimationEnd(Animator animation) {
                SearchViewAnimationHelper.this.rootView.setVisibility(8);
                if (!SearchViewAnimationHelper.this.searchView.isAdjustNothingSoftInputMode()) {
                    SearchViewAnimationHelper.this.searchView.clearFocusAndHideKeyboard();
                }
                SearchViewAnimationHelper.this.searchView.setTransitionState(SearchView.TransitionState.HIDDEN);
            }
        });
        animatorSet.start();
        return animatorSet;
    }

    private void startShowAnimationTranslate() {
        if (this.searchView.isAdjustNothingSoftInputMode()) {
            this.searchView.postDelayed(this.searchView::requestFocusAndShowKeyboardIfNeeded, 150L);
        }
        this.rootView.setVisibility(4);
        this.rootView.post(() -> {
            this.rootView.setTranslationY(this.rootView.getHeight());
            AnimatorSet animatorSet = this.getTranslateAnimatorSet(true);
            animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    SearchViewAnimationHelper.this.rootView.setVisibility(0);
                    SearchViewAnimationHelper.this.searchView.setTransitionState(SearchView.TransitionState.SHOWING);
                }

                public void onAnimationEnd(Animator animation) {
                    if (!SearchViewAnimationHelper.this.searchView.isAdjustNothingSoftInputMode()) {
                        SearchViewAnimationHelper.this.searchView.requestFocusAndShowKeyboardIfNeeded();
                    }
                    SearchViewAnimationHelper.this.searchView.setTransitionState(SearchView.TransitionState.SHOWN);
                }
            });
            animatorSet.start();
        });
    }

    private AnimatorSet startHideAnimationTranslate() {
        if (this.searchView.isAdjustNothingSoftInputMode()) {
            this.searchView.clearFocusAndHideKeyboard();
        }
        AnimatorSet animatorSet = this.getTranslateAnimatorSet(false);
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                SearchViewAnimationHelper.this.searchView.setTransitionState(SearchView.TransitionState.HIDING);
            }

            public void onAnimationEnd(Animator animation) {
                SearchViewAnimationHelper.this.rootView.setVisibility(8);
                if (!SearchViewAnimationHelper.this.searchView.isAdjustNothingSoftInputMode()) {
                    SearchViewAnimationHelper.this.searchView.clearFocusAndHideKeyboard();
                }
                SearchViewAnimationHelper.this.searchView.setTransitionState(SearchView.TransitionState.HIDDEN);
            }
        });
        animatorSet.start();
        return animatorSet;
    }

    private AnimatorSet getTranslateAnimatorSet(boolean show) {
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{this.getTranslationYAnimator()});
        this.addBackButtonProgressAnimatorIfNeeded(animatorSet);
        animatorSet.setInterpolator(ReversableAnimatedValueInterpolator.of(show, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        animatorSet.setDuration(show ? 350L : 300L);
        return animatorSet;
    }

    private Animator getTranslationYAnimator() {
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{this.rootView.getHeight(), 0.0f});
        animator2.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.translationYListener(new View[]{this.rootView}));
        return animator2;
    }

    private AnimatorSet getExpandCollapseAnimatorSet(final boolean show) {
        boolean backProgress;
        AnimatorSet animatorSet = new AnimatorSet();
        boolean bl = backProgress = this.backProgressAnimatorSet != null;
        if (!backProgress) {
            animatorSet.playTogether(new Animator[]{this.getButtonsProgressAnimator(show), this.getButtonsTranslationAnimator(show)});
        }
        animatorSet.playTogether(new Animator[]{this.getScrimAlphaAnimator(show), this.getRootViewAnimator(show), this.getClearButtonAnimator(show), this.getContentAnimator(show), this.getHeaderContainerAnimator(show), this.getDummyToolbarAnimator(show), this.getActionMenuViewsAlphaAnimator(show), this.getEditTextAnimator(show), this.getSearchPrefixAnimator(show)});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                SearchViewAnimationHelper.this.setContentViewsAlpha(show ? 0.0f : 1.0f);
            }

            public void onAnimationEnd(Animator animation) {
                SearchViewAnimationHelper.this.setContentViewsAlpha(show ? 1.0f : 0.0f);
                SearchViewAnimationHelper.this.rootView.resetClipBoundsAndCornerRadius();
            }
        });
        return animatorSet;
    }

    private void setContentViewsAlpha(float alpha) {
        this.clearButton.setAlpha(alpha);
        this.divider.setAlpha(alpha);
        this.contentContainer.setAlpha(alpha);
        this.setActionMenuViewAlphaIfNeeded(alpha);
    }

    private void setActionMenuViewAlphaIfNeeded(float alpha) {
        ActionMenuView actionMenuView;
        if (this.searchView.isMenuItemsAnimated() && (actionMenuView = ToolbarUtils.getActionMenuView(this.toolbar)) != null) {
            actionMenuView.setAlpha(alpha);
        }
    }

    private Animator getScrimAlphaAnimator(boolean show) {
        TimeInterpolator interpolator2 = show ? AnimationUtils.LINEAR_INTERPOLATOR : AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR;
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator2.setDuration(show ? 300L : 250L);
        animator2.setInterpolator(ReversableAnimatedValueInterpolator.of(show, interpolator2));
        animator2.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.alphaListener(this.scrim));
        return animator2;
    }

    private Animator getRootViewAnimator(boolean show) {
        Rect initialHideToClipBounds = this.backHelper.getInitialHideToClipBounds();
        Rect initialHideFromClipBounds = this.backHelper.getInitialHideFromClipBounds();
        Rect toClipBounds = initialHideToClipBounds != null ? initialHideToClipBounds : ViewUtils.calculateRectFromBounds((View)this.searchView);
        Rect fromClipBounds = initialHideFromClipBounds != null ? initialHideFromClipBounds : ViewUtils.calculateOffsetRectFromBounds((View)this.rootView, (View)this.searchBar);
        Rect clipBounds = new Rect(fromClipBounds);
        float fromCornerRadius = this.searchBar.getCornerSize();
        float toCornerRadius = Math.max(this.rootView.getCornerRadius(), (float)this.backHelper.getExpandedCornerSize());
        ValueAnimator animator2 = ValueAnimator.ofObject((TypeEvaluator)new RectEvaluator(clipBounds), (Object[])new Object[]{fromClipBounds, toClipBounds});
        animator2.addUpdateListener(valueAnimator -> {
            float cornerRadius = AnimationUtils.lerp(fromCornerRadius, toCornerRadius, valueAnimator.getAnimatedFraction());
            this.rootView.updateClipBoundsAndCornerRadius(clipBounds, cornerRadius);
        });
        animator2.setDuration(show ? 300L : 250L);
        animator2.setInterpolator(ReversableAnimatedValueInterpolator.of(show, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        return animator2;
    }

    private Animator getClearButtonAnimator(boolean show) {
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator2.setDuration(show ? 50L : 42L);
        animator2.setStartDelay(show ? 250L : 0L);
        animator2.setInterpolator(ReversableAnimatedValueInterpolator.of(show, AnimationUtils.LINEAR_INTERPOLATOR));
        animator2.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.alphaListener(new View[]{this.clearButton}));
        return animator2;
    }

    private AnimatorSet getButtonsProgressAnimator(boolean show) {
        AnimatorSet animatorSet = new AnimatorSet();
        this.addBackButtonProgressAnimatorIfNeeded(animatorSet);
        animatorSet.setDuration(show ? 300L : 250L);
        animatorSet.setInterpolator(ReversableAnimatedValueInterpolator.of(show, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        return animatorSet;
    }

    private AnimatorSet getButtonsTranslationAnimator(boolean show) {
        AnimatorSet animatorSet = new AnimatorSet();
        this.addBackButtonTranslationAnimatorIfNeeded(animatorSet);
        this.addActionMenuViewAnimatorIfNeeded(animatorSet);
        animatorSet.setDuration(show ? 300L : 250L);
        animatorSet.setInterpolator(ReversableAnimatedValueInterpolator.of(show, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        return animatorSet;
    }

    private void addBackButtonTranslationAnimatorIfNeeded(AnimatorSet animatorSet) {
        ImageButton backButton = ToolbarUtils.getNavigationIconButton(this.toolbar);
        if (backButton == null) {
            return;
        }
        ValueAnimator backButtonAnimatorX = ValueAnimator.ofFloat((float[])new float[]{this.getFromTranslationXStart((View)backButton), 0.0f});
        backButtonAnimatorX.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.translationXListener(new View[]{backButton}));
        ValueAnimator backButtonAnimatorY = ValueAnimator.ofFloat((float[])new float[]{this.getFromTranslationY(), 0.0f});
        backButtonAnimatorY.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.translationYListener(new View[]{backButton}));
        animatorSet.playTogether(new Animator[]{backButtonAnimatorX, backButtonAnimatorY});
    }

    private void addBackButtonProgressAnimatorIfNeeded(AnimatorSet animatorSet) {
        ImageButton backButton = ToolbarUtils.getNavigationIconButton(this.toolbar);
        if (backButton == null) {
            return;
        }
        Object drawable2 = DrawableCompat.unwrap(backButton.getDrawable());
        if (this.searchView.isAnimatedNavigationIcon()) {
            this.addDrawerArrowDrawableAnimatorIfNeeded(animatorSet, (Drawable)drawable2);
            this.addFadeThroughDrawableAnimatorIfNeeded(animatorSet, (Drawable)drawable2);
        } else {
            this.setFullDrawableProgressIfNeeded((Drawable)drawable2);
        }
    }

    private void addDrawerArrowDrawableAnimatorIfNeeded(AnimatorSet animatorSet, Drawable drawable2) {
        if (drawable2 instanceof DrawerArrowDrawable) {
            DrawerArrowDrawable drawerArrowDrawable = (DrawerArrowDrawable)drawable2;
            ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            animator2.addUpdateListener(animation -> drawerArrowDrawable.setProgress(((Float)animation.getAnimatedValue()).floatValue()));
            animatorSet.playTogether(new Animator[]{animator2});
        }
    }

    private void addFadeThroughDrawableAnimatorIfNeeded(AnimatorSet animatorSet, Drawable drawable2) {
        if (drawable2 instanceof FadeThroughDrawable) {
            FadeThroughDrawable fadeThroughDrawable = (FadeThroughDrawable)drawable2;
            ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            animator2.addUpdateListener(animation -> fadeThroughDrawable.setProgress(((Float)animation.getAnimatedValue()).floatValue()));
            animatorSet.playTogether(new Animator[]{animator2});
        }
    }

    private void setFullDrawableProgressIfNeeded(Drawable drawable2) {
        if (drawable2 instanceof DrawerArrowDrawable) {
            ((DrawerArrowDrawable)drawable2).setProgress(1.0f);
        }
        if (drawable2 instanceof FadeThroughDrawable) {
            ((FadeThroughDrawable)drawable2).setProgress(1.0f);
        }
    }

    private void addActionMenuViewAnimatorIfNeeded(AnimatorSet animatorSet) {
        ActionMenuView actionMenuView = ToolbarUtils.getActionMenuView(this.toolbar);
        if (actionMenuView == null) {
            return;
        }
        ValueAnimator actionMenuViewAnimatorX = ValueAnimator.ofFloat((float[])new float[]{this.getFromTranslationXEnd((View)actionMenuView), 0.0f});
        actionMenuViewAnimatorX.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.translationXListener(new View[]{actionMenuView}));
        ValueAnimator actionMenuViewAnimatorY = ValueAnimator.ofFloat((float[])new float[]{this.getFromTranslationY(), 0.0f});
        actionMenuViewAnimatorY.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.translationYListener(new View[]{actionMenuView}));
        animatorSet.playTogether(new Animator[]{actionMenuViewAnimatorX, actionMenuViewAnimatorY});
    }

    private Animator getDummyToolbarAnimator(boolean show) {
        return this.getTranslationAnimator(show, false, (View)this.dummyToolbar);
    }

    private Animator getHeaderContainerAnimator(boolean show) {
        return this.getTranslationAnimator(show, false, (View)this.headerContainer);
    }

    private Animator getActionMenuViewsAlphaAnimator(boolean show) {
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator2.setDuration(show ? 300L : 250L);
        animator2.setInterpolator(ReversableAnimatedValueInterpolator.of(show, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        if (this.searchView.isMenuItemsAnimated()) {
            ActionMenuView dummyActionMenuView = ToolbarUtils.getActionMenuView(this.dummyToolbar);
            ActionMenuView actionMenuView = ToolbarUtils.getActionMenuView(this.toolbar);
            animator2.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new FadeThroughUpdateListener((View)dummyActionMenuView, (View)actionMenuView));
        }
        return animator2;
    }

    private Animator getSearchPrefixAnimator(boolean show) {
        return this.getTranslationAnimator(show, true, (View)this.searchPrefix);
    }

    private Animator getEditTextAnimator(boolean show) {
        return this.getTranslationAnimator(show, true, (View)this.editText);
    }

    private Animator getContentAnimator(boolean show) {
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{this.getContentAlphaAnimator(show), this.getDividerAnimator(show), this.getContentScaleAnimator(show)});
        return animatorSet;
    }

    private Animator getContentAlphaAnimator(boolean show) {
        ValueAnimator animatorAlpha = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animatorAlpha.setDuration(show ? 150L : 83L);
        animatorAlpha.setStartDelay(show ? 75L : 0L);
        animatorAlpha.setInterpolator(ReversableAnimatedValueInterpolator.of(show, AnimationUtils.LINEAR_INTERPOLATOR));
        animatorAlpha.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.alphaListener(new View[]{this.divider, this.contentContainer}));
        return animatorAlpha;
    }

    private Animator getDividerAnimator(boolean show) {
        float dividerTranslationY = (float)this.contentContainer.getHeight() * 0.050000012f / 2.0f;
        ValueAnimator animatorDivider = ValueAnimator.ofFloat((float[])new float[]{dividerTranslationY, 0.0f});
        animatorDivider.setDuration(show ? 300L : 250L);
        animatorDivider.setInterpolator(ReversableAnimatedValueInterpolator.of(show, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        animatorDivider.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.translationYListener(this.divider));
        return animatorDivider;
    }

    private Animator getContentScaleAnimator(boolean show) {
        ValueAnimator animatorScale = ValueAnimator.ofFloat((float[])new float[]{0.95f, 1.0f});
        animatorScale.setDuration(show ? 300L : 250L);
        animatorScale.setInterpolator(ReversableAnimatedValueInterpolator.of(show, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        animatorScale.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.scaleListener(new View[]{this.contentContainer}));
        return animatorScale;
    }

    private Animator getTranslationAnimator(boolean show, boolean anchoredToStart, View view) {
        int startX = anchoredToStart ? this.getFromTranslationXStart(view) : this.getFromTranslationXEnd(view);
        ValueAnimator animatorX = ValueAnimator.ofFloat((float[])new float[]{startX, 0.0f});
        animatorX.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.translationXListener(view));
        ValueAnimator animatorY = ValueAnimator.ofFloat((float[])new float[]{this.getFromTranslationY(), 0.0f});
        animatorY.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.translationYListener(view));
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{animatorX, animatorY});
        animatorSet.setDuration(show ? 300L : 250L);
        animatorSet.setInterpolator(ReversableAnimatedValueInterpolator.of(show, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        return animatorSet;
    }

    private int getFromTranslationXStart(View view) {
        int marginStart = MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)view.getLayoutParams());
        int paddingStart = ViewCompat.getPaddingStart((View)this.searchBar);
        return ViewUtils.isLayoutRtl((View)this.searchBar) ? this.searchBar.getWidth() - this.searchBar.getRight() + marginStart - paddingStart : this.searchBar.getLeft() - marginStart + paddingStart;
    }

    private int getFromTranslationXEnd(View view) {
        int marginEnd = MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)view.getLayoutParams());
        return ViewUtils.isLayoutRtl((View)this.searchBar) ? this.searchBar.getLeft() - marginEnd : this.searchBar.getRight() - this.searchView.getWidth() + marginEnd;
    }

    private int getFromTranslationY() {
        int toolbarMiddleY = (this.toolbarContainer.getTop() + this.toolbarContainer.getBottom()) / 2;
        int searchBarMiddleY = (this.searchBar.getTop() + this.searchBar.getBottom()) / 2;
        return searchBarMiddleY - toolbarMiddleY;
    }

    private void setUpDummyToolbarIfNeeded() {
        Menu menu2 = this.dummyToolbar.getMenu();
        if (menu2 != null) {
            menu2.clear();
        }
        if (this.searchBar.getMenuResId() != -1 && this.searchView.isMenuItemsAnimated()) {
            this.dummyToolbar.inflateMenu(this.searchBar.getMenuResId());
            this.setMenuItemsNotClickable(this.dummyToolbar);
            this.dummyToolbar.setVisibility(0);
        } else {
            this.dummyToolbar.setVisibility(8);
        }
    }

    private void setMenuItemsNotClickable(Toolbar toolbar) {
        ActionMenuView actionMenuView = ToolbarUtils.getActionMenuView(toolbar);
        if (actionMenuView != null) {
            for (int i = 0; i < actionMenuView.getChildCount(); ++i) {
                View menuItem = actionMenuView.getChildAt(i);
                menuItem.setClickable(false);
                menuItem.setFocusable(false);
                menuItem.setFocusableInTouchMode(false);
            }
        }
    }

    void startBackProgress(@NonNull BackEventCompat backEvent) {
        this.backHelper.startBackProgress(backEvent, (View)this.searchBar);
    }

    @RequiresApi(value=34)
    public void updateBackProgress(@NonNull BackEventCompat backEvent) {
        if (backEvent.getProgress() <= 0.0f) {
            return;
        }
        this.backHelper.updateBackProgress(backEvent, (View)this.searchBar, this.searchBar.getCornerSize());
        if (this.backProgressAnimatorSet == null) {
            if (this.searchView.isAdjustNothingSoftInputMode()) {
                this.searchView.clearFocusAndHideKeyboard();
            }
            if (!this.searchView.isAnimatedNavigationIcon()) {
                return;
            }
            this.backProgressAnimatorSet = this.getButtonsProgressAnimator(false);
            this.backProgressAnimatorSet.start();
            this.backProgressAnimatorSet.pause();
        } else {
            this.backProgressAnimatorSet.setCurrentPlayTime((long)(backEvent.getProgress() * (float)this.backProgressAnimatorSet.getDuration()));
        }
    }

    @Nullable
    public BackEventCompat onHandleBackInvoked() {
        return this.backHelper.onHandleBackInvoked();
    }

    @RequiresApi(value=34)
    public void finishBackProgress() {
        AnimatorSet hideAnimatorSet = this.hide();
        long totalDuration = hideAnimatorSet.getTotalDuration();
        this.backHelper.finishBackProgress(totalDuration, (View)this.searchBar);
        if (this.backProgressAnimatorSet != null) {
            this.getButtonsTranslationAnimator(false).start();
            this.backProgressAnimatorSet.resume();
        }
        this.backProgressAnimatorSet = null;
    }

    @RequiresApi(value=34)
    public void cancelBackProgress() {
        this.backHelper.cancelBackProgress((View)this.searchBar);
        if (this.backProgressAnimatorSet != null) {
            this.backProgressAnimatorSet.reverse();
        }
        this.backProgressAnimatorSet = null;
    }

    MaterialMainContainerBackHelper getBackHelper() {
        return this.backHelper;
    }
}

