/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.shape;

import android.graphics.RectF;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.google.android.material.shape.AbsoluteCornerSize;
import com.google.android.material.shape.CornerSize;
import java.util.Arrays;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ClampedCornerSize
implements CornerSize {
    private final float target;

    @NonNull
    public static ClampedCornerSize createFromCornerSize(@NonNull AbsoluteCornerSize cornerSize) {
        return new ClampedCornerSize(cornerSize.getCornerSize());
    }

    private static float getMaxCornerSize(@NonNull RectF bounds) {
        return Math.min(bounds.width() / 2.0f, bounds.height() / 2.0f);
    }

    public ClampedCornerSize(float target) {
        this.target = target;
    }

    @Override
    public float getCornerSize(@NonNull RectF bounds) {
        return Math.min(this.target, ClampedCornerSize.getMaxCornerSize(bounds));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClampedCornerSize)) {
            return false;
        }
        ClampedCornerSize that = (ClampedCornerSize)o;
        return this.target == that.target;
    }

    public int hashCode() {
        Object[] hashedFields = new Object[]{Float.valueOf(this.target)};
        return Arrays.hashCode(hashedFields);
    }
}

