/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.shape;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.RectF;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.google.android.material.shadow.ShadowRenderer;
import java.util.ArrayList;
import java.util.List;

public class ShapePath {
    private static final float ANGLE_UP = 270.0f;
    protected static final float ANGLE_LEFT = 180.0f;
    @Deprecated
    public float startX;
    @Deprecated
    public float startY;
    @Deprecated
    public float endX;
    @Deprecated
    public float endY;
    @Deprecated
    public float currentShadowAngle;
    @Deprecated
    public float endShadowAngle;
    private final List<PathOperation> operations = new ArrayList<PathOperation>();
    private final List<ShadowCompatOperation> shadowCompatOperations = new ArrayList<ShadowCompatOperation>();
    private boolean containsIncompatibleShadowOp;

    public ShapePath() {
        this.reset(0.0f, 0.0f);
    }

    public ShapePath(float startX, float startY) {
        this.reset(startX, startY);
    }

    public void reset(float startX, float startY) {
        this.reset(startX, startY, 270.0f, 0.0f);
    }

    public void reset(float startX, float startY, float shadowStartAngle, float shadowSweepAngle) {
        this.setStartX(startX);
        this.setStartY(startY);
        this.setEndX(startX);
        this.setEndY(startY);
        this.setCurrentShadowAngle(shadowStartAngle);
        this.setEndShadowAngle((shadowStartAngle + shadowSweepAngle) % 360.0f);
        this.operations.clear();
        this.shadowCompatOperations.clear();
        this.containsIncompatibleShadowOp = false;
    }

    public void lineTo(float x, float y) {
        PathLineOperation operation = new PathLineOperation();
        operation.x = x;
        operation.y = y;
        this.operations.add(operation);
        LineShadowOperation shadowOperation = new LineShadowOperation(operation, this.getEndX(), this.getEndY());
        this.addShadowCompatOperation(shadowOperation, 270.0f + shadowOperation.getAngle(), 270.0f + shadowOperation.getAngle());
        this.setEndX(x);
        this.setEndY(y);
    }

    public void lineTo(float x1, float y1, float x2, float y2) {
        if (Math.abs(x1 - this.getEndX()) < 0.001f && Math.abs(y1 - this.getEndY()) < 0.001f || Math.abs(x1 - x2) < 0.001f && Math.abs(y1 - y2) < 0.001f) {
            this.lineTo(x2, y2);
            return;
        }
        PathLineOperation operation1 = new PathLineOperation();
        operation1.x = x1;
        operation1.y = y1;
        this.operations.add(operation1);
        PathLineOperation operation2 = new PathLineOperation();
        operation2.x = x2;
        operation2.y = y2;
        this.operations.add(operation2);
        InnerCornerShadowOperation shadowOperation = new InnerCornerShadowOperation(operation1, operation2, this.getEndX(), this.getEndY());
        if (shadowOperation.getSweepAngle() > 0.0f) {
            this.lineTo(x1, y1);
            this.lineTo(x2, y2);
            return;
        }
        this.addShadowCompatOperation(shadowOperation, 270.0f + shadowOperation.getStartAngle(), 270.0f + shadowOperation.getEndAngle());
        this.setEndX(x2);
        this.setEndY(y2);
    }

    @RequiresApi(value=21)
    public void quadToPoint(float controlX, float controlY, float toX, float toY) {
        PathQuadOperation operation = new PathQuadOperation();
        operation.setControlX(controlX);
        operation.setControlY(controlY);
        operation.setEndX(toX);
        operation.setEndY(toY);
        this.operations.add(operation);
        this.containsIncompatibleShadowOp = true;
        this.setEndX(toX);
        this.setEndY(toY);
    }

    @RequiresApi(value=21)
    public void cubicToPoint(float controlX1, float controlY1, float controlX2, float controlY2, float toX, float toY) {
        PathCubicOperation operation = new PathCubicOperation(controlX1, controlY1, controlX2, controlY2, toX, toY);
        this.operations.add(operation);
        this.containsIncompatibleShadowOp = true;
        this.setEndX(toX);
        this.setEndY(toY);
    }

    public void addArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle) {
        PathArcOperation operation = new PathArcOperation(left, top, right, bottom);
        operation.setStartAngle(startAngle);
        operation.setSweepAngle(sweepAngle);
        this.operations.add(operation);
        ArcShadowOperation arcShadowOperation = new ArcShadowOperation(operation);
        float endAngle = startAngle + sweepAngle;
        boolean drawShadowInsideBounds = sweepAngle < 0.0f;
        this.addShadowCompatOperation(arcShadowOperation, drawShadowInsideBounds ? (180.0f + startAngle) % 360.0f : startAngle, drawShadowInsideBounds ? (180.0f + endAngle) % 360.0f : endAngle);
        this.setEndX((left + right) * 0.5f + (right - left) / 2.0f * (float)Math.cos(Math.toRadians(startAngle + sweepAngle)));
        this.setEndY((top + bottom) * 0.5f + (bottom - top) / 2.0f * (float)Math.sin(Math.toRadians(startAngle + sweepAngle)));
    }

    public void applyToPath(Matrix transform2, Path path2) {
        int size = this.operations.size();
        for (int i = 0; i < size; ++i) {
            PathOperation operation = this.operations.get(i);
            operation.applyToPath(transform2, path2);
        }
    }

    @NonNull
    ShadowCompatOperation createShadowCompatOperation(Matrix transform2) {
        this.addConnectingShadowIfNecessary(this.getEndShadowAngle());
        final Matrix transformCopy = new Matrix(transform2);
        final ArrayList<ShadowCompatOperation> operations = new ArrayList<ShadowCompatOperation>(this.shadowCompatOperations);
        return new ShadowCompatOperation(){

            @Override
            public void draw(Matrix matrix, ShadowRenderer shadowRenderer, int shadowElevation, Canvas canvas) {
                for (ShadowCompatOperation op : operations) {
                    op.draw(transformCopy, shadowRenderer, shadowElevation, canvas);
                }
            }
        };
    }

    private void addShadowCompatOperation(ShadowCompatOperation shadowOperation, float startShadowAngle, float endShadowAngle) {
        this.addConnectingShadowIfNecessary(startShadowAngle);
        this.shadowCompatOperations.add(shadowOperation);
        this.setCurrentShadowAngle(endShadowAngle);
    }

    boolean containsIncompatibleShadowOp() {
        return this.containsIncompatibleShadowOp;
    }

    private void addConnectingShadowIfNecessary(float nextShadowAngle) {
        if (this.getCurrentShadowAngle() == nextShadowAngle) {
            return;
        }
        float shadowSweep = (nextShadowAngle - this.getCurrentShadowAngle() + 360.0f) % 360.0f;
        if (shadowSweep > 180.0f) {
            return;
        }
        PathArcOperation pathArcOperation = new PathArcOperation(this.getEndX(), this.getEndY(), this.getEndX(), this.getEndY());
        pathArcOperation.setStartAngle(this.getCurrentShadowAngle());
        pathArcOperation.setSweepAngle(shadowSweep);
        this.shadowCompatOperations.add(new ArcShadowOperation(pathArcOperation));
        this.setCurrentShadowAngle(nextShadowAngle);
    }

    float getStartX() {
        return this.startX;
    }

    float getStartY() {
        return this.startY;
    }

    float getEndX() {
        return this.endX;
    }

    float getEndY() {
        return this.endY;
    }

    private float getCurrentShadowAngle() {
        return this.currentShadowAngle;
    }

    private float getEndShadowAngle() {
        return this.endShadowAngle;
    }

    private void setStartX(float startX) {
        this.startX = startX;
    }

    private void setStartY(float startY) {
        this.startY = startY;
    }

    private void setEndX(float endX) {
        this.endX = endX;
    }

    private void setEndY(float endY) {
        this.endY = endY;
    }

    private void setCurrentShadowAngle(float currentShadowAngle) {
        this.currentShadowAngle = currentShadowAngle;
    }

    private void setEndShadowAngle(float endShadowAngle) {
        this.endShadowAngle = endShadowAngle;
    }

    public static class PathCubicOperation
    extends PathOperation {
        private float controlX1;
        private float controlY1;
        private float controlX2;
        private float controlY2;
        private float endX;
        private float endY;

        public PathCubicOperation(float controlX1, float controlY1, float controlX2, float controlY2, float endX, float endY) {
            this.setControlX1(controlX1);
            this.setControlY1(controlY1);
            this.setControlX2(controlX2);
            this.setControlY2(controlY2);
            this.setEndX(endX);
            this.setEndY(endY);
        }

        @Override
        public void applyToPath(@NonNull Matrix transform2, @NonNull Path path2) {
            Matrix inverse = this.matrix;
            transform2.invert(inverse);
            path2.transform(inverse);
            path2.cubicTo(this.controlX1, this.controlY1, this.controlX2, this.controlY2, this.endX, this.endY);
            path2.transform(transform2);
        }

        private float getControlX1() {
            return this.controlX1;
        }

        private void setControlX1(float controlX1) {
            this.controlX1 = controlX1;
        }

        private float getControlY1() {
            return this.controlY1;
        }

        private void setControlY1(float controlY1) {
            this.controlY1 = controlY1;
        }

        private float getControlX2() {
            return this.controlX2;
        }

        private void setControlX2(float controlX2) {
            this.controlX2 = controlX2;
        }

        private float getControlY2() {
            return this.controlY1;
        }

        private void setControlY2(float controlY2) {
            this.controlY2 = controlY2;
        }

        private float getEndX() {
            return this.endX;
        }

        private void setEndX(float endX) {
            this.endX = endX;
        }

        private float getEndY() {
            return this.endY;
        }

        private void setEndY(float endY) {
            this.endY = endY;
        }
    }

    public static class PathArcOperation
    extends PathOperation {
        private static final RectF rectF = new RectF();
        @Deprecated
        public float left;
        @Deprecated
        public float top;
        @Deprecated
        public float right;
        @Deprecated
        public float bottom;
        @Deprecated
        public float startAngle;
        @Deprecated
        public float sweepAngle;

        public PathArcOperation(float left, float top, float right, float bottom) {
            this.setLeft(left);
            this.setTop(top);
            this.setRight(right);
            this.setBottom(bottom);
        }

        @Override
        public void applyToPath(@NonNull Matrix transform2, @NonNull Path path2) {
            Matrix inverse = this.matrix;
            transform2.invert(inverse);
            path2.transform(inverse);
            rectF.set(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
            path2.arcTo(rectF, this.getStartAngle(), this.getSweepAngle(), false);
            path2.transform(transform2);
        }

        private float getLeft() {
            return this.left;
        }

        private float getTop() {
            return this.top;
        }

        private float getRight() {
            return this.right;
        }

        private float getBottom() {
            return this.bottom;
        }

        private void setLeft(float left) {
            this.left = left;
        }

        private void setTop(float top) {
            this.top = top;
        }

        private void setRight(float right) {
            this.right = right;
        }

        private void setBottom(float bottom) {
            this.bottom = bottom;
        }

        private float getStartAngle() {
            return this.startAngle;
        }

        private float getSweepAngle() {
            return this.sweepAngle;
        }

        private void setStartAngle(float startAngle) {
            this.startAngle = startAngle;
        }

        private void setSweepAngle(float sweepAngle) {
            this.sweepAngle = sweepAngle;
        }
    }

    public static class PathQuadOperation
    extends PathOperation {
        @Deprecated
        public float controlX;
        @Deprecated
        public float controlY;
        @Deprecated
        public float endX;
        @Deprecated
        public float endY;

        @Override
        public void applyToPath(@NonNull Matrix transform2, @NonNull Path path2) {
            Matrix inverse = this.matrix;
            transform2.invert(inverse);
            path2.transform(inverse);
            path2.quadTo(this.getControlX(), this.getControlY(), this.getEndX(), this.getEndY());
            path2.transform(transform2);
        }

        private float getEndX() {
            return this.endX;
        }

        private void setEndX(float endX) {
            this.endX = endX;
        }

        private float getControlY() {
            return this.controlY;
        }

        private void setControlY(float controlY) {
            this.controlY = controlY;
        }

        private float getEndY() {
            return this.endY;
        }

        private void setEndY(float endY) {
            this.endY = endY;
        }

        private float getControlX() {
            return this.controlX;
        }

        private void setControlX(float controlX) {
            this.controlX = controlX;
        }
    }

    public static class PathLineOperation
    extends PathOperation {
        private float x;
        private float y;

        @Override
        public void applyToPath(@NonNull Matrix transform2, @NonNull Path path2) {
            Matrix inverse = this.matrix;
            transform2.invert(inverse);
            path2.transform(inverse);
            path2.lineTo(this.x, this.y);
            path2.transform(transform2);
        }
    }

    public static abstract class PathOperation {
        protected final Matrix matrix = new Matrix();

        public abstract void applyToPath(Matrix var1, Path var2);
    }

    static class ArcShadowOperation
    extends ShadowCompatOperation {
        private final PathArcOperation operation;

        public ArcShadowOperation(PathArcOperation operation) {
            this.operation = operation;
        }

        @Override
        public void draw(Matrix transform2, @NonNull ShadowRenderer shadowRenderer, int shadowElevation, @NonNull Canvas canvas) {
            float startAngle = this.operation.getStartAngle();
            float sweepAngle = this.operation.getSweepAngle();
            RectF rect = new RectF(this.operation.getLeft(), this.operation.getTop(), this.operation.getRight(), this.operation.getBottom());
            shadowRenderer.drawCornerShadow(canvas, transform2, rect, shadowElevation, startAngle, sweepAngle);
        }
    }

    static class InnerCornerShadowOperation
    extends ShadowCompatOperation {
        private final PathLineOperation operation1;
        private final PathLineOperation operation2;
        private final float startX;
        private final float startY;

        public InnerCornerShadowOperation(PathLineOperation operation1, PathLineOperation operation2, float startX, float startY) {
            this.operation1 = operation1;
            this.operation2 = operation2;
            this.startX = startX;
            this.startY = startY;
        }

        @Override
        public void draw(Matrix transform2, ShadowRenderer shadowRenderer, int shadowElevation, Canvas canvas) {
            double length2;
            float arcRadius;
            double retractLength;
            float sweepAngle = this.getSweepAngle();
            if (sweepAngle > 0.0f) {
                return;
            }
            double length1 = Math.hypot(this.operation1.x - this.startX, this.operation1.y - this.startY);
            if (length1 > (retractLength = (double)(arcRadius = (float)Math.min((double)shadowElevation, Math.min(length1, length2 = Math.hypot(this.operation2.x - this.operation1.x, this.operation2.y - this.operation1.y)))) * Math.tan(Math.toRadians(-sweepAngle / 2.0f)))) {
                RectF rect1 = new RectF(0.0f, 0.0f, (float)(length1 - retractLength), 0.0f);
                this.renderMatrix.set(transform2);
                this.renderMatrix.preTranslate(this.startX, this.startY);
                this.renderMatrix.preRotate(this.getStartAngle());
                shadowRenderer.drawEdgeShadow(canvas, this.renderMatrix, rect1, shadowElevation);
            }
            RectF rect = new RectF(0.0f, 0.0f, 2.0f * arcRadius, 2.0f * arcRadius);
            this.renderMatrix.set(transform2);
            this.renderMatrix.preTranslate(this.operation1.x, this.operation1.y);
            this.renderMatrix.preRotate(this.getStartAngle());
            this.renderMatrix.preTranslate((float)(-retractLength - (double)arcRadius), -2.0f * arcRadius);
            shadowRenderer.drawInnerCornerShadow(canvas, this.renderMatrix, rect, (int)arcRadius, 450.0f, sweepAngle, new float[]{(float)((double)arcRadius + retractLength), 2.0f * arcRadius});
            if (length2 > retractLength) {
                RectF rect2 = new RectF(0.0f, 0.0f, (float)(length2 - retractLength), 0.0f);
                this.renderMatrix.set(transform2);
                this.renderMatrix.preTranslate(this.operation1.x, this.operation1.y);
                this.renderMatrix.preRotate(this.getEndAngle());
                this.renderMatrix.preTranslate((float)retractLength, 0.0f);
                shadowRenderer.drawEdgeShadow(canvas, this.renderMatrix, rect2, shadowElevation);
            }
        }

        float getStartAngle() {
            return (float)Math.toDegrees(Math.atan((this.operation1.y - this.startY) / (this.operation1.x - this.startX)));
        }

        float getEndAngle() {
            return (float)Math.toDegrees(Math.atan((this.operation2.y - this.operation1.y) / (this.operation2.x - this.operation1.x)));
        }

        float getSweepAngle() {
            float shadowAngle = (this.getEndAngle() - this.getStartAngle() + 360.0f) % 360.0f;
            if (shadowAngle <= 180.0f) {
                return shadowAngle;
            }
            return shadowAngle - 360.0f;
        }
    }

    static class LineShadowOperation
    extends ShadowCompatOperation {
        private final PathLineOperation operation;
        private final float startX;
        private final float startY;

        public LineShadowOperation(PathLineOperation operation, float startX, float startY) {
            this.operation = operation;
            this.startX = startX;
            this.startY = startY;
        }

        @Override
        public void draw(Matrix transform2, @NonNull ShadowRenderer shadowRenderer, int shadowElevation, @NonNull Canvas canvas) {
            float height = this.operation.y - this.startY;
            float width = this.operation.x - this.startX;
            RectF rect = new RectF(0.0f, 0.0f, (float)Math.hypot(height, width), 0.0f);
            this.renderMatrix.set(transform2);
            this.renderMatrix.preTranslate(this.startX, this.startY);
            this.renderMatrix.preRotate(this.getAngle());
            shadowRenderer.drawEdgeShadow(canvas, this.renderMatrix, rect, shadowElevation);
        }

        float getAngle() {
            return (float)Math.toDegrees(Math.atan((this.operation.y - this.startY) / (this.operation.x - this.startX)));
        }
    }

    static abstract class ShadowCompatOperation {
        static final Matrix IDENTITY_MATRIX = new Matrix();
        final Matrix renderMatrix = new Matrix();

        ShadowCompatOperation() {
        }

        public final void draw(ShadowRenderer shadowRenderer, int shadowElevation, Canvas canvas) {
            this.draw(IDENTITY_MATRIX, shadowRenderer, shadowElevation, canvas);
        }

        public abstract void draw(Matrix var1, ShadowRenderer var2, int var3, Canvas var4);
    }
}

