/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.shape;

import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.android.material.canvas.CanvasCompat;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.ShapeAppearancePathProvider;
import com.google.android.material.shape.ShapeableDelegateV14;
import com.google.android.material.shape.ShapeableDelegateV22;
import com.google.android.material.shape.ShapeableDelegateV33;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class ShapeableDelegate {
    boolean forceCompatClippingEnabled = false;
    boolean offsetZeroCornerEdgeBoundsEnabled = false;
    @Nullable
    ShapeAppearanceModel shapeAppearanceModel;
    RectF maskBounds = new RectF();
    final Path shapePath = new Path();

    @NonNull
    public static ShapeableDelegate create(@NonNull View view) {
        if (Build.VERSION.SDK_INT >= 33) {
            return new ShapeableDelegateV33(view);
        }
        if (Build.VERSION.SDK_INT >= 22) {
            return new ShapeableDelegateV22(view);
        }
        return new ShapeableDelegateV14();
    }

    abstract void invalidateClippingMethod(@NonNull View var1);

    abstract boolean shouldUseCompatClipping();

    public boolean isForceCompatClippingEnabled() {
        return this.forceCompatClippingEnabled;
    }

    public void setForceCompatClippingEnabled(@NonNull View view, boolean enabled) {
        if (enabled != this.forceCompatClippingEnabled) {
            this.forceCompatClippingEnabled = enabled;
            this.invalidateClippingMethod(view);
        }
    }

    public void setOffsetZeroCornerEdgeBoundsEnabled(@NonNull View view, boolean enabled) {
        this.offsetZeroCornerEdgeBoundsEnabled = enabled;
        this.invalidateClippingMethod(view);
    }

    public void onShapeAppearanceChanged(@NonNull View view, @NonNull ShapeAppearanceModel shapeAppearanceModel) {
        this.shapeAppearanceModel = shapeAppearanceModel;
        this.updateShapePath();
        this.invalidateClippingMethod(view);
    }

    public void onMaskChanged(@NonNull View view, @NonNull RectF maskBounds) {
        this.maskBounds = maskBounds;
        this.updateShapePath();
        this.invalidateClippingMethod(view);
    }

    private void updateShapePath() {
        if (this.isMaskBoundsValid() && this.shapeAppearanceModel != null) {
            ShapeAppearancePathProvider.getInstance().calculatePath(this.shapeAppearanceModel, 1.0f, this.maskBounds, this.shapePath);
        }
    }

    private boolean isMaskBoundsValid() {
        return this.maskBounds.left <= this.maskBounds.right && this.maskBounds.top <= this.maskBounds.bottom;
    }

    public void maybeClip(@NonNull Canvas canvas, @NonNull CanvasCompat.CanvasOperation op) {
        if (this.shouldUseCompatClipping() && !this.shapePath.isEmpty()) {
            canvas.save();
            canvas.clipPath(this.shapePath);
            op.run(canvas);
            canvas.restore();
        } else {
            op.run(canvas);
        }
    }
}

