/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.sidesheet;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.sidesheet.SheetDelegate;
import com.google.android.material.sidesheet.SheetUtils;
import com.google.android.material.sidesheet.SideSheetBehavior;

final class RightSheetDelegate
extends SheetDelegate {
    final SideSheetBehavior<? extends View> sheetBehavior;

    RightSheetDelegate(@NonNull SideSheetBehavior<? extends View> sheetBehavior) {
        this.sheetBehavior = sheetBehavior;
    }

    @Override
    int getSheetEdge() {
        return 0;
    }

    @Override
    int getHiddenOffset() {
        return this.sheetBehavior.getParentWidth();
    }

    @Override
    int getExpandedOffset() {
        return Math.max(0, this.getHiddenOffset() - this.sheetBehavior.getChildWidth() - this.sheetBehavior.getInnerMargin());
    }

    @Override
    boolean isReleasedCloseToInnerEdge(@NonNull View releasedChild) {
        return releasedChild.getLeft() > (this.getHiddenOffset() + this.getExpandedOffset()) / 2;
    }

    @Override
    boolean isSwipeSignificant(float xVelocity, float yVelocity) {
        return SheetUtils.isSwipeMostlyHorizontal(xVelocity, yVelocity) && Math.abs(xVelocity) > (float)this.sheetBehavior.getSignificantVelocityThreshold();
    }

    @Override
    boolean shouldHide(@NonNull View child, float velocity) {
        float newRight = (float)child.getRight() + velocity * this.sheetBehavior.getHideFriction();
        return Math.abs(newRight) > this.sheetBehavior.getHideThreshold();
    }

    @Override
    <V extends View> int getOuterEdge(@NonNull V child) {
        return child.getLeft() - this.sheetBehavior.getInnerMargin();
    }

    @Override
    float calculateSlideOffset(int left) {
        float hiddenOffset = this.getHiddenOffset();
        float sheetWidth = hiddenOffset - (float)this.getExpandedOffset();
        return (hiddenOffset - (float)left) / sheetWidth;
    }

    @Override
    void updateCoplanarSiblingLayoutParams(@NonNull ViewGroup.MarginLayoutParams coplanarSiblingLayoutParams, int sheetLeft, int sheetRight) {
        int parentWidth = this.sheetBehavior.getParentWidth();
        if (sheetLeft <= parentWidth) {
            coplanarSiblingLayoutParams.rightMargin = parentWidth - sheetLeft;
        }
    }

    @Override
    void updateCoplanarSiblingAdjacentMargin(@NonNull ViewGroup.MarginLayoutParams coplanarSiblingLayoutParams, int coplanarSiblingAdjacentMargin) {
        coplanarSiblingLayoutParams.rightMargin = coplanarSiblingAdjacentMargin;
    }

    @Override
    int getCoplanarSiblingAdjacentMargin(@NonNull ViewGroup.MarginLayoutParams coplanarSiblingLayoutParams) {
        return coplanarSiblingLayoutParams.rightMargin;
    }

    @Override
    public int getParentInnerEdge(@NonNull CoordinatorLayout parent) {
        return parent.getRight();
    }

    @Override
    int calculateInnerMargin(@NonNull ViewGroup.MarginLayoutParams marginLayoutParams) {
        return marginLayoutParams.rightMargin;
    }

    @Override
    int getMinViewPositionHorizontal() {
        return this.getExpandedOffset();
    }

    @Override
    int getMaxViewPositionHorizontal() {
        return this.sheetBehavior.getParentWidth();
    }

    @Override
    boolean isExpandingOutwards(float xVelocity) {
        return xVelocity < 0.0f;
    }
}

