/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.sidesheet;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.GravityInt;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.appcompat.app.AppCompatDialog;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.material.R;
import com.google.android.material.motion.MaterialBackOrchestrator;
import com.google.android.material.sidesheet.Sheet;
import com.google.android.material.sidesheet.SheetCallback;

abstract class SheetDialog<C extends SheetCallback>
extends AppCompatDialog {
    private static final int COORDINATOR_LAYOUT_ID = R.id.coordinator;
    private static final int TOUCH_OUTSIDE_ID = R.id.touch_outside;
    @Nullable
    private Sheet<C> behavior;
    @Nullable
    private FrameLayout container;
    @Nullable
    private FrameLayout sheet;
    boolean dismissWithAnimation;
    boolean cancelable = true;
    private boolean canceledOnTouchOutside = true;
    private boolean canceledOnTouchOutsideSet;
    @Nullable
    private MaterialBackOrchestrator backOrchestrator;

    SheetDialog(@NonNull Context context, @StyleRes int theme, @AttrRes int themeAttr, @StyleRes int defaultThemeAttr) {
        super(context, SheetDialog.getThemeResId(context, theme, themeAttr, defaultThemeAttr));
        this.supportRequestWindowFeature(1);
    }

    @Override
    public void setContentView(@LayoutRes int layoutResId) {
        super.setContentView(this.wrapInSheet(layoutResId, null, null));
    }

    @Override
    public void setContentView(@Nullable View view) {
        super.setContentView(this.wrapInSheet(0, view, null));
    }

    @Override
    public void setContentView(@Nullable View view, @Nullable ViewGroup.LayoutParams params) {
        super.setContentView(this.wrapInSheet(0, view, params));
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = this.getWindow();
        if (window != null) {
            if (Build.VERSION.SDK_INT >= 21) {
                window.setStatusBarColor(0);
                window.addFlags(Integer.MIN_VALUE);
                if (Build.VERSION.SDK_INT < 23) {
                    window.addFlags(0x4000000);
                }
            }
            window.setLayout(-1, -1);
        }
    }

    public void setCancelable(boolean cancelable) {
        super.setCancelable(cancelable);
        if (this.cancelable != cancelable) {
            this.cancelable = cancelable;
        }
        if (this.getWindow() != null) {
            this.updateListeningForBackCallbacks();
        }
    }

    private void updateListeningForBackCallbacks() {
        if (this.backOrchestrator == null) {
            return;
        }
        if (this.cancelable) {
            this.backOrchestrator.startListeningForBackCallbacks();
        } else {
            this.backOrchestrator.stopListeningForBackCallbacks();
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (this.behavior != null && this.behavior.getState() == 5) {
            this.behavior.setState(this.getStateOnStart());
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.maybeUpdateWindowAnimationsBasedOnLayoutDirection();
        this.updateListeningForBackCallbacks();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.backOrchestrator != null) {
            this.backOrchestrator.stopListeningForBackCallbacks();
        }
    }

    public void cancel() {
        Sheet<C> behavior = this.getBehavior();
        if (!this.dismissWithAnimation || behavior.getState() == 5) {
            super.cancel();
        } else {
            behavior.setState(5);
        }
    }

    public void setCanceledOnTouchOutside(boolean cancel) {
        super.setCanceledOnTouchOutside(cancel);
        if (cancel && !this.cancelable) {
            this.cancelable = true;
        }
        this.canceledOnTouchOutside = cancel;
        this.canceledOnTouchOutsideSet = true;
    }

    public void setDismissWithSheetAnimationEnabled(boolean dismissWithAnimation) {
        this.dismissWithAnimation = dismissWithAnimation;
    }

    public boolean isDismissWithSheetAnimationEnabled() {
        return this.dismissWithAnimation;
    }

    private void ensureContainerAndBehavior() {
        if (this.container == null) {
            this.container = (FrameLayout)View.inflate((Context)this.getContext(), (int)this.getLayoutResId(), null);
            this.sheet = (FrameLayout)this.container.findViewById(this.getDialogId());
            this.behavior = this.getBehaviorFromSheet(this.sheet);
            this.addSheetCancelOnHideCallback(this.behavior);
            this.backOrchestrator = new MaterialBackOrchestrator(this.behavior, (View)this.sheet);
        }
    }

    abstract void addSheetCancelOnHideCallback(Sheet<C> var1);

    @NonNull
    private FrameLayout getContainer() {
        if (this.container == null) {
            this.ensureContainerAndBehavior();
        }
        return this.container;
    }

    @NonNull
    private FrameLayout getSheet() {
        if (this.sheet == null) {
            this.ensureContainerAndBehavior();
        }
        return this.sheet;
    }

    @NonNull
    Sheet<C> getBehavior() {
        if (this.behavior == null) {
            this.ensureContainerAndBehavior();
        }
        return this.behavior;
    }

    private View wrapInSheet(int layoutResId, @Nullable View view, @Nullable ViewGroup.LayoutParams params) {
        this.ensureContainerAndBehavior();
        CoordinatorLayout coordinator = (CoordinatorLayout)this.getContainer().findViewById(COORDINATOR_LAYOUT_ID);
        if (layoutResId != 0 && view == null) {
            view = this.getLayoutInflater().inflate(layoutResId, (ViewGroup)coordinator, false);
        }
        FrameLayout sheet = this.getSheet();
        sheet.removeAllViews();
        if (params == null) {
            sheet.addView(view);
        } else {
            sheet.addView(view, params);
        }
        coordinator.findViewById(TOUCH_OUTSIDE_ID).setOnClickListener(v -> {
            if (this.cancelable && this.isShowing() && this.shouldWindowCloseOnTouchOutside()) {
                this.cancel();
            }
        });
        ViewCompat.setAccessibilityDelegate((View)this.getSheet(), new AccessibilityDelegateCompat(){

            @Override
            public void onInitializeAccessibilityNodeInfo(View host, @NonNull AccessibilityNodeInfoCompat info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                if (SheetDialog.this.cancelable) {
                    info.addAction(0x100000);
                    info.setDismissable(true);
                } else {
                    info.setDismissable(false);
                }
            }

            @Override
            public boolean performAccessibilityAction(View host, int action, Bundle args2) {
                if (action == 0x100000 && SheetDialog.this.cancelable) {
                    SheetDialog.this.cancel();
                    return true;
                }
                return super.performAccessibilityAction(host, action, args2);
            }
        });
        return this.container;
    }

    public void setSheetEdge(@GravityInt int gravity) {
        if (this.sheet == null) {
            throw new IllegalStateException("Sheet view reference is null; sheet edge cannot be changed if the sheet view is null.");
        }
        if (ViewCompat.isLaidOut((View)this.sheet)) {
            throw new IllegalStateException("Sheet view has been laid out; sheet edge cannot be changed once the sheet has been laid out.");
        }
        ViewGroup.LayoutParams layoutParams = this.sheet.getLayoutParams();
        if (layoutParams instanceof CoordinatorLayout.LayoutParams) {
            ((CoordinatorLayout.LayoutParams)layoutParams).gravity = gravity;
            this.maybeUpdateWindowAnimationsBasedOnLayoutDirection();
        }
    }

    private void maybeUpdateWindowAnimationsBasedOnLayoutDirection() {
        Window window = this.getWindow();
        if (window != null && this.sheet != null && this.sheet.getLayoutParams() instanceof CoordinatorLayout.LayoutParams) {
            CoordinatorLayout.LayoutParams layoutParams = (CoordinatorLayout.LayoutParams)this.sheet.getLayoutParams();
            int absoluteGravity = GravityCompat.getAbsoluteGravity(layoutParams.gravity, ViewCompat.getLayoutDirection((View)this.sheet));
            window.setWindowAnimations(absoluteGravity == 3 ? R.style.Animation_Material3_SideSheetDialog_Left : R.style.Animation_Material3_SideSheetDialog_Right);
        }
    }

    private boolean shouldWindowCloseOnTouchOutside() {
        if (!this.canceledOnTouchOutsideSet) {
            TypedArray a = this.getContext().obtainStyledAttributes(new int[]{16843611});
            this.canceledOnTouchOutside = a.getBoolean(0, true);
            a.recycle();
            this.canceledOnTouchOutsideSet = true;
        }
        return this.canceledOnTouchOutside;
    }

    private static int getThemeResId(@NonNull Context context, @StyleRes int themeId, @AttrRes int themeAttr, @StyleRes int defaultTheme) {
        if (themeId == 0) {
            TypedValue outValue = new TypedValue();
            themeId = context.getTheme().resolveAttribute(themeAttr, outValue, true) ? outValue.resourceId : defaultTheme;
        }
        return themeId;
    }

    @LayoutRes
    abstract int getLayoutResId();

    @IdRes
    abstract int getDialogId();

    @NonNull
    abstract Sheet<C> getBehaviorFromSheet(@NonNull FrameLayout var1);

    abstract int getStateOnStart();
}

