/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Filterable;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.annotation.ArrayRes;
import androidx.annotation.ColorInt;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatAutoCompleteTextView;
import androidx.appcompat.widget.ListPopupWindow;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.internal.ManufacturerUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.textfield.TextInputLayout;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.util.List;

public class MaterialAutoCompleteTextView
extends AppCompatAutoCompleteTextView {
    private static final int MAX_ITEMS_MEASURED = 15;
    private static final String SWITCH_ACCESS_ACTIVITY_NAME = "SwitchAccess";
    @NonNull
    private final ListPopupWindow modalListPopup;
    @Nullable
    private final AccessibilityManager accessibilityManager;
    @NonNull
    private final Rect tempRect = new Rect();
    @LayoutRes
    private final int simpleItemLayout;
    private final float popupElevation;
    @Nullable
    private ColorStateList dropDownBackgroundTint;
    private int simpleItemSelectedColor;
    @Nullable
    private ColorStateList simpleItemSelectedRippleColor;

    public MaterialAutoCompleteTextView(@NonNull Context context) {
        this(context, null);
    }

    public MaterialAutoCompleteTextView(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.autoCompleteTextViewStyle);
    }

    public MaterialAutoCompleteTextView(@NonNull Context context, @Nullable AttributeSet attributeSet, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attributeSet, defStyleAttr, 0), attributeSet, defStyleAttr);
        int inputType;
        context = this.getContext();
        TypedArray attributes = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.MaterialAutoCompleteTextView, defStyleAttr, R.style.Widget_AppCompat_AutoCompleteTextView, new int[0]);
        if (attributes.hasValue(R.styleable.MaterialAutoCompleteTextView_android_inputType) && (inputType = attributes.getInt(R.styleable.MaterialAutoCompleteTextView_android_inputType, 0)) == 0) {
            this.setKeyListener(null);
        }
        this.simpleItemLayout = attributes.getResourceId(R.styleable.MaterialAutoCompleteTextView_simpleItemLayout, R.layout.mtrl_auto_complete_simple_item);
        this.popupElevation = attributes.getDimensionPixelOffset(R.styleable.MaterialAutoCompleteTextView_android_popupElevation, R.dimen.mtrl_exposed_dropdown_menu_popup_elevation);
        if (attributes.hasValue(R.styleable.MaterialAutoCompleteTextView_dropDownBackgroundTint)) {
            this.dropDownBackgroundTint = ColorStateList.valueOf((int)attributes.getColor(R.styleable.MaterialAutoCompleteTextView_dropDownBackgroundTint, 0));
        }
        this.simpleItemSelectedColor = attributes.getColor(R.styleable.MaterialAutoCompleteTextView_simpleItemSelectedColor, 0);
        this.simpleItemSelectedRippleColor = MaterialResources.getColorStateList(context, attributes, R.styleable.MaterialAutoCompleteTextView_simpleItemSelectedRippleColor);
        this.accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        this.modalListPopup = new ListPopupWindow(context);
        this.modalListPopup.setModal(true);
        this.modalListPopup.setAnchorView((View)this);
        this.modalListPopup.setInputMethodMode(2);
        this.modalListPopup.setAdapter(this.getAdapter());
        this.modalListPopup.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View selectedView, int position, long id2) {
                Object selectedItem = position < 0 ? MaterialAutoCompleteTextView.this.modalListPopup.getSelectedItem() : MaterialAutoCompleteTextView.this.getAdapter().getItem(position);
                MaterialAutoCompleteTextView.this.updateText(selectedItem);
                AdapterView.OnItemClickListener userOnItemClickListener = MaterialAutoCompleteTextView.this.getOnItemClickListener();
                if (userOnItemClickListener != null) {
                    if (selectedView == null || position < 0) {
                        selectedView = MaterialAutoCompleteTextView.this.modalListPopup.getSelectedView();
                        position = MaterialAutoCompleteTextView.this.modalListPopup.getSelectedItemPosition();
                        id2 = MaterialAutoCompleteTextView.this.modalListPopup.getSelectedItemId();
                    }
                    userOnItemClickListener.onItemClick((AdapterView)MaterialAutoCompleteTextView.this.modalListPopup.getListView(), selectedView, position, id2);
                }
                MaterialAutoCompleteTextView.this.modalListPopup.dismiss();
            }
        });
        if (attributes.hasValue(R.styleable.MaterialAutoCompleteTextView_simpleItems)) {
            this.setSimpleItems(attributes.getResourceId(R.styleable.MaterialAutoCompleteTextView_simpleItems, 0));
        }
        attributes.recycle();
    }

    public void showDropDown() {
        if (this.isPopupRequired()) {
            this.modalListPopup.show();
        } else {
            super.showDropDown();
        }
    }

    public void dismissDropDown() {
        if (this.isPopupRequired()) {
            this.modalListPopup.dismiss();
        } else {
            super.dismissDropDown();
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        if (this.isPopupRequired()) {
            return;
        }
        super.onWindowFocusChanged(hasWindowFocus);
    }

    private boolean isPopupRequired() {
        return this.isTouchExplorationEnabled() || this.isSwitchAccessEnabled();
    }

    private boolean isTouchExplorationEnabled() {
        return this.accessibilityManager != null && this.accessibilityManager.isTouchExplorationEnabled();
    }

    private boolean isSwitchAccessEnabled() {
        if (this.accessibilityManager == null || !this.accessibilityManager.isEnabled()) {
            return false;
        }
        List accessibilityServiceInfos = this.accessibilityManager.getEnabledAccessibilityServiceList(16);
        if (accessibilityServiceInfos != null) {
            for (AccessibilityServiceInfo info : accessibilityServiceInfos) {
                if (info.getSettingsActivityName() == null || !info.getSettingsActivityName().contains(SWITCH_ACCESS_ACTIVITY_NAME)) continue;
                return true;
            }
        }
        return false;
    }

    public <T extends ListAdapter & Filterable> void setAdapter(@Nullable T adapter) {
        super.setAdapter(adapter);
        this.modalListPopup.setAdapter(this.getAdapter());
    }

    public void setRawInputType(int type) {
        super.setRawInputType(type);
        this.onInputTypeChanged();
    }

    public void setOnItemSelectedListener(@Nullable AdapterView.OnItemSelectedListener listener2) {
        super.setOnItemSelectedListener(listener2);
        this.modalListPopup.setOnItemSelectedListener(this.getOnItemSelectedListener());
    }

    public void setSimpleItems(@ArrayRes int stringArrayResId) {
        this.setSimpleItems(this.getResources().getStringArray(stringArrayResId));
    }

    public void setSimpleItems(@NonNull String[] stringArray) {
        this.setAdapter((ListAdapter & Filterable)new MaterialArrayAdapter(this.getContext(), this.simpleItemLayout, stringArray));
    }

    public void setDropDownBackgroundTint(@ColorInt int dropDownBackgroundColor) {
        this.setDropDownBackgroundTintList(ColorStateList.valueOf((int)dropDownBackgroundColor));
    }

    public void setDropDownBackgroundTintList(@Nullable ColorStateList dropDownBackgroundTint) {
        this.dropDownBackgroundTint = dropDownBackgroundTint;
        Drawable dropDownBackground = this.getDropDownBackground();
        if (dropDownBackground instanceof MaterialShapeDrawable) {
            ((MaterialShapeDrawable)dropDownBackground).setFillColor(this.dropDownBackgroundTint);
        }
    }

    @Nullable
    public ColorStateList getDropDownBackgroundTintList() {
        return this.dropDownBackgroundTint;
    }

    public void setSimpleItemSelectedColor(int simpleItemSelectedColor) {
        this.simpleItemSelectedColor = simpleItemSelectedColor;
        if (this.getAdapter() instanceof MaterialArrayAdapter) {
            ((MaterialArrayAdapter)this.getAdapter()).updateSelectedItemColorStateList();
        }
    }

    public int getSimpleItemSelectedColor() {
        return this.simpleItemSelectedColor;
    }

    public void setSimpleItemSelectedRippleColor(@Nullable ColorStateList simpleItemSelectedRippleColor) {
        this.simpleItemSelectedRippleColor = simpleItemSelectedRippleColor;
        if (this.getAdapter() instanceof MaterialArrayAdapter) {
            ((MaterialArrayAdapter)this.getAdapter()).updateSelectedItemColorStateList();
        }
    }

    @Nullable
    public ColorStateList getSimpleItemSelectedRippleColor() {
        return this.simpleItemSelectedRippleColor;
    }

    public void setDropDownBackgroundDrawable(Drawable d) {
        super.setDropDownBackgroundDrawable(d);
        if (this.modalListPopup != null) {
            this.modalListPopup.setBackgroundDrawable(d);
        }
    }

    public float getPopupElevation() {
        return this.popupElevation;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        TextInputLayout layout2 = this.findTextInputLayoutAncestor();
        if (layout2 != null && layout2.isProvidingHint() && super.getHint() == null && ManufacturerUtils.isMeizuDevice()) {
            this.setHint("");
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.modalListPopup.dismiss();
    }

    @Nullable
    public CharSequence getHint() {
        TextInputLayout textInputLayout = this.findTextInputLayoutAncestor();
        if (textInputLayout != null && textInputLayout.isProvidingHint()) {
            return textInputLayout.getHint();
        }
        return super.getHint();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) == Integer.MIN_VALUE) {
            int measuredWidth = this.getMeasuredWidth();
            this.setMeasuredDimension(Math.min(Math.max(measuredWidth, this.measureContentWidth()), View.MeasureSpec.getSize((int)widthMeasureSpec)), this.getMeasuredHeight());
        }
    }

    private int measureContentWidth() {
        ListAdapter adapter = this.getAdapter();
        TextInputLayout textInputLayout = this.findTextInputLayoutAncestor();
        if (adapter == null || textInputLayout == null) {
            return 0;
        }
        int width = 0;
        View itemView = null;
        int itemType = 0;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0);
        int start = Math.max(0, this.modalListPopup.getSelectedItemPosition());
        int end = Math.min(adapter.getCount(), start + 15);
        for (int i = start = Math.max(0, end - 15); i < end; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            if ((itemView = adapter.getView(i, itemView, (ViewGroup)textInputLayout)).getLayoutParams() == null) {
                itemView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            }
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            width = Math.max(width, itemView.getMeasuredWidth());
        }
        Drawable background = this.modalListPopup.getBackground();
        if (background != null) {
            background.getPadding(this.tempRect);
            width += this.tempRect.left + this.tempRect.right;
        }
        int iconWidth = textInputLayout.getEndIconView().getMeasuredWidth();
        return width += iconWidth;
    }

    private void onInputTypeChanged() {
        TextInputLayout textInputLayout = this.findTextInputLayoutAncestor();
        if (textInputLayout != null) {
            textInputLayout.updateEditTextBoxBackgroundIfNeeded();
        }
    }

    @Nullable
    private TextInputLayout findTextInputLayoutAncestor() {
        for (ViewParent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof TextInputLayout)) continue;
            return (TextInputLayout)parent;
        }
        return null;
    }

    private <T extends ListAdapter & Filterable> void updateText(Object selectedItem) {
        if (Build.VERSION.SDK_INT >= 17) {
            this.setText(this.convertSelectionToString(selectedItem), false);
        } else {
            ListAdapter adapter = this.getAdapter();
            this.setAdapter(null);
            this.setText(this.convertSelectionToString(selectedItem));
            this.setAdapter(adapter);
        }
    }

    private class MaterialArrayAdapter<T>
    extends ArrayAdapter<String> {
        @Nullable
        private ColorStateList selectedItemRippleOverlaidColor;
        @Nullable
        private ColorStateList pressedRippleColor;

        MaterialArrayAdapter(Context context, @NonNull int resource, String[] objects) {
            super(context, resource, (Object[])objects);
            this.updateSelectedItemColorStateList();
        }

        void updateSelectedItemColorStateList() {
            this.pressedRippleColor = this.sanitizeDropdownItemSelectedRippleColor();
            this.selectedItemRippleOverlaidColor = this.createItemSelectedColorStateList();
        }

        public View getView(int position, @Nullable View convertView, ViewGroup parent) {
            View view = super.getView(position, convertView, parent);
            if (view instanceof TextView) {
                TextView textView = (TextView)view;
                boolean isSelectedItem = MaterialAutoCompleteTextView.this.getText().toString().contentEquals(textView.getText());
                ViewCompat.setBackground((View)textView, isSelectedItem ? this.getSelectedItemDrawable() : null);
            }
            return view;
        }

        @Nullable
        private Drawable getSelectedItemDrawable() {
            if (!this.hasSelectedColor() || Build.VERSION.SDK_INT < 21) {
                return null;
            }
            ColorDrawable colorDrawable = new ColorDrawable(MaterialAutoCompleteTextView.this.simpleItemSelectedColor);
            if (this.pressedRippleColor != null) {
                DrawableCompat.setTintList((Drawable)colorDrawable, this.selectedItemRippleOverlaidColor);
                return new RippleDrawable(this.pressedRippleColor, (Drawable)colorDrawable, null);
            }
            return colorDrawable;
        }

        @Nullable
        private ColorStateList createItemSelectedColorStateList() {
            if (!this.hasSelectedColor() || !this.hasSelectedRippleColor() || Build.VERSION.SDK_INT < 21) {
                return null;
            }
            int[] stateHovered = new int[]{16843623, -16842919};
            int[] stateSelected = new int[]{0x10100A1, -16842919};
            int colorSelected = MaterialAutoCompleteTextView.this.simpleItemSelectedRippleColor.getColorForState(stateSelected, 0);
            int colorHovered = MaterialAutoCompleteTextView.this.simpleItemSelectedRippleColor.getColorForState(stateHovered, 0);
            int[] colors = new int[]{MaterialColors.layer(MaterialAutoCompleteTextView.this.simpleItemSelectedColor, colorSelected), MaterialColors.layer(MaterialAutoCompleteTextView.this.simpleItemSelectedColor, colorHovered), MaterialAutoCompleteTextView.this.simpleItemSelectedColor};
            int[][] states = new int[][]{stateSelected, stateHovered, new int[0]};
            return new ColorStateList((int[][])states, colors);
        }

        private ColorStateList sanitizeDropdownItemSelectedRippleColor() {
            if (!this.hasSelectedRippleColor()) {
                return null;
            }
            int[] statePressed = new int[]{16842919};
            int[] colors = new int[]{MaterialAutoCompleteTextView.this.simpleItemSelectedRippleColor.getColorForState(statePressed, 0), 0};
            int[][] states = new int[][]{statePressed, new int[0]};
            return new ColorStateList((int[][])states, colors);
        }

        private boolean hasSelectedColor() {
            return MaterialAutoCompleteTextView.this.simpleItemSelectedColor != 0;
        }

        private boolean hasSelectedRippleColor() {
            return MaterialAutoCompleteTextView.this.simpleItemSelectedRippleColor != null;
        }
    }
}

