/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.StyleRes;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.view.MarginLayoutParamsCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.widget.TextViewCompat;
import com.google.android.material.R;
import com.google.android.material.internal.CheckableImageButton;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.textfield.IconHelper;
import com.google.android.material.textfield.TextInputLayout;

@SuppressLint(value={"ViewConstructor"})
class StartCompoundLayout
extends LinearLayout {
    private final TextInputLayout textInputLayout;
    private final TextView prefixTextView;
    @Nullable
    private CharSequence prefixText;
    private final CheckableImageButton startIconView;
    private ColorStateList startIconTintList;
    private PorterDuff.Mode startIconTintMode;
    private int startIconMinSize;
    @NonNull
    private ImageView.ScaleType startIconScaleType;
    private View.OnLongClickListener startIconOnLongClickListener;
    private boolean hintExpanded;

    StartCompoundLayout(TextInputLayout textInputLayout, TintTypedArray a) {
        super(textInputLayout.getContext());
        this.textInputLayout = textInputLayout;
        this.setVisibility(8);
        this.setOrientation(0);
        this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 0x800003));
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        this.startIconView = (CheckableImageButton)layoutInflater.inflate(R.layout.design_text_input_start_icon, (ViewGroup)this, false);
        IconHelper.setCompatRippleBackgroundIfNeeded(this.startIconView);
        this.prefixTextView = new AppCompatTextView(this.getContext());
        this.initStartIconView(a);
        this.initPrefixTextView(a);
        this.addView((View)this.startIconView);
        this.addView((View)this.prefixTextView);
    }

    private void initStartIconView(TintTypedArray a) {
        if (MaterialResources.isFontScaleAtLeast1_3(this.getContext())) {
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.startIconView.getLayoutParams();
            MarginLayoutParamsCompat.setMarginEnd(lp, 0);
        }
        this.setStartIconOnClickListener(null);
        this.setStartIconOnLongClickListener(null);
        if (a.hasValue(R.styleable.TextInputLayout_startIconTint)) {
            this.startIconTintList = MaterialResources.getColorStateList(this.getContext(), a, R.styleable.TextInputLayout_startIconTint);
        }
        if (a.hasValue(R.styleable.TextInputLayout_startIconTintMode)) {
            this.startIconTintMode = ViewUtils.parseTintMode(a.getInt(R.styleable.TextInputLayout_startIconTintMode, -1), null);
        }
        if (a.hasValue(R.styleable.TextInputLayout_startIconDrawable)) {
            this.setStartIconDrawable(a.getDrawable(R.styleable.TextInputLayout_startIconDrawable));
            if (a.hasValue(R.styleable.TextInputLayout_startIconContentDescription)) {
                this.setStartIconContentDescription(a.getText(R.styleable.TextInputLayout_startIconContentDescription));
            }
            this.setStartIconCheckable(a.getBoolean(R.styleable.TextInputLayout_startIconCheckable, true));
        }
        this.setStartIconMinSize(a.getDimensionPixelSize(R.styleable.TextInputLayout_startIconMinSize, this.getResources().getDimensionPixelSize(R.dimen.mtrl_min_touch_target_size)));
        if (a.hasValue(R.styleable.TextInputLayout_startIconScaleType)) {
            this.setStartIconScaleType(IconHelper.convertScaleType(a.getInt(R.styleable.TextInputLayout_startIconScaleType, -1)));
        }
    }

    private void initPrefixTextView(TintTypedArray a) {
        this.prefixTextView.setVisibility(8);
        this.prefixTextView.setId(R.id.textinput_prefix_text);
        this.prefixTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        ViewCompat.setAccessibilityLiveRegion((View)this.prefixTextView, 1);
        this.setPrefixTextAppearance(a.getResourceId(R.styleable.TextInputLayout_prefixTextAppearance, 0));
        if (a.hasValue(R.styleable.TextInputLayout_prefixTextColor)) {
            this.setPrefixTextColor(a.getColorStateList(R.styleable.TextInputLayout_prefixTextColor));
        }
        this.setPrefixText(a.getText(R.styleable.TextInputLayout_prefixText));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.updatePrefixTextViewPadding();
    }

    @NonNull
    TextView getPrefixTextView() {
        return this.prefixTextView;
    }

    void setPrefixText(@Nullable CharSequence prefixText) {
        this.prefixText = TextUtils.isEmpty((CharSequence)prefixText) ? null : prefixText;
        this.prefixTextView.setText(prefixText);
        this.updateVisibility();
    }

    @Nullable
    CharSequence getPrefixText() {
        return this.prefixText;
    }

    void setPrefixTextColor(@NonNull ColorStateList prefixTextColor) {
        this.prefixTextView.setTextColor(prefixTextColor);
    }

    @Nullable
    ColorStateList getPrefixTextColor() {
        return this.prefixTextView.getTextColors();
    }

    void setPrefixTextAppearance(@StyleRes int prefixTextAppearance) {
        TextViewCompat.setTextAppearance(this.prefixTextView, prefixTextAppearance);
    }

    void setStartIconDrawable(@Nullable Drawable startIconDrawable) {
        this.startIconView.setImageDrawable(startIconDrawable);
        if (startIconDrawable != null) {
            IconHelper.applyIconTint(this.textInputLayout, this.startIconView, this.startIconTintList, this.startIconTintMode);
            this.setStartIconVisible(true);
            this.refreshStartIconDrawableState();
        } else {
            this.setStartIconVisible(false);
            this.setStartIconOnClickListener(null);
            this.setStartIconOnLongClickListener(null);
            this.setStartIconContentDescription(null);
        }
    }

    @Nullable
    Drawable getStartIconDrawable() {
        return this.startIconView.getDrawable();
    }

    void setStartIconOnClickListener(@Nullable View.OnClickListener startIconOnClickListener) {
        IconHelper.setIconOnClickListener(this.startIconView, startIconOnClickListener, this.startIconOnLongClickListener);
    }

    void setStartIconOnLongClickListener(@Nullable View.OnLongClickListener startIconOnLongClickListener) {
        this.startIconOnLongClickListener = startIconOnLongClickListener;
        IconHelper.setIconOnLongClickListener(this.startIconView, startIconOnLongClickListener);
    }

    void setStartIconVisible(boolean visible) {
        if (this.isStartIconVisible() != visible) {
            this.startIconView.setVisibility(visible ? 0 : 8);
            this.updatePrefixTextViewPadding();
            this.updateVisibility();
        }
    }

    boolean isStartIconVisible() {
        return this.startIconView.getVisibility() == 0;
    }

    void refreshStartIconDrawableState() {
        IconHelper.refreshIconDrawableState(this.textInputLayout, this.startIconView, this.startIconTintList);
    }

    void setStartIconCheckable(boolean startIconCheckable) {
        this.startIconView.setCheckable(startIconCheckable);
    }

    boolean isStartIconCheckable() {
        return this.startIconView.isCheckable();
    }

    void setStartIconContentDescription(@Nullable CharSequence startIconContentDescription) {
        if (this.getStartIconContentDescription() != startIconContentDescription) {
            this.startIconView.setContentDescription(startIconContentDescription);
        }
    }

    @Nullable
    CharSequence getStartIconContentDescription() {
        return this.startIconView.getContentDescription();
    }

    void setStartIconTintList(@Nullable ColorStateList startIconTintList) {
        if (this.startIconTintList != startIconTintList) {
            this.startIconTintList = startIconTintList;
            IconHelper.applyIconTint(this.textInputLayout, this.startIconView, startIconTintList, this.startIconTintMode);
        }
    }

    void setStartIconTintMode(@Nullable PorterDuff.Mode startIconTintMode) {
        if (this.startIconTintMode != startIconTintMode) {
            this.startIconTintMode = startIconTintMode;
            IconHelper.applyIconTint(this.textInputLayout, this.startIconView, this.startIconTintList, this.startIconTintMode);
        }
    }

    void setStartIconMinSize(@Px int iconSize) {
        if (iconSize < 0) {
            throw new IllegalArgumentException("startIconSize cannot be less than 0");
        }
        if (iconSize != this.startIconMinSize) {
            this.startIconMinSize = iconSize;
            IconHelper.setIconMinSize(this.startIconView, iconSize);
        }
    }

    int getStartIconMinSize() {
        return this.startIconMinSize;
    }

    void setStartIconScaleType(@NonNull ImageView.ScaleType startIconScaleType) {
        this.startIconScaleType = startIconScaleType;
        IconHelper.setIconScaleType(this.startIconView, startIconScaleType);
    }

    @NonNull
    ImageView.ScaleType getStartIconScaleType() {
        return this.startIconScaleType;
    }

    void setupAccessibilityNodeInfo(@NonNull AccessibilityNodeInfoCompat info) {
        if (this.prefixTextView.getVisibility() == 0) {
            info.setLabelFor((View)this.prefixTextView);
            info.setTraversalAfter((View)this.prefixTextView);
        } else {
            info.setTraversalAfter((View)this.startIconView);
        }
    }

    void updatePrefixTextViewPadding() {
        EditText editText = this.textInputLayout.editText;
        if (editText == null) {
            return;
        }
        int startPadding = this.isStartIconVisible() ? 0 : ViewCompat.getPaddingStart((View)editText);
        ViewCompat.setPaddingRelative((View)this.prefixTextView, startPadding, editText.getCompoundPaddingTop(), this.getContext().getResources().getDimensionPixelSize(R.dimen.material_input_text_to_prefix_suffix_padding), editText.getCompoundPaddingBottom());
    }

    int getPrefixTextStartOffset() {
        int startIconOffset = this.isStartIconVisible() ? this.startIconView.getMeasuredWidth() + MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)this.startIconView.getLayoutParams()) : 0;
        return ViewCompat.getPaddingStart((View)this) + ViewCompat.getPaddingStart((View)this.prefixTextView) + startIconOffset;
    }

    void onHintStateChanged(boolean hintExpanded) {
        this.hintExpanded = hintExpanded;
        this.updateVisibility();
    }

    private void updateVisibility() {
        int prefixTextVisibility = this.prefixText != null && !this.hintExpanded ? 0 : 8;
        boolean shouldBeVisible = this.startIconView.getVisibility() == 0 || prefixTextVisibility == 0;
        this.setVisibility(shouldBeVisible ? 0 : 8);
        this.prefixTextView.setVisibility(prefixTextVisibility);
        this.textInputLayout.updateDummyDrawables();
    }
}

