/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.TextView;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.material.R;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.timepicker.ClockHandView;
import com.google.android.material.timepicker.RadialViewGroup;
import java.util.Arrays;

class ClockFaceView
extends RadialViewGroup
implements ClockHandView.OnRotateListener {
    private static final float EPSILON = 0.001f;
    private static final int INITIAL_CAPACITY = 12;
    private static final String VALUE_PLACEHOLDER = "";
    private final ClockHandView clockHandView;
    private final Rect textViewRect = new Rect();
    private final RectF scratch = new RectF();
    private final Rect scratchLineBounds = new Rect();
    private final SparseArray<TextView> textViewPool = new SparseArray();
    private final AccessibilityDelegateCompat valueAccessibilityDelegate;
    private final int[] gradientColors;
    private final float[] gradientPositions = new float[]{0.0f, 0.9f, 1.0f};
    private final int clockHandPadding;
    private final int minimumHeight;
    private final int minimumWidth;
    private final int clockSize;
    private String[] values;
    private float currentHandRotation;
    private final ColorStateList textColor;

    public ClockFaceView(@NonNull Context context) {
        this(context, null);
    }

    public ClockFaceView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.materialClockStyle);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public ClockFaceView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ClockFaceView, defStyleAttr, R.style.Widget_MaterialComponents_TimePicker_Clock);
        Resources res = this.getResources();
        this.textColor = MaterialResources.getColorStateList(context, a, R.styleable.ClockFaceView_clockNumberTextColor);
        LayoutInflater.from((Context)context).inflate(R.layout.material_clockface_view, (ViewGroup)this, true);
        this.clockHandView = (ClockHandView)this.findViewById(R.id.material_clock_hand);
        this.clockHandPadding = res.getDimensionPixelSize(R.dimen.material_clock_hand_padding);
        int clockHandTextColor = this.textColor.getColorForState(new int[]{0x10100A1}, this.textColor.getDefaultColor());
        this.gradientColors = new int[]{clockHandTextColor, clockHandTextColor, this.textColor.getDefaultColor()};
        this.clockHandView.addOnRotateListener(this);
        int defaultBackgroundColor = AppCompatResources.getColorStateList(context, R.color.material_timepicker_clockface).getDefaultColor();
        ColorStateList backgroundColor = MaterialResources.getColorStateList(context, a, R.styleable.ClockFaceView_clockFaceBackgroundColor);
        this.setBackgroundColor(backgroundColor == null ? defaultBackgroundColor : backgroundColor.getDefaultColor());
        this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                if (!ClockFaceView.this.isShown()) {
                    return true;
                }
                ClockFaceView.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                int circleRadius = ClockFaceView.this.getHeight() / 2 - ClockFaceView.this.clockHandView.getSelectorRadius() - ClockFaceView.this.clockHandPadding;
                ClockFaceView.this.setRadius(circleRadius);
                return true;
            }
        });
        this.setFocusable(true);
        a.recycle();
        this.valueAccessibilityDelegate = new AccessibilityDelegateCompat(){

            @Override
            public void onInitializeAccessibilityNodeInfo(View host, @NonNull AccessibilityNodeInfoCompat info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                int index = (Integer)host.getTag(R.id.material_value_index);
                if (index > 0) {
                    info.setTraversalAfter((View)ClockFaceView.this.textViewPool.get(index - 1));
                }
                info.setCollectionItemInfo(AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain(0, 1, index, 1, false, host.isSelected()));
                info.setClickable(true);
                info.addAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLICK);
            }

            @Override
            public boolean performAccessibilityAction(View host, int action, Bundle args2) {
                if (action == 16) {
                    long time = SystemClock.uptimeMillis();
                    host.getHitRect(ClockFaceView.this.textViewRect);
                    float x = ClockFaceView.this.textViewRect.centerX();
                    float y = ClockFaceView.this.textViewRect.centerY();
                    ClockFaceView.this.clockHandView.onTouchEvent(MotionEvent.obtain((long)time, (long)time, (int)0, (float)x, (float)y, (int)0));
                    ClockFaceView.this.clockHandView.onTouchEvent(MotionEvent.obtain((long)time, (long)time, (int)1, (float)x, (float)y, (int)0));
                    return true;
                }
                return super.performAccessibilityAction(host, action, args2);
            }
        };
        Object[] initialValues = new String[12];
        Arrays.fill(initialValues, VALUE_PLACEHOLDER);
        this.setValues((String[])initialValues, 0);
        this.minimumHeight = res.getDimensionPixelSize(R.dimen.material_time_picker_minimum_screen_height);
        this.minimumWidth = res.getDimensionPixelSize(R.dimen.material_time_picker_minimum_screen_width);
        this.clockSize = res.getDimensionPixelSize(R.dimen.material_clock_size);
    }

    public void setValues(String[] values2, @StringRes int contentDescription) {
        this.values = values2;
        this.updateTextViews(contentDescription);
    }

    private void updateTextViews(@StringRes int contentDescription) {
        boolean isMultiLevel = false;
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        int size = this.textViewPool.size();
        for (int i = 0; i < Math.max(this.values.length, size); ++i) {
            TextView textView = (TextView)this.textViewPool.get(i);
            if (i >= this.values.length) {
                this.removeView((View)textView);
                this.textViewPool.remove(i);
                continue;
            }
            if (textView == null) {
                textView = (TextView)inflater.inflate(R.layout.material_clockface_textview, (ViewGroup)this, false);
                this.textViewPool.put(i, (Object)textView);
                this.addView((View)textView);
            }
            textView.setText((CharSequence)this.values[i]);
            textView.setTag(R.id.material_value_index, (Object)i);
            int level = i / 12 + 1;
            textView.setTag(R.id.material_clock_level, (Object)level);
            if (level > 1) {
                isMultiLevel = true;
            }
            ViewCompat.setAccessibilityDelegate((View)textView, this.valueAccessibilityDelegate);
            textView.setTextColor(this.textColor);
            if (contentDescription == 0) continue;
            Resources res = this.getResources();
            textView.setContentDescription((CharSequence)res.getString(contentDescription, new Object[]{this.values[i]}));
        }
        this.clockHandView.setMultiLevel(isMultiLevel);
    }

    @Override
    protected void updateLayoutParams() {
        super.updateLayoutParams();
        for (int i = 0; i < this.textViewPool.size(); ++i) {
            ((TextView)this.textViewPool.get(i)).setVisibility(0);
        }
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        AccessibilityNodeInfoCompat infoCompat = AccessibilityNodeInfoCompat.wrap(info);
        infoCompat.setCollectionInfo(AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain(1, this.values.length, false, 1));
    }

    @Override
    public void setRadius(int radius) {
        if (radius != this.getRadius()) {
            super.setRadius(radius);
            this.clockHandView.setCircleRadius(this.getRadius());
        }
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.findIntersectingTextView();
    }

    public void setHandRotation(@FloatRange(from=0.0, to=360.0) float rotation) {
        this.clockHandView.setHandRotation(rotation);
        this.findIntersectingTextView();
    }

    private void findIntersectingTextView() {
        RectF selectorBox = this.clockHandView.getCurrentSelectorBox();
        TextView selected = this.getSelectedTextView(selectorBox);
        for (int i = 0; i < this.textViewPool.size(); ++i) {
            TextView tv = (TextView)this.textViewPool.get(i);
            if (tv == null) continue;
            tv.setSelected(tv == selected);
            RadialGradient radialGradient = this.getGradientForTextView(selectorBox, tv);
            tv.getPaint().setShader((Shader)radialGradient);
            tv.invalidate();
        }
    }

    @Nullable
    private TextView getSelectedTextView(RectF selectorBox) {
        float minArea = Float.MAX_VALUE;
        TextView selected = null;
        for (int i = 0; i < this.textViewPool.size(); ++i) {
            TextView tv = (TextView)this.textViewPool.get(i);
            if (tv == null) continue;
            tv.getHitRect(this.textViewRect);
            this.scratch.set(this.textViewRect);
            this.scratch.union(selectorBox);
            float area = this.scratch.width() * this.scratch.height();
            if (!(area < minArea)) continue;
            minArea = area;
            selected = tv;
        }
        return selected;
    }

    @Nullable
    private RadialGradient getGradientForTextView(RectF selectorBox, TextView tv) {
        tv.getHitRect(this.textViewRect);
        this.scratch.set(this.textViewRect);
        tv.getLineBounds(0, this.scratchLineBounds);
        this.scratch.inset((float)this.scratchLineBounds.left, (float)this.scratchLineBounds.top);
        if (!RectF.intersects((RectF)selectorBox, (RectF)this.scratch)) {
            return null;
        }
        return new RadialGradient(selectorBox.centerX() - this.scratch.left, selectorBox.centerY() - this.scratch.top, selectorBox.width() * 0.5f, this.gradientColors, this.gradientPositions, Shader.TileMode.CLAMP);
    }

    @Override
    public void onRotate(float rotation, boolean animating) {
        if (Math.abs(this.currentHandRotation - rotation) > 0.001f) {
            this.currentHandRotation = rotation;
            this.findIntersectingTextView();
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Resources r = this.getResources();
        DisplayMetrics displayMetrics = r.getDisplayMetrics();
        float height = displayMetrics.heightPixels;
        float width = displayMetrics.widthPixels;
        int size = (int)((float)this.clockSize / ClockFaceView.max3((float)this.minimumHeight / height, (float)this.minimumWidth / width, 1.0f));
        int spec = View.MeasureSpec.makeMeasureSpec((int)size, (int)0x40000000);
        this.setMeasuredDimension(size, size);
        super.onMeasure(spec, spec);
    }

    private static float max3(float a, float b, float c) {
        return Math.max(Math.max(a, b), c);
    }

    int getCurrentLevel() {
        return this.clockHandView.getCurrentLevel();
    }

    void setCurrentLevel(int level) {
        this.clockHandView.setCurrentLevel(level);
    }
}

